/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.table;

import com.mathworks.mwswing.ColorUtils;
import com.mathworks.project.impl.settingsui.SettingsPaintingUtils;
import com.mathworks.project.impl.table.PropertyTableHighlighter;
import com.mathworks.project.impl.table.PropertyTablePainter;
import com.mathworks.project.impl.table.PropertyTablePaintingUtils;
import com.mathworks.services.ColorPrefs;
import com.mathworks.widgets.HyperlinkTextLabel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Map;

public class DefaultPropertyTablePainter<T>
implements PropertyTablePainter<T> {
    private static final int EXPANDER_HEIGHT = 9;
    private static final int EXPANDER_WIDTH = 5;
    private static final Color GRAY_BACKGROUND_COLOR = new Color(240, 240, 240);
    private static final Color DISABLED_FOREGROUND_COLOR = new Color(195, 195, 195);

    @Override
    public int getGridLineHeight() {
        return 1;
    }

    @Override
    public int getGridLineWidth() {
        return 1;
    }

    @Override
    public void paintGridLine(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        graphics2D.setColor(GRAY_BACKGROUND_COLOR);
        graphics2D.fill(rectangle2D);
    }

    @Override
    public void paintGroupBackground(Graphics2D graphics2D, int n, Rectangle2D rectangle2D) {
        graphics2D.setColor(GRAY_BACKGROUND_COLOR);
        graphics2D.fill(rectangle2D);
    }

    @Override
    public void paintNormalBackground(Graphics2D graphics2D, Rectangle2D rectangle2D, int n, T t, Map<PropertyTableHighlighter<T>, Double> map) {
        PropertyTablePaintingUtils.paintBackgroundWithHighlight(graphics2D, rectangle2D, t, ColorPrefs.getBackgroundColor(), map);
    }

    @Override
    public void paintSelectedBackground(Graphics2D graphics2D, Rectangle2D rectangle2D, boolean bl, boolean bl2) {
        if (bl && !bl2) {
            this.paintNormalBackground(graphics2D, rectangle2D, 0, null, new HashMap<PropertyTableHighlighter<T>, Double>(0));
        } else {
            graphics2D.setColor(ColorUtils.getSelectionBackgroundColor());
            graphics2D.fill(rectangle2D);
        }
    }

    @Override
    public void paintText(Graphics2D graphics2D, T t, HyperlinkTextLabel hyperlinkTextLabel, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, Rectangle2D rectangle2D, int n2, int n3, Map<PropertyTableHighlighter<T>, Double> map, String string) {
        Object object;
        Color color = ColorPrefs.getTextColor();
        if (!bl) {
            color = ColorUtils.getContrastingForegroundVariant((Color)ColorPrefs.getBackgroundColor(), (Color)new Color(143, 158, 177));
        } else if (bl3) {
            color = DISABLED_FOREGROUND_COLOR;
        } else if (bl2) {
            color = ColorUtils.getSelectionForegroundColor();
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n4 = n3 - (fontMetrics.getAscent() + fontMetrics.getDescent());
        int n5 = n2 == 0 ? 3 + 16 * Math.max(n, 1) : 3;
        int n6 = 0;
        if (hyperlinkTextLabel != null) {
            n6 = (int)(hyperlinkTextLabel.getComponent().getPreferredSize().getWidth() + 10.0);
        }
        AttributedString attributedString = new AttributedString(SettingsPaintingUtils.trim(graphics2D, string.length() == 0 ? " " : string, (int)(rectangle2D.getWidth() - (double)n5 - (double)n6)));
        Font font = graphics2D.getFont();
        font = !bl ? font.deriveFont(1) : font.deriveFont(0);
        attributedString.addAttribute(TextAttribute.FONT, font);
        color = PropertyTablePaintingUtils.adjustForegroundColorForHighlight(t, color, map);
        attributedString = PropertyTablePaintingUtils.adjustTextForHighlight(n2, t, attributedString, font, map);
        graphics2D.setColor(color);
        TextLayout textLayout = new TextLayout(attributedString.getIterator(), graphics2D.getFontRenderContext());
        textLayout.draw(graphics2D, (int)rectangle2D.getX() + n5, (int)(rectangle2D.getY() + (double)fontMetrics.getAscent() + (double)n4 / 2.0));
        if (bl2 && bl4 && !bl6 && n2 == 0) {
            object = graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(1.0f, 1, 1, 1.5f, new float[]{1.5f}, 0.0f));
            graphics2D.draw(new Rectangle2D.Double(rectangle2D.getX() + (double)n5 - 1.5, rectangle2D.getY() + 2.0, textLayout.getBounds().getWidth() + 3.0, rectangle2D.getHeight() - 4.0));
            graphics2D.setStroke((Stroke)object);
        }
        if (hyperlinkTextLabel != null) {
            object = hyperlinkTextLabel.getComponent().getPreferredSize();
            hyperlinkTextLabel.setFont(graphics2D.getFont());
            hyperlinkTextLabel.getComponent().setBounds((int)(rectangle2D.getX() + (double)n5 + textLayout.getBounds().getWidth() + 10.0), (int)(rectangle2D.getY() + rectangle2D.getHeight() / 2.0 - ((Dimension)object).getHeight() / 2.0), (int)((Dimension)object).getWidth(), (int)((Dimension)object).getHeight());
        }
        graphics2D.setFont(font);
    }

    @Override
    public int getCollapsedPhaseIndex() {
        return 1;
    }

    @Override
    public Rectangle2D getExpanderRect(Rectangle2D rectangle2D, int n) {
        double d = rectangle2D.getY() + rectangle2D.getHeight() / 2.0 - 4.5;
        double d2 = rectangle2D.getX() + Math.max(8.0, (double)(3 + Math.max(0, n - 1) * 16));
        double d3 = d2 + 5.0;
        double d4 = d + 9.0;
        return new Rectangle2D.Double(d2, d, d3 - d2 + 1.0, d4 - d + 1.0);
    }

    @Override
    public void paintExpander(Graphics2D graphics2D, Rectangle2D rectangle2D, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GeneralPath generalPath = new GeneralPath();
        Rectangle2D rectangle2D2 = this.getExpanderRect(rectangle2D, n);
        if (n2 == 0) {
            double d = (int)rectangle2D2.getY() + 2;
            double d2 = (int)rectangle2D2.getX();
            double d3 = d2 + 6.0;
            double d4 = d + 6.0;
            generalPath.append(new Line2D.Double(d2, d4, d3, d4), true);
            generalPath.append(new Line2D.Double(d3, d4, d3, d), true);
            generalPath.append(new Line2D.Double(d3, d, d2, d4), true);
        } else {
            double d = (int)rectangle2D2.getY();
            double d5 = (int)rectangle2D2.getX();
            double d6 = d5 + 4.0;
            double d7 = d + 8.0;
            double d8 = (d + d7) / 2.0;
            generalPath.append(new Line2D.Double(d5, d, d6, d8), true);
            generalPath.append(new Line2D.Double(d6, d8, d5, d7), true);
            generalPath.append(new Line2D.Double(d5, d7, d5, d), true);
        }
        if (bl && bl4) {
            graphics2D.setColor(Color.WHITE);
            graphics2D.fill(generalPath);
        } else if (n2 == 0) {
            graphics2D.setColor(Color.BLACK);
            graphics2D.fill(generalPath);
        } else {
            graphics2D.setColor(new Color(166, 166, 166));
            graphics2D.draw(generalPath);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }
}

