/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.table;

import com.mathworks.project.impl.table.PropertyTableHighlighter;
import com.mathworks.project.impl.table.PropertyTablePainter;
import com.mathworks.project.impl.table.PropertyTablePaintingUtils;
import com.mathworks.widgets.HyperlinkTextLabel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.AttributedString;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.UIManager;

public class MacPropertyTablePainter<T>
implements PropertyTablePainter<T> {
    private static final Color MAC_GROUP_BORDER_COLOR = new Color(192, 192, 192);
    private static final Color MAC_GROUP_BACKGROUND_TOP_1 = new Color(236, 238, 249);
    private static final Color MAC_GROUP_BACKGROUND_TOP_2 = new Color(225, 229, 242);
    private static final Color MAC_GROUP_BACKGROUND_BOTTOM_1 = new Color(217, 220, 236);
    private static final Color MAC_GROUP_BACKGROUND_BOTTOM_2 = new Color(189, 193, 211);
    private static final Color MAC_GROUP_HEADER_FOREGROUND = new Color(56, 57, 59);
    private static final Color MAC_ROW_BACKGROUND_1 = new Color(237, 243, 254);
    private static final Color MAC_ROW_BACKGROUND_2 = UIManager.getColor("Table.background");
    private static final Color MAC_SELECTED_ROW_BACKGROUND = new Color(56, 117, 215);
    private static final Color MAC_SELECTED_FOREGROUND = Color.WHITE;
    private static final Color MAC_REGULAR_EXPANDER_COLOR = new Color(152, 152, 152);
    private static final Color MAC_REGULAR_FINITE_DROPDOWN_COLOR = new Color(81, 81, 81);
    private static final Color MAC_DEFAULT_FOREGROUND = Color.BLACK;
    private static final Color MAC_DISABLED_FOREGROUND = new Color(195, 195, 195);
    private static final double MAC_EXPANDER_HEIGHT = 8.0;
    private static final double MAC_EXPANDER_WIDTH = 10.0;

    @Override
    public int getGridLineHeight() {
        return 0;
    }

    @Override
    public int getGridLineWidth() {
        return 0;
    }

    @Override
    public void paintGridLine(Graphics2D graphics2D, Rectangle2D rectangle2D) {
    }

    @Override
    public void paintGroupBackground(Graphics2D graphics2D, int n, Rectangle2D rectangle2D) {
        PropertyTablePaintingUtils.gradientFill(graphics2D, rectangle2D, MAC_GROUP_BACKGROUND_TOP_1, MAC_GROUP_BACKGROUND_TOP_2, MAC_GROUP_BACKGROUND_BOTTOM_1, MAC_GROUP_BACKGROUND_BOTTOM_2);
        PropertyTablePaintingUtils.drawBorder(graphics2D, rectangle2D, MAC_GROUP_BORDER_COLOR, n > 0);
    }

    @Override
    public void paintNormalBackground(Graphics2D graphics2D, Rectangle2D rectangle2D, int n, T t, Map<PropertyTableHighlighter<T>, Double> map) {
        Color color = n % 2 > 0 ? MAC_ROW_BACKGROUND_1 : MAC_ROW_BACKGROUND_2;
        PropertyTablePaintingUtils.paintBackgroundWithHighlight(graphics2D, rectangle2D, t, color, map);
    }

    @Override
    public void paintSelectedBackground(Graphics2D graphics2D, Rectangle2D rectangle2D, boolean bl, boolean bl2) {
        graphics2D.setColor(MAC_SELECTED_ROW_BACKGROUND);
        graphics2D.fill(rectangle2D);
    }

    @Override
    public void paintText(Graphics2D graphics2D, T t, HyperlinkTextLabel hyperlinkTextLabel, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, Rectangle2D rectangle2D, int n2, int n3, Map<PropertyTableHighlighter<T>, Double> map, String string) {
        Serializable serializable;
        Color color = MAC_DEFAULT_FOREGROUND;
        if (bl3) {
            color = MAC_DISABLED_FOREGROUND;
        } else if (!bl && !bl2) {
            color = MAC_GROUP_HEADER_FOREGROUND;
        } else if (bl2) {
            color = MAC_SELECTED_FOREGROUND;
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n4 = n3 - (fontMetrics.getAscent() + fontMetrics.getDescent());
        int n5 = n2 == 0 ? 3 + 16 * Math.max(n, 1) : 3;
        Font font = graphics2D.getFont();
        font = !bl ? font.deriveFont(1) : font.deriveFont(0);
        int n6 = 0;
        if (hyperlinkTextLabel != null) {
            n6 = (int)(hyperlinkTextLabel.getComponent().getPreferredSize().getWidth() + 14.0);
        }
        AttributedString attributedString = new AttributedString(PropertyTablePaintingUtils.trim(graphics2D, string.length() == 0 ? " " : string, (int)(rectangle2D.getWidth() - (double)n5 - (double)(bl5 ? 9 : 0) - (double)n6)));
        attributedString.addAttribute(TextAttribute.FONT, font);
        color = PropertyTablePaintingUtils.adjustForegroundColorForHighlight(t, color, map);
        attributedString = PropertyTablePaintingUtils.adjustTextForHighlight(n2, t, attributedString, font, map);
        graphics2D.setColor(color);
        TextLayout textLayout = new TextLayout(attributedString.getIterator(), graphics2D.getFontRenderContext());
        textLayout.draw(graphics2D, (int)rectangle2D.getX() + n5, (int)(rectangle2D.getY() + (double)fontMetrics.getAscent() + (double)n4 / 2.0));
        graphics2D.setFont(font);
        if (bl5) {
            serializable = MAC_REGULAR_FINITE_DROPDOWN_COLOR;
            if (bl3) {
                serializable = MAC_DISABLED_FOREGROUND;
            } else if (bl2) {
                serializable = MAC_SELECTED_FOREGROUND;
            }
            graphics2D.setColor((Color)serializable);
            double d = rectangle2D.getX() + (double)n5 + textLayout.getBounds().getWidth() + 4.0;
            double d2 = d + 5.0;
            double d3 = (d + d2) / 2.0;
            double d4 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0 - 6.0;
            double d5 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0 + 1.0;
            double d6 = d4 + 4.0;
            double d7 = d5 + 4.0;
            GeneralPath generalPath = new GeneralPath();
            generalPath.append(new Line2D.Double(d, d6, d3, d4), true);
            generalPath.append(new Line2D.Double(d3, d4, d2, d6), true);
            generalPath.append(new Line2D.Double(d2, d6, d, d6), true);
            GeneralPath generalPath2 = new GeneralPath();
            generalPath2.append(new Line2D.Double(d, d5, d2, d5), true);
            generalPath2.append(new Line2D.Double(d2, d5, d3, d7), true);
            generalPath2.append(new Line2D.Double(d3, d7, d, d5), true);
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.fill(generalPath);
            graphics2D.fill(generalPath2);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }
        if (hyperlinkTextLabel != null) {
            serializable = hyperlinkTextLabel.getComponent().getPreferredSize();
            hyperlinkTextLabel.setFont(graphics2D.getFont());
            hyperlinkTextLabel.getComponent().setBounds((int)(rectangle2D.getX() + (double)n5 + textLayout.getBounds().getWidth() + 14.0), (int)(rectangle2D.getY() + rectangle2D.getHeight() / 2.0 - ((Dimension)serializable).getHeight() / 2.0), (int)((Dimension)serializable).getWidth(), (int)((Dimension)serializable).getHeight());
        }
    }

    @Override
    public int getCollapsedPhaseIndex() {
        return 6;
    }

    @Override
    public Rectangle2D getExpanderRect(Rectangle2D rectangle2D, int n) {
        double d = rectangle2D.getY() + rectangle2D.getHeight() / 2.0 - 4.0;
        double d2 = rectangle2D.getX() + Math.max(8.0, (double)(3 + Math.max(0, n - 1) * 16));
        double d3 = d2 + 10.0;
        double d4 = d + 8.0;
        return new Rectangle2D.Double(d2, d, d3 - d2 + 1.0, d4 - d + 1.0);
    }

    @Override
    public void paintExpander(Graphics2D graphics2D, Rectangle2D rectangle2D, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GeneralPath generalPath = new GeneralPath();
        Rectangle2D rectangle2D2 = this.getExpanderRect(rectangle2D, n);
        boolean bl5 = false;
        boolean bl6 = false;
        int n3 = (int)(rectangle2D2.getWidth() - 1.0);
        int n4 = (int)(rectangle2D2.getHeight() - 1.0);
        int n5 = (int)(rectangle2D2.getWidth() / 2.0);
        generalPath.append(new Line2D.Double((double)bl6, (double)bl5, n5, n4), true);
        generalPath.append(new Line2D.Double(n5, n4, n3, (double)bl5), true);
        generalPath.append(new Line2D.Double(n3, (double)bl5, (double)bl6, (double)bl5), true);
        Color color = MAC_REGULAR_EXPANDER_COLOR;
        if (bl) {
            color = MAC_SELECTED_FOREGROUND;
            if (bl3) {
                color = MAC_DISABLED_FOREGROUND;
            }
        } else if (bl3) {
            color = Color.BLACK;
        }
        Icon icon = PropertyTablePaintingUtils.rotate(generalPath, color, -1.5707963267948966 * ((double)n2 / (double)this.getCollapsedPhaseIndex()), true, false);
        icon.paintIcon(null, graphics2D, (int)rectangle2D2.getX(), (int)rectangle2D2.getY());
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }
}

