/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.table;

import com.mathworks.mwswing.ComponentUtils;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.ProjectComponent;
import com.mathworks.project.impl.ProjectGUI;
import com.mathworks.project.impl.table.ClickSensitiveCellEditor;
import com.mathworks.project.impl.table.DefaultPropertyTablePainter;
import com.mathworks.project.impl.table.MacPropertyTablePainter;
import com.mathworks.project.impl.table.PropertyTableCellEditor;
import com.mathworks.project.impl.table.PropertyTableCellEditorFactory;
import com.mathworks.project.impl.table.PropertyTableColumn;
import com.mathworks.project.impl.table.PropertyTableColumnModel;
import com.mathworks.project.impl.table.PropertyTableHighlighter;
import com.mathworks.project.impl.table.PropertyTableModel;
import com.mathworks.project.impl.table.PropertyTablePainter;
import com.mathworks.project.impl.textfield.FormatTip;
import com.mathworks.project.impl.textfield.FormattedTextField;
import com.mathworks.services.FontPrefs;
import com.mathworks.util.Holder;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Predicate;
import com.mathworks.util.RequestFilter;
import com.mathworks.util.tree.TreeUtils;
import com.mathworks.widgets.HyperlinkTextLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.JTableHeader;
import javax.swing.text.JTextComponent;

public final class PropertyTable<T>
implements ProjectComponent {
    private final PropertyTableModel<T> fModel;
    private final PropertyTablePainter<T> fPainter;
    private final PropertyTableCellEditorFactory<T> fCellEditorFactory;
    private final TableComponent fTable;
    private final PropertyTableColumnModel<T> fColumnModel;
    private final Map<PropertyTableHighlighter<T>, Double> fHighlighters;
    private final JTableHeader fHeader;
    private final MJScrollPane fScrollPane;
    private final PropertyChangeListener fFocusOwnerListener;
    private boolean fVetoStopEditing;
    private boolean fDividerLocationsInitialized;
    private boolean fFoldInLastColumnWhenInitialized;
    private boolean fSuppressSelection;
    private boolean fAllowSelectingExpandableRows;
    private boolean fKeepEditorAlive;
    private double[] fColumnWeights;
    private int fSelectedRow = -1;
    private int fPressedExpanderRow = -1;
    private int fMovingExpanderPhase;
    private int fMovingExpanderRow = -1;
    private int fCurrentDividerIndex = -1;
    private int fScrollPaneAdjustment;
    private int fActiveAdjustmentIndex;
    private Integer fLastLineHeight;
    private Integer fPreferredWidth;
    private Integer fLastLineCount;
    private PropertyTableCellEditor<T> fCurrentCellEditor;
    private T fCurrentEditingValue;
    private int fCurrentEditingRow;
    private int fCurrentEditingColumn;
    private int fLeftDragLimit;
    private int fRightDragLimit;
    private boolean fPreferToShowAllRows;
    private PropertyTableColumnModel<T> fTemporaryColumnModel;
    private boolean fOverrideStopEditingOnFocusLost;
    private static final String NO_STRETCH_PROPERTY = "SettingsTable.NoStretch";
    public static final String CELL_EDITOR_DIALOG = "PropertyTable-cell-editor-dialog";
    private static final int MIN_WIDTH = 100;
    public static final String TABLE_CLIENT_PROPERTY = "PropertyTable.Table";
    public static final Predicate<Component> COMPONENT_PREDICATE = TreeUtils.instanceOf(TableComponent.class);
    public static final Predicate<Component> NO_STRETCH_COMPONENT_PREDICATE = new Predicate<Component>(){

        public boolean accept(Component component) {
            return COMPONENT_PREDICATE.accept((Object)component) && ((JComponent)component).getClientProperty(PropertyTable.NO_STRETCH_PROPERTY) == Boolean.TRUE;
        }
    };

    public PropertyTable(PropertyTableModel<T> propertyTableModel) {
        this(propertyTableModel, new PropertyTableCellEditorFactory<T>(){

            @Override
            public PropertyTableCellEditor<T> createWidget(PropertyTable<T> propertyTable, int n, int n2, T t) {
                return null;
            }
        });
    }

    public PropertyTable(PropertyTableModel<T> propertyTableModel, PropertyTableCellEditorFactory<T> propertyTableCellEditorFactory) {
        this.fModel = propertyTableModel;
        this.fPainter = PlatformInfo.isMacintosh() ? new MacPropertyTablePainter() : new DefaultPropertyTablePainter();
        this.fCellEditorFactory = propertyTableCellEditorFactory;
        this.fTable = new TableComponent();
        this.fHighlighters = new LinkedHashMap<PropertyTableHighlighter<T>, Double>();
        this.fColumnModel = new PropertyTableColumnModel<T>(this, this.fModel.getColumns(), (JComponent)((Object)this.fTable), this.fPainter.getGridLineWidth());
        this.initializeMetrics();
        JTable jTable = new JTable(1, this.fModel.getColumnCount());
        jTable.setColumnModel(this.fColumnModel);
        this.fHeader = jTable.getTableHeader();
        this.fColumnModel.setHeader(this.fHeader);
        this.fColumnWeights = new double[this.fModel.getColumnCount() - 1];
        Arrays.fill(this.fColumnWeights, 1.0 / (double)this.fModel.getColumnCount());
        this.fScrollPane = new MJScrollPane((Component)((Object)this.fTable)){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                return new Dimension((int)(dimension.getWidth() + (double)PropertyTable.this.fScrollPaneAdjustment), (int)dimension.getHeight());
            }
        };
        this.fScrollPane.setBorder(null);
        this.fScrollPane.setColumnHeaderView((Component)this.fHeader);
        this.fScrollPane.setCorner("UPPER_RIGHT_CORNER", (Component)((Object)new CornerComponent()));
        this.fFocusOwnerListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!PlatformInfo.isMacintosh() && PropertyTable.this.isFocusOutOfTable()) {
                    Timer timer = new Timer(250, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            if (!PropertyTable.this.fOverrideStopEditingOnFocusLost && PropertyTable.this.isFocusOutOfTable() && !PropertyTable.this.fKeepEditorAlive) {
                                PropertyTable.this.stopEditing(false, false);
                                PropertyTable.this.fTable.revalidate();
                                PropertyTable.this.fTable.repaint();
                            }
                        }
                    });
                    timer.setRepeats(false);
                    timer.start();
                }
            }
        };
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this.fFocusOwnerListener);
        this.fTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                PropertyTable.this.fTable.requestFocus();
                int n = PropertyTable.this.getRowAtPoint(mouseEvent.getPoint());
                if (n >= 0 && n < PropertyTable.this.fModel.getRowCount()) {
                    if (PropertyTable.this.isOnExpander(mouseEvent.getPoint(), n)) {
                        if (PlatformInfo.isMacintosh()) {
                            PropertyTable.this.fPressedExpanderRow = n;
                            PropertyTable.this.fTable.revalidate();
                            PropertyTable.this.fTable.repaint();
                        } else {
                            PropertyTable.this.startExpandOrCollapse(n);
                        }
                    } else if (PropertyTable.this.isRowSelectable(n) && (PropertyTable.this.fPainter.getGridLineWidth() == 0 || PropertyTable.this.getDividerIndex(mouseEvent.getX()) == -1)) {
                        int n2 = PropertyTable.this.getColumnAtPoint(mouseEvent.getPoint());
                        if (PropertyTable.this.fCurrentCellEditor != null && PropertyTable.this.fCurrentEditingValue != PropertyTable.this.fModel.getValue(n, n2)) {
                            PropertyTable.this.stopEditing(false);
                        }
                        PropertyTable.this.select(n);
                        if (!PlatformInfo.isMacintosh()) {
                            int n3 = n2;
                            if (!PropertyTable.this.fModel.isColumnEditable(n3)) {
                                ++n3;
                            }
                            if (n2 >= 0 && n3 < PropertyTable.this.getActiveColumnModel().getColumnCount() && PropertyTable.this.fModel.isColumnEditable(n3) && PropertyTable.this.fModel.isEnabled(n, n3)) {
                                Point point = mouseEvent.getPoint();
                                SwingUtilities.convertPointToScreen(point, (Component)mouseEvent.getSource());
                                PropertyTable.this.startEditing(n, n3, point, !PropertyTable.this.fModel.isColumnEditable(n2));
                            }
                        }
                    }
                }
                if (PlatformInfo.isMacintosh()) {
                    PropertyTable.this.showMacValueDropdownIfApplicable(n, PropertyTable.this.getColumnAtPoint(mouseEvent.getPoint()));
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                int n = PropertyTable.this.getRowAtPoint(mouseEvent.getPoint());
                if (PlatformInfo.isMacintosh() && n >= 0 && n < PropertyTable.this.fModel.getRowCount() && PropertyTable.this.isOnExpander(mouseEvent.getPoint(), n)) {
                    PropertyTable.this.fPressedExpanderRow = -1;
                    PropertyTable.this.fTable.revalidate();
                    PropertyTable.this.fTable.repaint();
                    PropertyTable.this.startExpandOrCollapse(n);
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = PropertyTable.this.getRowAtPoint(mouseEvent.getPoint());
                int n2 = PropertyTable.this.getColumnAtPoint(mouseEvent.getPoint());
                if (n >= 0 && PlatformInfo.isMacintosh() && mouseEvent.getClickCount() == 2 && PropertyTable.this.fModel.isColumnEditable(n2) && PropertyTable.this.fModel.isEnabled(n, n2)) {
                    Point point = mouseEvent.getPoint();
                    SwingUtilities.convertPointToScreen(point, (Component)mouseEvent.getSource());
                    PropertyTable.this.startEditing(n, n2, point, false);
                }
            }
        });
        this.fTable.setFocusable(true);
        if (this.fPainter.getGridLineWidth() > 0) {
            this.addColumnDragSupport((JComponent)((Object)this.fTable));
        }
        final RequestFilter requestFilter = new RequestFilter(new Runnable(){

            @Override
            public void run() {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        PropertyTable.this.fTable.revalidate();
                        PropertyTable.this.fTable.repaint();
                        if (ProjectGUI.getInstance().getCurrentClient() != null) {
                            ProjectGUI.getInstance().getCurrentClient().getComponent().revalidate();
                            ProjectGUI.getInstance().getCurrentClient().getComponent().repaint();
                        }
                    }
                });
            }
        });
        propertyTableModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Dimension dimension = PropertyTable.this.fTable.getPreferredSize();
                PropertyTable.this.fLastLineCount = PropertyTable.this.fModel.getRowCount();
                PropertyTable.this.fTable.firePropertyChange("preferredSize", dimension, PropertyTable.this.fTable.getPreferredSize());
                requestFilter.request();
            }
        });
        this.fTable.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (PropertyTable.this.fCurrentCellEditor != null) {
                    PropertyTable.this.updateCellEditorBounds();
                    PropertyTable.this.fTable.revalidate();
                    PropertyTable.this.fTable.repaint();
                }
            }
        });
    }

    public void updateCellEditorBounds() {
        if (this.fCurrentCellEditor == null) {
            return;
        }
        Rectangle rectangle = this.getCellRect(this.fCurrentEditingRow, this.fCurrentEditingColumn);
        if (this.fCurrentEditingColumn == 0) {
            int n = this.fModel.getNestLevel(this.fCurrentEditingRow);
            if (n == 1) {
                ((Rectangle2D)rectangle).setRect(((RectangularShape)rectangle).getX() + 16.0, ((RectangularShape)rectangle).getY(), ((RectangularShape)rectangle).getWidth() - 16.0, ((RectangularShape)rectangle).getHeight());
            } else {
                Rectangle2D rectangle2D = this.fPainter.getExpanderRect(rectangle, n);
                ((Rectangle2D)rectangle).setRect(rectangle2D.getX() + rectangle2D.getWidth() + 8.0, ((RectangularShape)rectangle).getY(), ((RectangularShape)rectangle).getX() + ((RectangularShape)rectangle).getWidth() - (rectangle2D.getX() + rectangle2D.getWidth()) - 8.0, ((RectangularShape)rectangle).getHeight());
            }
        }
        this.fCurrentCellEditor.getComponent().setBounds((int)((RectangularShape)rectangle).getX() - (PlatformInfo.isMacintosh() ? 2 : 0), (int)((RectangularShape)rectangle).getY(), (int)((RectangularShape)rectangle).getWidth(), (int)((RectangularShape)rectangle).getHeight());
        this.fCurrentCellEditor.getComponent().revalidate();
    }

    public void setAllowSelectingExpandableRows(boolean bl) {
        this.fAllowSelectingExpandableRows = bl;
    }

    private void initializeMetrics() {
        this.fPreferredWidth = 0;
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setFont(PropertyTable.getTableFont());
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        this.fLastLineHeight = fontMetrics.getAscent() + fontMetrics.getDescent() + 5;
        this.fLastLineCount = this.fModel.getRowCount();
        for (int i = 0; i < this.fModel.getColumnCount(); ++i) {
            int n = (int)(fontMetrics.getStringBounds(this.fModel.getColumnName(i), graphics2D).getWidth() * (i == 0 ? 3.2 : 2.5));
            for (int j = 0; j < this.fModel.getRowCount(); ++j) {
                String string = this.fModel.getColumnText(j, i);
                n = Math.max(n, (int)fontMetrics.getStringBounds(string, graphics2D).getWidth());
            }
            this.fPreferredWidth = this.fPreferredWidth + n;
        }
        this.fPreferredWidth = Math.max(350, this.fPreferredWidth);
    }

    public void setKeepEditorAlive(boolean bl) {
        this.fKeepEditorAlive = bl;
    }

    public boolean isKeepingEditorAlive() {
        return this.fKeepEditorAlive;
    }

    public void setSearchText(String string) {
        this.fModel.setSearchText(string);
    }

    public void setHeaderVisible(boolean bl) {
        this.fScrollPane.setColumnHeaderView((Component)(bl ? this.fHeader : null));
    }

    public void setNoStretch(boolean bl) {
        this.fTable.putClientProperty(NO_STRETCH_PROPERTY, bl);
    }

    public void setColumnWeights(double[] dArray) {
        if (this.fDividerLocationsInitialized) {
            throw new IllegalStateException("The column weights must be set at initialization time");
        }
        this.fColumnWeights = (double[])dArray.clone();
    }

    public void addHighlighter(PropertyTableHighlighter<T> propertyTableHighlighter) {
        this.animateHighlighterTransition(propertyTableHighlighter, true, false);
    }

    public void removeHighlighter(PropertyTableHighlighter<T> propertyTableHighlighter) {
        this.animateHighlighterTransition(propertyTableHighlighter, false, false);
    }

    public void swapHighlighter(PropertyTableHighlighter<T> propertyTableHighlighter, PropertyTableHighlighter<T> propertyTableHighlighter2) {
        if (propertyTableHighlighter == null) {
            this.addHighlighter(propertyTableHighlighter2);
        } else if (propertyTableHighlighter2 == null) {
            this.removeHighlighter(propertyTableHighlighter);
        } else {
            this.animateHighlighterTransition(propertyTableHighlighter, false, true);
            this.animateHighlighterTransition(propertyTableHighlighter2, true, true);
        }
    }

    public PropertyTableModel<T> getModel() {
        return this.fModel;
    }

    public JComponent getComponent() {
        return this.fScrollPane;
    }

    public void dispose() {
        this.fModel.dispose();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(this.fFocusOwnerListener);
    }

    public int getRowAtPoint(Point point) {
        int n = (int)(point.getY() / (double)(this.fLastLineHeight + this.fPainter.getGridLineHeight()));
        return n > this.fModel.getRowCount() ? -1 : n;
    }

    public int getColumnAtPoint(Point point) {
        return this.getActiveColumnModel().getColumnIndexAtX((int)point.getX());
    }

    public boolean isRowSelectable(int n) {
        return !this.fSuppressSelection && !this.fModel.isPrimaryGroupHeader(n);
    }

    public void setSuppressSelection(boolean bl) {
        this.fSuppressSelection = bl;
        if (bl) {
            this.fSelectedRow = -1;
            this.fTable.revalidate();
            this.fTable.repaint();
        }
    }

    public void clearSelection() {
        this.fSelectedRow = -1;
        this.fTable.revalidate();
        this.fTable.repaint();
    }

    public int getSelectedRow() {
        return this.fSelectedRow;
    }

    public void select(int n) {
        if (this.fSelectedRow != n && this.isRowSelectable(n)) {
            this.fSelectedRow = n;
            this.fTable.scrollRectToVisible(this.getRowRect(this.fSelectedRow));
            this.fTable.revalidate();
            this.fTable.repaint();
        }
    }

    public Rectangle getRowRect(int n) {
        return new Rectangle(0, n * (this.fPainter.getGridLineHeight() + this.fLastLineHeight), this.fTable.getWidth(), this.fLastLineHeight);
    }

    public Rectangle getCellRect(int n, int n2) {
        Rectangle rectangle = this.getRowRect(n);
        if (n2 == 0) {
            rectangle.width = this.getActiveColumnModel().getDividerLocation(0);
        } else {
            int n3 = 1 + this.fPainter.getGridLineWidth();
            rectangle.x = this.getActiveColumnModel().getDividerLocation(n2 - 1) + n3;
            rectangle.width = n2 < this.getActiveColumnModel().getColumnCount() - 1 ? this.getActiveColumnModel().getDividerLocation(n2) - rectangle.x + n3 : this.fTable.getWidth() - rectangle.x;
        }
        return rectangle;
    }

    public void showPopupMenu(JPopupMenu jPopupMenu, int n, int n2) {
        Rectangle rectangle = this.getRowRect(n);
        jPopupMenu.show((Component)((Object)this.fTable), this.getActiveColumnModel().getDividerLocation(n2 - 1), (int)((RectangularShape)rectangle).getY());
    }

    public void convertPointToScreen(Point point) {
        SwingUtilities.convertPointToScreen(point, (Component)((Object)this.fTable));
    }

    public void foldInLastColumn(boolean bl) {
        int n = -(this.fTable.getWidth() - this.fScrollPaneAdjustment - this.fColumnModel.getDividerLocation(this.fModel.getColumnCount() - 2));
        if (bl) {
            if (this.fTable.getWidth() == 0 || !this.fDividerLocationsInitialized) {
                this.fFoldInLastColumnWhenInitialized = true;
                return;
            }
            this.fScrollPaneAdjustment = n;
            ((JComponent)this.fScrollPane.getParent()).revalidate();
            this.fScrollPane.getParent().repaint();
        } else {
            this.animateScrollPaneAdjustment(n);
        }
        List<PropertyTableColumn<T>> list = this.fModel.getColumns();
        list.remove(list.size() - 1);
        this.fTemporaryColumnModel = new PropertyTableColumnModel<T>(this, list, (JComponent)((Object)this.fTable), this.fPainter.getGridLineWidth());
        for (int i = 0; i < list.size() - 1; ++i) {
            this.fTemporaryColumnModel.setDividerLocation(i, this.fColumnModel.getDividerLocation(i));
        }
        JTable jTable = new JTable(1, list.size());
        jTable.setColumnModel(this.fTemporaryColumnModel);
        JTableHeader jTableHeader = jTable.getTableHeader();
        this.fTemporaryColumnModel.setHeader(jTableHeader);
        this.fScrollPane.setColumnHeaderView((Component)jTableHeader);
    }

    public void foldOutLastColumn() {
        this.animateScrollPaneAdjustment(0);
    }

    public void setPreferToShowAllRows(boolean bl) {
        this.fPreferToShowAllRows = bl;
    }

    public boolean isEditor(Component component) {
        return this.fCurrentCellEditor != null && ComponentUtils.isChild((Component)component, (Component)this.fCurrentCellEditor.getComponent());
    }

    public boolean isEditing() {
        return this.fCurrentCellEditor != null;
    }

    public void startEditing(int n, int n2, boolean bl) {
        this.startEditing(n, n2, null, bl);
    }

    public void startEditing(int n, int n2, Point point, final boolean bl) {
        this.fOverrideStopEditingOnFocusLost = false;
        this.fKeepEditorAlive = false;
        T t = this.fModel.getValue(n, n2);
        if (t == null) {
            return;
        }
        PropertyTableCellEditor<T> propertyTableCellEditor = this.fCellEditorFactory.createWidget(this, n, n2, t);
        if (propertyTableCellEditor == null) {
            return;
        }
        if (propertyTableCellEditor instanceof ClickSensitiveCellEditor) {
            ((ClickSensitiveCellEditor)propertyTableCellEditor).setInitialClickPoint(point);
        }
        if (this.fCurrentCellEditor != null) {
            this.stopEditing(false);
        }
        this.fVetoStopEditing = true;
        propertyTableCellEditor.loadData(t, this.fModel.getColumnText(n, n2));
        this.fCurrentEditingValue = t;
        this.fCurrentEditingRow = n;
        this.fCurrentEditingColumn = n2;
        this.fCurrentCellEditor = propertyTableCellEditor;
        this.fTable.removeAll();
        Rectangle rectangle = this.getCellRect(n, n2);
        JComponent jComponent = this.fCurrentCellEditor.getComponent();
        if (jComponent != null) {
            this.fTable.add(this.fCurrentCellEditor.getComponent());
            this.updateCellEditorBounds();
            this.fTable.revalidate();
            this.fTable.repaint();
            Timer timer = new Timer(50, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (PropertyTable.this.fCurrentCellEditor != null) {
                        PropertyTable.this.fCurrentCellEditor.getComponent().requestFocus();
                        PropertyTable.this.fOverrideStopEditingOnFocusLost = false;
                        PropertyTable.this.fVetoStopEditing = false;
                        if (!bl) {
                            PropertyTable.this.fCurrentCellEditor.activate();
                        }
                    }
                }
            });
            timer.setRepeats(false);
            timer.start();
        } else {
            this.fVetoStopEditing = false;
        }
    }

    public void commitEditedValue() {
        if (this.fCurrentCellEditor != null) {
            this.fCurrentCellEditor.commitData();
            this.fTable.revalidate();
            this.fTable.repaint();
        }
    }

    public void stopEditing(boolean bl) {
        this.stopEditing(bl, true);
    }

    public void stopEditing(boolean bl, boolean bl2) {
        if (this.fCurrentCellEditor != null && !this.fVetoStopEditing) {
            if (!bl) {
                this.commitEditedValue();
            }
            this.fTable.removeAll();
            this.fTable.revalidate();
            this.fTable.repaint();
            if (this.fCurrentCellEditor != null) {
                this.fCurrentCellEditor.dispose();
            }
            this.fCurrentCellEditor = null;
            if (bl2) {
                this.fTable.requestFocus();
            }
        }
    }

    public void setOverrideStopEditingOnFocusLost(boolean bl) {
        this.fOverrideStopEditingOnFocusLost = bl;
    }

    public Font getFont() {
        return PropertyTable.getTableFont();
    }

    public void requestFocus() {
        this.fTable.requestFocus();
    }

    public static Font getTableFont() {
        return FontPrefs.getTextFont().deriveFont(PlatformInfo.isMacintosh() ? 11.0f : 12.0f);
    }

    private PropertyTableColumnModel<T> getActiveColumnModel() {
        return this.fTemporaryColumnModel == null ? this.fColumnModel : this.fTemporaryColumnModel;
    }

    private boolean isFocusOutOfTable() {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        if (component == null) {
            component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        }
        boolean bl = component != null && !FormatTip.isInstance(SwingUtilities.windowForComponent(component)) && !this.isCellEditorDialog(SwingUtilities.windowForComponent(component)) && !ComponentUtils.isChild((Component)component, (Component)((Object)this.fTable)) && (this.fCurrentCellEditor == null || !ComponentUtils.isChild((Component)component, (Component)this.fCurrentCellEditor.getComponent()));
        return bl;
    }

    private boolean isCellEditorDialog(Window window) {
        if (!(window instanceof JDialog)) {
            return false;
        }
        Container container = ((JDialog)window).getContentPane();
        if (container instanceof JComponent) {
            Object object = ((JComponent)container).getClientProperty(CELL_EDITOR_DIALOG);
            return object == this;
        }
        return false;
    }

    private void animateScrollPaneAdjustment(final int n) {
        final Holder holder = new Holder();
        final int n2 = ++this.fActiveAdjustmentIndex;
        holder.set((Object)new Timer(20, new ActionListener(){
            private double iIncrement;
            {
                this.iIncrement = n < 0 ? -2.0 : 2.0;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PropertyTable.this.fActiveAdjustmentIndex != n2) {
                    ((Timer)holder.get()).stop();
                    return;
                }
                PropertyTable.this.fScrollPaneAdjustment = (int)((double)PropertyTable.this.fScrollPaneAdjustment + this.iIncrement);
                this.iIncrement *= 1.5;
                PropertyTable.this.fScrollPaneAdjustment = n < 0 ? Math.max(n, PropertyTable.this.fScrollPaneAdjustment) : Math.min(n, PropertyTable.this.fScrollPaneAdjustment);
                ((JComponent)PropertyTable.this.fScrollPane.getParent()).revalidate();
                PropertyTable.this.fScrollPane.getParent().repaint();
                if (PropertyTable.this.fScrollPaneAdjustment == n) {
                    ((Timer)holder.get()).stop();
                    if (n == 0) {
                        if (PropertyTable.this.fTemporaryColumnModel != null) {
                            for (int i = 0; i < PropertyTable.this.fModel.getColumnCount() - 2; ++i) {
                                PropertyTable.this.fColumnModel.setDividerLocation(i, PropertyTable.this.fTemporaryColumnModel.getDividerLocation(i));
                            }
                            PropertyTable.this.fTemporaryColumnModel.dispose();
                            PropertyTable.this.fTemporaryColumnModel = null;
                        }
                        PropertyTable.this.fScrollPane.setColumnHeaderView((Component)PropertyTable.this.fHeader);
                    }
                }
            }
        }));
        ((Timer)holder.get()).setRepeats(true);
        ((Timer)holder.get()).start();
    }

    private void startExpandOrCollapse(final int n) {
        if (n < 0) {
            return;
        }
        if (this.isEditing()) {
            this.stopEditing(false);
        }
        if (this.fPainter.getCollapsedPhaseIndex() < 2) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PropertyTable.this.fModel.setExpanded(n, !PropertyTable.this.fModel.isExpanded(n));
                    PropertyTable.this.fTable.revalidate();
                    PropertyTable.this.fTable.repaint();
                }
            });
        } else {
            this.fMovingExpanderPhase = this.fModel.isExpanded(n) ? 0 : this.fPainter.getCollapsedPhaseIndex();
            this.fMovingExpanderRow = n;
            final int n2 = this.fMovingExpanderPhase == 0 ? 1 : -1;
            final Holder holder = new Holder();
            holder.set((Object)new Timer(10, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PropertyTable.this.fMovingExpanderPhase += n2;
                    PropertyTable.this.fTable.revalidate();
                    PropertyTable.this.fTable.repaint();
                    if (PropertyTable.this.fMovingExpanderPhase == 0 || PropertyTable.this.fMovingExpanderPhase == PropertyTable.this.fPainter.getCollapsedPhaseIndex()) {
                        PropertyTable.this.fModel.setExpanded(PropertyTable.this.fMovingExpanderRow, PropertyTable.this.fMovingExpanderPhase == 0);
                        PropertyTable.this.fMovingExpanderRow = -1;
                        ((Timer)holder.get()).stop();
                    }
                }
            }));
            ((Timer)holder.get()).setRepeats(true);
            ((Timer)holder.get()).start();
        }
    }

    private void animateHighlighterTransition(final PropertyTableHighlighter<T> propertyTableHighlighter, final boolean bl, final boolean bl2) {
        if (bl) {
            this.fHighlighters.put(propertyTableHighlighter, bl2 ? 0.5 : 0.0);
        }
        if (!bl && this.fHighlighters.get(propertyTableHighlighter) != null && this.fHighlighters.get(propertyTableHighlighter) < 1.0) {
            this.fHighlighters.remove(propertyTableHighlighter);
            return;
        }
        final Holder holder = new Holder();
        final double d = bl ? 0.1 : -0.1;
        holder.set((Object)new Timer(50, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Double d2 = (Double)PropertyTable.this.fHighlighters.get(propertyTableHighlighter);
                if (d2 == null) {
                    ((Timer)holder.get()).stop();
                    return;
                }
                d2 = d2 + d;
                d2 = Math.max(0.0, Math.min(1.0, d2));
                PropertyTable.this.fHighlighters.put(propertyTableHighlighter, d2);
                if (d2 <= 0.6 && !bl && bl2 || d2 == 0.0 && !bl || bl && d2 >= 1.0) {
                    ((Timer)holder.get()).stop();
                    if (!bl) {
                        PropertyTable.this.fHighlighters.remove(propertyTableHighlighter);
                    }
                    return;
                }
                PropertyTable.this.fTable.revalidate();
                PropertyTable.this.fTable.repaint();
            }
        }));
        ((Timer)holder.get()).start();
    }

    private boolean isOnExpander(Point point, int n) {
        return this.fModel.isExpandable(n) && this.fPainter.getExpanderRect(this.getRowRect(n), this.fModel.getNestLevel(n)).contains(point);
    }

    private void showMacValueDropdownIfApplicable(int n, int n2) {
        if (this.fModel.isColumnEditable(n2) && this.fModel.isEnabled(n, n2) && this.fModel.isFinite(n)) {
            this.startEditing(n, n2, false);
        }
    }

    private void startMacEditingIfNoDropdown(int n, int n2) {
        if (this.fModel.isColumnEditable(n2) && this.fModel.isEnabled(n, n2) && !this.fModel.isFinite(n) && this.fModel.getValue(n, n2) != null) {
            this.startEditing(n, n2, false);
        }
    }

    private void delegateCopyOrPasteToEditor(KeyEvent keyEvent) {
        if (this.fModel.isColumnEditable(1) && this.fSelectedRow != -1) {
            T t = this.fModel.getValue(this.fSelectedRow, 1);
            if (t == null) {
                return;
            }
            PropertyTableCellEditor<T> propertyTableCellEditor = this.fCellEditorFactory.createWidget(this, this.fSelectedRow, 1, t);
            propertyTableCellEditor.loadData(t, this.fModel.getColumnText(this.fSelectedRow, 1));
            Object object = TreeUtils.findComponent((Component)propertyTableCellEditor.getComponent(), JTextComponent.class);
            if (object == null) {
                FormattedTextField.TextComponent textComponent = (FormattedTextField.TextComponent)((Object)TreeUtils.findComponent((Component)propertyTableCellEditor.getComponent(), FormattedTextField.TextComponent.class));
                if (textComponent != null) {
                    textComponent.getOwner().selectAll();
                    object = textComponent;
                }
            } else {
                ((JTextComponent)object).selectAll();
            }
            if (object != null) {
                object.dispatchEvent(keyEvent);
            }
            if (keyEvent.getKeyCode() == 86) {
                propertyTableCellEditor.commitData();
            }
            propertyTableCellEditor.dispose();
        }
    }

    private int getDividerIndex(int n) {
        PropertyTableColumnModel<T> propertyTableColumnModel = this.getActiveColumnModel();
        for (int i = 0; i < propertyTableColumnModel.getColumnCount() - 1; ++i) {
            if (n < propertyTableColumnModel.getDividerLocation(i) - 1 || n > propertyTableColumnModel.getDividerLocation(i) + 1) continue;
            return i;
        }
        return -1;
    }

    private void addColumnDragSupport(final JComponent jComponent) {
        jComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                PropertyTable.this.fCurrentDividerIndex = PropertyTable.this.getDividerIndex(mouseEvent.getX());
                PropertyTable.this.fLeftDragLimit = 32;
                PropertyTable.this.fRightDragLimit = jComponent.getWidth() - 16;
                if (PropertyTable.this.fCurrentDividerIndex > 0) {
                    PropertyTable.this.fLeftDragLimit = PropertyTable.this.getActiveColumnModel().getDividerLocation(PropertyTable.this.fCurrentDividerIndex - 1) + 10;
                }
                if (PropertyTable.this.fCurrentDividerIndex >= 0 && PropertyTable.this.fCurrentDividerIndex < PropertyTable.this.getActiveColumnModel().getColumnCount() - 2) {
                    PropertyTable.this.fRightDragLimit = PropertyTable.this.getActiveColumnModel().getDividerLocation(PropertyTable.this.fCurrentDividerIndex + 1) - 10;
                }
            }
        });
        jComponent.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (PropertyTable.this.fCurrentDividerIndex != -1 && mouseEvent.getX() >= PropertyTable.this.fLeftDragLimit && mouseEvent.getY() <= PropertyTable.this.fRightDragLimit) {
                    PropertyTable.this.getActiveColumnModel().setDividerLocation(PropertyTable.this.fCurrentDividerIndex, mouseEvent.getX());
                    PropertyTable.this.fTable.revalidate();
                    PropertyTable.this.fTable.repaint();
                    jComponent.revalidate();
                    jComponent.repaint();
                }
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                int n = PropertyTable.this.getDividerIndex(mouseEvent.getX());
                if (n > -1) {
                    jComponent.setCursor(Cursor.getPredefinedCursor(11));
                } else {
                    jComponent.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
    }

    private void initializeDividerLocationsIfNecessary() {
        if (!this.fDividerLocationsInitialized) {
            for (int i = 0; i < this.fModel.getColumnCount() - 1; ++i) {
                this.getActiveColumnModel().setDividerLocation(i, (int)((double)this.fTable.getWidth() * this.fColumnWeights[i] + (double)(i == 0 ? 0 : this.getActiveColumnModel().getDividerLocation(i - 1))));
            }
            this.fDividerLocationsInitialized = true;
            if (this.fFoldInLastColumnWhenInitialized) {
                this.foldInLastColumn(true);
            }
            this.fTable.revalidate();
            this.fTable.repaint();
            this.fHeader.revalidate();
            this.fHeader.repaint();
        }
    }

    private class TableComponent
    extends MJPanel
    implements Scrollable {
        TableComponent() {
            this.setLayout(null);
            this.putClientProperty(PropertyTable.TABLE_CLIENT_PROPERTY, PropertyTable.this);
        }

        public void firePropertyChange(String string, Object object, Object object2) {
            super.firePropertyChange(string, object, object2);
        }

        public Dimension getPreferredSize() {
            return new Dimension(0, (PropertyTable.this.fLastLineHeight + PropertyTable.this.fPainter.getGridLineHeight()) * Math.max(1, PropertyTable.this.fLastLineCount));
        }

        protected void processKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getID() == 401) {
                if (PropertyTable.this.fSelectedRow >= 0 && keyEvent.getKeyCode() == 38) {
                    int n;
                    for (n = PropertyTable.this.fSelectedRow - 1; n >= 0 && PropertyTable.this.fModel.isPrimaryGroupHeader(n); --n) {
                    }
                    if (n >= 0 && !PropertyTable.this.fModel.isPrimaryGroupHeader(n)) {
                        PropertyTable.this.select(n);
                    }
                    return;
                }
                if (PropertyTable.this.fSelectedRow >= 0 && keyEvent.getKeyCode() == 40) {
                    int n;
                    for (n = PropertyTable.this.fSelectedRow + 1; n < PropertyTable.this.fModel.getRowCount() && PropertyTable.this.fModel.isPrimaryGroupHeader(n); ++n) {
                    }
                    if (n < PropertyTable.this.fModel.getRowCount() && !PropertyTable.this.fModel.isPrimaryGroupHeader(n)) {
                        PropertyTable.this.select(n);
                    }
                    return;
                }
                if (PlatformInfo.isMacintosh() && keyEvent.getKeyCode() == 32) {
                    PropertyTable.this.showMacValueDropdownIfApplicable(PropertyTable.this.fSelectedRow, 1);
                } else if (PlatformInfo.isMacintosh() && keyEvent.getKeyCode() == 10) {
                    PropertyTable.this.startMacEditingIfNoDropdown(PropertyTable.this.fSelectedRow, 1);
                } else if (!(PlatformInfo.isMacintosh() || keyEvent.getKeyCode() != 32 && keyEvent.getKeyCode() != 113)) {
                    PropertyTable.this.startEditing(PropertyTable.this.fSelectedRow, 1, false);
                } else if ((keyEvent.getKeyCode() == 67 || keyEvent.getKeyCode() == 86) && (keyEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                    PropertyTable.this.delegateCopyOrPasteToEditor(keyEvent);
                } else if (keyEvent.getKeyCode() == 37 && PropertyTable.this.fModel.isExpandable(PropertyTable.this.fSelectedRow)) {
                    PropertyTable.this.fModel.setExpanded(PropertyTable.this.fSelectedRow, false);
                    PropertyTable.this.fTable.revalidate();
                    PropertyTable.this.fTable.repaint();
                } else if (keyEvent.getKeyCode() == 39 && PropertyTable.this.fModel.isExpandable(PropertyTable.this.fSelectedRow)) {
                    PropertyTable.this.fModel.setExpanded(PropertyTable.this.fSelectedRow, true);
                    PropertyTable.this.fTable.revalidate();
                    PropertyTable.this.fTable.repaint();
                }
            }
            super.processKeyEvent(keyEvent);
        }

        public void reshape(int n, int n2, int n3, int n4) {
            if (n3 >= 100) {
                super.reshape(n, n2, n3, n4);
                PropertyTable.this.initializeMetrics();
                PropertyTable.this.initializeDividerLocationsIfNecessary();
            } else {
                super.reshape(n, n2, 0, 0);
            }
        }

        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics.setFont(PropertyTable.getTableFont());
            if (PropertyTable.this.fLastLineCount == 0) {
                graphics2D.setColor(PropertyTable.this.fScrollPane.getViewport().getBackground());
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            if (PropertyTable.this.fLastLineCount.intValue() != PropertyTable.this.fModel.getRowCount()) {
                PropertyTable.this.fLastLineCount = PropertyTable.this.fModel.getRowCount();
                this.revalidate();
                this.repaint();
            }
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < PropertyTable.this.fModel.getRowCount(); ++i) {
                int n3;
                Rectangle rectangle = PropertyTable.this.getRowRect(i);
                boolean bl = i == PropertyTable.this.fSelectedRow && !PropertyTable.this.fModel.isPrimaryGroupHeader(i);
                boolean bl2 = PropertyTable.this.fModel.isExpandable(i);
                int n4 = PropertyTable.this.fModel.getNestLevel(i);
                if (PropertyTable.this.fModel.isPrimaryGroupHeader(i)) {
                    PropertyTable.this.fPainter.paintGroupBackground(graphics2D, i, rectangle);
                } else if (i == PropertyTable.this.fSelectedRow) {
                    PropertyTable.this.fPainter.paintSelectedBackground(graphics2D, rectangle, bl2, PropertyTable.this.fAllowSelectingExpandableRows);
                    ++n2;
                } else {
                    PropertyTable.this.fPainter.paintNormalBackground(graphics2D, rectangle, n2++, PropertyTable.this.fModel.getValue(i, 0), PropertyTable.this.fHighlighters);
                }
                if (bl2) {
                    int n5 = n3 = PropertyTable.this.fModel.isExpanded(i) ? 0 : PropertyTable.this.fPainter.getCollapsedPhaseIndex();
                    if (i == PropertyTable.this.fMovingExpanderRow) {
                        n3 = PropertyTable.this.fMovingExpanderPhase;
                    }
                    PropertyTable.this.fPainter.paintExpander(graphics2D, rectangle, n4, n3, bl, PropertyTable.this.fModel.isExpanded(i), i == PropertyTable.this.fPressedExpanderRow, PropertyTable.this.fAllowSelectingExpandableRows);
                }
                for (n3 = 0; n3 < PropertyTable.this.getActiveColumnModel().getColumnCount(); ++n3) {
                    Object t = PropertyTable.this.fModel.getValue(i, n3);
                    HyperlinkTextLabel hyperlinkTextLabel = PropertyTable.this.fModel.getColumnLink(i, n3);
                    if (hyperlinkTextLabel != null && hyperlinkTextLabel.getComponent().getParent() == null) {
                        this.add(hyperlinkTextLabel.getComponent());
                    }
                    boolean bl3 = PropertyTable.this.fModel.isLeaf(i);
                    boolean bl4 = !PropertyTable.this.fModel.isEnabled(i, n3) && !PropertyTable.this.fModel.isPrimaryGroupHeader(i);
                    Rectangle rectangle2 = PropertyTable.this.getCellRect(i, n3);
                    boolean bl5 = PropertyTable.this.fModel.isColumnEditable(n3) && PropertyTable.this.fModel.isFinite(i);
                    String string = PropertyTable.this.fModel.getColumnText(i, n3);
                    PropertyTable.this.fPainter.paintText(graphics2D, t, hyperlinkTextLabel, n4, bl3, bl, bl4, bl2, bl5, PropertyTable.this.fAllowSelectingExpandableRows, rectangle2, n3, PropertyTable.this.fLastLineHeight, PropertyTable.this.fHighlighters, string);
                    if (bl4 && hyperlinkTextLabel != null) {
                        hyperlinkTextLabel.getComponent().setBounds(0, 0, 0, 0);
                    }
                    Rectangle2D.Double double_ = new Rectangle2D.Double(((RectangularShape)rectangle2).getX() + ((RectangularShape)rectangle2).getWidth(), n, PropertyTable.this.fPainter.getGridLineWidth(), ((RectangularShape)rectangle2).getHeight());
                    PropertyTable.this.fPainter.paintGridLine(graphics2D, double_);
                }
                Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, n += PropertyTable.this.fLastLineHeight.intValue(), rectangle.getWidth(), n + PropertyTable.this.fPainter.getGridLineHeight());
                PropertyTable.this.fPainter.paintGridLine(graphics2D, double_);
                n += PropertyTable.this.fPainter.getGridLineHeight();
            }
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            if (PropertyTable.this.fLastLineHeight != null) {
                int n = Math.max(1, Math.min(8, PropertyTable.this.fLastLineCount));
                if (PropertyTable.this.fPreferToShowAllRows) {
                    n = PropertyTable.this.fLastLineCount;
                }
                Dimension dimension = new Dimension(PropertyTable.this.fPreferredWidth, (PropertyTable.this.fLastLineHeight + PropertyTable.this.fPainter.getGridLineHeight()) * n);
                return dimension;
            }
            return new Dimension(0, 0);
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            return PropertyTable.this.fLastLineHeight + PropertyTable.this.fPainter.getGridLineHeight();
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            if (n == 1) {
                return (int)(rectangle.getHeight() - (double)(PropertyTable.this.fLastLineHeight / 2));
            }
            return (int)(rectangle.getWidth() - 5.0);
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }

    private static class CornerComponent
    extends MJPanel {
        CornerComponent() {
            this.setLayout(new BorderLayout(0, 0));
            Component component = new JTableHeader().getDefaultRenderer().getTableCellRendererComponent(null, "", false, false, -1, 0);
            ((JComponent)component).setOpaque(false);
            this.add(component, "Center");
        }
    }
}

