/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.workflowui;

import com.mathworks.project.api.ProjectComponent;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.workflowui.OutputTabDefinition;
import java.awt.Component;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class OutputTabInstance {
    private final OutputTabDefinition fDefinition;
    private final ProjectComponent fComponent;

    public OutputTabInstance(OutputTabDefinition outputTabDefinition, Project project) {
        this.fDefinition = outputTabDefinition;
        try {
            Class<?> clazz = Class.forName(outputTabDefinition.getClassName());
            Constructor<?> constructor = clazz.getConstructor(Project.class);
            this.fComponent = (ProjectComponent)constructor.newInstance(project);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException("Could not find output tab class: " + outputTabDefinition.getClassName());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException("No suitable constructor for output tab class: " + outputTabDefinition.getClassName());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException("No suitable constructor for output tab class: " + outputTabDefinition.getClassName());
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalStateException("Failed to instantiate output tab clasS: " + outputTabDefinition.getClassName());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalStateException(invocationTargetException.getTargetException());
        }
    }

    public OutputTabDefinition getDefinition() {
        return this.fDefinition;
    }

    public Component getComponent() {
        return this.fComponent.getComponent();
    }

    public void dispose() {
        this.fComponent.dispose();
    }
}

