/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.logging;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.logging.Level;

public class Levels {
    public static final Level FAILED = Levels.createLevel("FAILED", 600, null);
    public static final Level HANDLED = Levels.createLevel("HANDLED", 550, null);

    private Levels() {
        throw new AssertionError((Object)"This class cannot be instantiated");
    }

    private static Level createLevel(String string, int n, String string2) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ClassReplacingObjectOutputStream classReplacingObjectOutputStream = new ClassReplacingObjectOutputStream(byteArrayOutputStream, LevelData.class, Level.class);
            classReplacingObjectOutputStream.writeObject(new LevelData(string, n, string2));
            classReplacingObjectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            Level level = (Level)objectInputStream.readObject();
            objectInputStream.close();
            return level;
        }
        catch (Exception exception) {
            throw new RuntimeException("Unexpected exception", exception);
        }
    }

    private static final class ClassReplacingObjectOutputStream
    extends ObjectOutputStream {
        private final ObjectStreamClass from;
        private final ObjectStreamClass to;

        ClassReplacingObjectOutputStream(OutputStream outputStream, Class clazz, Class clazz2) throws IOException {
            super(outputStream);
            this.from = ObjectStreamClass.lookup(clazz);
            this.to = ObjectStreamClass.lookup(clazz2);
        }

        protected void writeClassDescriptor(ObjectStreamClass objectStreamClass) throws IOException {
            if (this.from.equals(objectStreamClass)) {
                objectStreamClass = this.to;
            }
            super.writeClassDescriptor(objectStreamClass);
        }
    }

    private static final class LevelData
    implements Serializable {
        private static final long serialVersionUID = -8176160795706313070L;
        private final String name;
        private final int value;
        private final String resourceBundleName;

        LevelData(String string, int n, String string2) {
            this.name = string;
            this.value = n;
            this.resourceBundleName = string2;
        }
    }
}

