/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mahalo;

import com.sun.jini.constants.TxnConstants;
import com.sun.jini.mahalo.StorableObject;
import com.sun.jini.mahalo.TxnManagerImpl;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.transaction.server.TransactionConstants;
import net.jini.core.transaction.server.TransactionParticipant;
import net.jini.security.ProxyPreparer;

class ParticipantHandle
implements Serializable,
TransactionConstants {
    static final long serialVersionUID = -1776073824495304317L;
    private transient TransactionParticipant preparedPart;
    private StorableObject storedpart;
    private long crashcount;
    private int prepstate;
    private static final Logger persistenceLogger = TxnManagerImpl.persistenceLogger;

    ParticipantHandle(TransactionParticipant transactionParticipant, long l) throws RemoteException {
        block3: {
            this.crashcount = 0L;
            if (transactionParticipant == null) {
                throw new NullPointerException("TransactionParticipant argument cannot be null");
            }
            try {
                this.storedpart = new StorableObject(transactionParticipant);
                this.preparedPart = transactionParticipant;
                this.crashcount = l;
            }
            catch (RemoteException remoteException) {
                if (!persistenceLogger.isLoggable(Level.WARNING)) break block3;
                persistenceLogger.log(Level.WARNING, "Cannot store the TransactionParticipant", remoteException);
            }
        }
        this.prepstate = 1;
    }

    long getCrashCount() {
        return this.crashcount;
    }

    synchronized TransactionParticipant getPreParedParticipant() {
        return this.preparedPart;
    }

    void restoreTransientState(ProxyPreparer proxyPreparer) throws RemoteException {
        if (proxyPreparer == null) {
            throw new NullPointerException("Preparer argument cannot be null");
        }
        this.preparedPart = (TransactionParticipant)proxyPreparer.prepareProxy(this.storedpart.get());
    }

    StorableObject getStoredPart() {
        return this.storedpart;
    }

    synchronized void setPrepState(int n) {
        switch (n) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            default: {
                throw new IllegalArgumentException("ParticipantHandle: setPrepState: cannot set to " + TxnConstants.getName(n));
            }
        }
        this.prepstate = n;
    }

    synchronized int getPrepState() {
        return this.prepstate;
    }

    boolean compareTo(ParticipantHandle participantHandle) {
        if (this.storedpart != null) {
            return this.storedpart.equals(participantHandle);
        }
        if (participantHandle == null) {
            return false;
        }
        return false;
    }

    public int hashCode() {
        return this.preparedPart.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        ParticipantHandle participantHandle = (ParticipantHandle)object;
        return this.preparedPart.equals(participantHandle.preparedPart);
    }
}

