/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mahalo;

import java.io.IOException;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;

public class StorableObject
implements Serializable {
    private MarshalledObject bytes;
    private transient Object obj;
    private static final boolean DEBUG = false;
    private static final long serialVersionUID = -3793675220968988873L;

    public StorableObject(Object object) throws RemoteException {
        try {
            this.bytes = new MarshalledObject<Object>(object);
            this.obj = object;
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (IOException iOException) {
            StorableObject.fatalError("can't encode object", iOException);
        }
    }

    public int hashCode() {
        return this.bytes.hashCode();
    }

    public boolean equals(Object object) {
        try {
            if (object instanceof StorableObject) {
                return this.get().equals(((StorableObject)object).get());
            }
            return this.get().equals(object);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public Object get() throws RemoteException {
        try {
            if (this.obj == null) {
                this.obj = this.bytes.get();
            }
            return this.obj;
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (IOException iOException) {
            StorableObject.fatalError("can't decode object", iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            StorableObject.fatalError("can't decode object", classNotFoundException);
        }
        StorableObject.fatalError("how did we get here?", null);
        return null;
    }

    private static void fatalError(String string, Throwable throwable) throws RemoteException {
        System.err.println(string);
        if (throwable != null) {
            throwable.printStackTrace(System.err);
        }
        throw new RemoteException(string, throwable);
    }
}

