/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mahalo;

import com.sun.jini.config.Config;
import com.sun.jini.constants.TimeConstants;
import com.sun.jini.landlord.FixedLeasePeriodPolicy;
import com.sun.jini.landlord.Landlord;
import com.sun.jini.landlord.LandlordLease;
import com.sun.jini.landlord.LandlordUtil;
import com.sun.jini.landlord.LeaseFactory;
import com.sun.jini.landlord.LeasePeriodPolicy;
import com.sun.jini.landlord.LeasedResource;
import com.sun.jini.landlord.LocalLandlord;
import com.sun.jini.logging.Levels;
import com.sun.jini.lookup.entry.BasicServiceType;
import com.sun.jini.mahalo.JoinStateManager;
import com.sun.jini.mahalo.LeaseExpirationMgr;
import com.sun.jini.mahalo.ProxyVerifier;
import com.sun.jini.mahalo.SettlerTask;
import com.sun.jini.mahalo.TxnLogRecord;
import com.sun.jini.mahalo.TxnManager;
import com.sun.jini.mahalo.TxnManagerTransaction;
import com.sun.jini.mahalo.TxnMgrAdminProxy;
import com.sun.jini.mahalo.TxnMgrProxy;
import com.sun.jini.mahalo.TxnSettler;
import com.sun.jini.mahalo.log.LogException;
import com.sun.jini.mahalo.log.LogManager;
import com.sun.jini.mahalo.log.LogRecord;
import com.sun.jini.mahalo.log.LogRecovery;
import com.sun.jini.mahalo.log.MultiLogManager;
import com.sun.jini.mahalo.log.MultiLogManagerAdmin;
import com.sun.jini.start.LifeCycle;
import com.sun.jini.system.FileSystem;
import com.sun.jini.thread.TaskManager;
import com.sun.jini.thread.WakeupManager;
import java.io.File;
import java.io.IOException;
import java.rmi.MarshalledObject;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.Activatable;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationSystem;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import net.jini.activation.ActivationExporter;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationProvider;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.core.lookup.ServiceID;
import net.jini.core.transaction.CannotAbortException;
import net.jini.core.transaction.CannotCommitException;
import net.jini.core.transaction.CannotJoinException;
import net.jini.core.transaction.TimeoutExpiredException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;
import net.jini.core.transaction.UnknownTransactionException;
import net.jini.core.transaction.server.CrashCountException;
import net.jini.core.transaction.server.ServerTransaction;
import net.jini.core.transaction.server.TransactionManager;
import net.jini.core.transaction.server.TransactionParticipant;
import net.jini.export.Exporter;
import net.jini.export.ProxyAccessor;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.jini.jeri.BasicILFactory;
import net.jini.jeri.BasicJeriExporter;
import net.jini.jeri.InvocationLayerFactory;
import net.jini.jeri.ServerEndpoint;
import net.jini.jeri.tcp.TcpServerEndpoint;
import net.jini.lookup.entry.ServiceInfo;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.ServerProxyTrust;

class TxnManagerImpl
implements TxnManager,
LeaseExpirationMgr.Expirer,
LogRecovery,
TxnSettler,
TimeConstants,
LocalLandlord,
ServerProxyTrust,
ProxyAccessor {
    static final Logger startupLogger = Logger.getLogger("com.sun.jini.mahalo.startup");
    static final Logger initLogger = Logger.getLogger("com.sun.jini.mahalo.init");
    static final Logger destroyLogger = Logger.getLogger("com.sun.jini.mahalo.destroy");
    static final Logger operationsLogger = Logger.getLogger("com.sun.jini.mahalo.operations");
    static final Logger transactionsLogger = Logger.getLogger("com.sun.jini.mahalo.transactions");
    static final Logger participantLogger = Logger.getLogger("com.sun.jini.mahalo.participant");
    static final Logger persistenceLogger = Logger.getLogger("com.sun.jini.mahalo.persistence");
    private LogManager logmgr;
    private transient int settlerthreads = 150;
    private transient long settlertimeout = 15000L;
    private transient float settlerload = 1.0f;
    private transient int taskthreads = 50;
    private transient long tasktimeout = 15000L;
    private transient float taskload = 3.0f;
    private transient TaskManager settlerpool;
    private WakeupManager settlerWakeupMgr;
    private transient TaskManager taskpool;
    private WakeupManager taskWakeupMgr;
    private transient Map txns;
    private transient Vector unsettledtxns;
    private transient Thread settleThread;
    private String persistenceDirectory = null;
    private ActivationID activationID;
    private boolean activationPrepared;
    private ActivationSystem activationSystem;
    private ProxyPreparer participantPreparer;
    protected Exporter exporter;
    protected LoginContext loginContext;
    private static transient SecureRandom idGen = new SecureRandom();
    private static final transient byte[] idGenBuf = new byte[8];
    private LeaseExpirationMgr expMgr;
    private LeasePeriodPolicy txnLeasePeriodPolicy = null;
    private LeaseFactory leaseFactory = null;
    private JoinStateManager joinStateManager;
    private Uuid topUuid = null;
    private TxnMgrProxy txnMgrProxy;
    private TxnMgrAdminProxy txnMgrAdminProxy;
    private TxnManager serverStub = null;
    private LifeCycle lifeCycle = null;
    private boolean persistent = true;
    private static final long MAX_UNEXPORT_DELAY = 120000L;
    static /* synthetic */ Class class$com$sun$jini$mahalo$TxnManagerImpl$DestroyThread;

    TxnManagerImpl(String[] stringArray, LifeCycle lifeCycle, boolean bl) throws Exception {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "TxnManagerImpl", new Object[]{Arrays.asList(stringArray), lifeCycle, new Boolean(bl)});
        }
        this.lifeCycle = lifeCycle;
        this.persistent = bl;
        try {
            this.init(stringArray);
        }
        catch (Throwable throwable) {
            this.cleanup();
            this.initFailed(throwable);
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "TxnManagerImpl");
        }
    }

    TxnManagerImpl(ActivationID activationID, MarshalledObject marshalledObject) throws Exception {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "TxnManagerImpl", new Object[]{activationID, marshalledObject});
        }
        this.activationID = activationID;
        try {
            this.init((String[])marshalledObject.get());
        }
        catch (Throwable throwable) {
            this.cleanup();
            this.initFailed(throwable);
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "TxnManagerImpl");
        }
    }

    private void init(String[] stringArray) throws Exception {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "init", stringArray);
        }
        Configuration configuration = ConfigurationProvider.getInstance((String[])stringArray, (ClassLoader)this.getClass().getClassLoader());
        this.loginContext = (LoginContext)configuration.getEntry("com.sun.jini.mahalo", "loginContext", LoginContext.class, null);
        if (this.loginContext != null) {
            this.doInitWithLogin(configuration, this.loginContext);
        } else {
            this.doInit(configuration);
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "init");
        }
    }

    private void doInitWithLogin(final Configuration configuration, LoginContext loginContext) throws Exception {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "doInitWithLogin", new Object[]{configuration, loginContext});
        }
        loginContext.login();
        try {
            Subject.doAsPrivileged(loginContext.getSubject(), new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    TxnManagerImpl.this.doInit(configuration);
                    return null;
                }
            }, null);
        }
        catch (PrivilegedActionException privilegedActionException) {
            block6: {
                try {
                    loginContext.logout();
                }
                catch (LoginException loginException) {
                    if (!initLogger.isLoggable(Levels.HANDLED)) break block6;
                    initLogger.log(Levels.HANDLED, "Trouble logging out", loginException);
                }
            }
            throw privilegedActionException.getException();
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "doInitWithLogin");
        }
    }

    private void doInit(Configuration configuration) throws Exception {
        Object object;
        ProxyPreparer proxyPreparer;
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "doInit", configuration);
        }
        if (this.activationID != null) {
            proxyPreparer = (ProxyPreparer)Config.getNonNullEntry(configuration, "com.sun.jini.mahalo", "activationSystemPreparer", ProxyPreparer.class, new BasicProxyPreparer());
            if (initLogger.isLoggable(Level.CONFIG)) {
                initLogger.log(Level.CONFIG, "activationSystemPreparer: {0}", proxyPreparer);
            }
            this.activationSystem = (ActivationSystem)proxyPreparer.prepareProxy((Object)ActivationGroup.getSystem());
            if (initLogger.isLoggable(Level.CONFIG)) {
                initLogger.log(Level.CONFIG, "Prepared activation system is: {0}", this.activationSystem);
            }
            object = (ProxyPreparer)Config.getNonNullEntry(configuration, "com.sun.jini.mahalo", "activationIdPreparer", ProxyPreparer.class, new BasicProxyPreparer());
            if (initLogger.isLoggable(Level.CONFIG)) {
                initLogger.log(Level.CONFIG, "activationIdPreparer: {0}", object);
            }
            this.activationID = (ActivationID)object.prepareProxy((Object)this.activationID);
            if (initLogger.isLoggable(Level.CONFIG)) {
                initLogger.log(Level.CONFIG, "Prepared activationID is: {0}", this.activationID);
            }
            this.activationPrepared = true;
            this.exporter = (Exporter)Config.getNonNullEntry(configuration, "com.sun.jini.mahalo", "serverExporter", Exporter.class, new ActivationExporter(this.activationID, (Exporter)new BasicJeriExporter((ServerEndpoint)TcpServerEndpoint.getInstance((int)0), (InvocationLayerFactory)new BasicILFactory(), false, true)), this.activationID);
            if (initLogger.isLoggable(Level.CONFIG)) {
                initLogger.log(Level.CONFIG, "Activatable service exporter is: {0}", this.exporter);
            }
        } else {
            this.exporter = (Exporter)Config.getNonNullEntry(configuration, "com.sun.jini.mahalo", "serverExporter", Exporter.class, new BasicJeriExporter((ServerEndpoint)TcpServerEndpoint.getInstance((int)0), (InvocationLayerFactory)new BasicILFactory(), false, true));
            if (initLogger.isLoggable(Level.CONFIG)) {
                initLogger.log(Level.CONFIG, "Non-activatable service exporter is: {0}", this.exporter);
            }
        }
        proxyPreparer = (ProxyPreparer)Config.getNonNullEntry(configuration, "com.sun.jini.mahalo", "recoveredParticipantPreparer", ProxyPreparer.class, new BasicProxyPreparer());
        if (initLogger.isLoggable(Level.CONFIG)) {
            initLogger.log(Level.CONFIG, "Recovered participant preparer is: {0}", proxyPreparer);
        }
        this.participantPreparer = (ProxyPreparer)Config.getNonNullEntry(configuration, "com.sun.jini.mahalo", "participantPreparer", ProxyPreparer.class, new BasicProxyPreparer());
        if (initLogger.isLoggable(Level.CONFIG)) {
            initLogger.log(Level.CONFIG, "Participant preparer is: {0}", this.participantPreparer);
        }
        this.txnLeasePeriodPolicy = (LeasePeriodPolicy)Config.getNonNullEntry(configuration, "com.sun.jini.mahalo", "leasePeriodPolicy", LeasePeriodPolicy.class, new FixedLeasePeriodPolicy(10800000L, 3600000L));
        if (initLogger.isLoggable(Level.CONFIG)) {
            initLogger.log(Level.CONFIG, "leasePeriodPolicy is: {0}", this.txnLeasePeriodPolicy);
        }
        if (this.persistent) {
            this.persistenceDirectory = (String)Config.getNonNullEntry(configuration, "com.sun.jini.mahalo", "persistenceDirectory", String.class);
            if (initLogger.isLoggable(Level.CONFIG)) {
                initLogger.log(Level.CONFIG, "Persistence directory is: {0}", this.persistenceDirectory);
            }
        } else {
            this.persistenceDirectory = null;
        }
        if (initLogger.isLoggable(Level.FINEST)) {
            initLogger.log(Level.FINEST, "Creating JoinStateManager");
        }
        this.joinStateManager = new JoinStateManager(this.persistenceDirectory);
        if (initLogger.isLoggable(Level.FINEST)) {
            initLogger.log(Level.FINEST, "Recovering join state ...");
        }
        this.joinStateManager.recover();
        if (this.joinStateManager.getServiceUuid() == null) {
            if (initLogger.isLoggable(Level.FINEST)) {
                initLogger.log(Level.FINEST, "Generating service Uuid");
            }
            this.topUuid = UuidFactory.generate();
            this.joinStateManager.setServiceUuid(this.topUuid);
        } else {
            if (initLogger.isLoggable(Level.FINEST)) {
                initLogger.log(Level.FINEST, "Recovering service Uuid");
            }
            this.topUuid = this.joinStateManager.getServiceUuid();
        }
        if (initLogger.isLoggable(Level.FINEST)) {
            initLogger.log(Level.FINEST, "Uuid is: {0}", this.topUuid);
        }
        if (this.persistent) {
            FileSystem.ensureDir(this.persistenceDirectory);
        }
        if (initLogger.isLoggable(Level.FINEST)) {
            initLogger.log(Level.FINEST, "Exporting server");
        }
        this.serverStub = (TxnManager)this.exporter.export((Remote)this);
        if (initLogger.isLoggable(Level.FINEST)) {
            initLogger.log(Level.FINEST, "Server stub: {0}", this.serverStub);
        }
        this.txnMgrProxy = TxnMgrProxy.create(this.serverStub, this.topUuid);
        if (initLogger.isLoggable(Level.FINEST)) {
            initLogger.log(Level.FINEST, "Service proxy is: {0}", this.txnMgrProxy);
        }
        this.txnMgrAdminProxy = TxnMgrAdminProxy.create(this.serverStub, this.topUuid);
        if (initLogger.isLoggable(Level.FINEST)) {
            initLogger.log(Level.FINEST, "Service admin proxy is: {0}", this.txnMgrAdminProxy);
        }
        if (initLogger.isLoggable(Level.FINEST)) {
            initLogger.log(Level.FINEST, "Setting up data structures");
        }
        this.txns = Collections.synchronizedMap(new HashMap());
        this.settlerWakeupMgr = new WakeupManager(new WakeupManager.ThreadDesc(null, true));
        this.taskWakeupMgr = new WakeupManager(new WakeupManager.ThreadDesc(null, true));
        this.settlerpool = new TaskManager(this.settlerthreads, this.settlertimeout, this.settlerload);
        this.taskpool = new TaskManager(this.taskthreads, this.tasktimeout, this.taskload);
        this.unsettledtxns = new Vector();
        this.leaseFactory = new LeaseFactory(this.serverStub, this.topUuid);
        this.expMgr = new LeaseExpirationMgr(this);
        if (initLogger.isLoggable(Level.FINEST)) {
            initLogger.log(Level.FINEST, "Setting up log manager");
        }
        this.logmgr = this.persistent ? new MultiLogManager(this, this.persistenceDirectory) : new MultiLogManager();
        try {
            if (initLogger.isLoggable(Level.FINEST)) {
                initLogger.log(Level.FINEST, "Recovering state");
            }
            this.logmgr.recover();
            object = this.txns.values().iterator();
            while (object.hasNext()) {
                TxnManagerTransaction txnManagerTransaction = (TxnManagerTransaction)object.next();
                if (initLogger.isLoggable(Level.FINEST)) {
                    initLogger.log(Level.FINEST, "Restoring transient state for txn id: {0}", new Long(((ServerTransaction)txnManagerTransaction.getTransaction()).id));
                }
                try {
                    txnManagerTransaction.restoreTransientState(proxyPreparer);
                }
                catch (RemoteException remoteException) {
                    if (!persistenceLogger.isLoggable(Level.WARNING)) continue;
                    persistenceLogger.log(Level.WARNING, "Cannot restore the TransactionParticipant", remoteException);
                }
            }
            if (initLogger.isLoggable(Level.FINEST)) {
                initLogger.log(Level.FINEST, "Settling incomplete transactions");
            }
            this.settleThread = new Thread("settleThread"){

                public void run() {
                    try {
                        TxnManagerImpl.this.settleTxns();
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
            };
            this.settleThread.start();
        }
        catch (LogException logException) {
            RemoteException remoteException = new RemoteException("Problem recovering state");
            initLogger.throwing(TxnManagerImpl.class.getName(), "doInit", remoteException);
            throw remoteException;
        }
        TxnManagerImpl.nextID();
        if (initLogger.isLoggable(Level.FINEST)) {
            initLogger.log(Level.FINEST, "Starting JoinStateManager");
        }
        this.joinStateManager.startManager(configuration, this.txnMgrProxy, new ServiceID(this.topUuid.getMostSignificantBits(), this.topUuid.getLeastSignificantBits()), TxnManagerImpl.attributesFor());
        if (startupLogger.isLoggable(Level.INFO)) {
            startupLogger.log(Level.INFO, "Mahalo started: {0}", this);
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "doInit");
        }
    }

    public TransactionManager.Created create(long l) throws LeaseDeniedException {
        LeasePeriodPolicy.Result result;
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "create", new Long(l));
        }
        TxnManagerTransaction txnManagerTransaction = null;
        long l2 = TxnManagerImpl.nextID();
        Uuid uuid = this.createLeaseUuid(l2);
        if (transactionsLogger.isLoggable(Level.FINEST)) {
            transactionsLogger.log(Level.FINEST, "Transaction ID is: {0}", new Long(l2));
        }
        txnManagerTransaction = new TxnManagerTransaction(this.txnMgrProxy, this.logmgr, l2, this.taskpool, this.taskWakeupMgr, this, uuid);
        LandlordLease landlordLease = null;
        try {
            result = this.txnLeasePeriodPolicy.grant(txnManagerTransaction, l);
            txnManagerTransaction.setExpiration(result.expiration);
            landlordLease = this.leaseFactory.newLease(uuid, result.expiration);
            this.expMgr.register(txnManagerTransaction);
        }
        catch (LeaseDeniedException leaseDeniedException) {
            throw new AssertionError((Object)("Transaction lease was denied" + (Object)((Object)leaseDeniedException)));
        }
        if (transactionsLogger.isLoggable(Level.FINEST)) {
            transactionsLogger.log(Level.FINEST, "Created new TxnManagerTransaction ID is: {0}", new Long(l2));
        }
        result = txnManagerTransaction.getTransaction();
        ServerTransaction serverTransaction = null;
        try {
            serverTransaction = this.serverTransaction((Transaction)result);
            this.txns.put(new Long(serverTransaction.id), txnManagerTransaction);
            if (transactionsLogger.isLoggable(Level.FINEST)) {
                transactionsLogger.log(Level.FINEST, "recorded new TxnManagerTransaction", txnManagerTransaction);
            }
        }
        catch (Exception exception) {
            if (transactionsLogger.isLoggable(Level.FINEST)) {
                transactionsLogger.log(Level.FINEST, "Problem creating transaction", exception);
            }
            RuntimeException runtimeException = new RuntimeException("Unable to create transaction", exception);
            transactionsLogger.throwing(TxnManagerImpl.class.getName(), "create", runtimeException);
            throw runtimeException;
        }
        TransactionManager.Created created = new TransactionManager.Created(serverTransaction.id, (Lease)landlordLease);
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "create", created);
        }
        return created;
    }

    public void join(long l, TransactionParticipant transactionParticipant, long l2) throws UnknownTransactionException, CannotJoinException, CrashCountException, RemoteException {
        TxnManagerTransaction txnManagerTransaction;
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "join", new Object[]{new Long(l), transactionParticipant, new Long(l2)});
        }
        TransactionParticipant transactionParticipant2 = null;
        transactionParticipant2 = (TransactionParticipant)this.participantPreparer.prepareProxy((Object)transactionParticipant);
        if (participantLogger.isLoggable(Level.FINEST)) {
            participantLogger.log(Level.FINEST, "prepared participant: {0}", transactionParticipant2);
        }
        if ((txnManagerTransaction = (TxnManagerTransaction)this.txns.get(new Long(l))) == null) {
            throw new UnknownTransactionException("unknown transaction");
        }
        txnManagerTransaction.join(transactionParticipant2, l2);
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "join");
        }
    }

    public int getState(long l) throws UnknownTransactionException {
        TxnManagerTransaction txnManagerTransaction;
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "getState", new Object[]{new Long(l)});
        }
        if ((txnManagerTransaction = (TxnManagerTransaction)this.txns.get(new Long(l))) == null) {
            throw new UnknownTransactionException("unknown transaction");
        }
        int n = txnManagerTransaction.getState();
        if (n == 1 && !TxnManagerImpl.ensureCurrent(txnManagerTransaction)) {
            throw new UnknownTransactionException("unknown transaction");
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "getState", new Integer(n));
        }
        return n;
    }

    public void commit(long l) throws UnknownTransactionException, CannotCommitException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "commit", new Long(l));
        }
        try {
            this.commit(l, 0L);
        }
        catch (TimeoutExpiredException timeoutExpiredException) {
            // empty catch block
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "commit");
        }
    }

    public void commit(long l, long l2) throws UnknownTransactionException, CannotCommitException, TimeoutExpiredException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "commit", new Object[]{new Long(l), new Long(l2)});
        }
        TxnManagerTransaction txnManagerTransaction = (TxnManagerTransaction)this.txns.get(new Long(l));
        if (transactionsLogger.isLoggable(Level.FINEST)) {
            transactionsLogger.log(Level.FINEST, "Retrieved TxnManagerTransaction: {0}", txnManagerTransaction);
        }
        if (txnManagerTransaction == null) {
            throw new UnknownTransactionException("Unknown transaction");
        }
        txnManagerTransaction.commit(l2);
        this.txns.remove(new Long(l));
        if (transactionsLogger.isLoggable(Level.FINEST)) {
            transactionsLogger.log(Level.FINEST, "Committed transaction id {0}", new Long(l));
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "commit");
        }
    }

    public void abort(long l) throws UnknownTransactionException, CannotAbortException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "abort", new Object[]{new Long(l)});
        }
        try {
            this.abort(l, 0L);
        }
        catch (TimeoutExpiredException timeoutExpiredException) {
            // empty catch block
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "abort");
        }
    }

    public void abort(long l, long l2) throws UnknownTransactionException, CannotAbortException, TimeoutExpiredException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "abort", new Object[]{new Long(l), new Long(l2)});
        }
        TxnManagerTransaction txnManagerTransaction = (TxnManagerTransaction)this.txns.get(new Long(l));
        if (transactionsLogger.isLoggable(Level.FINEST)) {
            transactionsLogger.log(Level.FINEST, "Retrieved TxnManagerTransaction: {0}", txnManagerTransaction);
        }
        if (txnManagerTransaction == null) {
            throw new CannotAbortException();
        }
        txnManagerTransaction.abort(l2);
        this.txns.remove(new Long(l));
        if (transactionsLogger.isLoggable(Level.FINEST)) {
            transactionsLogger.log(Level.FINEST, "aborted transaction id {0}", new Long(l));
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "abort");
        }
    }

    public void recover(long l, LogRecord logRecord) throws LogException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "recover", new Object[]{new Long(l), logRecord});
        }
        TxnManagerTransaction txnManagerTransaction = this.enterTMT(l);
        TxnLogRecord txnLogRecord = (TxnLogRecord)logRecord;
        txnLogRecord.recover(txnManagerTransaction);
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "recover");
        }
    }

    public synchronized void noteUnsettledTxn(long l) {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "noteUnsettledTxn", new Object[]{new Long(l)});
        }
        this.unsettledtxns.add(new Long(l));
        this.notifyAll();
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "noteUnsettledTxn");
        }
    }

    private synchronized void settleTxns() throws InterruptedException {
        Object var1_1 = null;
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "settleTxns");
        }
        if (transactionsLogger.isLoggable(Level.FINEST)) {
            transactionsLogger.log(Level.FINEST, "Settling {0} transactions.", new Integer(this.unsettledtxns.size()));
        }
        int n = 0;
        Long l = null;
        long l2 = 0L;
        while (true) {
            if ((n = this.unsettledtxns.size()) == 0) {
                if (transactionsLogger.isLoggable(Level.FINEST)) {
                    transactionsLogger.log(Level.FINEST, "Settler waiting");
                }
                this.wait();
                if (!transactionsLogger.isLoggable(Level.FINEST)) continue;
                transactionsLogger.log(Level.FINEST, "Settler notified");
                continue;
            }
            l = null;
            l = (Long)this.unsettledtxns.firstElement();
            l2 = l;
            SettlerTask settlerTask = new SettlerTask(this.settlerpool, this.settlerWakeupMgr, this, l2);
            this.settlerpool.add(settlerTask);
            this.unsettledtxns.remove(l);
            Thread.currentThread();
            if (Thread.interrupted()) {
                throw new InterruptedException("settleTxns interrupted");
            }
            if (!transactionsLogger.isLoggable(Level.FINEST)) continue;
            transactionsLogger.log(Level.FINEST, "Added SettlerTask for tid {0}", new Long(l2));
        }
    }

    public Transaction getTransaction(long l) throws UnknownTransactionException {
        if (l == -1L) {
            return null;
        }
        TxnManagerTransaction txnManagerTransaction = (TxnManagerTransaction)this.txns.get(new Long(l));
        if (txnManagerTransaction == null) {
            throw new UnknownTransactionException("unknown transaction");
        }
        Transaction transaction = txnManagerTransaction.getTransaction();
        ServerTransaction serverTransaction = this.serverTransaction(transaction);
        if (serverTransaction == null) {
            throw new UnknownTransactionException("TxnManagerImpl: getTransaction: unable to find transaction(" + l + ")");
        }
        if (!serverTransaction.mgr.equals(this)) {
            throw new UnknownTransactionException("wrong manager (" + serverTransaction.mgr + " instead of " + this + ")");
        }
        return serverTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long renew(Uuid uuid, long l) throws UnknownLeaseException, LeaseDeniedException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "renew", new Object[]{uuid, new Long(l)});
        }
        this.verifyLeaseUuid(uuid);
        Long l2 = this.getLeaseTid(uuid);
        TxnManagerTransaction txnManagerTransaction = (TxnManagerTransaction)this.txns.get(l2);
        if (txnManagerTransaction == null) {
            throw new UnknownLeaseException();
        }
        TxnManagerTransaction txnManagerTransaction2 = txnManagerTransaction;
        synchronized (txnManagerTransaction2) {
            if (!TxnManagerImpl.ensureCurrent(txnManagerTransaction)) {
                throw new UnknownLeaseException("Lease already expired");
            }
            long l3 = txnManagerTransaction.getExpiration();
            LeasePeriodPolicy.Result result = this.txnLeasePeriodPolicy.renew(txnManagerTransaction, l);
            txnManagerTransaction.setExpiration(result.expiration);
            this.expMgr.renewed(txnManagerTransaction);
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(TxnManagerImpl.class.getName(), "renew", new Object[]{new Long(result.duration)});
            }
            return result.duration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(Uuid uuid) throws UnknownLeaseException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "cancel", new Object[]{uuid});
        }
        this.verifyLeaseUuid(uuid);
        Long l = this.getLeaseTid(uuid);
        TxnManagerTransaction txnManagerTransaction = (TxnManagerTransaction)this.txns.get(l);
        if (txnManagerTransaction == null) {
            throw new UnknownLeaseException();
        }
        int n = txnManagerTransaction.getState();
        if (n == 1) {
            TxnManagerTransaction txnManagerTransaction2 = txnManagerTransaction;
            synchronized (txnManagerTransaction2) {
                txnManagerTransaction.setExpiration(0L);
            }
            try {
                this.abort(l);
            }
            catch (TransactionException transactionException) {
                throw new UnknownLeaseException("When canceling abort threw:" + ((Object)((Object)transactionException)).getClass().getName() + ":" + transactionException.getLocalizedMessage());
            }
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "cancel");
        }
    }

    public Landlord.RenewResults renewAll(Uuid[] uuidArray, long[] lArray) {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "renewAll");
        }
        Landlord.RenewResults renewResults = LandlordUtil.renewAll(this, uuidArray, lArray);
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "renewAll");
        }
        return renewResults;
    }

    public Map cancelAll(Uuid[] uuidArray) {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "cancelAll");
        }
        Map map = LandlordUtil.cancelAll(this, uuidArray);
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "cancelAll");
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long nextID() {
        long l;
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "nextID");
        }
        SecureRandom secureRandom = idGen;
        synchronized (secureRandom) {
            do {
                l = 0L;
                idGen.nextBytes(idGenBuf);
                for (int i = 0; i < 8; ++i) {
                    l = l << 8 | (long)(idGenBuf[i] & 0xFF);
                }
            } while (l == 0L);
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "nextID", new Long(l));
        }
        return l;
    }

    private ServerTransaction serverTransaction(Transaction transaction) throws UnknownTransactionException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "serverTransaction", transaction);
        }
        try {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(TxnManagerImpl.class.getName(), "serverTransaction", transaction);
            }
            return (ServerTransaction)transaction;
        }
        catch (ClassCastException classCastException) {
            throw new UnknownTransactionException("unexpected transaction type");
        }
    }

    public TransactionManager manager() {
        return this.txnMgrProxy;
    }

    private TxnManagerTransaction enterTMT(long l) {
        TxnManagerTransaction txnManagerTransaction;
        Long l2 = new Long(l);
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "enterTMT", l2);
        }
        if ((txnManagerTransaction = (TxnManagerTransaction)this.txns.get(l2)) == null) {
            Uuid uuid = this.createLeaseUuid(l);
            txnManagerTransaction = new TxnManagerTransaction(this.txnMgrProxy, this.logmgr, l, this.taskpool, this.taskWakeupMgr, this, uuid);
            this.noteUnsettledTxn(l);
        }
        this.txns.put(l2, txnManagerTransaction);
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "enterTMT", txnManagerTransaction);
        }
        return txnManagerTransaction;
    }

    public void destroy() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "destroy");
        }
        new DestroyThread().start();
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "destroy");
        }
    }

    public Object getAdmin() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "getAdmin");
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "getAdmin", this.txnMgrAdminProxy);
        }
        return this.txnMgrAdminProxy;
    }

    public Entry[] getLookupAttributes() {
        return this.joinStateManager.getLookupAttributes();
    }

    public void addLookupAttributes(Entry[] entryArray) {
        this.joinStateManager.addLookupAttributes(entryArray);
    }

    public void modifyLookupAttributes(Entry[] entryArray, Entry[] entryArray2) {
        this.joinStateManager.modifyLookupAttributes(entryArray, entryArray2);
    }

    public String[] getLookupGroups() {
        return this.joinStateManager.getLookupGroups();
    }

    public void addLookupGroups(String[] stringArray) {
        this.joinStateManager.addLookupGroups(stringArray);
    }

    public void removeLookupGroups(String[] stringArray) {
        this.joinStateManager.removeLookupGroups(stringArray);
    }

    public void setLookupGroups(String[] stringArray) {
        this.joinStateManager.setLookupGroups(stringArray);
    }

    public LookupLocator[] getLookupLocators() {
        return this.joinStateManager.getLookupLocators();
    }

    public void addLookupLocators(LookupLocator[] lookupLocatorArray) throws RemoteException {
        this.joinStateManager.addLookupLocators(lookupLocatorArray);
    }

    public void removeLookupLocators(LookupLocator[] lookupLocatorArray) throws RemoteException {
        this.joinStateManager.removeLookupLocators(lookupLocatorArray);
    }

    public void setLookupLocators(LookupLocator[] lookupLocatorArray) throws RemoteException {
        this.joinStateManager.setLookupLocators(lookupLocatorArray);
    }

    private static Entry[] attributesFor() {
        ServiceInfo serviceInfo = new ServiceInfo("Transaction Manager", "Sun Microsystems, Inc.", "Sun Microsystems, Inc.", "2.0_002", "", "");
        BasicServiceType basicServiceType = new BasicServiceType("Transaction Manager");
        return new Entry[]{serviceInfo, basicServiceType};
    }

    public Object getProxy() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "getProxy");
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "getProxy", this.serverStub);
        }
        return this.serverStub;
    }

    public Object getServiceProxy() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "getServiceProxy");
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "getServiceProxy", this.txnMgrProxy);
        }
        return this.txnMgrProxy;
    }

    protected void initFailed(Throwable throwable) throws Exception {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "initFailed");
        }
        if (initLogger.isLoggable(Level.SEVERE)) {
            initLogger.log(Level.SEVERE, "Mahalo failed to initialize", throwable);
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "initFailed");
        }
        if (throwable instanceof Exception) {
            throw (Exception)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        IllegalStateException illegalStateException = new IllegalStateException(throwable.getMessage());
        illegalStateException.initCause(throwable);
        throw illegalStateException;
    }

    private void cleanup() {
        block32: {
            block31: {
                block30: {
                    block29: {
                        block28: {
                            if (operationsLogger.isLoggable(Level.FINER)) {
                                operationsLogger.entering(TxnManagerImpl.class.getName(), "cleanup");
                            }
                            if (this.serverStub != null) {
                                try {
                                    if (initLogger.isLoggable(Level.FINEST)) {
                                        initLogger.log(Level.FINEST, "Unexporting service");
                                    }
                                    this.exporter.unexport(true);
                                }
                                catch (Throwable throwable) {
                                    if (!initLogger.isLoggable(Levels.HANDLED)) break block28;
                                    initLogger.log(Levels.HANDLED, "Trouble unexporting service", throwable);
                                }
                            }
                        }
                        if (this.settlerpool != null) {
                            if (initLogger.isLoggable(Level.FINEST)) {
                                initLogger.log(Level.FINEST, "Terminating settlerpool.");
                            }
                            try {
                                this.settlerpool.terminate();
                                if (this.settlerWakeupMgr != null) {
                                    if (initLogger.isLoggable(Level.FINEST)) {
                                        initLogger.log(Level.FINEST, "Terminating settlerWakeupMgr.");
                                    }
                                    this.settlerWakeupMgr.stop();
                                    this.settlerWakeupMgr.cancelAll();
                                }
                            }
                            catch (Throwable throwable) {
                                if (!initLogger.isLoggable(Levels.HANDLED)) break block29;
                                initLogger.log(Levels.HANDLED, "Trouble terminating settlerpool", throwable);
                            }
                        }
                    }
                    if (this.taskpool != null) {
                        if (initLogger.isLoggable(Level.FINEST)) {
                            initLogger.log(Level.FINEST, "Terminating taskpool.");
                        }
                        try {
                            this.taskpool.terminate();
                            if (this.taskWakeupMgr != null) {
                                if (initLogger.isLoggable(Level.FINEST)) {
                                    initLogger.log(Level.FINEST, "Terminating taskWakeupMgr.");
                                }
                                this.taskWakeupMgr.stop();
                                this.taskWakeupMgr.cancelAll();
                            }
                        }
                        catch (Throwable throwable) {
                            if (!initLogger.isLoggable(Levels.HANDLED)) break block30;
                            initLogger.log(Levels.HANDLED, "Trouble terminating taskpool", throwable);
                        }
                    }
                }
                if (this.settleThread != null) {
                    if (initLogger.isLoggable(Level.FINEST)) {
                        initLogger.log(Level.FINEST, "Interrupting settleThread.");
                    }
                    try {
                        this.settleThread.interrupt();
                    }
                    catch (Throwable throwable) {
                        if (!initLogger.isLoggable(Levels.HANDLED)) break block31;
                        initLogger.log(Levels.HANDLED, "Trouble terminating settleThread", throwable);
                    }
                }
            }
            if (this.expMgr != null) {
                if (initLogger.isLoggable(Level.FINEST)) {
                    initLogger.log(Level.FINEST, "Terminating lease expiration manager.");
                }
                this.expMgr.terminate();
            }
            if (initLogger.isLoggable(Level.FINEST)) {
                initLogger.log(Level.FINEST, "Destroying JoinStateManager.");
            }
            try {
                if (this.joinStateManager != null) {
                    this.joinStateManager.stop();
                }
            }
            catch (Exception exception) {
                if (!initLogger.isLoggable(Levels.HANDLED)) break block32;
                initLogger.log(Levels.HANDLED, "Problem destroying JoinStateManager", exception);
            }
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "cleanup");
        }
    }

    public TrustVerifier getProxyVerifier() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "getProxyVerifier");
        }
        if (!(this.txnMgrProxy instanceof RemoteMethodControl)) {
            throw new UnsupportedOperationException();
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "getProxyVerifier");
        }
        return new ProxyVerifier(this.serverStub, this.topUuid);
    }

    private static boolean ensureCurrent(LeasedResource leasedResource) {
        return leasedResource.getExpiration() > System.currentTimeMillis();
    }

    private Uuid createLeaseUuid(long l) {
        return UuidFactory.create((long)this.topUuid.getLeastSignificantBits(), (long)l);
    }

    private void verifyLeaseUuid(Uuid uuid) throws UnknownLeaseException {
        if (uuid.getMostSignificantBits() != this.topUuid.getLeastSignificantBits()) {
            throw new UnknownLeaseException();
        }
    }

    private Long getLeaseTid(Uuid uuid) {
        return new Long(uuid.getLeastSignificantBits());
    }

    private class DestroyThread
    extends Thread {
        public DestroyThread() {
            super("DestroyThread");
            this.setDaemon(false);
        }

        public void run() {
            block44: {
                block43: {
                    block42: {
                        block41: {
                            block40: {
                                block39: {
                                    if (operationsLogger.isLoggable(Level.FINER)) {
                                        operationsLogger.entering((class$com$sun$jini$mahalo$TxnManagerImpl$DestroyThread == null ? (class$com$sun$jini$mahalo$TxnManagerImpl$DestroyThread = TxnManagerImpl.class$("com.sun.jini.mahalo.TxnManagerImpl$DestroyThread")) : class$com$sun$jini$mahalo$TxnManagerImpl$DestroyThread).getName(), "run");
                                    }
                                    Object var1_1 = null;
                                    if (TxnManagerImpl.this.activationPrepared) {
                                        try {
                                            if (destroyLogger.isLoggable(Level.FINEST)) {
                                                destroyLogger.log(Level.FINEST, "Unregistering object.");
                                            }
                                            if (TxnManagerImpl.this.activationID != null) {
                                                TxnManagerImpl.this.activationSystem.unregisterObject(TxnManagerImpl.this.activationID);
                                            }
                                        }
                                        catch (RemoteException remoteException) {
                                            if (destroyLogger.isLoggable(Levels.HANDLED)) {
                                                destroyLogger.log(Levels.HANDLED, "Trouble unregistering object.", remoteException);
                                            }
                                            return;
                                        }
                                        catch (ActivationException activationException) {
                                            if (!destroyLogger.isLoggable(Levels.HANDLED)) break block39;
                                            destroyLogger.log(Levels.HANDLED, "Trouble unregistering object.", activationException);
                                        }
                                    }
                                }
                                if (destroyLogger.isLoggable(Level.FINEST)) {
                                    destroyLogger.log(Level.FINEST, "Attempting unforced unexport.");
                                }
                                long l = System.currentTimeMillis() + 120000L;
                                boolean bl = false;
                                boolean bl2 = false;
                                while (!bl && System.currentTimeMillis() < l) {
                                    bl = TxnManagerImpl.this.exporter.unexport(false);
                                    if (bl) continue;
                                    Thread.yield();
                                }
                                if (!bl) {
                                    if (destroyLogger.isLoggable(Level.FINEST)) {
                                        destroyLogger.log(Level.FINEST, "Attempting forced unexport.");
                                    }
                                    bl2 = true;
                                    bl = TxnManagerImpl.this.exporter.unexport(true);
                                }
                                if (destroyLogger.isLoggable(Level.FINEST)) {
                                    destroyLogger.log(Level.FINEST, "Destroying JoinStateManager.");
                                }
                                try {
                                    TxnManagerImpl.this.joinStateManager.destroy();
                                }
                                catch (Exception exception) {
                                    if (!destroyLogger.isLoggable(Levels.HANDLED)) break block40;
                                    destroyLogger.log(Levels.HANDLED, "Problem destroying JoinStateManager", exception);
                                }
                            }
                            if (destroyLogger.isLoggable(Level.FINEST)) {
                                destroyLogger.log(Level.FINEST, "Terminating lease expiration manager.");
                            }
                            TxnManagerImpl.this.expMgr.terminate();
                            if (destroyLogger.isLoggable(Level.FINEST)) {
                                destroyLogger.log(Level.FINEST, "Interrupting settleThread.");
                            }
                            TxnManagerImpl.this.settleThread.interrupt();
                            try {
                                TxnManagerImpl.this.settleThread.join();
                            }
                            catch (InterruptedException interruptedException) {
                                if (!destroyLogger.isLoggable(Levels.HANDLED)) break block41;
                                destroyLogger.log(Levels.HANDLED, "Problem stopping settleThread", interruptedException);
                            }
                        }
                        if (destroyLogger.isLoggable(Level.FINEST)) {
                            destroyLogger.log(Level.FINEST, "Terminating settlerpool.");
                        }
                        TxnManagerImpl.this.settlerpool.terminate();
                        TxnManagerImpl.this.settlerWakeupMgr.stop();
                        TxnManagerImpl.this.settlerWakeupMgr.cancelAll();
                        if (destroyLogger.isLoggable(Level.FINEST)) {
                            destroyLogger.log(Level.FINEST, "Terminating taskpool.");
                        }
                        TxnManagerImpl.this.taskpool.terminate();
                        TxnManagerImpl.this.taskWakeupMgr.stop();
                        TxnManagerImpl.this.taskWakeupMgr.cancelAll();
                        if (destroyLogger.isLoggable(Level.FINEST)) {
                            destroyLogger.log(Level.FINEST, "Destroying transaction logs.");
                        }
                        MultiLogManagerAdmin multiLogManagerAdmin = (MultiLogManagerAdmin)TxnManagerImpl.this.logmgr.getAdmin();
                        multiLogManagerAdmin.destroy();
                        if (TxnManagerImpl.this.persistent) {
                            if (destroyLogger.isLoggable(Level.FINEST)) {
                                destroyLogger.log(Level.FINEST, "Destroying persistence directory.");
                            }
                            try {
                                FileSystem.destroy(new File(TxnManagerImpl.this.persistenceDirectory), true);
                            }
                            catch (IOException iOException) {
                                if (!destroyLogger.isLoggable(Levels.HANDLED)) break block42;
                                destroyLogger.log(Levels.HANDLED, "Problem destroying persistence directory", iOException);
                            }
                        }
                    }
                    if (TxnManagerImpl.this.activationID != null) {
                        if (destroyLogger.isLoggable(Level.FINEST)) {
                            destroyLogger.log(Level.FINEST, "Calling Activatable.inactive.");
                        }
                        try {
                            Activatable.inactive((ActivationID)TxnManagerImpl.this.activationID);
                        }
                        catch (RemoteException remoteException) {
                            if (destroyLogger.isLoggable(Levels.HANDLED)) {
                                destroyLogger.log(Levels.HANDLED, "Problem inactivating service", remoteException);
                            }
                        }
                        catch (ActivationException activationException) {
                            if (!destroyLogger.isLoggable(Levels.HANDLED)) break block43;
                            destroyLogger.log(Levels.HANDLED, "Problem inactivating service", activationException);
                        }
                    }
                }
                if (TxnManagerImpl.this.lifeCycle != null) {
                    if (destroyLogger.isLoggable(Level.FINEST)) {
                        destroyLogger.log(Level.FINEST, "Unregistering with LifeCycle.");
                    }
                    TxnManagerImpl.this.lifeCycle.unregister(TxnManagerImpl.this);
                }
                if (TxnManagerImpl.this.loginContext != null) {
                    try {
                        if (destroyLogger.isLoggable(Level.FINEST)) {
                            destroyLogger.log(Level.FINEST, "Logging out");
                        }
                        TxnManagerImpl.this.loginContext.logout();
                    }
                    catch (Exception exception) {
                        if (!destroyLogger.isLoggable(Levels.HANDLED)) break block44;
                        destroyLogger.log(Levels.HANDLED, "Exception while logging out", exception);
                    }
                }
            }
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting((class$com$sun$jini$mahalo$TxnManagerImpl$DestroyThread == null ? (class$com$sun$jini$mahalo$TxnManagerImpl$DestroyThread = TxnManagerImpl.class$("com.sun.jini.mahalo.TxnManagerImpl$DestroyThread")) : class$com$sun$jini$mahalo$TxnManagerImpl$DestroyThread).getName(), "run");
            }
        }
    }
}

