/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.jmi;

import com.mathworks.jmi.NativeMatlab;
import com.mathworks.mvm.MVM;
import com.mathworks.mvm.context.MvmContext;
import com.mathworks.util.MatlabThreadException;
import com.mathworks.util.PlatformInfo;
import java.awt.EventQueue;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Vector;
import java.util.concurrent.Callable;

public class AWTUtilities {
    private static int sTimeout = 0;
    private static int sInvokeCount = 0;
    private static int sWatchDogCount = 0;
    private static final Collection<InvokerObservable> OBSERVABLES = new Vector<InvokerObservable>();

    private AWTUtilities() {
    }

    public static void invokeLater(Object object, Method method, Object[] objectArray) {
        Invoker invoker = new Invoker(false, object, method, objectArray);
        try {
            invoker.invoke(false);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public static Object invokeAndWait(Object object, Method method, Object ... objectArray) throws Throwable {
        return AWTUtilities.invokeAndWaitInternal(false, object, method, objectArray).getResult();
    }

    static Object invokeAndWait(boolean bl, Object object, Method method, Object ... objectArray) throws Throwable {
        return AWTUtilities.invokeAndWaitInternal(bl, object, method, objectArray).getResult();
    }

    static boolean invokeAndWaitBoolean(boolean bl, Object object, Method method, Object ... objectArray) throws Throwable {
        return AWTUtilities.invokeAndWaitInternal(bl, object, method, objectArray).getBooleanResult();
    }

    static byte invokeAndWaitByte(boolean bl, Object object, Method method, Object ... objectArray) throws Throwable {
        return AWTUtilities.invokeAndWaitInternal(bl, object, method, objectArray).getByteResult();
    }

    static char invokeAndWaitChar(boolean bl, Object object, Method method, Object ... objectArray) throws Throwable {
        return AWTUtilities.invokeAndWaitInternal(bl, object, method, objectArray).getCharResult();
    }

    static short invokeAndWaitShort(boolean bl, Object object, Method method, Object ... objectArray) throws Throwable {
        return AWTUtilities.invokeAndWaitInternal(bl, object, method, objectArray).getShortResult();
    }

    static int invokeAndWaitInt(boolean bl, Object object, Method method, Object ... objectArray) throws Throwable {
        return AWTUtilities.invokeAndWaitInternal(bl, object, method, objectArray).getIntResult();
    }

    static long invokeAndWaitLong(boolean bl, Object object, Method method, Object ... objectArray) throws Throwable {
        return AWTUtilities.invokeAndWaitInternal(bl, object, method, objectArray).getLongResult();
    }

    static float invokeAndWaitFloat(boolean bl, Object object, Method method, Object ... objectArray) throws Throwable {
        return AWTUtilities.invokeAndWaitInternal(bl, object, method, objectArray).getFloatResult();
    }

    static double invokeAndWaitDouble(boolean bl, Object object, Method method, Object ... objectArray) throws Throwable {
        return AWTUtilities.invokeAndWaitInternal(bl, object, method, objectArray).getDoubleResult();
    }

    private static Invoker invokeAndWaitInternal(boolean bl, Object object, Method method, Object ... objectArray) throws Throwable {
        Invoker invoker = new Invoker(bl, object, method, objectArray);
        invoker.invoke(true);
        Throwable throwable = invoker.getInvokeException();
        if (throwable != null) {
            throw throwable;
        }
        return invoker;
    }

    static Object constructAndWait(boolean bl, Constructor constructor, Object ... objectArray) throws Throwable {
        Invoker invoker = new Invoker(bl, constructor, objectArray);
        invoker.invoke(true);
        Throwable throwable = invoker.getInvokeException();
        if (throwable != null) {
            throw throwable;
        }
        return invoker.getResult();
    }

    public static void invokeAndWait(Runnable runnable) throws Throwable {
        Invoker invoker = new Invoker(runnable);
        invoker.invoke(true);
        Throwable throwable = invoker.getInvokeException();
        if (throwable != null) {
            throw throwable;
        }
    }

    public static void invokeAndWaitWithDispatch(Runnable runnable) throws Throwable {
        if (!runnable.getClass().getName().startsWith("com.mathworks.mde.desk.MLDesktop$")) {
            throw new IllegalStateException("This method is only for desktop initialization");
        }
        Invoker invoker = new Invoker(runnable);
        if (PlatformInfo.isWindows()) {
            invoker.setDispatch(true);
        }
        invoker.invoke(true);
        Throwable throwable = invoker.getInvokeException();
        if (throwable != null) {
            throw throwable;
        }
    }

    public static Object invokeAndWait(InvocationRunnable invocationRunnable) throws Throwable {
        Invoker invoker = new Invoker(invocationRunnable);
        invoker.invoke(true);
        Throwable throwable = invoker.getInvokeException();
        if (throwable != null) {
            throw throwable;
        }
        return invoker.getResult();
    }

    public static void setTimeout(double d) throws TimeoutRangeException {
        if (!(d >= 0.0) || !(d <= 1.0)) {
            throw new TimeoutRangeException();
        }
        sTimeout = (int)(d * 60000.0);
    }

    public static int getInvokeCount() {
        return sInvokeCount;
    }

    public static int getWatchDogCount() {
        return sWatchDogCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isInvoking() {
        Collection<InvokerObservable> collection = OBSERVABLES;
        synchronized (collection) {
            for (InvokerObservable invokerObservable : OBSERVABLES) {
                if (!invokerObservable.isInvoking()) continue;
                return true;
            }
        }
        return false;
    }

    public static void addInvokerObservable(InvokerObservable invokerObservable) {
        OBSERVABLES.add(invokerObservable);
    }

    public static void removeInvokerObservable(InvokerObservable invokerObservable) {
        OBSERVABLES.remove(invokerObservable);
    }

    public static class MatlabWait
    implements Synchronizer {
        private Latch fLatch = new MatlabLatch();
        private final Object fLock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Latch getLatch(boolean bl) {
            Latch latch;
            Object object = this.fLock;
            synchronized (object) {
                latch = this.fLatch;
            }
            if (bl && latch.isLatched()) {
                latch = new MatlabLatch();
                object = this.fLock;
                synchronized (object) {
                    this.fLatch = latch;
                }
            }
            return latch;
        }

        @Override
        public void acquire() throws InterruptedException {
            this.getLatch(true).acquire();
        }

        @Override
        public boolean attempt(long l) throws InterruptedException {
            return this.getLatch(true).attempt(l);
        }

        @Override
        public void release() {
            this.getLatch(false).release();
        }
    }

    public static class MatlabLatch
    extends Latch {
        private static final int WAIT_TIME = 10;
        private boolean fDispatch = false;

        private void safeWait() {
            if (NativeMatlab.nativeIsMatlabThread() && !this.isLatched()) {
                try {
                    NativeMatlab.processSynchronousSystemEvents();
                    if (this.fDispatch && !this.isLatched()) {
                        NativeMatlab.processPendingEvents();
                    }
                }
                catch (MatlabThreadException matlabThreadException) {
                    // empty catch block
                }
            }
        }

        @Override
        protected void waitFcn(long l) throws InterruptedException {
            this.defaultWaitFcn(10L);
            this.safeWait();
        }

        @Override
        protected String threadCheckFcn() {
            return null;
        }

        protected void setDispatch(boolean bl) {
            this.fDispatch = bl;
        }
    }

    public static class Latch
    implements Synchronizer {
        private boolean fReleased = false;
        private static final Object LATCH_LOCK = new Object();
        private static final long INFINITE = -1L;

        @Override
        public void acquire() throws InterruptedException {
            boolean bl;
            String string = this.threadCheckFcn();
            if (string != null) {
                throw new InterruptedException(string);
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            do {
                this.waitFcn(-1L);
                bl = this.isLatched();
                if (!Thread.interrupted()) continue;
                throw new InterruptedException();
            } while (!bl);
        }

        @Override
        public boolean attempt(long l) throws InterruptedException {
            String string = this.threadCheckFcn();
            if (string != null) {
                throw new InterruptedException(string);
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (l <= 0L) {
                return false;
            }
            long l2 = l;
            long l3 = System.currentTimeMillis();
            do {
                this.waitFcn(l2);
                boolean bl = this.isLatched();
                if (bl) {
                    return true;
                }
                l2 = l - (System.currentTimeMillis() - l3);
                if (l2 > 0L) continue;
                return false;
            } while (!Thread.interrupted());
            throw new InterruptedException();
        }

        protected void waitFcn(long l) throws InterruptedException {
            this.defaultWaitFcn(l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void defaultWaitFcn(long l) throws InterruptedException {
            Object object = LATCH_LOCK;
            synchronized (object) {
                if (this.fReleased) {
                    return;
                }
                if (l == -1L) {
                    LATCH_LOCK.wait();
                } else {
                    LATCH_LOCK.wait(l);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean isLatched() {
            Object object = LATCH_LOCK;
            synchronized (object) {
                return this.fReleased;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setReleased() {
            Object object = LATCH_LOCK;
            synchronized (object) {
                this.fReleased = true;
                LATCH_LOCK.notifyAll();
            }
        }

        @Override
        public void release() {
            this.setReleased();
        }

        protected String threadCheckFcn() {
            if (NativeMatlab.nativeIsMatlabThread()) {
                return "Use MatlabLatch to synchronize with the MATLAB thread";
            }
            return null;
        }
    }

    public static interface Synchronizer {
        public void acquire() throws InterruptedException;

        public boolean attempt(long var1) throws InterruptedException;

        public void release();
    }

    private static class Invoker
    extends MatlabLatch {
        private Object fResult;
        private InvocationRunnable fInvocationRunnable = null;
        private Throwable fInvokeException;

        public void invoke(boolean bl) throws InterruptedException, TimeoutException {
            WatchDog watchDog = new WatchDog(){

                @Override
                public void run() {
                    if (this.fWatching) {
                        sWatchDogCount++;
                        Invoker.this.setDispatch(true);
                    }
                }
            };
            WatchedRunnable watchedRunnable = new WatchedRunnable(watchDog){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void watchedRun() {
                    sInvokeCount++;
                    try {
                        Invoker.this.fResult = Invoker.this.fInvocationRunnable.runWithOutput();
                    }
                    catch (Throwable throwable) {
                        Invoker.this.fInvokeException = throwable.getCause();
                        if (Invoker.this.fInvokeException == null) {
                            Invoker.this.fInvokeException = throwable;
                        }
                    }
                    finally {
                        Invoker.this.release();
                    }
                }
            };
            if (!bl) {
                EventQueue.invokeLater(watchedRunnable);
                return;
            }
            if (EventQueue.isDispatchThread()) {
                watchedRunnable.run();
                return;
            }
            EventQueue.invokeLater(watchedRunnable);
            EventQueue.invokeLater(watchDog);
            if (sTimeout == 0) {
                this.acquire();
            } else if (!this.attempt(sTimeout)) {
                throw new TimeoutException(sTimeout);
            }
        }

        Invoker(boolean bl, final Object object, final Method method, final Object ... objectArray) {
            final MVM mVM = MvmContext.get();
            this.fInvocationRunnable = new InvocationRunnable(){

                @Override
                public Object runWithOutput() {
                    Object object2 = null;
                    try {
                        object2 = mVM != null ? MvmContext.callWithContext((MVM)mVM, (Callable)new Callable<Object>(){

                            @Override
                            public Object call() throws Exception {
                                return method.invoke(object, objectArray);
                            }
                        }) : method.invoke(object, objectArray);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Invoker.this.fInvokeException = invocationTargetException.getCause();
                    }
                    catch (Exception exception) {
                        Invoker.this.fInvokeException = exception;
                    }
                    return object2;
                }
            };
            this.setDispatch(bl);
        }

        Invoker(boolean bl, final Constructor constructor, final Object ... objectArray) {
            final MVM mVM = MvmContext.get();
            this.fInvocationRunnable = new InvocationRunnable(){

                @Override
                public Object runWithOutput() {
                    Object object = null;
                    try {
                        object = mVM != null ? MvmContext.callWithContext((MVM)mVM, (Callable)new Callable<Object>(){

                            @Override
                            public Object call() throws Exception {
                                return constructor.newInstance(objectArray);
                            }
                        }) : (Object)constructor.newInstance(objectArray);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Invoker.this.fInvokeException = invocationTargetException.getCause();
                    }
                    catch (Exception exception) {
                        Invoker.this.fInvokeException = exception;
                    }
                    return object;
                }
            };
            this.setDispatch(bl);
        }

        Invoker(final Runnable runnable) {
            final MVM mVM = MvmContext.get();
            this.fInvocationRunnable = new InvocationRunnable(){

                @Override
                public Object runWithOutput() {
                    block4: {
                        try {
                            if (mVM != null) {
                                MvmContext.runWithContext((MVM)mVM, (Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        runnable.run();
                                    }
                                });
                            } else {
                                runnable.run();
                            }
                        }
                        catch (RuntimeException runtimeException) {
                            Invoker.this.fInvokeException = runtimeException.getCause();
                            if (Invoker.this.fInvokeException != null) break block4;
                            Invoker.this.fInvokeException = runtimeException;
                        }
                    }
                    return null;
                }
            };
        }

        Invoker(InvocationRunnable invocationRunnable) {
            this.fInvocationRunnable = invocationRunnable;
        }

        public Throwable getInvokeException() {
            return this.fInvokeException;
        }

        public Object getResult() {
            return this.fResult;
        }

        public boolean getBooleanResult() throws ConversionException {
            if (this.fResult instanceof Boolean) {
                return (Boolean)this.fResult;
            }
            throw new ConversionException();
        }

        public byte getByteResult() throws ConversionException {
            if (this.fResult instanceof Byte) {
                return (Byte)this.fResult;
            }
            throw new ConversionException();
        }

        public char getCharResult() throws ConversionException {
            if (this.fResult instanceof Character) {
                return ((Character)this.fResult).charValue();
            }
            throw new ConversionException();
        }

        public short getShortResult() throws ConversionException {
            if (this.fResult instanceof Short) {
                return (Short)this.fResult;
            }
            throw new ConversionException();
        }

        public int getIntResult() throws ConversionException {
            if (this.fResult instanceof Integer) {
                return (Integer)this.fResult;
            }
            throw new ConversionException();
        }

        public long getLongResult() throws ConversionException {
            if (this.fResult instanceof Long) {
                return (Long)this.fResult;
            }
            throw new ConversionException();
        }

        public float getFloatResult() throws ConversionException {
            if (this.fResult instanceof Float) {
                return ((Float)this.fResult).floatValue();
            }
            throw new ConversionException();
        }

        public double getDoubleResult() throws ConversionException {
            if (this.fResult instanceof Double) {
                return (Double)this.fResult;
            }
            throw new ConversionException();
        }
    }

    public static interface InvokerObservable {
        public boolean isInvoking();
    }

    private static abstract class WatchedRunnable
    implements Runnable {
        private WatchDog fWatchdog;

        WatchedRunnable(WatchDog watchDog) {
            this.fWatchdog = watchDog;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.watchedRun();
            }
            finally {
                this.fWatchdog.finished();
            }
        }

        public abstract void watchedRun();
    }

    private static abstract class WatchDog
    implements Runnable {
        protected boolean fWatching = true;

        private WatchDog() {
        }

        public void finished() {
            assert (this.fWatching);
            this.fWatching = false;
        }
    }

    private static class TimeoutException
    extends Exception {
        private static final String MSG = "Timeout waiting for Event Dispatch Thread to finish.";

        TimeoutException(long l) {
            super("Timeout waiting for Event Dispatch Thread to finish.(" + l + ")");
        }
    }

    private static class ConversionException
    extends Exception {
        private static final String MSG = "Improper return value conversion while dispatching java method.";

        ConversionException() {
            super(MSG);
        }
    }

    private static class TimeoutRangeException
    extends Exception {
        private static final String MSG = "\nTimeout must be in range [0:1].\n0 means wait forever (default). \n1 means wait for 60 seconds.";

        TimeoutRangeException() {
            super(MSG);
        }
    }

    public static interface InvocationRunnable {
        public Object runWithOutput();
    }
}

