/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.jmi;

import com.mathworks.jmi.CustomClassLoader;
import com.mathworks.jmi.CustomURLClassLoader;
import com.mathworks.jmi.InternetClassLoader;
import com.mathworks.util.jarloader.SimpleClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ClassLoaderManager {
    public static final int VERBOSE_0 = 0;
    public static final int VERBOSE_1 = 1;
    public static final int VERBOSE_2 = 2;
    private static int sCurrentVerboseLevel = 0;
    private static ClassLoaderManager sThis = null;
    public static final String[] EMPTY_CLASSPATH = new String[0];
    private String[] fFileSystemClassPath = null;
    private URL[] fURLClassPath = null;
    private String[] fStringClassPath = null;
    private Vector<String> fNativeLibraryPath = ClassLoaderManager.pathString2Vector(System.getProperty("java.library.path"));
    private CustomClassLoader fCurrentFileSystemClassLoader = null;
    private InternetClassLoader fCurrentInternetClassLoader = null;
    private CustomURLClassLoader fCurrentURLClassLoader = null;
    private boolean fIsEnabled = false;
    private int fDebuggingID = 0;
    private boolean fUseURLClassLoader = true;
    private boolean fDoRecordClassCache = false;

    private ClassLoaderManager() {
    }

    public boolean isEnabled() {
        return this.fIsEnabled;
    }

    public void setEnabled(boolean bl) {
        this.fIsEnabled = bl;
    }

    public ClassLoader getCustomClassLoader() {
        return this.fCurrentFileSystemClassLoader;
    }

    public ClassLoader getCurrentClassLoader() {
        return this.fCurrentURLClassLoader;
    }

    public void addDirToNativeLibraryPath(String string) {
        this.fNativeLibraryPath.add(string);
    }

    public static ClassLoaderManager getClassLoaderManager() {
        if (sThis == null) {
            sThis = new ClassLoaderManager();
            sThis.loadClassPath();
        }
        return sThis;
    }

    public static boolean isReloadable(Class<?> clazz) {
        ClassLoader classLoader;
        boolean bl = false;
        if (clazz != null && (classLoader = clazz.getClassLoader()) != null && (classLoader instanceof CustomURLClassLoader || classLoader instanceof CustomClassLoader || classLoader instanceof InternetClassLoader || classLoader instanceof SimpleClassLoader)) {
            bl = true;
        }
        return bl;
    }

    public static String load() {
        ClassLoaderManager classLoaderManager = ClassLoaderManager.getClassLoaderManager();
        return classLoaderManager.loadClassPath();
    }

    private String loadClassPath() {
        if (this.fUseURLClassLoader) {
            return this.loadClassPathNew();
        }
        return this.loadClassPathOld();
    }

    private String loadClassPathNew() {
        String string = null;
        if (this.fCurrentURLClassLoader != null) {
            if (this.fCurrentURLClassLoader.isLocked()) {
                string = "One or more java native libraries are loaded. Clearing java not permitted.\nPlease move any packages on the dynamic java path that use:\n" + this.fCurrentFileSystemClassLoader.getLoadedNativeLibrariesString() + "\nonto the static java path";
                return string;
            }
            this.fCurrentURLClassLoader.setValid(false);
            this.fCurrentURLClassLoader = null;
        }
        ++this.fDebuggingID;
        if (this.fURLClassPath != null) {
            if (sCurrentVerboseLevel >= 1) {
                System.out.println("Loading following class path(s) from local file system:");
                for (URL uRL : this.fURLClassPath) {
                    System.out.println("* " + uRL);
                }
            }
            this.fCurrentURLClassLoader = new CustomURLClassLoader(this.getClass().getClassLoader(), this.fURLClassPath, this.fNativeLibraryPath, this.fDebuggingID, this.fDoRecordClassCache, sCurrentVerboseLevel);
        }
        return string;
    }

    private String loadClassPathOld() {
        String string = null;
        if (this.fCurrentFileSystemClassLoader != null) {
            if (this.fCurrentFileSystemClassLoader.isLocked()) {
                string = "One or more java native libraries are loaded. Clearing java not permitted.\nPlease move any packages on the dynamic java path that use:\n" + this.fCurrentFileSystemClassLoader.getLoadedNativeLibrariesString() + "\nonto the static java path";
                return string;
            }
            this.fCurrentFileSystemClassLoader.setValid(false);
            this.fCurrentFileSystemClassLoader = null;
        }
        ++this.fDebuggingID;
        if (this.fFileSystemClassPath != null) {
            if (sCurrentVerboseLevel >= 1) {
                System.out.println("Loading following class path(s) from local file system:");
                for (String object : this.fFileSystemClassPath) {
                    System.out.println("* " + object);
                }
            }
            this.fCurrentFileSystemClassLoader = new CustomClassLoader(this.getClass().getClassLoader(), this.fFileSystemClassPath, this.fNativeLibraryPath, this.fDebuggingID);
        } else {
            this.fCurrentFileSystemClassLoader = new CustomClassLoader(this.getClass().getClassLoader(), EMPTY_CLASSPATH, this.fNativeLibraryPath, this.fDebuggingID);
        }
        if (this.fURLClassPath != null) {
            if (sCurrentVerboseLevel >= 1) {
                System.out.println("Loading following class path(s) from Internet:");
                for (URL uRL : this.fURLClassPath) {
                    System.out.println("* " + uRL);
                }
            }
            this.fCurrentInternetClassLoader = new InternetClassLoader(this.fURLClassPath, (ClassLoader)this.fCurrentFileSystemClassLoader, this.fDebuggingID);
        } else {
            this.fCurrentInternetClassLoader = null;
        }
        return string;
    }

    public void setClassPath(String[] stringArray) {
        if (this.fUseURLClassLoader) {
            this.setClassPathNew(stringArray);
        } else {
            this.setClassPathOld(stringArray);
        }
    }

    private static URL createURL(String string) {
        URL uRL;
        block4: {
            uRL = null;
            try {
                uRL = new URL(string);
            }
            catch (Exception exception) {
                File file = new File(string);
                try {
                    uRL = file.toURI().toURL();
                }
                catch (Exception exception2) {
                    if (sCurrentVerboseLevel < 1) break block4;
                    System.out.println(exception2);
                }
            }
        }
        return uRL;
    }

    private void setClassPathNew(String[] stringArray) {
        this.fStringClassPath = stringArray;
        if (stringArray != null) {
            this.fURLClassPath = new URL[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.fURLClassPath[i] = ClassLoaderManager.createURL(stringArray[i]);
            }
        } else {
            this.fURLClassPath = null;
        }
    }

    private void setClassPathOld(String[] stringArray) {
        this.fFileSystemClassPath = null;
        this.fURLClassPath = null;
        if (stringArray == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        for (String string : stringArray) {
            if (string.startsWith("http:") || string.startsWith("ftp:")) {
                ++n;
                continue;
            }
            ++n2;
        }
        if (n2 > 0) {
            this.fFileSystemClassPath = new String[n2];
        }
        if (n > 0) {
            this.fURLClassPath = new URL[n];
        }
        int n3 = 0;
        int n4 = 0;
        for (String string : stringArray) {
            if (string.startsWith("http:") || string.startsWith("ftp:")) {
                try {
                    this.fURLClassPath[n3] = new URL(string);
                    ++n3;
                }
                catch (MalformedURLException malformedURLException) {
                    System.out.println(string + " is not a valid URL");
                    --n3;
                }
                continue;
            }
            this.fFileSystemClassPath[n4] = string;
            ++n4;
        }
    }

    public String[] getClassPath() {
        if (this.fUseURLClassLoader) {
            return this.getClassPathNew();
        }
        return this.getClassPathOld();
    }

    private String[] getClassPathNew() {
        return this.fStringClassPath;
    }

    private String[] getClassPathOld() {
        int n = 0;
        if (this.fFileSystemClassPath != null) {
            n = this.fFileSystemClassPath.length;
        }
        int n2 = 0;
        if (this.fURLClassPath != null) {
            n2 = this.fURLClassPath.length;
        }
        if (n + n2 == 0) {
            return null;
        }
        String[] stringArray = new String[n + n2];
        System.arraycopy(this.fFileSystemClassPath, 0, stringArray, 0, n);
        for (int i = 0; i < n2; ++i) {
            assert (this.fURLClassPath != null);
            stringArray[i + n] = this.fURLClassPath[i].toString();
        }
        return stringArray;
    }

    public static Class<?> findClass(String string) throws ClassNotFoundException {
        ClassLoaderManager classLoaderManager = ClassLoaderManager.getClassLoaderManager();
        if (classLoaderManager != null) {
            return classLoaderManager.loadClass(string);
        }
        throw new ClassNotFoundException(string);
    }

    public Class<?> loadClass(String string) throws ClassNotFoundException {
        if (this.fUseURLClassLoader) {
            if (this.fCurrentURLClassLoader != null) {
                return Class.forName(string, true, this.fCurrentURLClassLoader);
            }
            return Class.forName(string);
        }
        return this.loadClassOld(string);
    }

    private Class<?> loadClassOld(String string) throws ClassNotFoundException {
        if (this.fCurrentInternetClassLoader != null) {
            return this.fCurrentInternetClassLoader.loadClass(string);
        }
        if (this.fCurrentFileSystemClassLoader != null) {
            return this.fCurrentFileSystemClassLoader.loadClass(string);
        }
        throw new ClassNotFoundException();
    }

    private static Vector<String> pathString2Vector(String string) {
        String string2;
        int n;
        int n2 = 0;
        Vector<String> vector = new Vector<String>();
        char c = System.getProperty("path.separator").charAt(0);
        while ((n = string.indexOf(c, n2)) != -1) {
            string2 = string.substring(n2, n).trim();
            if (string2.length() > 0) {
                vector.addElement(string2);
            }
            n2 = ++n;
        }
        string2 = string.substring(n2).trim();
        if (string2.length() > 0) {
            vector.addElement(string2);
        }
        return vector;
    }

    public void setVerbose(int n) {
        sCurrentVerboseLevel = n;
        if (this.fUseURLClassLoader && this.fCurrentURLClassLoader != null) {
            this.fCurrentURLClassLoader.setVerbose(n);
        }
    }

    public static int getCurrentVerboseLevel() {
        return sCurrentVerboseLevel;
    }

    public void debugSetDoRecordClassCache(boolean bl) {
        this.fDoRecordClassCache = bl;
        if (this.fUseURLClassLoader && this.fCurrentURLClassLoader != null) {
            this.fCurrentURLClassLoader.debugSetDoRecordClassCache(bl);
        }
    }

    public boolean debugGetDoRecordClassCache() {
        return this.fDoRecordClassCache;
    }

    public void debugSetDoUseURLClassLoader(boolean bl) {
        this.fUseURLClassLoader = bl;
    }

    public boolean debugGetDoUseURLClassLoader() {
        return this.fUseURLClassLoader;
    }

    public void debugPrintClassPath() {
        for (String string : this.fFileSystemClassPath) {
            System.out.println(string);
        }
    }

    public void debugPrintNativeLibraryPath() {
        Enumeration<String> enumeration = this.fNativeLibraryPath.elements();
        while (enumeration.hasMoreElements()) {
            System.out.println(enumeration.nextElement());
        }
    }

    public Hashtable<Class<?>, String> debugGetClassCache() {
        Hashtable<Class<?>, String> hashtable = null;
        if (this.fCurrentURLClassLoader != null) {
            hashtable = this.fCurrentURLClassLoader.debugGetClassCache();
        }
        return hashtable;
    }

    public static ClassLoader getStandaloneClassLoader(String string, String string2, ClassLoader classLoader) {
        return new StandaloneURLClassLoader(string, string2, classLoader);
    }

    public static ClassLoader getStandaloneClassLoader(String[] stringArray, String[] stringArray2, ClassLoader classLoader) {
        return new StandaloneURLClassLoader(stringArray, stringArray2, classLoader);
    }

    static class StandaloneURLClassLoader
    extends URLClassLoader {
        public static final URL[] EMPTY_URL = new URL[0];
        private Collection<String> fVecLibPath = new Vector<String>();

        StandaloneURLClassLoader(String string, String string2, ClassLoader classLoader) {
            super(EMPTY_URL, classLoader != null ? classLoader : StandaloneURLClassLoader.getSystemClassLoader());
            this.addToClassPath(string);
            this.addToLibPath(string2);
        }

        StandaloneURLClassLoader(String[] stringArray, String[] stringArray2, ClassLoader classLoader) {
            super(EMPTY_URL, classLoader != null ? classLoader : StandaloneURLClassLoader.getSystemClassLoader());
            this.addToClassPath(stringArray);
            this.addToLibPath(stringArray2);
        }

        private void addToClassPath(String string) {
            if (string == null) {
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                this.addElementToClassPath(string2);
            }
        }

        private void addToClassPath(String[] stringArray) {
            if (stringArray == null) {
                return;
            }
            for (String string : stringArray) {
                this.addElementToClassPath(string);
            }
        }

        private void addToLibPath(String string) {
            if (string == null) {
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                this.addElementToLibPath(string2);
            }
        }

        private void addToLibPath(String[] stringArray) {
            if (stringArray == null) {
                return;
            }
            for (String string : stringArray) {
                this.addElementToClassPath(string);
            }
        }

        private void addElementToClassPath(String string) {
            if (string == null) {
                return;
            }
            File file = new File(string);
            if (file.exists()) {
                try {
                    URL uRL = file.toURI().toURL();
                    this.addURL(uRL);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }

        private void addElementToLibPath(String string) {
            if (string == null) {
                return;
            }
            File file = new File(string);
            if (file.exists()) {
                this.fVecLibPath.add(string);
            }
        }

        @Override
        protected String findLibrary(String string) {
            for (String string2 : this.fVecLibPath) {
                String string3 = string2;
                File file = new File(string3 + File.separator + System.mapLibraryName(string));
                if (!file.exists()) continue;
                try {
                    return file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            return null;
        }

        @Override
        public InputStream getResourceAsStream(String string) {
            if ("META-INF/services/javax.xml.parsers.DocumentBuilderFactory".equals(string)) {
                return new StringBufferInputStream("org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
            }
            if ("META-INF/services/javax.xml.parsers.SAXParserFactory".equals(string)) {
                return new StringBufferInputStream("org.apache.xerces.jaxp.SAXParserFactoryImpl");
            }
            if ("META-INF/services/javax.xml.transform.TransformerFactory".equals(string)) {
                return new StringBufferInputStream("com.icl.saxon.TransformerFactoryImpl");
            }
            return super.getResourceAsStream(string);
        }
    }
}

