/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.jmi;

import com.mathworks.jmi.Support;
import com.mathworks.util.FileUtils;
import com.mathworks.util.Log;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;

public class MLFileUtils {
    private static final String[] ALL_MEX_EXTENSIONS = Support.allMexExtensions();
    private static final String[] ARCHES = Support.allArches();
    private static final String MEXEXT = Support.mexExtension();
    public static final int SIMULINK_VALID_VERSION = 6;
    private static final String NEWLINE = Character.toString('\n');
    private static final Character QUOTE = Character.valueOf('\"');
    private static final String QUOTESTRING = QUOTE.toString();
    private static final String SLASH = Character.toString('\\');
    private static final String sSeparator = System.getProperty("file.separator");
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.jmi.resources.RES_JMI");
    private static final String DOT_M = ".m";
    private static final String P_FILE_EXTENSION = "p";
    private static final String kUnknownFileType = "????";

    private MLFileUtils() {
    }

    public static boolean isMatlabRunnableFile(String string) {
        return MLFileUtils.isMFile(string) || MLFileUtils.isPFile(string) || MLFileUtils.isNativeMexFile(string);
    }

    public static boolean isMexFile(String string) {
        boolean bl = false;
        for (String string2 : ALL_MEX_EXTENSIONS) {
            if (!string.endsWith(string2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean isNativeMexFile(String string) {
        return MLFileUtils.isMexFile(string) && string.endsWith(MEXEXT);
    }

    public static String getMexArch(String string) {
        String string2 = "";
        for (int i = 0; i < ALL_MEX_EXTENSIONS.length; ++i) {
            String string3 = ALL_MEX_EXTENSIONS[i];
            if (!string.endsWith(string3)) continue;
            string2 = ARCHES[i];
            break;
        }
        return string2;
    }

    public static boolean isMFile(String string) {
        if (PlatformInfo.isWindows()) {
            string = string.toLowerCase();
        }
        return string.endsWith(DOT_M);
    }

    public static boolean isMatFile(String string) {
        string = string.toLowerCase();
        return string.endsWith(".mat");
    }

    public static boolean isPFile(String string) {
        return FilenameUtils.getExtension((String)string).toLowerCase().equals(P_FILE_EXTENSION);
    }

    public static boolean isMdlFile(String string) {
        return (string = string.toLowerCase()).endsWith(".mdl") || string.endsWith(".slx");
    }

    public static boolean isFigFile(String string) {
        string = string.toLowerCase();
        return string.endsWith(".fig");
    }

    public static boolean isReportGenFile(String string) {
        string = string.toLowerCase();
        return string.endsWith(".rpt");
    }

    public static boolean isRtwFile(String string) {
        string = string.toLowerCase();
        return string.endsWith(".rtw");
    }

    public static boolean isTmfFile(String string) {
        string = string.toLowerCase();
        return string.endsWith(".tmf");
    }

    public static boolean isTlcFile(String string) {
        string = string.toLowerCase();
        return string.endsWith(".tlc");
    }

    public static boolean isCgtFile(String string) {
        string = string.toLowerCase();
        return string.endsWith(".cgt");
    }

    public static boolean isRealtimeMatlabFile(String string) {
        return MLFileUtils.isRtwFile(string) || MLFileUtils.isTmfFile(string) || MLFileUtils.isTlcFile(string) || MLFileUtils.isCgtFile(string);
    }

    public static boolean isMatlabProjectFile(String string) {
        if (PlatformInfo.isWindows()) {
            string = string.toLowerCase();
        }
        return string.endsWith(".mlprj");
    }

    public static String mapPFileToMFile(String string) {
        if (string == null) {
            throw new IllegalArgumentException("filename cannot be null");
        }
        if (MLFileUtils.isPFile(string)) {
            return FilenameUtils.removeExtension((String)string) + DOT_M;
        }
        return string;
    }

    private static String MacFileExtensionToFileType(String string) {
        String string2 = kUnknownFileType;
        if (MLFileUtils.isFigFile(string)) {
            string2 = "FIG0";
        }
        if (MLFileUtils.isMFile(string)) {
            string2 = "MATF";
        } else if (MLFileUtils.isReportGenFile(string)) {
            string2 = "RPT0";
        } else if (MLFileUtils.isMatFile(string)) {
            string2 = "MATW";
        } else if (MLFileUtils.isMdlFile(string)) {
            string2 = "MDLS";
        } else if (MLFileUtils.isMexFile(string)) {
            string2 = "MEX0";
        } else if (MLFileUtils.isPFile(string)) {
            string2 = "PCod";
        } else if (MLFileUtils.isTlcFile(string)) {
            string2 = "TLC0";
        } else if (FileUtils.isPdfFile((String)string)) {
            string2 = "PDF ";
        } else if (FileUtils.isHtmlFile((String)string)) {
            string2 = "HTML";
        }
        return string2;
    }

    public static void resetFileType(File file) {
        MLFileUtils.resetFileType(file.toString());
    }

    private static void MacResetFileType(String string) {
        String string2;
        if (PlatformInfo.isMacintosh() && !(string2 = MLFileUtils.MacFileExtensionToFileType(string)).equals(kUnknownFileType)) {
            try {
                Class<?> clazz = Class.forName("com.apple.eio.FileManager");
                Class[] classArray = new Class[]{String.class, Integer.TYPE, Integer.TYPE};
                Method method = clazz.getDeclaredMethod("setFileTypeAndCreator", classArray);
                Object[] objectArray = new Object[]{string, MLFileUtils.MacCharCodeToInt(string2), MLFileUtils.MacCharCodeToInt(MLFileUtils.MacMatlabAppSignature())};
                method.invoke(null, objectArray);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
    }

    public static void resetFileType(String string) {
        if (PlatformInfo.isMacintosh()) {
            MLFileUtils.MacResetFileType(string);
        }
    }

    private static String MacMatlabAppSignature() {
        return "MATL";
    }

    private static int MacCharCodeToInt(String string) {
        int n = 0;
        try {
            byte[] byArray = string.getBytes("MacRoman");
            n = byArray[0] << 24 | byArray[1] << 16 | byArray[2] << 8 | byArray[3];
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println(unsupportedEncodingException);
        }
        return n;
    }

    public static String getMdlDesc(String string, boolean bl) {
        return MLFileUtils.getMdlDesc(string, bl, null);
    }

    public static InputStream getNonLockingInputStream(File file) throws FileNotFoundException {
        if (!PlatformInfo.isWindows()) {
            return new FileInputStream(file);
        }
        FileDescriptor fileDescriptor = new FileDescriptor();
        boolean bl = NativeJava.getNonLockingInputHandle((String)NativeJava.getNormalizedWindowsPath((File)file), (FileDescriptor)fileDescriptor);
        if (!bl) {
            throw new FileNotFoundException("Failed to get non-locking handle to \"" + file + "\"");
        }
        return new FileInputStream(fileDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMdlDesc(String string, boolean bl, String string2) {
        File file = new File(string);
        InputStream inputStream = null;
        String string3 = "";
        try {
            inputStream = MLFileUtils.getNonLockingInputStream(file);
            string3 = MLFileUtils.getMdlDesc(inputStream, bl, string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return string3;
    }

    public static String getMdlDesc(InputStream inputStream, boolean bl, String string) {
        String string2;
        block12: {
            InputStreamReader inputStreamReader = null;
            string2 = "";
            String string3 = null;
            try {
                BufferedReader bufferedReader;
                if (string != null) {
                    try {
                        inputStreamReader = new InputStreamReader(inputStream, string);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
                if (inputStreamReader == null) {
                    inputStreamReader = new InputStreamReader(inputStream);
                }
                if ((bufferedReader = new BufferedReader(inputStreamReader)) == null) break block12;
                boolean bl2 = false;
                boolean bl3 = false;
                int n = 0;
                while ((string3 = bufferedReader.readLine()) != null && string3.length() != 0) {
                    int[] nArray;
                    ++n;
                    int[] nArray2 = MLFileUtils.findPattern("\\A\\s*\\bSystem\\b\\s*\\{", 0, string3);
                    int[] nArray3 = MLFileUtils.findPattern("\\A\\s*\\bSimulink.ConfigSet\\b\\s*\\{", 0, string3);
                    if (nArray2[0] != -1 || nArray3[0] != -1) {
                        bl2 = true;
                    } else if (!bl3 && (nArray = MLFileUtils.findPattern("\\A\\s*\\bVersion\\b\\s*", 0, string3))[0] != -1) {
                        bl3 = true;
                        if (MLFileUtils.determineIfOldMdlFile(string3.substring(nArray[1], string3.length()))) {
                            bl2 = true;
                            string2 = sRes.getString("olddescription");
                        }
                    }
                    if (!bl2 && (nArray = MLFileUtils.findPattern("\\A\\s*\\bDescription\\b\\s*\"", 0, string3))[0] != -1) {
                        bl2 = true;
                        string2 = bl ? MLFileUtils.getFullMdlDesc(string2, nArray[1], string3, bufferedReader) : MLFileUtils.getH1MdlDesc(string2, nArray[1], string3, bufferedReader);
                    }
                    if (string3 != null && !bl2 && n < 1500) continue;
                    break;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string2.trim();
    }

    private static boolean determineIfOldMdlFile(String string) {
        boolean bl = false;
        if (MLFileUtils.getVersionNumber(string) < 6) {
            bl = true;
        }
        return bl;
    }

    private static int getVersionNumber(String string) {
        int n;
        try {
            Number number = NumberFormat.getInstance().parse(string);
            n = number.intValue();
        }
        catch (Exception exception) {
            n = 0;
        }
        return n;
    }

    private static String getFullMdlDesc(String string, int n, String string2, BufferedReader bufferedReader) {
        string = MLFileUtils.appendMDLDescription(string, n, string2);
        do {
            try {
                string2 = bufferedReader.readLine();
                if (string2 == null || (string2 = string2.trim()).length() <= 0 || string2.charAt(0) != QUOTE.charValue() || string2.length() + string.length() >= 120000) continue;
                string = MLFileUtils.appendMDLDescription(string, 1, string2);
            }
            catch (IOException iOException) {
                string2 = null;
            }
        } while (string2 != null && string2.length() > 0 && string2.charAt(0) == QUOTE.charValue() && string.length() < 120000);
        return string;
    }

    private static String getH1MdlDesc(String string, int n, String string2, BufferedReader bufferedReader) {
        int n2;
        boolean bl = true;
        do {
            if (string2 != null) {
                string2 = string2.trim();
            }
            if ((n2 = StringUtils.indexOf((String)string2, (String)"\\n", (int)1, (boolean)false)) != -1) {
                if (bl) {
                    string = MLFileUtils.appendMDLDescription(string, 0, string2.substring(n, n2 + 1));
                    bl = false;
                } else {
                    string = MLFileUtils.appendMDLDescription(string, 0, string2.substring(1, n2 + 1));
                }
            } else if (bl) {
                string = MLFileUtils.appendMDLDescription(string, 0, string2.substring(n, string2.length()));
                bl = false;
            } else {
                string = MLFileUtils.appendMDLDescription(string, 0, string2.substring(1, string2.length()));
            }
            if (n2 != -1) continue;
            try {
                string2 = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                string2 = null;
            }
        } while (string2 != null && n2 == -1 && string2.length() > 0 && string2.charAt(0) == '\"' && string.length() < 120);
        return string;
    }

    private static String appendMDLDescription(String string, int n, String string2) {
        if (n < 0 || string2.length() < 1 || n >= string2.length()) {
            return string;
        }
        string2 = string2.substring(n);
        string2 = StringUtils.replaceAllStrings((String)string2, (String)"\\n", (String)NEWLINE);
        string2 = StringUtils.replaceAllStrings((String)string2, (String)"\\\"", (String)QUOTESTRING);
        string2 = StringUtils.replaceAllStrings((String)string2, (String)"\\\\", (String)SLASH);
        return string.concat(string2.substring(0, string2.length() - 1));
    }

    public static int[] findPattern(String string, int n, CharSequence charSequence) {
        int n2 = -1;
        int n3 = -1;
        try {
            Pattern pattern = Pattern.compile(string);
            Matcher matcher = pattern.matcher(charSequence);
            boolean bl = matcher.find(n);
            if (bl) {
                n2 = matcher.start();
                n3 = matcher.end();
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Log.printLn((String)("Illegal starting index: " + n));
            Log.logException((Exception)indexOutOfBoundsException);
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
        }
        return new int[]{n2, n3};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getH1Line(File file) {
        Object object;
        if (!file.exists()) {
            return "";
        }
        String string = Locale.getDefault().getLanguage();
        if (MLFileUtils.isFolderNotMacPackage(file)) {
            if (!string.equals("en") && ((File)(object = new File(file.getAbsolutePath(), string))).exists()) {
                file = object;
            }
            if (!(file = new File(file.getAbsolutePath() + sSeparator + "Contents.m")).exists()) {
                return "";
            }
        } else {
            if (file.getName().equals("Contents.m")) {
                return sRes.getString("DirectoryDescription");
            }
            if (!MLFileUtils.isMFile(file.getName())) {
                return "";
            }
        }
        object = null;
        try {
            object = new FileReader(file);
            String string2 = MLFileUtils.getH1Line((Reader)object);
            return string2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string3 = null;
            return string3;
        }
        finally {
            try {
                if (object != null) {
                    ((Reader)object).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static String getH1Line(InputStream inputStream) {
        return MLFileUtils.getH1Line(new InputStreamReader(inputStream));
    }

    public static String getH1Line(Reader reader) {
        BufferedReader bufferedReader = new BufferedReader(reader);
        String string = null;
        try {
            do {
                if ((string = bufferedReader.readLine()) == null) continue;
                string = string.trim();
            } while (string != null && (string.length() == 0 || string.charAt(0) != '%') && (string != null || string.length() != 0 || string.charAt(0) != '%'));
            bufferedReader.close();
            if (string == null || string.length() == 0 || string.charAt(0) != '%') {
                return "";
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return string;
        }
        String string2 = string.startsWith("%%") ? string.substring(2, string.length()) : string.substring(1, string.length());
        return string2.trim();
    }

    public static String getMDesc(File file) {
        Object object;
        BufferedReader bufferedReader = null;
        String string = null;
        String string2 = file.getAbsolutePath();
        if (string2 == null) {
            return null;
        }
        try {
            object = new FileReader(string2);
            bufferedReader = new BufferedReader((Reader)object);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (bufferedReader != null) {
            try {
                while (!((string = bufferedReader.readLine()) == null || string.length() != 0 && string.charAt(0) == '%' || string == null && string.length() == 0 && string.charAt(0) == '%')) {
                }
                object = new StringBuffer();
                while (string != null && string.length() != 0 && string.charAt(0) == '%') {
                    if (string.startsWith("%%")) {
                        ((StringBuffer)object).append(string.substring(2).trim());
                    } else {
                        ((StringBuffer)object).append(string.substring(1).trim());
                    }
                    ((StringBuffer)object).append("\n");
                    string = bufferedReader.readLine();
                }
                bufferedReader.close();
                return ((StringBuffer)object).toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return string;
        }
        object = string.substring(1, string.length());
        return ((String)object).trim();
    }

    public static boolean isFolderNotMacPackage(File file) {
        boolean bl = false;
        if (file != null) {
            bl = FileUtils.isANativeMacPackage((File)file) ? false : file.isDirectory();
        }
        return bl;
    }
}

