/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.jmi;

import com.mathworks.jmi.AWTUtilities;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabPath;
import com.mathworks.util.Log;
import com.mathworks.util.MatlabThreadException;
import java.io.File;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Vector;

public class NativeMatlab {
    private long fMCRid = -1L;
    private Vector fMrQueue = null;
    private Vector fMiQueue = null;
    private static Hashtable sMrQueues = new Hashtable();
    private static Hashtable sMiQueues = new Hashtable();
    private static String sMatlabVersion = null;

    NativeMatlab(boolean bl) {
        NativeMatlab.GetMatlabVersion();
        this.fMCRid = !bl || !Matlab.isStandaloneMode() ? -1L : NativeMatlab.nativeRetrieveMCRID();
        Vector vector = (Vector)sMrQueues.get(new Long(this.fMCRid));
        if (vector == null) {
            vector = new Vector();
            sMrQueues.put(this.fMCRid, vector);
        }
        this.fMrQueue = vector;
        Vector vector2 = (Vector)sMiQueues.get(new Long(this.fMCRid));
        if (vector2 == null) {
            vector2 = new Vector();
            sMiQueues.put(this.fMCRid, vector2);
        }
        this.fMiQueue = vector2;
        String string = System.getProperty("mathworks.CallWSPPEUponStartup");
        if ("true".equals(string)) {
            NativeMatlab.processPendingEvents();
        }
    }

    private static native void NativeWaitForDistributorMessages();

    public static void nativeWaitForDistributorMessages() {
        NativeMatlab.NativeWaitForDistributorMessages();
    }

    private static native long NativeRetrieveMCRID();

    private static long nativeRetrieveMCRID() {
        return NativeMatlab.NativeRetrieveMCRID();
    }

    static long retrieveMCRID() {
        if (!Matlab.isStandaloneMode()) {
            return -1L;
        }
        return NativeMatlab.nativeRetrieveMCRID();
    }

    private native void PostMatlabMessage(Object var1, long var2);

    void postMatlabMessage(Object object, long l) {
        block2: {
            try {
                this.PostMatlabMessage(object, l);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"MATLAB not available");
            }
        }
    }

    void postMatlabMessage(Object object) {
        this.postMatlabMessage(object, this.fMCRid);
    }

    private native Object SendMatlabMessage(Object var1) throws Exception;

    Object sendMatlabMessage(Object object) throws Exception {
        assert (NativeMatlab.nativeIsMatlabThread());
        return this.SendMatlabMessage(object);
    }

    private static native boolean NativeIsMatlabThread();

    public static boolean nativeIsMatlabThread() {
        boolean bl = false;
        try {
            bl = NativeMatlab.NativeIsMatlabThread();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        return bl;
    }

    private static native void RestoreMatlabWindows();

    public static void restoreMatlabWindows() {
        if (NativeMatlab.nativeIsMatlabThread()) {
            NativeMatlab.RestoreMatlabWindows();
        }
    }

    private static native void DisableMatlabWindows();

    public static void disableMatlabWindows() {
        if (NativeMatlab.nativeIsMatlabThread()) {
            NativeMatlab.DisableMatlabWindows();
        }
    }

    private static native void NativeLabCmdWinSetup(Writer var0, Writer var1);

    public static void nativeLabCmdWinSetup(Writer writer, Writer writer2) {
        if (NativeMatlab.nativeIsMatlabThread()) {
            NativeMatlab.NativeLabCmdWinSetup(writer, writer2);
        }
    }

    private static native void NativeLabCmdWinRemove();

    public static void nativeLabCmdWinRemove() {
        if (NativeMatlab.nativeIsMatlabThread()) {
            NativeMatlab.NativeLabCmdWinRemove();
        }
    }

    private static boolean dispatchMTRequestsEnabled() {
        assert (NativeMatlab.nativeIsMatlabThread());
        return !AWTUtilities.isInvoking();
    }

    private static void dispatchMTRequests(boolean bl) {
        Object object;
        if (!NativeMatlab.dispatchMTRequestsEnabled()) {
            return;
        }
        Vector vector = (Vector)sMrQueues.get(new Long(NativeMatlab.retrieveMCRID()));
        if (vector != null) {
            while (!vector.isEmpty()) {
                object = (Runnable)vector.firstElement();
                if (object == null) continue;
                vector.removeElement(object);
                try {
                    object.run();
                }
                catch (Exception exception) {
                    Log.logException((Exception)exception);
                }
            }
        }
        object = (Vector)sMiQueues.get(new Long(NativeMatlab.retrieveMCRID()));
        if (bl && object != null) {
            while (!((Vector)object).isEmpty()) {
                Runnable runnable = (Runnable)((Vector)object).firstElement();
                if (runnable == null) continue;
                ((Vector)object).removeElement(runnable);
                try {
                    runnable.run();
                }
                catch (Exception exception) {
                    Log.logException((Exception)exception);
                }
            }
        }
    }

    private native void PostMatlabRunnable(long var1, boolean var3);

    void postMatlabRunnable(Runnable runnable, boolean bl) {
        if (bl) {
            this.fMiQueue.addElement(runnable);
        } else {
            this.fMrQueue.addElement(runnable);
        }
        this.PostMatlabRunnable(this.fMCRid, bl);
    }

    private native void PostMatlabTimerRunnable(long var1);

    void postMatlabTimerRunnable(Runnable runnable) {
        this.fMrQueue.addElement(runnable);
        this.PostMatlabTimerRunnable(this.fMCRid);
    }

    public static boolean processExposeEvents() {
        boolean bl = false;
        if (NativeMatlab.nativeIsMatlabThread()) {
            bl = NativeMatlab.ProcessExposeEvents();
        }
        return bl;
    }

    public static boolean processPendingEvents() {
        boolean bl = false;
        if (NativeMatlab.nativeIsMatlabThread()) {
            bl = NativeMatlab.ProcessPendingEvents();
        }
        return bl;
    }

    public static boolean processSynchronousSystemEvents() throws MatlabThreadException {
        if (NativeMatlab.nativeIsMatlabThread()) {
            return NativeMatlab.ProcessSynchronousSystemEvents();
        }
        throw new MatlabThreadException("Must call processSynchronousSystemEvents from MATLAB thread.");
    }

    private static native boolean ProcessExposeEvents();

    private static native boolean ProcessPendingEvents();

    private static native boolean ProcessSynchronousSystemEvents();

    private static synchronized native boolean UseJava(int var0);

    static boolean useJava(int n) {
        return NativeMatlab.UseJava(n);
    }

    private static synchronized native boolean DesktopRequestedAtStartup();

    public static boolean desktopRequestedAtStartup() {
        return NativeMatlab.DesktopRequestedAtStartup();
    }

    private static native int PlatformIndex(long var0);

    static int platformIndex(long l) {
        return NativeMatlab.PlatformIndex(l);
    }

    private static native String GetMatlabVersion_();

    public static String GetMatlabVersion() {
        if (sMatlabVersion == null) {
            try {
                sMatlabVersion = NativeMatlab.GetMatlabVersion_();
                assert (sMatlabVersion != null);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                sMatlabVersion = "<unknown>";
            }
        }
        return sMatlabVersion;
    }

    private static native void NativeDisplayAboutBox(long var0);

    public static void nativeDisplayAboutBox(long l) {
        if (NativeMatlab.nativeIsMatlabThread()) {
            NativeMatlab.NativeDisplayAboutBox(l);
        }
    }

    private static native boolean PostUserEventToMatlab(int var0, long var1);

    public static boolean postUserEventToMatlab(int n, long l) {
        boolean bl = false;
        try {
            bl = NativeMatlab.PostUserEventToMatlab(n, l);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        return bl;
    }

    private static native void NativeReleaseDeletedDirFromPath(String var0);

    public static void nativeReleaseDeletedDirFromPath(final File file) {
        try {
            if (!NativeMatlab.nativeIsMatlabThread()) {
                Matlab.whenMatlabReady(new Runnable(){

                    @Override
                    public void run() {
                        NativeMatlab.nativeReleaseDeletedDirFromPath(file);
                    }
                });
            } else {
                MatlabPath.callFSChange(file);
                NativeMatlab.NativeReleaseDeletedDirFromPath(file.getAbsolutePath());
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }

    private static native void NativeHideSplashScreen();

    public static void nativeHideSplashScreen() {
        NativeMatlab.NativeHideSplashScreen();
    }

    private static native void NativeTic();

    public static void nativeTic() {
        NativeMatlab.NativeTic();
    }

    private static native void NativeToc(String var0);

    public static void nativeToc(String string) {
        NativeMatlab.NativeToc(string);
    }
}

