/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.jmi.bean;

import com.mathworks.jmi.bean.ClassInfoServer;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class ClassInfo {
    public String name = null;
    public boolean isArray;
    public int arrayType;
    public String[] fieldNames = null;
    public int[] fieldTypes = null;
    public String[] constantNames = null;
    public int[] constantTypes = null;
    private int fMaxFieldIndex;
    private Field[] fFD = null;
    private PropertyDescriptor[] fPD = null;
    private static Class fObjectClass = null;

    public ClassInfo(Class clazz) {
        this.name = clazz.getName();
        this.isArray = clazz.isArray();
        if (this.isArray) {
            this.arrayType = ClassInfoServer.addClass(clazz.getComponentType());
        } else {
            Class<?> clazz2;
            int n;
            Field[] fieldArray = clazz.getFields();
            BeanInfo beanInfo = null;
            try {
                beanInfo = Introspector.getBeanInfo(clazz, fObjectClass);
                this.fPD = beanInfo.getPropertyDescriptors();
            }
            catch (Exception exception) {
                beanInfo = null;
                this.fPD = null;
            }
            this.fFD = new Field[fieldArray.length];
            int n2 = 0;
            int n3 = 0;
            for (n = 0; n < fieldArray.length; ++n) {
                if (!Modifier.isFinal(fieldArray[n].getModifiers())) continue;
                this.fFD[n3] = fieldArray[n];
                ++n3;
            }
            for (n = 0; n < fieldArray.length; ++n) {
                if (Modifier.isFinal(fieldArray[n].getModifiers())) continue;
                this.fFD[n3 + n2] = fieldArray[n];
                ++n2;
            }
            int n4 = n2;
            if (this.fPD != null) {
                n4 += this.fPD.length;
            }
            this.fMaxFieldIndex = n4 + n3;
            this.fieldNames = new String[n4];
            this.fieldTypes = new int[n4];
            this.constantNames = new String[n3];
            this.constantTypes = new int[n3];
            for (n = 0; n < n3; ++n) {
                clazz2 = this.fFD[n].getType();
                this.constantNames[n] = this.fFD[n].getName();
                this.constantTypes[n] = ClassInfoServer.addClass(clazz2);
            }
            for (n = 0; n < n2; ++n) {
                clazz2 = this.fFD[n + n3].getType();
                this.fieldNames[n] = this.fFD[n + n3].getName();
                this.fieldTypes[n] = ClassInfoServer.addClass(clazz2);
            }
            try {
                for (n = 0; n < this.fPD.length; ++n) {
                    this.fieldNames[n + n2] = this.fPD[n].getName();
                    clazz2 = this.fPD[n].getPropertyType();
                    this.fieldTypes[n + n2] = ClassInfoServer.addClass(clazz2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean getBooleanField(Object object, int n) {
        boolean bl = false;
        if (n < this.fFD.length) {
            try {
                bl = this.fFD[n].getBoolean(object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            Method method = this.fPD[n - this.fFD.length].getReadMethod();
            try {
                bl = (Boolean)method.invoke(object, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl;
    }

    public byte getByteField(Object object, int n) {
        byte by = 0;
        if (n < this.fFD.length) {
            try {
                by = this.fFD[n].getByte(object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            Method method = this.fPD[n - this.fFD.length].getReadMethod();
            try {
                by = (Byte)method.invoke(object, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return by;
    }

    public char getCharField(Object object, int n) {
        char c = '\u0000';
        if (n < this.fFD.length) {
            try {
                c = this.fFD[n].getChar(object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            Method method = this.fPD[n - this.fFD.length].getReadMethod();
            try {
                c = ((Character)method.invoke(object, null)).charValue();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return c;
    }

    public short getShortField(Object object, int n) {
        short s = 0;
        if (n < this.fFD.length) {
            try {
                s = this.fFD[n].getShort(object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            Method method = this.fPD[n - this.fFD.length].getReadMethod();
            try {
                s = (Short)method.invoke(object, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return s;
    }

    public int getIntField(Object object, int n) {
        int n2 = 0;
        if (n < this.fFD.length) {
            try {
                n2 = this.fFD[n].getInt(object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            Method method = this.fPD[n - this.fFD.length].getReadMethod();
            try {
                n2 = (Integer)method.invoke(object, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return n2;
    }

    public long getLongField(Object object, int n) {
        long l = 0L;
        if (n < this.fFD.length) {
            try {
                l = this.fFD[n].getLong(object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            Method method = this.fPD[n - this.fFD.length].getReadMethod();
            try {
                l = (Long)method.invoke(object, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return l;
    }

    public float getFloatField(Object object, int n) {
        float f = 0.0f;
        if (n < this.fFD.length) {
            try {
                f = this.fFD[n].getFloat(object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            Method method = this.fPD[n - this.fFD.length].getReadMethod();
            try {
                f = ((Integer)method.invoke(object, null)).floatValue();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return f;
    }

    public double getDoubleField(Object object, int n) {
        double d = 0.0;
        if (n < this.fFD.length) {
            try {
                d = this.fFD[n].getDouble(object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            Method method = this.fPD[n - this.fFD.length].getReadMethod();
            try {
                d = ((Integer)method.invoke(object, null)).doubleValue();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return d;
    }

    public Object getObjectField(Object object, int n) {
        Object object2 = null;
        if (n < this.fFD.length) {
            try {
                object2 = this.fFD[n].get(object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            Method method = this.fPD[n - this.fFD.length].getReadMethod();
            try {
                object2 = method.invoke(object, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return object2;
    }

    public void setBooleanField(Object object, int n, boolean bl) {
        if (n < this.fFD.length) {
            try {
                this.fFD[n].setBoolean(object, bl);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            Method method = this.fPD[n - this.fFD.length].getWriteMethod();
            try {
                Object[] objectArray = new Object[]{new Boolean(bl)};
                method.invoke(object, objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setByteField(Object object, int n, byte by) {
        if (n < this.fFD.length) {
            try {
                this.fFD[n].setByte(object, by);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            Method method = this.fPD[n - this.fFD.length].getWriteMethod();
            try {
                Object[] objectArray = new Object[]{new Byte(by)};
                method.invoke(object, objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setCharField(Object object, int n, char c) {
        if (n < this.fFD.length) {
            try {
                this.fFD[n].setChar(object, c);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            Method method = this.fPD[n - this.fFD.length].getWriteMethod();
            try {
                Object[] objectArray = new Object[]{new Character(c)};
                method.invoke(object, objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setShortField(Object object, int n, short s) {
        if (n < this.fFD.length) {
            try {
                this.fFD[n].setShort(object, s);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            Method method = this.fPD[n - this.fFD.length].getWriteMethod();
            try {
                Object[] objectArray = new Object[]{new Short(s)};
                method.invoke(object, objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setIntField(Object object, int n, int n2) {
        if (n < this.fFD.length) {
            try {
                this.fFD[n].setInt(object, n2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            Method method = this.fPD[n - this.fFD.length].getWriteMethod();
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                method.invoke(object, objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setLongField(Object object, int n, long l) {
        if (n < this.fFD.length) {
            try {
                this.fFD[n].setLong(object, l);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            Method method = this.fPD[n - this.fFD.length].getWriteMethod();
            try {
                Object[] objectArray = new Object[]{new Long(l)};
                method.invoke(object, objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setFloatField(Object object, int n, float f) {
        if (n < this.fFD.length) {
            try {
                this.fFD[n].setFloat(object, f);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            Method method = this.fPD[n - this.fFD.length].getWriteMethod();
            try {
                Object[] objectArray = new Object[]{new Float(f)};
                method.invoke(object, objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setDoubleField(Object object, int n, double d) {
        if (n < this.fFD.length) {
            try {
                this.fFD[n].setDouble(object, d);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            Method method = this.fPD[n - this.fFD.length].getWriteMethod();
            try {
                Object[] objectArray = new Object[]{new Double(d)};
                method.invoke(object, objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setObjectField(Object object, int n, Object object2) {
        if (n < this.fFD.length) {
            try {
                this.fFD[n].set(object, object2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            Method method = this.fPD[n - this.fFD.length].getWriteMethod();
            try {
                Object[] objectArray = new Object[]{object2};
                method.invoke(object, objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    static {
        try {
            fObjectClass = Class.forName("java.lang.Object");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

