/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.jmi.tabcompletion;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.Validate;

public final class TabCompletionResults
implements Serializable {
    private final List<String> fMatches;
    private final Status fStatus;

    public static TabCompletionResults createSuccessfulResult(List<String> list) {
        Validate.notNull(list, (String)"'matches' cannot be null");
        return new TabCompletionResults(list.isEmpty() ? Status.NO_MATCHES : Status.SOME_MATCHES, list);
    }

    public static TabCompletionResults createTooManyMatchesResult() {
        return new TabCompletionResults(Status.TOO_MANY_MATCHES, Collections.<String>emptyList());
    }

    public static TabCompletionResults createErrorResult() {
        return new TabCompletionResults(Status.ERROR, Collections.<String>emptyList());
    }

    public Status getStatus() {
        return this.fStatus;
    }

    public List<String> getStrings() {
        return Collections.unmodifiableList(this.fMatches);
    }

    private TabCompletionResults(Status status, List<String> list) {
        Validate.notNull(list, (String)"'matches' cannot be null");
        Validate.notNull((Object)((Object)status), (String)"'status' cannot be null");
        this.fMatches = list;
        this.fStatus = status;
    }

    public static enum Status {
        NO_MATCHES,
        SOME_MATCHES,
        TOO_MANY_MATCHES,
        ERROR;

    }
}

