/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.jmi.types;

import com.mathworks.beans.editors.MWPropertyEditorSupport;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.jmi.types.MLArrayRefEditorPanel;
import com.mathworks.util.ResLoader;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;

public class MLArrayRefEditor
extends MWPropertyEditorSupport {
    private static Image sIcon = null;
    private MLArrayRefEditorPanel fPanel = null;
    private Object fobjScalar = null;

    public Image getIcon() {
        if (sIcon == null) {
            ResLoader resLoader = new ResLoader(((Object)((Object)this)).getClass());
            sIcon = resLoader.loadImage("resources/mlarrayref.gif");
        }
        return sIcon;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized String getAsText() {
        String string = "";
        MLArrayRef mLArrayRef = (MLArrayRef)this.getValue();
        int[] nArray = null;
        Object object = null;
        int n = 0;
        if (mLArrayRef == null) return string;
        nArray = mLArrayRef.getDimensions();
        boolean bl = mLArrayRef.isComplex();
        if (bl) return string + mLArrayRef.toString();
        if (nArray == null) return string + mLArrayRef.toString();
        if (nArray.length != 2) return string + mLArrayRef.toString();
        if (nArray[0] != 1) return string + mLArrayRef.toString();
        if (nArray[1] != 1) return string + mLArrayRef.toString();
        object = this.getCachedScalar();
        if (object == null) return string;
        n = mLArrayRef.getType();
        switch (n) {
            case 7: {
                if (!(object instanceof float[])) return string;
                float f = ((float[])object)[0];
                return "single(" + Float.toString(f) + ")";
            }
            case 6: {
                if (!(object instanceof double[])) return string;
                double d = ((double[])object)[0];
                return Double.toString(d);
            }
            case 8: 
            case 9: {
                if (!(object instanceof byte[])) return string;
                byte by = ((byte[])object)[0];
                short s = by;
                String string2 = "int8";
                if (n != 9) return string2 + "(" + Short.toString(s) + ")";
                if (by < 0) {
                    s = (short)(256 + by);
                }
                string2 = "u" + string2;
                return string2 + "(" + Short.toString(s) + ")";
            }
            case 10: 
            case 11: {
                int n2;
                if (!(object instanceof short[])) return string;
                int n3 = n2 = ((short[])object)[0];
                String string3 = "int16";
                if (n != 11) return string3 + "(" + Integer.toString(n3) + ")";
                if (n2 < 0) {
                    n3 = 65536 + n2;
                }
                string3 = "u" + string3;
                return string3 + "(" + Integer.toString(n3) + ")";
            }
            case 12: 
            case 13: {
                if (!(object instanceof int[])) return string;
                int n4 = ((int[])object)[0];
                long l = n4;
                String string4 = "int32";
                if (n != 13) return string4 + "(" + Long.toString(l) + ")";
                if (n4 < 0) {
                    l = 0x100000000L + (long)n4;
                }
                string4 = "u" + string4;
                return string4 + "(" + Long.toString(l) + ")";
            }
            case 14: 
            case 15: {
                long l;
                if (!(object instanceof long[])) return string;
                long l2 = l = ((long[])object)[0];
                String string5 = "int64";
                if (n != 15) return string5 + "(" + Long.toString(l2) + ")";
                if (l < 0L) {
                    l2 = 0L + l;
                }
                string5 = "u" + string5;
                return string5 + "(" + Long.toString(l2) + ")";
            }
            case 3: {
                if (!(object instanceof boolean[])) return string;
                boolean bl2 = ((boolean[])object)[0];
                return "boolean(" + bl2 + ")";
            }
            default: {
                return mLArrayRef.toString();
            }
        }
    }

    public Object getCachedScalar() {
        return this.fobjScalar;
    }

    public void setCachedScalar(Object object) {
        this.fobjScalar = object;
    }

    public void setAsText(final String string) {
        Matlab.whenMatlabReady(new Runnable(){

            @Override
            public void run() {
                MLArrayRefEditor.this.setAsText_MatlabThread(string);
            }
        });
    }

    private void setAsText_MatlabThread(String string) {
        MLArrayRef mLArrayRef = null;
        Object[] objectArray = new Object[1];
        Matlab matlab = new Matlab();
        String string2 = null;
        if (string != null && string.length() > 0 && string != "") {
            string2 = string;
            try {
                objectArray[0] = "system_dependent(45," + string2 + ")";
                mLArrayRef = (MLArrayRef)Matlab.mtFeval("eval", objectArray, 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (mLArrayRef != null) {
                this.setValue(mLArrayRef);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    public boolean supportsInPlaceEditing() {
        return true;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        MLArrayRef mLArrayRef = (MLArrayRef)this.getValue();
        if (this.fPanel == null) {
            this.fPanel = new MLArrayRefEditorPanel(mLArrayRef);
        } else {
            this.fPanel.setRef(mLArrayRef);
        }
        return this.fPanel;
    }

    public boolean canApply() {
        return true;
    }

    public void apply() {
        this.setValue(this.fPanel != null ? this.fPanel.getRef() : null);
    }
}

