/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt;

import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWCanvas;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWGroupbox;
import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWTable;
import com.mathworks.mwt.MWUtils;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;

public class MWCardPanel
extends MWPanel
implements ItemSelectable {
    public static final int ETCHED = 0;
    public static final int EMBOSSED = 1;
    public static final int RAISED = 2;
    public static final int RECESSED = 3;
    public static final int SIMPLE = 4;
    public static final int NONE = 5;
    public static final int NO_PANEL = -1;
    private static final String PANEL_TAG = "Panel";
    private MWGroupbox fGroupbox;
    private CardLayout fCardLayout;
    private Vector fTaggedPanels;
    private int fSelectedIndex;
    private int fUniqueId;
    private ItemListener fItemListener;

    public MWCardPanel(String string, int n) {
        this.setLayout(new BorderLayout());
        this.fGroupbox = new MWGroupbox(string, n);
        this.fCardLayout = new CardLayout();
        this.fGroupbox.setLayout(this.fCardLayout);
        this.add((Component)this.fGroupbox, "Center");
        this.fUniqueId = 0;
        this.fSelectedIndex = -1;
        this.fTaggedPanels = new Vector();
        this.fItemListener = null;
    }

    public MWCardPanel(String string) {
        this(string, 0);
    }

    public MWCardPanel() {
        this("", 0);
    }

    public String getLabel() {
        return this.fGroupbox.getLabel();
    }

    public void setLabel(String string) {
        this.fGroupbox.setLabel(string);
    }

    public int getStyle() {
        return this.fGroupbox.getStyle();
    }

    public void setStyle(int n) {
        this.fGroupbox.setStyle(n);
    }

    public Insets getMargins() {
        return this.fGroupbox.getMargins();
    }

    public void setMargins(Insets insets) {
        this.fGroupbox.setMargins(insets);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.fGroupbox.setFont(font);
    }

    public int addPanel(String string, Component component) {
        return this.addPanel(string, component, true);
    }

    public int addPanelNoSelect(String string, Component component) {
        return this.addPanel(string, component, false);
    }

    private int addPanel(String string, Component component, boolean bl) {
        int n = -1;
        if (string != null && component != null) {
            TaggedPanel taggedPanel = new TaggedPanel(string, this.uniqueID(), component);
            this.fTaggedPanels.addElement(taggedPanel);
            this.fGroupbox.add(PANEL_TAG + taggedPanel.getID(), taggedPanel.getComponent());
            if (bl) {
                this.selectPanel(this.fTaggedPanels.size() - 1);
            }
            n = taggedPanel.getID();
        }
        return n;
    }

    public void removePanel(int n) {
        if (n >= 0 && n < this.fTaggedPanels.size()) {
            TaggedPanel taggedPanel = (TaggedPanel)this.fTaggedPanels.elementAt(n);
            this.fGroupbox.remove(taggedPanel.getComponent());
            this.fTaggedPanels.removeElementAt(n);
            this.fSelectedIndex = -1;
            if (n < this.fTaggedPanels.size()) {
                this.selectPanel(n);
            } else if (n > 0) {
                this.selectPanel(n - 1);
            }
        }
    }

    public void removePanel(String string) {
        int n = this.findIndex(string);
        if (n != -1) {
            this.removePanel(n);
        }
    }

    public void removePanelID(int n) {
        int n2 = this.findIndex(n);
        if (n2 != -1) {
            this.removePanel(n2);
        }
    }

    public void selectPanel(int n) {
        if (n >= 0 && n < this.fTaggedPanels.size()) {
            Component component;
            TaggedPanel taggedPanel;
            if (this.fSelectedIndex != -1) {
                taggedPanel = (TaggedPanel)this.fTaggedPanels.elementAt(this.fSelectedIndex);
                Window window = MWUtils.getTopLevelWindow(this);
                if (window != null) {
                    component = window.getFocusOwner();
                    if (component == null) {
                        component = taggedPanel.getComponent();
                    }
                    taggedPanel.setFocus(component);
                }
            }
            taggedPanel = (TaggedPanel)this.fTaggedPanels.elementAt(n);
            this.fSelectedIndex = n;
            this.fCardLayout.show(this.fGroupbox, PANEL_TAG + taggedPanel.getID());
            component = taggedPanel.getFocus();
            if (component == null) {
                component = taggedPanel.getComponent();
            }
            component.requestFocus();
            this.repaint();
            if (this.fItemListener != null) {
                ItemEvent itemEvent = new ItemEvent(this, 701, this.getSelectedPanel(), 1);
                this.fItemListener.itemStateChanged(itemEvent);
            }
        }
    }

    public void showPanel(int n) {
        if (n >= 0 && n < this.fTaggedPanels.size()) {
            TaggedPanel taggedPanel = (TaggedPanel)this.fTaggedPanels.elementAt(n);
            this.fSelectedIndex = n;
            this.fCardLayout.show(this.fGroupbox, PANEL_TAG + taggedPanel.getID());
            this.repaint();
            if (this.fItemListener != null) {
                ItemEvent itemEvent = new ItemEvent(this, 701, this.getSelectedPanel(), 1);
                this.fItemListener.itemStateChanged(itemEvent);
            }
        }
    }

    public void selectPanel(String string) {
        int n = this.findIndex(string);
        if (n != -1) {
            this.selectPanel(n);
        }
    }

    public void selectPanelID(int n) {
        int n2 = this.findIndex(n);
        if (n2 != -1) {
            this.selectPanel(n2);
        }
    }

    public int getPanelCount() {
        return this.fTaggedPanels.size();
    }

    public void setPanelName(String string, int n) {
        if (n >= 0 && n < this.fTaggedPanels.size()) {
            TaggedPanel taggedPanel = (TaggedPanel)this.fTaggedPanels.elementAt(n);
            taggedPanel.setName(string);
        }
    }

    public void setPanelNameID(String string, int n) {
        for (int i = 0; i < this.fTaggedPanels.size(); ++i) {
            TaggedPanel taggedPanel = (TaggedPanel)this.fTaggedPanels.elementAt(i);
            if (n != taggedPanel.getID()) continue;
            this.setPanelName(string, i);
            break;
        }
    }

    public Component getPanel(int n) {
        Component component = null;
        if (n >= 0 && n < this.fTaggedPanels.size()) {
            TaggedPanel taggedPanel = (TaggedPanel)this.fTaggedPanels.elementAt(n);
            component = taggedPanel.getComponent();
        }
        return component;
    }

    public Component getPanel(String string) {
        Component component = null;
        int n = this.findIndex(string);
        if (n != -1) {
            TaggedPanel taggedPanel = (TaggedPanel)this.fTaggedPanels.elementAt(n);
            component = taggedPanel.getComponent();
        }
        return component;
    }

    public String getPanelName(int n) {
        String string = null;
        if (n >= 0 && n < this.fTaggedPanels.size()) {
            TaggedPanel taggedPanel = (TaggedPanel)this.fTaggedPanels.elementAt(n);
            string = taggedPanel.getName();
        }
        return string;
    }

    public String getPanelNameID(int n) {
        String string = null;
        for (int i = 0; i < this.fTaggedPanels.size(); ++i) {
            TaggedPanel taggedPanel = (TaggedPanel)this.fTaggedPanels.elementAt(i);
            if (taggedPanel.getID() != n) continue;
            string = taggedPanel.getName();
            break;
        }
        return string;
    }

    public int getSelectedIndex() {
        return this.fSelectedIndex;
    }

    public Component getSelectedPanel() {
        return this.getPanel(this.getSelectedIndex());
    }

    @Override
    public Object[] getSelectedObjects() {
        Object[] objectArray = this.getSelectedIndex() == -1 ? new Object[]{} : new Object[]{this.getSelectedPanel()};
        return objectArray;
    }

    @Override
    public void addItemListener(ItemListener itemListener) {
        this.fItemListener = AWTEventMulticaster.add(this.fItemListener, itemListener);
    }

    @Override
    public void removeItemListener(ItemListener itemListener) {
        this.fItemListener = AWTEventMulticaster.remove(this.fItemListener, itemListener);
    }

    protected MWGroupbox getGroupbox() {
        return this.fGroupbox;
    }

    private int uniqueID() {
        return this.fUniqueId++;
    }

    private int findIndex(String string) {
        int n = -1;
        for (int i = 0; i < this.fTaggedPanels.size(); ++i) {
            TaggedPanel taggedPanel = (TaggedPanel)this.fTaggedPanels.elementAt(i);
            if (!string.equals(taggedPanel.getName())) continue;
            n = i;
            break;
        }
        return n;
    }

    private int findIndex(int n) {
        int n2 = -1;
        for (int i = 0; i < this.fTaggedPanels.size(); ++i) {
            TaggedPanel taggedPanel = (TaggedPanel)this.fTaggedPanels.elementAt(i);
            if (n != taggedPanel.getID()) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    public static void main(String[] stringArray) {
        try {
            MWFrame mWFrame = new MWFrame("Test");
            MWCardPanel mWCardPanel = new MWCardPanel("CardPanel");
            mWCardPanel.addPanel("one", new MWLabel("One"));
            mWCardPanel.addPanel("two", new MWTable());
            mWCardPanel.addPanel("three", new MWLabel("Three"));
            mWCardPanel.addPanel("four", new MWButton("Four"));
            mWCardPanel.addItemListener(new PanelHandler());
            ButtonHandler buttonHandler = new ButtonHandler(mWCardPanel);
            MWButton mWButton = new MWButton("Next");
            mWButton.addActionListener(buttonHandler);
            MWButton mWButton2 = new MWButton("Previous");
            mWButton2.addActionListener(buttonHandler);
            MWPanel mWPanel = new MWPanel(new FlowLayout());
            mWPanel.add(mWButton2);
            mWPanel.add(mWButton);
            mWFrame.add((Component)new MWCanvas(5, 5), "North");
            mWFrame.add((Component)new MWCanvas(5, 5), "West");
            mWFrame.add((Component)new MWCanvas(5, 5), "East");
            mWFrame.add((Component)mWCardPanel, "Center");
            mWFrame.add((Component)mWPanel, "South");
            mWFrame.pack();
            mWFrame.setResizable(false);
            mWFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static class PanelHandler
    implements ItemListener {
        private PanelHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            ItemSelectable itemSelectable = itemEvent.getItemSelectable();
            if (itemSelectable instanceof MWCardPanel) {
                MWCardPanel mWCardPanel = (MWCardPanel)itemSelectable;
                mWCardPanel.setLabel("Panel #" + mWCardPanel.getSelectedIndex());
                mWCardPanel.repaint();
            }
        }
    }

    private static class ButtonHandler
    implements ActionListener {
        private MWCardPanel fCardPanel;

        ButtonHandler(MWCardPanel mWCardPanel) {
            this.fCardPanel = mWCardPanel;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            String string = actionEvent.getActionCommand();
            if (string.equals("Next")) {
                int n2 = this.fCardPanel.getSelectedIndex() + 1;
                if (n2 < this.fCardPanel.getPanelCount()) {
                    this.fCardPanel.selectPanel(n2);
                }
            } else if (string.equals("Previous") && (n = this.fCardPanel.getSelectedIndex() - 1) >= 0) {
                this.fCardPanel.selectPanel(n);
            }
        }
    }

    private class TaggedPanel {
        private String fName;
        private int fID;
        private Component fComponent;
        private Component fFocus;

        TaggedPanel(String string, int n, Component component) {
            this.fName = string;
            this.fID = n;
            this.fComponent = component;
        }

        void setName(String string) {
            this.fName = string;
        }

        String getName() {
            return this.fName;
        }

        int getID() {
            return this.fID;
        }

        Component getComponent() {
            return this.fComponent;
        }

        Component getFocus() {
            return this.fFocus;
        }

        void setFocus(Component component) {
            this.fFocus = component;
        }
    }
}

