/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt;

import com.mathworks.util.PlatformInfo;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Vector;

public class MWClipboard {
    public static final DataFlavor MATLAB_ARRAY_DATAFLAVOR = new DataFlavor("text/x-matlab-array", "MATLAB Array");
    private static Clipboard sSystemClipboard;
    private static Clipboard sXSelectionClipboard;
    private Clipboard fPrivateClipboard;
    private Clipboard fVeryPrivateClipboard;
    private static MWClipboard sThis;
    private static PrivateClipboardOwner sClipboardOwner;

    private MWClipboard() {
        sClipboardOwner = new PrivateClipboardOwner();
        sSystemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        sXSelectionClipboard = Toolkit.getDefaultToolkit().getSystemSelection();
        this.fPrivateClipboard = this.fVeryPrivateClipboard = new Clipboard("MJClipboard private Clipboard");
    }

    private static void initialize() {
        if (sThis == null) {
            sThis = new MWClipboard();
        }
    }

    public static MWClipboard getMWClipboard() {
        MWClipboard.initialize();
        return sThis;
    }

    public synchronized void setContents(String string, ClipboardOwner clipboardOwner, String string2) {
        this.setContents(string, null, clipboardOwner);
    }

    public synchronized void setContents(String string, Transferable transferable, ClipboardOwner clipboardOwner, String string2) {
        this.setContents(string, transferable, clipboardOwner);
    }

    public synchronized void setContents(String string, ClipboardOwner clipboardOwner) {
        this.setContents(string, null, clipboardOwner);
    }

    public synchronized void setContents(String string, Transferable transferable, ClipboardOwner clipboardOwner) {
        if (string == null) {
            return;
        }
        this.setContents(new StringSelection(string), transferable, clipboardOwner);
    }

    public synchronized void setContents(Transferable transferable, ClipboardOwner clipboardOwner) {
        this.setContents(transferable, null, clipboardOwner);
    }

    public synchronized void setContents(Transferable transferable, Transferable transferable2, ClipboardOwner clipboardOwner) {
        if (transferable == null) {
            return;
        }
        try {
            sSystemClipboard.setContents(transferable, sClipboardOwner);
            if (clipboardOwner != null) {
                sClipboardOwner.setExternalOwner(clipboardOwner);
            }
            if (this.fPrivateClipboard == null) {
                this.fPrivateClipboard = this.fVeryPrivateClipboard;
            }
            this.fPrivateClipboard.setContents(transferable2, clipboardOwner);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public synchronized Transferable getContents(Object object) {
        Transferable transferable = null;
        Transferable transferable2 = null;
        if (sSystemClipboard != null) {
            transferable = sSystemClipboard.getContents(object);
        }
        if (this.fPrivateClipboard != null) {
            transferable2 = this.fPrivateClipboard.getContents(object);
        }
        Transferable[] transferableArray = new Transferable[]{transferable, transferable2};
        return new CombinedTransferable(transferableArray);
    }

    public void setXSelectionContents(String string) {
        if (PlatformInfo.isXWindows()) {
            StringSelection stringSelection = new StringSelection(string);
            sXSelectionClipboard.setContents(stringSelection, null);
        }
    }

    public Transferable getXSelectionContents(Object object) {
        if (PlatformInfo.isXWindows()) {
            Transferable transferable = null;
            try {
                if (sXSelectionClipboard != null) {
                    transferable = sXSelectionClipboard.getContents(object);
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            return transferable;
        }
        return null;
    }

    public static Transferable makeStringMimeSelection(String string, DataFlavor dataFlavor) {
        return new StringMimeSelection(string, dataFlavor);
    }

    static {
        sThis = null;
        sClipboardOwner = null;
    }

    private static class StringMimeSelection
    implements Transferable {
        private String fArrayRep = null;
        private DataFlavor fDataFlavor = null;

        private StringMimeSelection(String string, DataFlavor dataFlavor) {
            this.fArrayRep = string;
            this.fDataFlavor = dataFlavor;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (!dataFlavor.isMimeTypeEqual(this.fDataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.fArrayRep;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return dataFlavor.isMimeTypeEqual(this.fDataFlavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray = new DataFlavor[]{this.fDataFlavor};
            return dataFlavorArray;
        }
    }

    private static class CombinedTransferable
    implements Transferable {
        private Transferable[] fTransferables;

        private CombinedTransferable(Transferable[] transferableArray) {
            this.fTransferables = transferableArray;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            Object object = null;
            for (int i = 0; i < this.fTransferables.length; ++i) {
                if (object != null || this.fTransferables[i] == null || !this.fTransferables[i].isDataFlavorSupported(dataFlavor)) continue;
                object = this.fTransferables[i].getTransferData(dataFlavor);
            }
            if (object == null) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return object;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            boolean bl = false;
            for (int i = 0; i < this.fTransferables.length; ++i) {
                if (bl || this.fTransferables[i] == null) continue;
                bl = this.fTransferables[i].isDataFlavorSupported(dataFlavor);
            }
            return bl;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            Vector<DataFlavor> vector = new Vector<DataFlavor>();
            for (int i = 0; i < this.fTransferables.length; ++i) {
                if (this.fTransferables[i] == null) continue;
                DataFlavor[] dataFlavorArray = this.fTransferables[i].getTransferDataFlavors();
                for (int j = 0; j < dataFlavorArray.length; ++j) {
                    vector.addElement(dataFlavorArray[j]);
                }
            }
            DataFlavor[] dataFlavorArray = new DataFlavor[vector.size()];
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                dataFlavorArray[i] = (DataFlavor)vector.elementAt(i);
            }
            return dataFlavorArray;
        }
    }

    private class PrivateClipboardOwner
    implements ClipboardOwner {
        private ClipboardOwner fExternalOwner = null;

        private PrivateClipboardOwner() {
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
            MWClipboard.this.fPrivateClipboard = null;
            if (this.fExternalOwner != null) {
                this.fExternalOwner.lostOwnership(clipboard, transferable);
            }
        }

        void setExternalOwner(ClipboardOwner clipboardOwner) {
            this.fExternalOwner = clipboardOwner;
        }

        ClipboardOwner getExternalOwner() {
            return this.fExternalOwner;
        }
    }
}

