/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt;

import com.mathworks.mwt.MWMenu;
import com.mathworks.mwt.MWMenuComponent;
import com.mathworks.mwt.MWUtils;
import com.mathworks.mwt.command.MWCommandTarget;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import java.awt.AWTEvent;
import java.awt.CheckboxMenuItem;
import java.awt.Font;
import java.awt.Menu;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;

public class MWMenuItem
extends MWMenuComponent {
    private static final int SETKEY = 9;
    private static final int SETSTATE = 10;
    private int fKey;
    private boolean fState;
    private boolean fToggle;
    MenuItem fItem;

    public MWMenuItem(String string) {
        this(string, null);
    }

    public MWMenuItem(String string, MenuShortcut menuShortcut) {
        super(string);
        if (menuShortcut != null) {
            this.fKey = menuShortcut.getKey();
            if (menuShortcut.usesShiftModifier()) {
                this.fKey += 0x1000000;
            }
        }
    }

    public MWMenuItem(String string, int n) {
        super(string);
        this.setKey(n);
    }

    public MWMenuItem(String string, boolean bl) {
        super(string);
        this.fState = bl;
    }

    public final void dispatchEvent(AWTEvent aWTEvent) {
        if (this.fItem != null) {
            if (!(this.fItem instanceof CheckboxMenuItem) && aWTEvent instanceof ItemEvent) {
                aWTEvent = new ActionEvent(aWTEvent.getSource(), 1001, "");
            }
            this.fItem.dispatchEvent(aWTEvent);
        }
    }

    @Override
    void deferredAction(int n) {
        switch (n) {
            case 3: {
                this.restore();
                break;
            }
            case 4: {
                this.setLabel(this.getLabel());
                break;
            }
            case 5: {
                this.set_enabled(this.isEnabled());
                break;
            }
            case 8: {
                this.disconnect();
                break;
            }
            case 9: {
                this.setKey(this.fKey);
                break;
            }
            case 10: {
                this.set_state(this.fState);
                break;
            }
            default: {
                super.deferredAction(n);
            }
        }
    }

    @Override
    public void setLabel(String string) {
        super.setLabel(string);
        if (this.fItem != null) {
            if (MWMenuItem.isAWTEventQueueThread()) {
                if (PlatformInfo.isUnix() && "sun.awt.X11.XToolkit".equals(Toolkit.getDefaultToolkit().getClass().getName())) {
                    Menu menu = (Menu)this.fItem.getParent();
                    int n = this.getIndexOfMenuItemInParent();
                    if (n >= 0) {
                        menu.remove(n);
                    }
                    this.fItem.setLabel(this.stripLabel(string));
                    if (n >= 0) {
                        menu.insert(this.fItem, n);
                    }
                } else {
                    this.fItem.setLabel(this.stripLabel(string));
                }
                if (PlatformInfo.isWindows() || PlatformInfo.isUnix()) {
                    this.restore();
                }
            } else {
                MWMenuItem.awtDeferAction(4, this);
            }
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        if (bl != this.isEnabled()) {
            this.set_enabled(bl);
        }
    }

    private void set_enabled(boolean bl) {
        super.setEnabled(bl);
        if (this.fItem != null) {
            if (MWMenuItem.isAWTEventQueueThread()) {
                if (PlatformInfo.isUnix() && "sun.awt.X11.XToolkit".equals(Toolkit.getDefaultToolkit().getClass().getName())) {
                    Menu menu = (Menu)this.fItem.getParent();
                    int n = this.getIndexOfMenuItemInParent();
                    if (n >= 0) {
                        menu.remove(n);
                    }
                    this.fItem.setEnabled(bl);
                    if (n >= 0) {
                        menu.insert(this.fItem, n);
                    }
                } else {
                    this.fItem.setEnabled(bl);
                }
            } else {
                MWMenuItem.awtDeferAction(5, this);
            }
        }
    }

    public void setKey(int n) {
        this.fKey = n == -1 ? 0 : n;
        if (this.fItem != null) {
            if (MWMenuItem.isAWTEventQueueThread()) {
                MWMenuItem.updateShortcut(this.fItem, this.fKey);
                if (PlatformInfo.isWindows() || PlatformInfo.isUnix()) {
                    this.fItem.setLabel(this.stripLabel(this.getLabel()));
                    this.restore();
                }
            } else {
                MWMenuItem.awtDeferAction(9, this);
            }
        }
    }

    public int getKey() {
        return this.fKey;
    }

    public void setState(boolean bl) {
        if (bl != this.fState) {
            this.set_state(bl);
        }
    }

    private void set_state(boolean bl) {
        this.fState = bl;
        if (this.fItem != null) {
            if (MWMenuItem.isAWTEventQueueThread()) {
                this.toggleImpl();
            } else {
                MWMenuItem.awtDeferAction(10, this);
            }
        }
    }

    private void toggleImpl() {
        int n = this.getIndexOfMenuItemInParent();
        if (n >= 0) {
            Menu menu = (Menu)this.fItem.getParent();
            this.fItem = this.buildMenuItem();
            menu.remove(n);
            menu.insert(this.fItem, n);
            if (this.getParent() != null) {
                this.getParent().restore();
            }
        } else {
            this.fItem = this.buildMenuItem();
        }
    }

    private int getIndexOfMenuItemInParent() {
        Menu menu;
        int n = -1;
        if (this.fItem != null && (menu = (Menu)this.fItem.getParent()) != null) {
            int n2 = menu.getItemCount();
            for (int i = 0; i < n2; ++i) {
                MenuItem menuItem = menu.getItem(i);
                if (menuItem != this.fItem) continue;
                n = i;
                break;
            }
        }
        return n;
    }

    public boolean getState() {
        return this.fState;
    }

    public void setToggle(boolean bl) {
        this.fToggle = bl;
    }

    public boolean getToggle() {
        return this.fToggle;
    }

    private void menuAction() {
        if (this.fToggle) {
            this.fState = !this.fState;
            this.toggleImpl();
        } else if (this.fState && this.fItem != null && this.fItem instanceof CheckboxMenuItem) {
            ((CheckboxMenuItem)this.fItem).setState(this.fState);
        }
        MWCommandTarget mWCommandTarget = this.getTarget();
        if (mWCommandTarget != null) {
            mWCommandTarget.doCommand(this.getCommand());
        }
    }

    private MenuItem buildMenuItem() {
        boolean bl;
        MenuItem menuItem = this.fState ? new CheckboxMenuItemImpl(this.stripLabel(this.getLabel()), this.fState) : new MenuItemImpl(this.stripLabel(this.getLabel()));
        Font font = this.getFont();
        if (font != null) {
            menuItem.setFont(font);
        }
        if (!(bl = this.isEnabled())) {
            menuItem.setEnabled(bl);
        }
        if (this.fKey != 0) {
            MWMenuItem.updateShortcut(menuItem, this.fKey);
        }
        return menuItem;
    }

    @Override
    MenuItem getImpl() {
        if (this.fItem == null) {
            this.fItem = this.buildMenuItem();
        }
        return this.fItem;
    }

    @Override
    void disconnect() {
        if (this.fItem != null) {
            if (MWMenuItem.isAWTEventQueueThread()) {
                MenuContainer menuContainer = this.fItem.getParent();
                if (menuContainer != null) {
                    menuContainer.remove(this.fItem);
                }
            } else {
                MWMenuItem.awtDeferAction(8, this);
            }
        }
        super.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void restore() {
        if (this.fItem == null || this.getRootParent() == null) {
            return;
        }
        if (MWMenuItem.isAWTEventQueueThread()) {
            if (PlatformInfo.isMacintosh()) {
                this.fItem.setEnabled(this.isEnabled());
                if (this.fState && this.fItem instanceof CheckboxMenuItemImpl) {
                    ((CheckboxMenuItemImpl)this.fItem).setState(this.fState);
                }
            } else if (PlatformInfo.isWindows() && NativeJava.nativeLibraryExists()) {
                int n;
                MWMenuComponent mWMenuComponent = this.getParent();
                long l = mWMenuComponent.getPlatformHandle();
                if (l != 0L && (n = mWMenuComponent.getComponentIndex(this)) != -1) {
                    NativeJava.setMenuItemLabel((long)l, (int)n, (String)this.fItem.getLabel());
                }
            } else if (PlatformInfo.isXWindows() && NativeJava.nativeLibraryExists() && PlatformInfo.getVersion() < 6 && PlatformInfo.getVersion() != 0 && this.fItem != null && this.fItem.getPeer() != null) {
                String string = this.getLabel();
                String string2 = "";
                String string3 = "";
                int n = string.indexOf(38);
                if (n != -1) {
                    string2 = string.substring(n + 1, n + 2);
                }
                if (string2 == null) {
                    string2 = "";
                }
                if ((n = string.lastIndexOf(9)) != -1) {
                    string3 = string.substring(n + 1);
                } else if (this.fKey != 0) {
                    string3 = MWMenuItem.accelString(this.fKey).substring(1);
                }
                if (string3 == null) {
                    string3 = "";
                }
                if (this.fItem.getPeer() != null) {
                    Object object = this.getTreeLock();
                    synchronized (object) {
                        Object object2 = MWMenu.sAwtLock;
                        synchronized (object2) {
                            NativeJava.setMenuItemThings((Object)this.fItem.getPeer(), (String)MWUtils.stripMenuItemLabel(string), (String)string2, (String)string3);
                        }
                    }
                }
            }
        } else {
            MWMenuItem.awtDeferAction(3, this);
        }
    }

    private String stripLabel(String string) {
        if (PlatformInfo.isWindows()) {
            if (this.fKey != 0 && string.lastIndexOf("\t") == -1) {
                string = string + MWMenuItem.accelString(this.fKey);
            }
            return string;
        }
        return MWUtils.stripMenuItemLabel(string);
    }

    private static boolean isValidShortcut(MenuItem menuItem, int n) {
        if (PlatformInfo.isMacintosh()) {
            if ((n & 0x8A000000) != 0) {
                return false;
            }
            int n2 = n & 0xFFFFFF;
            if (n2 >= 112 && n <= 123 || n2 == 127) {
                return false;
            }
        }
        return true;
    }

    private static void updateShortcut(MenuItem menuItem, int n) {
        if (menuItem != null) {
            if (n == 0) {
                menuItem.deleteShortcut();
            } else {
                boolean bl;
                int n2 = n & 0xFFFFFF;
                boolean bl2 = bl = (n & 0x1000000) != 0;
                if (MWMenuItem.isValidShortcut(menuItem, n)) {
                    if ((n & 0x40000000) != 0) {
                        menuItem.deleteShortcut();
                    } else {
                        menuItem.setShortcut(new MenuShortcut(n2, bl));
                    }
                } else if (PlatformInfo.isMacintosh()) {
                    menuItem.deleteShortcut();
                }
            }
        }
    }

    private static String accelString(int n) {
        String string;
        String string2;
        int n2 = n & 0xFFFFFF;
        if (n2 >= 112 && n2 <= 123 || n2 == 127) {
            int n3 = n - n2;
            switch (n3) {
                case 0: {
                    string2 = "\tCtrl+";
                    break;
                }
                case -2147483648: {
                    string2 = "\t";
                    break;
                }
                case 0x1000000: {
                    string2 = "\tCtrl+Shift+";
                    break;
                }
                case -2130706432: {
                    string2 = "\tShift+";
                    break;
                }
                default: {
                    string2 = "\t";
                    break;
                }
            }
        } else {
            int n4 = n - n2 & Integer.MAX_VALUE;
            switch (n4) {
                case 0: {
                    string2 = "\tCtrl+";
                    break;
                }
                case 0x1000000: {
                    string2 = "\tCtrl+Shift+";
                    break;
                }
                case 0x4000000: {
                    string2 = "\tMeta+";
                    break;
                }
                case 0x8000000: {
                    string2 = "\tAlt+";
                    break;
                }
                case 0x40000000: {
                    string2 = "\tCtrl+X ";
                    break;
                }
                case 0x42000000: {
                    string2 = "\tCtrl+X Ctrl+";
                    break;
                }
                default: {
                    string2 = "\t";
                }
            }
        }
        switch (n2) {
            case 45: 
            case 189: {
                string = "Minus";
                break;
            }
            default: {
                string = KeyEvent.getKeyText(n2);
            }
        }
        return string2 + string;
    }

    private class CheckboxMenuItemImpl
    extends CheckboxMenuItem
    implements ItemListener {
        protected CheckboxMenuItemImpl(String string, boolean bl) {
            super(string, bl);
            this.addItemListener(this);
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            MWMenuItem.this.menuAction();
        }
    }

    private class MenuItemImpl
    extends MenuItem
    implements ActionListener {
        protected MenuItemImpl(String string) {
            super(string);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MWMenuItem.this.menuAction();
        }
    }
}

