/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt;

import com.mathworks.mwt.MWScrollLayout;
import com.mathworks.mwt.MWScrollbar;
import com.mathworks.mwt.MWUtils;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.mwt.floater.FloaterPanel;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.QueueEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

public class MWPopupList
extends FloaterPanel
implements ItemSelectable {
    public static final int NO_ITEM = -1;
    private static int BORDER_WIDTH = 1;
    private static final String SPACER_CHAR = "3";
    private static final Insets INSETS = new Insets(1, 1, 1, 1);
    private static final int SLEEP = 25;
    private Vector fItems;
    private int fSelectedIndex;
    private int fHilitedIndex;
    private int fLinesVis;
    private Dimension fPrefSize;
    private boolean fUseOwnersWidth;
    private boolean fSuppressTemporary;
    private MWScrollbar fScrollbar;
    private EventHandler fHandler;
    private int fAutoScrollId;
    private boolean fIsAbove;
    private boolean fIsBelow;
    private ItemListener fItemListener;

    public MWPopupList(boolean bl) {
        if (PlatformInfo.useWindowsXPAppearance()) {
            BORDER_WIDTH = 0;
        }
        this.fHandler = new EventHandler();
        this.setLayout(new MWScrollLayout());
        this.setVisible(false);
        this.setFont(Decorations.getFont(0));
        this.fItems = new Vector();
        this.fSelectedIndex = -1;
        this.fHilitedIndex = -1;
        this.fUseOwnersWidth = bl;
        this.fLinesVis = 0;
        this.fPrefSize = new Dimension();
        this.fItemListener = null;
        this.fAutoScrollId = 0;
        this.fIsAbove = false;
        this.fIsBelow = false;
        this.fScrollbar = new MWScrollbar(0);
        this.fScrollbar.addAdjustmentListener(this.fHandler);
        this.add((Component)this.fScrollbar, "Vertical");
        this.fScrollbar.setVisible(false);
        this.addMouseListener(this.fHandler);
        this.addMouseMotionListener(this.fHandler);
        this.addKeyListener(this.fHandler);
    }

    public MWPopupList() {
        this(false);
    }

    public void show(Component component, int n, int n2, int n3, int n4) {
        Window window = MWUtils.getTopLevelWindow(component);
        int n5 = 0;
        int n6 = 0;
        if (window != null) {
            Rectangle rectangle = MWUtils.boundsInOtherComponent(component, window);
            Insets insets = window.getInsets();
            int n7 = window.getSize().height;
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Point point = MWUtils.getTopLevelWindow(component).getLocationOnScreen();
            if (n7 + point.y > dimension.height) {
                n7 = dimension.height - point.y;
            }
            rectangle.x += n;
            rectangle.y += n2;
            rectangle.width = n3;
            rectangle.height = n4;
            int n8 = rectangle.y - insets.top;
            int n9 = n7 - insets.bottom - rectangle.y - rectangle.height;
            this.fLinesVis = this.fItems.size();
            int n10 = this.getPreferredSize().height;
            if (n10 <= n9) {
                n5 = n;
                n6 = n2 + n4 - 1;
            } else if (n10 <= n8) {
                n5 = n;
                n6 = n2 - n10;
            } else if (n8 > n9) {
                n5 = n;
                this.fitToHeight(n8);
                n10 = this.getPreferredSize().height;
                n6 = n2 - n10;
            } else {
                n5 = n;
                this.fitToHeight(n9);
                n6 = n2 + n4 - 1;
            }
        }
        this.fHilitedIndex = this.fSelectedIndex;
        if (this.fLinesVis == this.fItems.size()) {
            this.fScrollbar.setVisible(false);
        } else {
            this.fScrollbar.setValues(this.fSelectedIndex, this.fLinesVis, 0, this.fItems.size() - this.fLinesVis);
            this.fScrollbar.setBlockIncrement(this.fLinesVis);
            this.fScrollbar.setVisible(true);
        }
        if (this.getUseOwnersWidth() || this.fPrefSize.width < n3) {
            this.fPrefSize.width = n3;
        }
        super.show(component, n5, n6);
    }

    public void show(Component component) {
        Dimension dimension = component.getSize();
        this.show(component, 0, 0, dimension.width, dimension.height);
    }

    public boolean getUseOwnersWidth() {
        return this.fUseOwnersWidth;
    }

    public void setUseOwnersWidth(boolean bl) {
        this.fUseOwnersWidth = bl;
    }

    public boolean getSuppressTemporarySelections() {
        return this.fSuppressTemporary;
    }

    public void setSuppressTemporarySelections(boolean bl) {
        this.fSuppressTemporary = bl;
    }

    public void addItem(String string) {
        if (string != null) {
            this.fItems.addElement(string);
            if (this.fSelectedIndex == -1) {
                this.fSelectedIndex = this.fItems.size() - 1;
            }
        }
    }

    public void insertItem(String string, int n) {
        if (string != null) {
            this.fItems.insertElementAt(string, n);
            if (this.fSelectedIndex >= n) {
                ++this.fSelectedIndex;
            }
        }
    }

    public void removeItem(int n) {
        if (n >= 0 && n < this.fItems.size()) {
            this.fItems.removeElementAt(n);
            if (this.fItems.size() == 0) {
                this.fSelectedIndex = -1;
            } else if (this.fSelectedIndex == n) {
                this.fSelectedIndex = 0;
            } else if (this.fSelectedIndex > n) {
                --this.fSelectedIndex;
            }
        }
    }

    public void removeItem(String string) {
        if (string != null) {
            this.removeItem(this.fItems.indexOf(string));
        }
    }

    public void removeAllItems() {
        while (this.fItems.size() > 0) {
            this.removeItem(0);
        }
    }

    public String getItem(int n) {
        String string = null;
        if (n >= 0 && n < this.fItems.size()) {
            string = (String)this.fItems.elementAt(n);
        }
        return string;
    }

    public void setItem(String string, int n) {
        if (string != null && n >= 0 && n < this.fItems.size()) {
            this.fItems.setElementAt(string, n);
        }
    }

    public int getItemCount() {
        return this.fItems.size();
    }

    public int getSelectedIndex() {
        return this.fSelectedIndex;
    }

    public void setSelectedIndex(int n) {
        if (n >= 0 && n < this.fItems.size() || n == -1) {
            this.fSelectedIndex = n;
        }
    }

    public String getSelectedItem() {
        return this.getItem(this.getSelectedIndex());
    }

    @Override
    public Object[] getSelectedObjects() {
        Object[] objectArray = this.fSelectedIndex == -1 ? new Object[]{} : new Object[]{this.fItems.elementAt(this.fSelectedIndex)};
        return objectArray;
    }

    @Override
    public void addItemListener(ItemListener itemListener) {
        this.fItemListener = AWTEventMulticaster.add(this.fItemListener, itemListener);
    }

    @Override
    public void removeItemListener(ItemListener itemListener) {
        this.fItemListener = AWTEventMulticaster.remove(this.fItemListener, itemListener);
    }

    private void fitToHeight(int n) {
        int n2 = 0;
        Font font = this.getFont();
        FontMetrics fontMetrics = font != null ? this.getFontMetrics(font) : null;
        int n3 = fontMetrics != null ? fontMetrics.getHeight() : 1;
        n2 = (n -= 2 * BORDER_WIDTH) / n3;
        this.fLinesVis = n2 < 1 ? 1 : n2;
    }

    @Override
    public Insets getInsets() {
        return INSETS;
    }

    @Override
    public Dimension getPreferredSize() {
        Window window = MWUtils.getTopLevelWindow(this);
        Font font = this.getFont();
        FontMetrics fontMetrics = font != null ? this.getFontMetrics(font) : null;
        int n = this.fPrefSize.width;
        this.fPrefSize.width = 0;
        this.fPrefSize.height = 0;
        Rectangle rectangle = null;
        if (window != null && (rectangle = window.getBounds()) != null) {
            rectangle.width -= 2 * BORDER_WIDTH + 10;
        }
        if (fontMetrics != null) {
            this.fPrefSize.height += fontMetrics.getHeight() * this.fLinesVis;
            for (int i = 0; i < this.fItems.size(); ++i) {
                String string = (String)this.fItems.elementAt(i);
                int n2 = fontMetrics.stringWidth(string + SPACER_CHAR);
                if (n2 <= this.fPrefSize.width) continue;
                this.fPrefSize.width = n2;
            }
        }
        this.fPrefSize.width += 2 * BORDER_WIDTH;
        this.fPrefSize.height += 2 * BORDER_WIDTH;
        if (this.fScrollbar.isVisible()) {
            this.fPrefSize.width += this.fScrollbar.getPreferredWidth();
        }
        if (this.getUseOwnersWidth() || this.fPrefSize.width < n) {
            this.fPrefSize.width = n;
        }
        if (rectangle != null) {
            this.fPrefSize.width = Math.min(this.fPrefSize.width, rectangle.width);
        }
        return this.fPrefSize;
    }

    public void paintOneCell(int n) {
        int n2;
        int n3;
        int n4;
        Font font = this.getFont();
        FontMetrics fontMetrics = font != null ? this.getFontMetrics(font) : null;
        int n5 = BORDER_WIDTH;
        int n6 = n4 = fontMetrics != null ? fontMetrics.getHeight() : 0;
        if (this.fScrollbar.isVisible()) {
            n3 = (n - this.fScrollbar.getValue()) * n4;
            n2 = this.fScrollbar.getLocation().x - BORDER_WIDTH;
        } else {
            n3 = n * n4;
            n2 = this.getSize().width - 2 * BORDER_WIDTH;
        }
        this.repaint(n5, n3, n2, n4 + 1);
    }

    public void updateListArea() {
        int n = BORDER_WIDTH;
        int n2 = BORDER_WIDTH;
        int n3 = this.getSize().height - 2 * BORDER_WIDTH;
        int n4 = this.fScrollbar.isVisible() ? this.fScrollbar.getLocation().x - BORDER_WIDTH : this.getSize().width - 2 * BORDER_WIDTH;
        this.repaint(n, n2, n4, n3);
    }

    @Override
    public void paint(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        Font font = this.getFont();
        FontMetrics fontMetrics = font != null ? this.getFontMetrics(font) : null;
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, n - 1, n2 - 1);
        graphics.setColor(Color.black);
        if (fontMetrics != null) {
            int n3 = fontMetrics.stringWidth(SPACER_CHAR) / 2 + BORDER_WIDTH;
            int n4 = fontMetrics.getAscent();
            int n5 = BORDER_WIDTH;
            int n6 = fontMetrics.getHeight();
            if (this.fScrollbar.isVisible()) {
                graphics.clipRect(1, 1, this.fScrollbar.getLocation().x - 1, n2 - 2);
            } else {
                graphics.clipRect(1, 1, n - 2, n2 - 2);
            }
            for (int i = 0; i < this.fLinesVis; ++i) {
                int n7;
                int n8 = n7 = this.fScrollbar.isVisible() ? this.fScrollbar.getValue() + i : i;
                if (n7 == this.fHilitedIndex) {
                    graphics.setColor(Decorations.getColor(4));
                } else {
                    graphics.setColor(Decorations.getColor(2));
                }
                graphics.fillRect(BORDER_WIDTH, n5, n - 2 * BORDER_WIDTH, n6);
                if (n7 < this.fItems.size()) {
                    if (n7 == this.fHilitedIndex) {
                        graphics.setColor(Decorations.getColor(5));
                    } else {
                        graphics.setColor(Decorations.getColor(12));
                    }
                    String string = (String)this.fItems.elementAt(n7);
                    graphics.drawString(string, n3, n5 + n4);
                    if (n7 == this.fHilitedIndex && PlatformInfo.getAppearance() == 1) {
                        Decorations.drawFocusRect(graphics, BORDER_WIDTH, n5, n - 2 * BORDER_WIDTH - 1, n6 - 1);
                    }
                }
                n5 += n6;
            }
        }
        graphics.setClip(rectangle);
        super.paint(graphics);
    }

    private void scrollToHilite() {
        if (this.fScrollbar.isVisible()) {
            if (this.fHilitedIndex < this.fScrollbar.getValue()) {
                this.fScrollbar.setValue(this.fHilitedIndex);
                this.updateListArea();
            } else if (this.fHilitedIndex >= this.fScrollbar.getValue() + this.fScrollbar.getBlockIncrement()) {
                this.fScrollbar.setValue(this.fHilitedIndex - this.fScrollbar.getBlockIncrement() + 1);
                this.updateListArea();
            }
        }
    }

    private void commitSelection() {
        if (this.fHilitedIndex != -1 && this.fHilitedIndex != this.fSelectedIndex) {
            this.fSelectedIndex = this.fHilitedIndex;
            if (this.fItemListener != null) {
                ItemEvent itemEvent = new ItemEvent(this, 701, this.fItems.elementAt(this.fSelectedIndex), 1);
                this.fItemListener.itemStateChanged(itemEvent);
            }
        }
    }

    private void selectAtPoint(int n, int n2) {
        int n3;
        int n4 = this.getSize().width;
        int n5 = this.getSize().height;
        Font font = this.getFont();
        FontMetrics fontMetrics = font != null ? this.getFontMetrics(font) : null;
        int n6 = n3 = fontMetrics != null ? fontMetrics.getHeight() : 1;
        if (n2 > 0 && n2 < n5 - 1 && n > 0 && n < n4 - 1) {
            int n7 = (n2 - 1) / n3;
            if (this.fScrollbar.isVisible()) {
                n7 += this.fScrollbar.getValue();
            }
            if (n7 != this.fHilitedIndex) {
                int n8 = this.fHilitedIndex;
                this.fHilitedIndex = n7;
                this.paintOneCell(n8);
                this.paintOneCell(this.fHilitedIndex);
            }
        } else {
            int n9 = this.fHilitedIndex;
            this.fHilitedIndex = -1;
            this.paintOneCell(n9);
        }
    }

    private class EventHandler
    extends MouseAdapter
    implements MouseMotionListener,
    AdjustmentListener,
    KeyListener {
        private EventHandler() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            MWPopupList.this.updateListArea();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            MWPopupList.this.selectAtPoint(point.x, point.y);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            MWPopupList mWPopupList = MWPopupList.this;
            synchronized (mWPopupList) {
                MWPopupList.this.fAutoScrollId = 0;
                MWPopupList.this.fIsAbove = false;
                MWPopupList.this.fIsBelow = false;
            }
            MWPopupList.this.selectAtPoint(point.x, point.y);
            MWPopupList.this.commitSelection();
            MWPopupList.this.collapse();
            if (MWPopupList.this.getFloaterOwner() != null) {
                MWPopupList.this.getFloaterOwner().floaterAutoCollapsed(MWPopupList.this);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            MWPopupList.this.selectAtPoint(point.x, point.y);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            MWPopupList.this.selectAtPoint(point.x, point.y);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = MWPopupList.this.getSize().height;
            MWPopupList mWPopupList = MWPopupList.this;
            synchronized (mWPopupList) {
                boolean bl;
                boolean bl2 = point.y < 0;
                boolean bl3 = bl = point.y >= n;
                if (bl2 != MWPopupList.this.fIsAbove) {
                    MWPopupList.this.fAutoScrollId++;
                    MWPopupList.this.fIsAbove = bl2;
                    if (MWPopupList.this.fIsAbove && MWPopupList.this.fScrollbar.isVisible() && MWPopupList.this.fScrollbar.getValue() > MWPopupList.this.fScrollbar.getMinimum()) {
                        Thread thread = new Thread(new AutoScroller(MWPopupList.this.fAutoScrollId, false));
                        thread.setName("MWPopupListAutoScroll@" + Integer.toHexString(this.hashCode()));
                        thread.setPriority(1);
                        thread.start();
                    }
                } else if (bl != MWPopupList.this.fIsBelow) {
                    MWPopupList.this.fAutoScrollId++;
                    MWPopupList.this.fIsBelow = bl;
                    if (MWPopupList.this.fIsBelow && MWPopupList.this.fScrollbar.isVisible() && MWPopupList.this.fScrollbar.getValue() < MWPopupList.this.fScrollbar.getMaximum()) {
                        Thread thread = new Thread(new AutoScroller(MWPopupList.this.fAutoScrollId, true));
                        thread.setName("MWPopupListAutoScroll@" + Integer.toHexString(this.hashCode()));
                        thread.setPriority(1);
                        thread.start();
                    }
                }
            }
            MWPopupList.this.selectAtPoint(point.x, point.y);
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 27: {
                    this.collapseList();
                    break;
                }
                case 10: {
                    if (MWPopupList.this.fSuppressTemporary) {
                        MWPopupList.this.commitSelection();
                    }
                    this.collapseList();
                    break;
                }
                case 38: {
                    int n;
                    if (keyEvent.getModifiers() == 8) {
                        this.collapseList();
                        break;
                    }
                    if (MWPopupList.this.getItemCount() <= 0) break;
                    int n2 = n = MWPopupList.this.fSuppressTemporary ? MWPopupList.this.fHilitedIndex : MWPopupList.this.fSelectedIndex;
                    if (MWPopupList.this.fHilitedIndex == -1) {
                        MWPopupList.this.fHilitedIndex = MWPopupList.this.getItemCount() - 1;
                    } else if (n > 0) {
                        MWPopupList.this.fHilitedIndex = n - 1;
                    } else {
                        MWPopupList.this.fHilitedIndex = 0;
                    }
                    MWPopupList.this.scrollToHilite();
                    MWPopupList.this.repaint();
                    if (MWPopupList.this.fSuppressTemporary) break;
                    MWPopupList.this.commitSelection();
                    break;
                }
                case 40: {
                    int n;
                    if (keyEvent.getModifiers() == 8) {
                        this.collapseList();
                        break;
                    }
                    if (MWPopupList.this.getItemCount() <= 0) break;
                    int n3 = n = MWPopupList.this.fSuppressTemporary ? MWPopupList.this.fHilitedIndex : MWPopupList.this.fSelectedIndex;
                    if (MWPopupList.this.fHilitedIndex == -1) {
                        MWPopupList.this.fHilitedIndex = 0;
                    } else if (n < MWPopupList.this.getItemCount() - 1) {
                        MWPopupList.this.fHilitedIndex = n + 1;
                    } else {
                        MWPopupList.this.fHilitedIndex = MWPopupList.this.getItemCount() - 1;
                    }
                    MWPopupList.this.scrollToHilite();
                    MWPopupList.this.repaint();
                    if (MWPopupList.this.fSuppressTemporary) break;
                    MWPopupList.this.commitSelection();
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        private void collapseList() {
            MWPopupList.this.collapse();
            if (MWPopupList.this.getFloaterOwner() != null) {
                MWPopupList.this.getFloaterOwner().floaterAutoCollapsed(MWPopupList.this);
                if (MWPopupList.this.getFloaterOwner() instanceof Component) {
                    ((Component)((Object)MWPopupList.this.getFloaterOwner())).requestFocus();
                    ((Component)((Object)MWPopupList.this.getFloaterOwner())).repaint();
                }
            }
        }
    }

    private class AutoScrollAdjustEvent
    extends QueueEvent {
        private boolean fScrollDown;

        AutoScrollAdjustEvent(boolean bl) {
            this.fScrollDown = bl;
        }

        public void dispatch() {
            int n = MWPopupList.this.fScrollbar.getValue();
            int n2 = MWPopupList.this.fScrollbar.getUnitIncrement();
            int n3 = 1;
            if (this.fScrollDown) {
                MWPopupList.this.fScrollbar.setValue(n + n2);
            } else {
                MWPopupList.this.fScrollbar.setValue(n - n2);
                n3 = 2;
            }
            if (MWPopupList.this.fScrollbar.getValue() != n) {
                AdjustmentEvent adjustmentEvent = new AdjustmentEvent(MWPopupList.this.fScrollbar, 601, n3, MWPopupList.this.fScrollbar.getValue());
                MWPopupList.this.fHandler.adjustmentValueChanged(adjustmentEvent);
            }
        }
    }

    private class AutoScroller
    implements Runnable {
        private int fId;
        private boolean fScrollDown;

        AutoScroller(int n, boolean bl) {
            this.fId = n;
            this.fScrollDown = bl;
        }

        @Override
        public void run() {
            while (MWPopupList.this.fAutoScrollId == this.fId) {
                try {
                    Thread.sleep(25L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                QueueEvent.postQueueEvent((QueueEvent)new AutoScrollAdjustEvent(this.fScrollDown));
            }
        }
    }
}

