/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt;

import com.mathworks.mwt.MWComponent;
import com.mathworks.mwt.window.MWWindowActivater;
import com.mathworks.util.IntBuffer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;

public class MWStyledTextLabel
extends MWComponent {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int TOP = 0;
    public static final int BOTTOM = 2;
    private int fHorizontalAlignment = 0;
    private int fVerticalAlignment = 0;
    private char[] fStoredText = null;
    private String[] fWrappedText = null;
    private Dimension fCachedSize = null;

    public MWStyledTextLabel(String string) {
        this.setText(string);
        this.setFont(new Font("Dialog", 0, 10));
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = this.getMinimumSize();
        if (dimension.width < 1) {
            FontMetrics fontMetrics = null;
            IntBuffer intBuffer = null;
            fontMetrics = this.getFontMetrics(this.getFont());
            if (fontMetrics != null) {
                intBuffer = MWStyledTextLabel.wrapText(this.fStoredText, 1024, fontMetrics);
                int n = intBuffer.length() / 2;
                int n2 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + fontMetrics.getLeading();
                int n3 = n * n2;
                if (n != 0) {
                    int n4 = fontMetrics.charsWidth(this.fStoredText, 0, this.fStoredText.length - 1);
                    int n5 = (int)Math.sqrt(n2 * n4 / 2);
                    dimension.height = Math.max(n3, n5);
                    dimension.width = n2 * n4 / dimension.height;
                }
            }
        }
        return dimension;
    }

    @Override
    public Dimension getMinimumSize() {
        int n = 5;
        Dimension dimension = this.getSize();
        if (dimension.width > 0) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n2 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + fontMetrics.getLeading();
            IntBuffer intBuffer = MWStyledTextLabel.wrapText(this.fStoredText, dimension.width - n, fontMetrics);
            dimension.height = n2 * intBuffer.length() / 2;
        }
        return dimension;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.fCachedSize = null;
    }

    public int getHAlignment() {
        return this.fHorizontalAlignment;
    }

    public void setHAlignment(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.fHorizontalAlignment = n;
                break;
            }
            default: {
                this.fHorizontalAlignment = 0;
            }
        }
        this.repaint();
    }

    public int getVAlignment() {
        return this.fVerticalAlignment;
    }

    public void setVAlignment(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.fVerticalAlignment = n;
                break;
            }
            default: {
                this.fVerticalAlignment = 0;
            }
        }
        this.repaint();
    }

    public String getText() {
        return new String(this.fStoredText);
    }

    public void setText(String string) {
        this.fStoredText = string.toCharArray();
        this.fWrappedText = null;
        this.fCachedSize = null;
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Dimension dimension = this.getSize();
        Font font = this.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        if (!dimension.equals(this.fCachedSize) || this.fWrappedText == null) {
            IntBuffer intBuffer = MWStyledTextLabel.wrapText(this.fStoredText, dimension.width, fontMetrics);
            n = intBuffer.length() / 2;
            this.fWrappedText = new String[n];
            for (int i = 0; i < n; ++i) {
                this.fWrappedText[i] = new String(this.fStoredText, intBuffer.getAt(i * 2), intBuffer.getAt(i * 2 + 1));
            }
            this.fCachedSize = dimension;
            this.invalidate();
        }
        int n5 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + fontMetrics.getLeading();
        n = this.fWrappedText.length;
        if (n == 0) {
            return;
        }
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setFont(font);
        graphics.setColor(this.getForeground());
        switch (this.getVAlignment()) {
            case 0: {
                n2 = fontMetrics.getMaxAscent();
                break;
            }
            case 1: {
                n2 = dimension.height / 2 - n5 * n / 2 + fontMetrics.getMaxAscent();
                break;
            }
            case 2: {
                n2 = dimension.height - n5 * (n - 1) - fontMetrics.getMaxDescent();
            }
        }
        for (int i = 0; i < n; ++i) {
            n4 = fontMetrics.stringWidth(this.fWrappedText[i]);
            switch (this.getHAlignment()) {
                case 0: {
                    n3 = 0;
                    break;
                }
                case 1: {
                    n3 = dimension.width / 2 - n4 / 2;
                    break;
                }
                case 2: {
                    n3 = dimension.width - n4;
                }
            }
            graphics.drawString(this.fWrappedText[i], n3, n2);
            n2 += n5;
        }
    }

    private static final void STATIC_________() {
    }

    public static IntBuffer wrapText(char[] cArray, int n, FontMetrics fontMetrics) {
        int n2 = 0;
        int n3 = 0;
        IntBuffer intBuffer = new IntBuffer();
        if (fontMetrics != null) {
            n3 = MWStyledTextLabel.getLineLength(cArray, n2, n, fontMetrics);
            intBuffer.append(n2);
            intBuffer.append(MWStyledTextLabel.stripTrailingLineFeeds(cArray, n2, n3));
            while (n2 + n3 < cArray.length) {
                n2 = MWStyledTextLabel.skipLeadingWhiteSpace(cArray, n2 + n3);
                n3 = MWStyledTextLabel.getLineLength(cArray, n2, n, fontMetrics);
                intBuffer.append(n2);
                intBuffer.append(MWStyledTextLabel.stripTrailingLineFeeds(cArray, n2, n3));
            }
        }
        return intBuffer;
    }

    private static final int getLineLength(char[] cArray, int n, int n2, FontMetrics fontMetrics) {
        int n3 = 0;
        int n4 = 0;
        int n5 = n;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = n; i < cArray.length; ++i) {
            ++n3;
            bl = MWStyledTextLabel.isWhiteSpace(cArray[i]);
            boolean bl4 = bl3 = i == cArray.length - 1 || cArray[i] == '\n' || cArray[i] == '\r';
            if (bl && !bl2 || bl3) {
                n4 = fontMetrics.charsWidth(cArray, n, n3);
                if (n4 > n2) {
                    if (n5 != n) {
                        n3 = n5 - n;
                        break;
                    }
                    while (n4 > n2 && n3 > 1) {
                        n4 = fontMetrics.charsWidth(cArray, n, --n3);
                    }
                    break;
                }
                if (bl3) break;
                n5 = i;
                bl2 = true;
                continue;
            }
            bl2 = bl;
        }
        return n3;
    }

    private static final boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\t';
    }

    private static final int skipLeadingWhiteSpace(char[] cArray, int n) {
        int n2;
        for (n2 = n; n2 < cArray.length && MWStyledTextLabel.isWhiteSpace(cArray[n2]); ++n2) {
        }
        return n2;
    }

    private static final int stripTrailingLineFeeds(char[] cArray, int n, int n2) {
        int n3 = n2;
        for (int i = n + n2 - 1; n2 > 0 && i < cArray.length && (cArray[i] == '\r' || cArray[i] == '\n'); --i) {
            --n3;
        }
        return n3 > 0 ? n3 : 0;
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame("Alert Frame");
        MWWindowActivater mWWindowActivater = new MWWindowActivater(frame);
        frame.setBounds(50, 50, 500, 500);
        String string = "Hi, this sentence should start on a new line (one CR) and be followed by a blank line (CR CR):\n\n4 Spaces (    ) in middle, and at line's end:    \nTab (\t) in middle, and at line's end:\t\nFinally, a very long word like antidisestablishementarianism. Oh, and lets not forget the case of (3) trailing spaces   ";
        MWStyledTextLabel mWStyledTextLabel = new MWStyledTextLabel("TOP-LEFT\n" + string);
        mWStyledTextLabel.setBackground(Color.white);
        MWStyledTextLabel mWStyledTextLabel2 = new MWStyledTextLabel("TOP-CENTER\n" + string);
        mWStyledTextLabel2.setHAlignment(1);
        mWStyledTextLabel2.setBackground(Color.white);
        MWStyledTextLabel mWStyledTextLabel3 = new MWStyledTextLabel("TOP-RIGHT\n" + string);
        mWStyledTextLabel3.setHAlignment(2);
        mWStyledTextLabel3.setBackground(Color.white);
        MWStyledTextLabel mWStyledTextLabel4 = new MWStyledTextLabel("LEFT-CENTER\n" + string);
        mWStyledTextLabel4.setVAlignment(1);
        mWStyledTextLabel4.setBackground(Color.white);
        MWStyledTextLabel mWStyledTextLabel5 = new MWStyledTextLabel("CENTER-CENTER\n" + string);
        mWStyledTextLabel5.setVAlignment(1);
        mWStyledTextLabel5.setHAlignment(1);
        mWStyledTextLabel5.setBackground(Color.yellow);
        mWStyledTextLabel5.setForeground(Color.blue);
        mWStyledTextLabel5.setFont(new Font("SansSerif", 2, 12));
        MWStyledTextLabel mWStyledTextLabel6 = new MWStyledTextLabel("RIGHT-CENTER\n" + string);
        mWStyledTextLabel6.setVAlignment(1);
        mWStyledTextLabel6.setHAlignment(2);
        mWStyledTextLabel6.setBackground(Color.white);
        MWStyledTextLabel mWStyledTextLabel7 = new MWStyledTextLabel(string + "\nBOTTOM-LEFT");
        mWStyledTextLabel7.setVAlignment(2);
        mWStyledTextLabel7.setBackground(Color.white);
        MWStyledTextLabel mWStyledTextLabel8 = new MWStyledTextLabel(string + "\nBOTTOM-CENTER");
        mWStyledTextLabel8.setVAlignment(2);
        mWStyledTextLabel8.setHAlignment(1);
        mWStyledTextLabel8.setBackground(Color.white);
        MWStyledTextLabel mWStyledTextLabel9 = new MWStyledTextLabel(string + "\nBOTTOM-RIGHT");
        mWStyledTextLabel9.setVAlignment(2);
        mWStyledTextLabel9.setHAlignment(2);
        mWStyledTextLabel9.setBackground(Color.white);
        GridLayout gridLayout = new GridLayout(3, 3, 10, 10);
        frame.setLayout(gridLayout);
        frame.add(mWStyledTextLabel);
        frame.add(mWStyledTextLabel2);
        frame.add(mWStyledTextLabel3);
        frame.add(mWStyledTextLabel4);
        frame.add(mWStyledTextLabel5);
        frame.add(mWStyledTextLabel6);
        frame.add(mWStyledTextLabel7);
        frame.add(mWStyledTextLabel8);
        frame.add(mWStyledTextLabel9);
        Dimension dimension = gridLayout.preferredLayoutSize(frame);
        frame.invalidate();
        frame.setBounds(50, 50, dimension.width, dimension.height);
        frame.setBackground(Color.gray);
        frame.setVisible(true);
        frame.repaint();
    }
}

