/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.decorations;

import com.mathworks.mwt.MWImageResource;
import com.mathworks.mwt.decorations.HiliteFilter;
import com.mathworks.mwt.decorations.PlatformDecorations;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.image.FilteredImageSource;
import javax.swing.UIManager;

class MotifDecorations
extends PlatformDecorations {
    private static final int DIR_UP = 0;
    private static final int DIR_LEFT = 1;
    private static final int DIR_DOWN = 2;
    private static final int DIR_RIGHT = 3;
    private static Color FACE = SystemColor.control;
    private static final Color FACE_HILITED = new Color(159, 159, 159);
    private static final Color TEXT = new Color(0, 0, 0);
    private static final Color TEXT_DISABLED = new Color(127, 127, 127);
    private static final Color LT_HILITE = new Color(255, 255, 255);
    private static Color HILITE = new Color(223, 223, 223);
    private static final Color SHADOW = new Color(111, 111, 111);
    private static final Color DK_SHADOW = new Color(0, 0, 0);
    private static final Color SELECTION = new Color(172, 90, 123);
    private static final Font DEFAULT_FONT = new Font("Dialog", 0, 12);
    private int fChecksize = 13;
    private static final int RB_EMPTY = 0;
    private static final int RB_EMPTY_HILITE = 1;
    private static final int RB_EMPTY_DISABLED = 2;
    private static final int RB_CHECKED = 3;
    private static final int RB_CHECKED_HILITE = 4;
    private static final int RB_CHECKED_DISABLED = 5;
    private static final byte[] RB_OUTLINE;
    private static final byte[] RB_OUTLINE2;
    private MWImageResource[] fRBImages;

    MotifDecorations() {
    }

    @Override
    Font getFont(int n) {
        Font font = null;
        switch (n) {
            case 0: {
                font = DEFAULT_FONT;
            }
        }
        return font;
    }

    @Override
    Color getColor(int n) {
        Color color = null;
        switch (n) {
            case 0: {
                color = Color.white;
                break;
            }
            case 1: {
                color = FACE;
                break;
            }
            case 2: {
                color = Color.white;
                break;
            }
            case 3: {
                color = Color.gray;
                break;
            }
            case 4: {
                color = Color.black;
                break;
            }
            case 5: {
                color = Color.white;
                break;
            }
            case 6: {
                color = FACE;
                break;
            }
            case 7: {
                color = LT_HILITE;
                break;
            }
            case 8: {
                color = HILITE;
                break;
            }
            case 9: {
                color = SHADOW;
                break;
            }
            case 10: {
                color = DK_SHADOW;
                break;
            }
            case 11: {
                color = Color.black;
                break;
            }
            case 12: {
                color = Color.black;
                break;
            }
            case 13: {
                color = Color.white;
                break;
            }
            case 14: {
                color = Color.black;
                break;
            }
            case 15: {
                color = SystemColor.textInactiveText;
                break;
            }
            case 17: {
                color = SystemColor.activeCaptionText;
                break;
            }
            case 16: {
                color = SystemColor.activeCaption;
                break;
            }
            case 19: {
                color = SystemColor.inactiveCaptionText;
                break;
            }
            case 18: {
                color = SystemColor.inactiveCaption;
            }
        }
        return color;
    }

    @Override
    void drawLabel(Graphics graphics, String string, int n, int n2, boolean bl, boolean bl2) {
        if (string != null) {
            if (bl2) {
                graphics.setColor(TEXT);
                graphics.drawString(string, n, n2);
            } else {
                graphics.setColor(LT_HILITE);
                graphics.drawString(string, n + 1, n2 + 1);
                graphics.setColor(TEXT_DISABLED);
                graphics.drawString(string, n, n2);
            }
        }
    }

    @Override
    void drawButtonLabel(Graphics graphics, String string, int n, int n2, boolean bl, boolean bl2) {
        this.drawLabel(graphics, string, n, n2, bl, bl2);
    }

    @Override
    void drawButtonBevel(Graphics graphics, Rectangle rectangle, boolean bl, boolean bl2, boolean bl3) {
        graphics.translate(rectangle.x, rectangle.y);
        if (bl || bl2) {
            graphics.setColor(SHADOW);
            graphics.drawRect(0, 0, rectangle.width - 1, rectangle.height - 1);
            graphics.setColor(HILITE);
            graphics.drawLine(1, rectangle.height - 2, rectangle.width - 2, rectangle.height - 2);
            graphics.drawLine(rectangle.width - 2, rectangle.height - 3, rectangle.width - 2, 1);
            graphics.setColor(FACE_HILITED);
            graphics.fillRect(1, 1, rectangle.width - 3, rectangle.height - 3);
        } else {
            graphics.setColor(HILITE);
            graphics.drawLine(0, rectangle.height - 2, 0, 0);
            graphics.drawLine(1, 0, rectangle.width - 2, 0);
            graphics.setColor(DK_SHADOW);
            graphics.drawLine(rectangle.width - 1, 0, rectangle.width - 1, rectangle.height - 1);
            graphics.drawLine(rectangle.width - 2, rectangle.height - 1, 0, rectangle.height - 1);
            graphics.setColor(SHADOW);
            graphics.drawLine(1, rectangle.height - 2, rectangle.width - 2, rectangle.height - 2);
            graphics.drawLine(rectangle.width - 2, rectangle.height - 3, rectangle.width - 2, 1);
            graphics.setColor(FACE);
            graphics.fillRect(1, 1, rectangle.width - 3, rectangle.height - 3);
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    @Override
    void drawTBButtonBevel(Graphics graphics, Rectangle rectangle, boolean bl, boolean bl2, boolean bl3) {
        this.drawButtonBevel(graphics, rectangle, bl, bl2, bl3);
    }

    @Override
    MWImageResource[] drawButtonImage(MWImageResource[] mWImageResourceArray, Graphics graphics, MWImageResource mWImageResource, int n, int n2, boolean bl, boolean bl2) {
        MWImageResource[] mWImageResourceArray2 = mWImageResourceArray;
        if (mWImageResource != null) {
            if (bl) {
                mWImageResourceArray2 = this.buildCache(mWImageResource, mWImageResourceArray2, 0);
                graphics.drawImage(mWImageResourceArray2[0].getImage(), n, n2, this);
            } else if (bl2) {
                graphics.drawImage(mWImageResource.getImage(), n, n2, this);
            } else {
                mWImageResourceArray2 = this.buildCache(mWImageResource, mWImageResourceArray2, 1);
                graphics.drawImage(mWImageResourceArray2[1].getImage(), n + 1, n2 + 1, this);
                graphics.drawImage(mWImageResourceArray2[2].getImage(), n, n2, this);
            }
        }
        return mWImageResourceArray2;
    }

    @Override
    Image[] drawButtonImage(Image[] imageArray, Graphics graphics, Image image, int n, int n2, boolean bl, boolean bl2) {
        Image[] imageArray2 = imageArray;
        if (image != null) {
            if (bl) {
                imageArray2 = this.buildCache(image, imageArray2, 0);
                graphics.drawImage(imageArray2[0], n, n2, this);
            } else if (bl2) {
                graphics.drawImage(image, n, n2, this);
            } else {
                imageArray2 = this.buildCache(image, imageArray2, 1);
                graphics.drawImage(imageArray2[1], n + 1, n2 + 1, this);
                graphics.drawImage(imageArray2[2], n, n2, this);
            }
        }
        return imageArray2;
    }

    private MWImageResource[] buildCache(MWImageResource mWImageResource, MWImageResource[] mWImageResourceArray, int n) {
        if (mWImageResourceArray == null) {
            mWImageResourceArray = new MWImageResource[3];
        }
        if (mWImageResourceArray[n] == null) {
            if (n == 1) {
                FilteredImageSource filteredImageSource = new FilteredImageSource(mWImageResource.getImage().getSource(), new HiliteFilter(LT_HILITE));
                mWImageResourceArray[1] = new MWImageResource(mWImageResource.getResourceName() + "1", filteredImageSource);
                filteredImageSource = new FilteredImageSource(mWImageResource.getImage().getSource(), new HiliteFilter(SHADOW));
                mWImageResourceArray[2] = new MWImageResource(mWImageResource.getResourceName() + "2", filteredImageSource);
            } else {
                FilteredImageSource filteredImageSource = new FilteredImageSource(mWImageResource.getImage().getSource(), new HiliteFilter(0));
                mWImageResourceArray[0] = new MWImageResource(mWImageResource.getResourceName() + "0", filteredImageSource);
            }
        }
        return mWImageResourceArray;
    }

    private Image[] buildCache(Image image, Image[] imageArray, int n) {
        if (imageArray == null) {
            imageArray = new Image[3];
        }
        if (imageArray[n] == null) {
            switch (n) {
                case 0: {
                    FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), new HiliteFilter(0));
                    imageArray[0] = this.createImage(filteredImageSource);
                    this.waitForImage(imageArray[0]);
                    break;
                }
                case 1: {
                    FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), new HiliteFilter(LT_HILITE));
                    imageArray[1] = this.createImage(filteredImageSource);
                    this.waitForImage(imageArray[1]);
                    filteredImageSource = new FilteredImageSource(image.getSource(), new HiliteFilter(SHADOW));
                    imageArray[2] = this.createImage(filteredImageSource);
                    this.waitForImage(imageArray[2]);
                    break;
                }
            }
        }
        return imageArray;
    }

    @Override
    void drawButtonImage(Graphics graphics, Image image, int n, int n2, boolean bl, boolean bl2) {
        this.drawButtonImage(null, graphics, image, n, n2, bl, bl2);
    }

    private boolean waitForImage(Image image) {
        boolean bl = true;
        if (image != null) {
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(image, 2013);
            try {
                mediaTracker.waitForID(2013);
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    int getChecksize() {
        return this.fChecksize;
    }

    @Override
    void drawCheckbox(Graphics graphics, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        graphics.translate(n, n2);
        if (bl || bl2) {
            graphics.setColor(FACE_HILITED);
            graphics.fillRect(1, 1, this.fChecksize - 2, this.fChecksize - 2);
            graphics.setColor(SHADOW);
            graphics.drawLine(0, this.fChecksize - 2, 0, 0);
            graphics.drawLine(1, 0, this.fChecksize - 2, 0);
            graphics.setColor(HILITE);
            graphics.drawLine(this.fChecksize - 1, 0, this.fChecksize - 1, this.fChecksize - 1);
            graphics.drawLine(this.fChecksize - 2, this.fChecksize - 1, 0, this.fChecksize - 1);
        } else {
            graphics.setColor(FACE);
            graphics.fillRect(1, 1, this.fChecksize - 2, this.fChecksize - 2);
            graphics.setColor(HILITE);
            graphics.drawLine(0, this.fChecksize - 2, 0, 0);
            graphics.drawLine(1, 0, this.fChecksize - 2, 0);
            graphics.setColor(SHADOW);
            graphics.drawLine(this.fChecksize - 1, 0, this.fChecksize - 1, this.fChecksize - 1);
            graphics.drawLine(this.fChecksize - 2, this.fChecksize - 1, 0, this.fChecksize - 1);
        }
        Color color = bl4 ? TEXT : TEXT_DISABLED;
        graphics.setColor(color);
        if (bl3) {
            graphics.drawLine(3, 5, 9, 5);
            graphics.drawLine(3, 6, 9, 6);
        } else if (bl2) {
            graphics.drawLine(3, 5, 3, 9);
            graphics.drawLine(4, 9, 10, 3);
            graphics.drawLine(9, 3, 5, 7);
            graphics.drawLine(4, 8, 4, 5);
        }
        graphics.translate(-n, -n2);
    }

    private int[] newRBMap(int n) {
        int[] nArray = new int[6];
        nArray[0] = 0;
        if (n == FACE_HILITED.getRGB()) {
            nArray[1] = SHADOW.getRGB() | 0xFF000000;
            nArray[2] = FACE_HILITED.getRGB() | 0xFF000000;
            nArray[3] = HILITE.getRGB() | 0xFF000000;
        } else {
            nArray[1] = HILITE.getRGB() | 0xFF000000;
            nArray[2] = FACE_HILITED.getRGB() | 0xFF000000;
            nArray[3] = SHADOW.getRGB() | 0xFF000000;
        }
        nArray[5] = n | 0xFF000000;
        return nArray;
    }

    private void addRBCheck(int[] nArray, int n) {
        nArray[44] = nArray[45] = (n |= 0xFF000000);
        nArray[58] = nArray[59] = n;
        nArray[57] = nArray[59];
        nArray[56] = nArray[59];
        nArray[72] = nArray[73] = n;
        nArray[71] = nArray[73];
        nArray[70] = nArray[73];
        nArray[69] = nArray[73];
        nArray[68] = nArray[73];
        nArray[85] = nArray[86] = n;
        nArray[84] = nArray[86];
        nArray[83] = nArray[86];
        nArray[82] = nArray[86];
        nArray[81] = nArray[86];
        nArray[97] = nArray[98] = n;
        nArray[96] = nArray[98];
        nArray[95] = nArray[98];
        nArray[109] = nArray[110] = n;
    }

    private void buildRBImages() {
        if (this.fRBImages == null) {
            this.fRBImages = new MWImageResource[6];
            int[] nArray = this.newRBMap(FACE.getRGB());
            int[] nArray2 = this.newRBInts(RB_OUTLINE, nArray);
            this.fRBImages[0] = new MWImageResource(12, 12, nArray2);
            nArray = this.newRBMap(FACE_HILITED.getRGB());
            nArray2 = this.newRBInts(RB_OUTLINE, nArray);
            this.fRBImages[1] = new MWImageResource(12, 12, nArray2);
            this.fRBImages[2] = this.fRBImages[1];
            nArray2 = this.newRBInts(RB_OUTLINE2, nArray);
            this.addRBCheck(nArray2, SELECTION.getRGB());
            this.fRBImages[3] = new MWImageResource(13, 13, nArray2);
            this.fRBImages[4] = this.fRBImages[3];
            this.fRBImages[5] = this.fRBImages[4];
        }
    }

    @Override
    void drawRadiobutton(Graphics graphics, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        graphics.translate(n, n2);
        this.buildRBImages();
        if (this.fRBImages != null) {
            if (bl2 && !bl3) {
                graphics.drawImage(this.fRBImages[3].getImage(), 0, 0, this);
            } else if (bl) {
                graphics.drawImage(this.fRBImages[1].getImage(), 0, 0, this);
            } else {
                graphics.drawImage(this.fRBImages[0].getImage(), 0, 0, this);
            }
            if (bl3) {
                graphics.setColor(SELECTION);
                graphics.drawLine(3, 5, 9, 5);
                graphics.drawLine(3, 6, 9, 6);
            }
        } else {
            if (bl || bl2) {
                graphics.setColor(FACE_HILITED);
                graphics.fillOval(1, 1, this.fChecksize - 3, this.fChecksize - 3);
                graphics.setColor(SHADOW);
                graphics.drawArc(0, 0, this.fChecksize - 1, this.fChecksize - 1, 45, 180);
                graphics.setColor(HILITE);
                graphics.drawArc(0, 0, this.fChecksize - 1, this.fChecksize - 1, 225, 180);
            } else {
                graphics.setColor(FACE);
                graphics.fillOval(1, 1, this.fChecksize - 3, this.fChecksize - 3);
                graphics.setColor(HILITE);
                graphics.drawArc(0, 0, this.fChecksize - 1, this.fChecksize - 1, 45, 180);
                graphics.setColor(SHADOW);
                graphics.drawArc(0, 0, this.fChecksize - 1, this.fChecksize - 1, 225, 180);
            }
            graphics.setColor(SELECTION);
            if (bl3) {
                graphics.drawLine(3, 5, 9, 5);
                graphics.drawLine(3, 6, 9, 6);
            } else if (bl2) {
                graphics.fillOval(3, 3, this.fChecksize - 7, this.fChecksize - 7);
            }
        }
        graphics.translate(-n, -n2);
    }

    @Override
    void drawScrollTrack(Graphics graphics, Rectangle rectangle, int n, int n2, boolean bl, boolean bl2) {
        if (rectangle.isEmpty()) {
            return;
        }
        if (n2 == 0) {
            graphics.setColor(FACE_HILITED);
            graphics.fillRect(rectangle.x + 2, rectangle.y, rectangle.width - 4, rectangle.height);
            graphics.setColor(SHADOW);
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
            graphics.drawLine(rectangle.x + 1, rectangle.y, rectangle.x + 1, rectangle.y + rectangle.height - 1);
            graphics.setColor(HILITE);
            graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
            graphics.drawLine(rectangle.x + rectangle.width - 2, rectangle.y, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 1);
        } else {
            graphics.setColor(FACE_HILITED);
            graphics.fillRect(rectangle.x, rectangle.y + 2, rectangle.width, rectangle.height - 4);
            graphics.setColor(SHADOW);
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y);
            graphics.drawLine(rectangle.x, rectangle.y + 1, rectangle.x + rectangle.width - 1, rectangle.y + 1);
            graphics.setColor(HILITE);
            graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
            graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 2, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 2);
        }
    }

    @Override
    void drawScrollThumb(Graphics graphics, Rectangle rectangle, int n, boolean bl, boolean bl2, boolean bl3) {
        if (rectangle.isEmpty()) {
            return;
        }
        graphics.translate(rectangle.x, rectangle.y);
        if (n == 0) {
            graphics.setColor(FACE);
            graphics.fillRect(4, 2, rectangle.width - 8, rectangle.height - 4);
            graphics.setColor(SHADOW);
            graphics.drawLine(0, 0, 0, rectangle.height - 1);
            graphics.drawLine(1, 0, 1, rectangle.height - 1);
            graphics.drawLine(3, rectangle.height - 1, rectangle.width - 3, rectangle.height - 1);
            graphics.drawLine(rectangle.width - 3, rectangle.height - 2, rectangle.width - 3, 0);
            graphics.drawLine(rectangle.width - 4, 1, rectangle.width - 4, rectangle.height - 2);
            graphics.drawLine(rectangle.width - 5, rectangle.height - 2, 4, rectangle.height - 2);
            graphics.setColor(HILITE);
            graphics.drawLine(rectangle.width - 1, 0, rectangle.width - 1, rectangle.height - 1);
            graphics.drawLine(rectangle.width - 2, 0, rectangle.width - 2, rectangle.height - 1);
            graphics.drawLine(2, rectangle.height - 1, 2, 0);
            graphics.drawLine(3, 0, rectangle.width - 4, 0);
            graphics.drawLine(rectangle.width - 5, 1, 3, 1);
            graphics.drawLine(3, 2, 3, rectangle.height - 2);
        } else {
            graphics.setColor(FACE);
            graphics.fillRect(2, 4, rectangle.width - 4, rectangle.height - 8);
            graphics.setColor(SHADOW);
            graphics.drawLine(0, 0, rectangle.width - 1, 0);
            graphics.drawLine(0, 1, rectangle.width - 1, 1);
            graphics.drawLine(rectangle.width - 1, 3, rectangle.width - 1, rectangle.height - 3);
            graphics.drawLine(rectangle.width - 2, rectangle.height - 3, 0, rectangle.height - 3);
            graphics.drawLine(1, rectangle.height - 4, rectangle.width - 2, rectangle.height - 4);
            graphics.drawLine(rectangle.width - 2, rectangle.height - 5, rectangle.width - 2, 4);
            graphics.setColor(HILITE);
            graphics.drawLine(0, rectangle.height - 1, rectangle.width - 1, rectangle.height - 1);
            graphics.drawLine(0, rectangle.height - 2, rectangle.width - 1, rectangle.height - 2);
            graphics.drawLine(rectangle.width - 1, 2, 0, 2);
            graphics.drawLine(0, 3, 0, rectangle.height - 4);
            graphics.drawLine(1, rectangle.height - 5, 1, 3);
            graphics.drawLine(2, 3, rectangle.width - 2, 3);
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    @Override
    int sliderThumbLength() {
        return 11;
    }

    @Override
    void drawSliderThumb(Graphics graphics, Rectangle rectangle, int n, boolean bl, boolean bl2, boolean bl3) {
        if (rectangle.isEmpty()) {
            return;
        }
        graphics.translate(rectangle.x, rectangle.y);
        boolean bl4 = false;
        boolean bl5 = true;
        int n2 = rectangle.width;
        int n3 = rectangle.height - 2;
        if (bl2) {
            if (n == 0) {
                graphics.setColor(this.getColor(7));
                graphics.drawLine(0, 0, 9, 0);
                graphics.drawLine(0, 0, 0, 10);
                graphics.drawLine(0, 10, 4, 14);
                graphics.setColor(this.getColor(8));
                graphics.drawLine(1, 1, 8, 1);
                graphics.drawLine(1, 1, 1, 10);
                graphics.drawLine(1, 10, 4, 13);
                graphics.setColor(this.getColor(10));
                graphics.drawLine(10, 0, 10, 10);
                graphics.drawLine(10, 10, 5, 15);
                graphics.setColor(this.getColor(9));
                graphics.drawLine(9, 1, 9, 10);
                graphics.drawLine(9, 10, 5, 14);
                graphics.setColor(this.getColor(6));
                graphics.fillRect(2, 2, 7, 9);
                for (int i = 0; i < 3; ++i) {
                    graphics.drawLine(3 + i, 11 + i, 7 - i, 11 + i);
                }
            } else {
                graphics.setColor(this.getColor(7));
                graphics.drawLine(0, 0, 0, 9);
                graphics.drawLine(0, 0, 10, 0);
                graphics.drawLine(10, 0, 14, 4);
                graphics.setColor(this.getColor(8));
                graphics.drawLine(1, 1, 1, 8);
                graphics.drawLine(1, 1, 10, 1);
                graphics.drawLine(10, 1, 13, 4);
                graphics.setColor(this.getColor(10));
                graphics.drawLine(0, 10, 10, 10);
                graphics.drawLine(10, 10, 15, 5);
                graphics.setColor(this.getColor(9));
                graphics.drawLine(1, 9, 10, 9);
                graphics.drawLine(10, 9, 14, 5);
                graphics.setColor(this.getColor(6));
                graphics.fillRect(2, 2, 9, 7);
                for (int i = 0; i < 3; ++i) {
                    graphics.drawLine(11 + i, 3 + i, 11 - i, 7 + i);
                }
            }
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    @Override
    void drawSliderTrack(Graphics graphics, Rectangle rectangle, int n, int n2, boolean bl) {
        if (rectangle.isEmpty()) {
            return;
        }
        graphics.translate(rectangle.x, rectangle.y);
        graphics.setColor(Color.black);
        if (bl) {
            if (n == 2) {
                if (n2 == 0) {
                    graphics.setColor(this.getColor(9));
                    graphics.drawLine(0, 4, rectangle.width - 1, 4);
                    graphics.setColor(this.getColor(10));
                    graphics.drawLine(0, 5, rectangle.width - 1, 5);
                    graphics.setColor(this.getColor(8));
                    graphics.drawLine(0, 6, rectangle.width - 1, 6);
                    graphics.setColor(this.getColor(7));
                    graphics.drawLine(0, 7, rectangle.width - 1, 7);
                } else {
                    graphics.setColor(this.getColor(9));
                    graphics.drawLine(4, 0, 4, rectangle.height - 1);
                    graphics.setColor(this.getColor(10));
                    graphics.drawLine(5, 0, 5, rectangle.height - 1);
                    graphics.setColor(this.getColor(8));
                    graphics.drawLine(6, 0, 6, rectangle.height - 1);
                    graphics.setColor(this.getColor(7));
                    graphics.drawLine(7, 0, 7, rectangle.height - 1);
                }
            } else if (n2 == 0) {
                graphics.setColor(this.getColor(9));
                graphics.drawLine(1, 4, rectangle.width, 4);
                graphics.setColor(this.getColor(10));
                graphics.drawLine(1, 5, rectangle.width, 5);
                graphics.setColor(this.getColor(8));
                graphics.drawLine(1, 6, rectangle.width, 6);
                graphics.setColor(this.getColor(7));
                graphics.drawLine(1, 7, rectangle.width, 7);
            } else {
                graphics.setColor(this.getColor(9));
                graphics.drawLine(4, 1, 4, rectangle.height);
                graphics.setColor(this.getColor(10));
                graphics.drawLine(5, 1, 5, rectangle.height);
                graphics.setColor(this.getColor(8));
                graphics.drawLine(6, 1, 6, rectangle.height);
                graphics.setColor(this.getColor(7));
                graphics.drawLine(7, 1, 7, rectangle.height);
            }
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    @Override
    void drawScrollArrowButton(Graphics graphics, Rectangle rectangle, boolean bl, boolean bl2, boolean bl3, int n, int n2) {
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = n3 / 2;
        int n6 = n4 / 2;
        graphics.translate(rectangle.x, rectangle.y);
        if (n == 0) {
            if (n2 == 0) {
                graphics.setColor(FACE_HILITED);
                graphics.fillRect(2, 2, n3 - 4, n4 - 2);
                graphics.setColor(SHADOW);
                graphics.drawLine(0, n4 - 1, 0, 0);
                graphics.drawLine(1, 0, n3 - 2, 0);
                graphics.drawLine(n3 - 3, 1, 1, 1);
                graphics.drawLine(1, 2, 1, n4 - 1);
                graphics.setColor(HILITE);
                graphics.drawLine(n3 - 1, 0, n3 - 1, n4 - 1);
                graphics.drawLine(n3 - 2, 1, n3 - 2, n4 - 1);
                Color color = bl ? SHADOW : HILITE;
                graphics.setColor(color);
                graphics.drawLine(n5 - 1, 2, 2, n4 - 4);
                graphics.drawLine(n5, 2, 3, n4 - 4);
                color = bl ? HILITE : SHADOW;
                graphics.setColor(color);
                graphics.drawLine(2, n4 - 3, n3 - 3, n4 - 3);
                graphics.drawLine(n3 - 3, n4 - 4, n5, 2);
                graphics.drawLine(3, n4 - 4, n3 - 4, n4 - 4);
                graphics.drawLine(n3 - 4, n4 - 4, n5, 4);
                graphics.drawLine(n5, 3, n5, 3);
            } else {
                graphics.setColor(FACE_HILITED);
                graphics.fillRect(2, 0, n3 - 4, n4 - 2);
                graphics.setColor(HILITE);
                graphics.drawLine(n3 - 1, 0, n3 - 1, n4 - 1);
                graphics.drawLine(n3 - 2, n4 - 1, 1, n4 - 1);
                graphics.drawLine(2, n4 - 2, n3 - 2, n4 - 2);
                graphics.drawLine(n3 - 2, n4 - 3, n3 - 2, 0);
                graphics.setColor(SHADOW);
                graphics.drawLine(0, 0, 0, n4 - 1);
                graphics.drawLine(1, 0, 1, n4 - 2);
                Color color = bl ? SHADOW : HILITE;
                graphics.setColor(color);
                graphics.drawLine(2, 3, n5 - 1, n4 - 3);
                graphics.drawLine(3, 3, n5, n4 - 3);
                graphics.drawLine(2, 2, n3 - 3, 2);
                graphics.drawLine(4, 3, n3 - 5, 3);
                color = bl ? HILITE : SHADOW;
                graphics.setColor(color);
                graphics.drawLine(n5, n4 - 3, n3 - 3, 3);
                graphics.drawLine(n5, n4 - 5, n3 - 4, 3);
            }
        } else if (n2 == 0) {
            graphics.setColor(FACE_HILITED);
            graphics.fillRect(2, 2, n3 - 2, n4 - 4);
            graphics.setColor(SHADOW);
            graphics.drawLine(n3 - 1, 0, 0, 0);
            graphics.drawLine(0, 1, 0, n4 - 2);
            graphics.drawLine(1, n4 - 3, 1, 1);
            graphics.drawLine(2, 1, n3 - 1, 1);
            graphics.setColor(HILITE);
            graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
            graphics.drawLine(1, n4 - 2, n3 - 1, n4 - 2);
            Color color = bl ? SHADOW : HILITE;
            graphics.setColor(color);
            graphics.drawLine(2, n6 - 1, n3 - 4, 2);
            graphics.drawLine(2, n6, n3 - 4, 3);
            color = bl ? HILITE : SHADOW;
            graphics.setColor(color);
            graphics.drawLine(n3 - 3, 2, n3 - 3, n4 - 3);
            graphics.drawLine(n3 - 4, n4 - 3, 2, n6);
            graphics.drawLine(n3 - 4, 3, n3 - 4, n4 - 4);
            graphics.drawLine(n3 - 4, n4 - 4, 4, n6);
            graphics.drawLine(3, n6, 3, n6);
        } else {
            graphics.setColor(FACE_HILITED);
            graphics.fillRect(0, 2, n3 - 2, n4 - 4);
            graphics.setColor(HILITE);
            graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
            graphics.drawLine(n3 - 1, n4 - 2, n3 - 1, 1);
            graphics.drawLine(n3 - 2, 2, n3 - 2, n4 - 2);
            graphics.drawLine(n3 - 3, n4 - 2, 0, n4 - 2);
            graphics.setColor(SHADOW);
            graphics.drawLine(0, 0, n3 - 1, 0);
            graphics.drawLine(0, 1, n3 - 2, 1);
            Color color = bl ? SHADOW : HILITE;
            graphics.setColor(color);
            graphics.drawLine(3, 2, n3 - 3, n6 - 1);
            graphics.drawLine(3, 3, n3 - 3, n6);
            graphics.drawLine(2, 2, 2, n4 - 3);
            graphics.drawLine(3, 4, 3, n4 - 5);
            color = bl ? HILITE : SHADOW;
            graphics.setColor(color);
            graphics.drawLine(n3 - 3, n6, 3, n4 - 3);
            graphics.drawLine(n3 - 5, n6, 3, n4 - 4);
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    @Override
    void drawPopupControl(Graphics graphics, Rectangle rectangle, String string, boolean bl, boolean bl2, boolean bl3) {
        Rectangle rectangle2 = new Rectangle(rectangle);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        rectangle2.x = rectangle.x + rectangle.width - rectangle.height;
        rectangle2.height = rectangle.height / 3;
        rectangle2.y = rectangle.y + rectangle2.height;
        rectangle2.width = 2 * rectangle2.height;
        this.drawButtonBevel(graphics, rectangle, bl, false, bl2);
        this.drawButtonBevel(graphics, rectangle2, bl, false, bl2);
        string = this.shortenString(string, fontMetrics, rectangle.width - rectangle.height - 4);
        this.drawLabel(graphics, string, rectangle.x + 4, rectangle.y + fontMetrics.getAscent() + fontMetrics.getLeading() + 2, bl, bl2);
    }

    @Override
    void drawComboControl(Graphics graphics, Rectangle rectangle, boolean bl, boolean bl2, boolean bl3) {
        int n = rectangle.width;
        int n2 = rectangle.height;
        int n3 = rectangle.x + n - n2;
        int n4 = rectangle.y;
        int n5 = n2 / 4;
        int n6 = 2 * n5;
        int n7 = 3 * n5;
        graphics.translate(n3, n4);
        graphics.fillRect(-2, 0, 2, n2);
        this.drawButtonBevel(graphics, new Rectangle(0, 0, n2, n2), bl, false, bl2);
        if (bl) {
            graphics.setColor(this.getColor(9));
        } else {
            graphics.setColor(this.getColor(7));
        }
        graphics.drawLine(n7 - 1, n5, n6, n7 - 1);
        if (bl) {
            graphics.setColor(this.getColor(7));
        } else {
            graphics.setColor(this.getColor(9));
        }
        graphics.drawLine(n7 - 1, n5, n5, n5);
        graphics.drawLine(n5, n5, n6 - 1, n7 - 1);
        graphics.translate(-n3, -n4);
    }

    static {
        Color color = FACE = UIManager.getLookAndFeel().getClass().getName().equals("com.jgoodies.looks.plastic.Plastic3DLookAndFeel") ? new Color(236, 233, 216) : new Color(220, 220, 220);
        if (FACE.getRed() > 200 && FACE.getGreen() > 200 && FACE.getBlue() > 200) {
            HILITE = Color.white;
        }
        RB_OUTLINE = new byte[]{0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 5, 5, 5, 5, 1, 1, 0, 0, 0, 1, 5, 5, 5, 5, 5, 5, 5, 5, 2, 0, 0, 1, 5, 5, 5, 5, 5, 5, 5, 5, 5, 2, 1, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 3, 1, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 3, 1, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 3, 1, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 3, 0, 1, 5, 5, 5, 5, 5, 5, 5, 5, 3, 0, 0, 1, 5, 5, 5, 5, 5, 5, 5, 5, 3, 0, 0, 0, 2, 2, 5, 5, 5, 5, 3, 3, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 0, 0, 0, 0};
        RB_OUTLINE2 = new byte[]{0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 5, 5, 5, 5, 1, 1, 0, 0, 0, 0, 1, 5, 5, 5, 5, 5, 5, 5, 5, 1, 0, 0, 0, 1, 5, 5, 5, 5, 5, 5, 5, 5, 5, 3, 0, 1, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 3, 1, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 3, 1, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 3, 1, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 3, 0, 1, 5, 5, 5, 5, 5, 5, 5, 5, 5, 3, 0, 0, 1, 5, 5, 5, 5, 5, 5, 5, 5, 5, 3, 0, 0, 0, 5, 5, 5, 5, 5, 5, 5, 5, 3, 0, 0, 0, 0, 3, 3, 5, 5, 5, 5, 3, 3, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 0, 0, 0, 0, 0};
    }
}

