/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.floater;

import com.mathworks.mwt.MWBorderLayout;
import com.mathworks.mwt.MWUtils;
import com.mathworks.mwt.floater.Floater;
import com.mathworks.mwt.floater.FloaterOwner;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class FloaterCanvas
extends Canvas
implements Floater {
    private static final int MARGIN = 4;
    private FloaterOwner fFloaterOwner = null;
    private DeactivateHandler fDeactivateHandler = null;

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void show(Component component, int n, int n2) {
        Window window = MWUtils.getTopLevelWindow(component);
        LayoutManager layoutManager = window.getLayout();
        if (layoutManager instanceof MWBorderLayout) {
            window.add(this, "Floating", 0);
            Dimension dimension = this.getPreferredSize();
            Point point = this.getLocationInWindow(component);
            Rectangle rectangle = this.fitInWindow(window, point.x + n, point.y + n2, dimension.width, dimension.height);
            this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.setVisible(true);
            this.requestFocus();
        } else {
            System.out.println("The window containing this component must have");
            System.out.println("an MWBorderLayout for this component to function.");
            System.out.println("It is recommended that you use MWFrame or MWDialog.");
        }
    }

    @Override
    public void collapse() {
        Window window = MWUtils.getTopLevelWindow(this);
        Rectangle rectangle = this.getBounds();
        this.setVisible(false);
        if (window != null) {
            window.remove(this);
            Graphics graphics = window.getGraphics();
            if (graphics != null && window.getBackground() != null) {
                graphics.setColor(window.getBackground());
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                graphics.dispose();
            }
            window.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    @Override
    public boolean getAutoCollapse() {
        return true;
    }

    @Override
    public void setFloaterOwner(FloaterOwner floaterOwner) {
        this.fFloaterOwner = floaterOwner;
    }

    @Override
    public FloaterOwner getFloaterOwner() {
        return this.fFloaterOwner;
    }

    @Override
    public void addNotify() {
        this.fDeactivateHandler = new DeactivateHandler();
        MWUtils.getTopLevelWindow(this).addWindowListener(this.fDeactivateHandler);
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        MWUtils.getTopLevelWindow(this).removeWindowListener(this.fDeactivateHandler);
        this.fDeactivateHandler = null;
        super.removeNotify();
    }

    private Rectangle fitInWindow(Window window, int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        Rectangle rectangle2 = window.getBounds();
        Insets insets = window.getInsets();
        int n5 = rectangle2.height - insets.bottom - 4;
        int n6 = rectangle2.width - insets.right - 4;
        if (rectangle.x + n3 > n6) {
            rectangle.x = n6 - n3;
        }
        if (rectangle.y + n4 > n5) {
            rectangle.y = n5 - n4;
        }
        return rectangle;
    }

    private Point getLocationInWindow(Component component) {
        Point point = component.getLocation();
        for (Container container = component.getParent(); container != null && !(container instanceof Window); container = container.getParent()) {
            point.x += container.getLocation().x;
            point.y += container.getLocation().y;
        }
        return point;
    }

    private class DeactivateHandler
    extends WindowAdapter {
        private DeactivateHandler() {
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
            FloaterCanvas.this.collapse();
            if (FloaterCanvas.this.getFloaterOwner() != null) {
                FloaterCanvas.this.getFloaterOwner().floaterAutoCollapsed(FloaterCanvas.this);
            }
        }
    }
}

