/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.table;

import com.mathworks.mwt.MWImageResource;
import com.mathworks.mwt.MWTextField;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.mwt.table.CellText;
import com.mathworks.mwt.table.LabeledImageResource;
import com.mathworks.mwt.table.Style;
import com.mathworks.mwt.table.Table;
import com.mathworks.util.PlatformInfo;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;

public class CellImageResource
extends CellText {
    private Point fImgPoint = new Point();
    private Point fTxtPoint = new Point();

    public CellImageResource(Table table) {
        super(table);
    }

    @Override
    public void render(Graphics graphics, int n, int n2, Rectangle rectangle, Object object, Style style, boolean bl) {
        if (object instanceof MWImageResource) {
            Image image = ((MWImageResource)object).getImage(this.getTable());
            String string = null;
            boolean bl2 = this.isTableActive();
            if (object instanceof LabeledImageResource) {
                string = CellImageResource.displayString(((LabeledImageResource)object).getLabel());
            }
            graphics.setFont(style.getFont());
            this.getImageLocation(rectangle, image, string, graphics.getFontMetrics(), style, this.fImgPoint, this.fTxtPoint);
            if (image != null) {
                graphics.drawImage(image, this.fImgPoint.x, this.fImgPoint.y, this.getTable());
            }
            if (string != null) {
                if (bl && style.getCustomHilite()) {
                    FontMetrics fontMetrics = graphics.getFontMetrics();
                    int n3 = fontMetrics.stringWidth(string);
                    int n4 = this.fTxtPoint.y - fontMetrics.getMaxAscent();
                    int n5 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
                    graphics.setColor(Decorations.getColor(4, bl2, this.getTable().getBackground()));
                    graphics.fillRect(this.fTxtPoint.x - 1, n4 - 1, n3 + 2, n5 + 2);
                }
                if (bl && PlatformInfo.getAppearance() != 0) {
                    graphics.setColor(Decorations.getColor(5, bl2, null));
                } else {
                    graphics.setColor(style.getForeground());
                }
                graphics.drawString(string, this.fTxtPoint.x, this.fTxtPoint.y);
            }
        }
    }

    @Override
    protected Rectangle getFieldBounds(int n, int n2) {
        Image image;
        Rectangle rectangle = super.getFieldBounds(n, n2);
        Object object = this.getTable().getData().getData(n, n2);
        int n3 = this.getTable().getCellStyle((int)n, (int)n2).getMargins().left;
        if (object instanceof LabeledImageResource && (image = ((LabeledImageResource)object).getImage(this.getTable())) != null) {
            n3 += image.getWidth(this.getTable());
        }
        rectangle.x += n3;
        rectangle.width -= n3;
        return rectangle;
    }

    @Override
    protected String getInitialValue(int n, int n2) {
        String string = "";
        Object object = this.getTable().getCellData(n, n2);
        if (object instanceof LabeledImageResource) {
            string = ((LabeledImageResource)object).getLabel();
        }
        return string;
    }

    @Override
    public void commitEdit(int n, int n2) {
        MWTextField mWTextField = this.getField();
        Object object = this.getTable().getCellData(n, n2);
        if (mWTextField != null && object instanceof LabeledImageResource) {
            LabeledImageResource labeledImageResource = (LabeledImageResource)object;
            labeledImageResource.setLabel(mWTextField.getText());
            this.commitEdit(n, n2, labeledImageResource);
        } else {
            super.commitEdit(n, n2);
        }
    }

    @Override
    protected void getPreferredCellSize(int n, int n2, Dimension dimension) {
        if (dimension != null) {
            super.getPreferredCellSize(n, n2, dimension);
            Object object = this.getTable().getCellData(n, n2);
            if (object instanceof LabeledImageResource) {
                Font font;
                Image image = ((LabeledImageResource)object).getImage();
                int n3 = 0;
                int n4 = 0;
                if (image != null) {
                    n3 = image.getWidth(this.getTable());
                    n4 = image.getHeight(this.getTable());
                }
                if ((font = this.getTable().getCellStyle(n, n2).getFont()) != null) {
                    FontMetrics fontMetrics = this.getTable().getFontMetrics(font);
                    if (fontMetrics.getHeight() > n4) {
                        n4 = fontMetrics.getHeight();
                    }
                    n3 += fontMetrics.stringWidth("3") / 2;
                    n3 += fontMetrics.stringWidth(((LabeledImageResource)object).getLabel());
                }
                dimension.width += n3;
                dimension.height += n4;
            }
        }
    }

    private void getImageLocation(Rectangle rectangle, Image image, String string, FontMetrics fontMetrics, Style style, Point point, Point point2) {
        Insets insets = style.getMargins();
        int n = fontMetrics.stringWidth("3") / 2;
        int n2 = image != null ? image.getWidth(this.getTable()) : 0;
        int n3 = string != null ? fontMetrics.stringWidth(string) : 0;
        int n4 = image != null ? image.getHeight(this.getTable()) : 0;
        int n5 = string != null ? fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() : 0;
        int n6 = rectangle.width - insets.left - insets.right;
        int n7 = n2 + n3;
        if (image != null && string != null && !string.equals("")) {
            n7 += n;
        }
        switch (style.getHAlignment()) {
            case 0: {
                point.x = rectangle.x + insets.left;
                break;
            }
            case 1: {
                point.x = rectangle.x + insets.left + (n6 - n7) / 2;
                break;
            }
            case 2: {
                point.x = rectangle.x + rectangle.width - insets.right - n7;
            }
        }
        point2.x = point.x;
        if (image != null) {
            point2.x += n2 + n;
        }
        int n8 = rectangle.height - insets.top - insets.bottom;
        switch (style.getVAlignment()) {
            case 0: {
                point.y = rectangle.y + insets.top;
                point2.y = rectangle.y + insets.top + fontMetrics.getMaxAscent();
                break;
            }
            case 1: {
                point.y = rectangle.y + insets.top + (n8 - n4) / 2;
                point2.y = rectangle.y + insets.top + (n8 - n5) / 2 + fontMetrics.getMaxAscent();
                break;
            }
            case 2: {
                point.y = rectangle.y + rectangle.height - insets.bottom - n4;
                point2.y = rectangle.y + rectangle.height - insets.bottom - fontMetrics.getMaxDescent();
            }
        }
    }
}

