/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.table;

import com.mathworks.mwt.table.TableData;
import com.mathworks.mwt.table.TableDataEvent;

public class SimpleData
extends TableData {
    private static final int NO_INDEX = -1;
    private int fWidth;
    private int fHeight;
    private Object[] fData;

    public SimpleData(int n, int n2) {
        this.fWidth = n;
        this.fHeight = n2;
        this.fData = new Object[n * n2];
    }

    @Override
    public Object getData(int n, int n2) {
        int n3 = this.getIndex(n, n2);
        Object object = n3 != -1 ? this.fData[n3] : null;
        return object;
    }

    @Override
    public synchronized void setData(int n, int n2, Object object) {
        int n3 = this.getIndex(n, n2);
        if (n3 != -1) {
            this.fData[n3] = object;
        }
        this.fireDataChangedEvent(n, n2);
    }

    @Override
    public void setPort(Object object, int n, int n2, int n3, int n4) {
    }

    @Override
    public int getWidth() {
        return this.fWidth;
    }

    @Override
    public synchronized void setWidth(int n) {
        if (n > 0 && n != this.fWidth) {
            this.fireDataEvent(new TableDataEvent(4));
            Object[] objectArray = new Object[n * this.fHeight];
            int n2 = Math.min(n, this.fWidth);
            int n3 = 0;
            int n4 = 0;
            for (int i = 0; i < this.fHeight; ++i) {
                System.arraycopy(this.fData, n3, objectArray, n4, n2);
                n3 += this.fWidth;
                n4 += n;
            }
            this.fData = objectArray;
            this.fWidth = n;
            this.fireDataEvent(new TableDataEvent(this.fWidth, this.fHeight));
        }
    }

    @Override
    public int getHeight() {
        return this.fHeight;
    }

    @Override
    public void setHeight(int n) {
        this.setHeight(n, false);
    }

    private synchronized void setHeight(int n, boolean bl) {
        if (n >= 0 && n != this.fHeight) {
            this.fireDataEvent(new TableDataEvent(4));
            Object[] objectArray = new Object[this.fWidth * n];
            int n2 = Math.min(this.fData.length, objectArray.length);
            System.arraycopy(this.fData, 0, objectArray, 0, n2);
            n2 = n - this.fHeight;
            this.fData = objectArray;
            this.fHeight = n;
            if (bl) {
                int n3;
                if (n2 < 0) {
                    n3 = 3;
                    n2 = -n2;
                } else {
                    n3 = 2;
                }
                this.fireDataEvent(new TableDataEvent(n3, n, n2));
            }
            this.fireDataEvent(new TableDataEvent(this.fWidth, this.fHeight));
        }
    }

    @Override
    public synchronized void addRows(int n, int n2) {
        if (n <= -1 || n >= this.fHeight) {
            this.setHeight(this.fHeight + n2, true);
        } else {
            this.fireDataEvent(new TableDataEvent(4));
            int n3 = this.fHeight + n2;
            Object[] objectArray = new Object[this.fWidth * n3];
            int n4 = (this.fHeight - n) * this.fWidth;
            int n5 = n * this.fWidth;
            int n6 = n2 * this.fWidth;
            if (n > 0) {
                System.arraycopy(this.fData, 0, objectArray, 0, n * this.fWidth);
            }
            System.arraycopy(this.fData, n5, objectArray, n5 + n6, n4);
            this.fData = objectArray;
            this.fHeight = n3;
            this.fireDataEvent(new TableDataEvent(2, n, n2));
            this.fireDataEvent(new TableDataEvent(this.fWidth, this.fHeight));
        }
    }

    @Override
    public synchronized void addColumns(int n, int n2) {
        if (n <= -1 || n >= this.fWidth) {
            this.setWidth(this.fWidth + n2);
        } else {
            this.fireDataEvent(new TableDataEvent(4));
            int n3 = this.fWidth + n2;
            Object[] objectArray = new Object[n3 * this.fHeight];
            for (int i = 0; i < this.fHeight; ++i) {
                if (n > 0) {
                    System.arraycopy(this.fData, i * this.fWidth, objectArray, i * n3, n);
                }
                System.arraycopy(this.fData, i * this.fWidth + n, objectArray, i * n3 + n + n2, this.fWidth - n);
            }
            this.fData = objectArray;
            this.fWidth = n3;
            this.fireDataEvent(new TableDataEvent(this.fWidth, this.fHeight));
        }
    }

    @Override
    public synchronized void removeRows(int n, int n2) {
        if (n >= 0 && n < this.fHeight) {
            if (n + n2 >= this.fHeight) {
                this.setHeight(n, true);
            } else {
                this.fireDataEvent(new TableDataEvent(4));
                int n3 = this.fHeight - n2;
                Object[] objectArray = new Object[this.fWidth * n3];
                int n4 = (n3 - n) * this.fWidth;
                int n5 = (n + n2) * this.fWidth;
                int n6 = n2 * this.fWidth;
                if (n > 0) {
                    System.arraycopy(this.fData, 0, objectArray, 0, n * this.fWidth);
                }
                System.arraycopy(this.fData, n5, objectArray, n5 - n6, n4);
                this.fData = objectArray;
                this.fHeight = n3;
                this.fireDataEvent(new TableDataEvent(3, n, n2));
                this.fireDataEvent(new TableDataEvent(this.fWidth, this.fHeight));
            }
        }
    }

    @Override
    public synchronized void removeColumns(int n, int n2) {
        if (n >= 0 && n < this.fWidth) {
            if (n + n2 >= this.fWidth) {
                this.setWidth(n);
            } else {
                this.fireDataEvent(new TableDataEvent(4));
                int n3 = this.fWidth - n2;
                Object[] objectArray = new Object[n3 * this.fHeight];
                for (int i = 0; i < this.fHeight; ++i) {
                    if (n > 0) {
                        System.arraycopy(this.fData, i * this.fWidth, objectArray, i * n3, n);
                    }
                    System.arraycopy(this.fData, i * this.fWidth + n + n2, objectArray, i * n3 + n, n3 - n);
                }
                this.fData = objectArray;
                this.fWidth = n3;
                this.fireDataEvent(new TableDataEvent(this.fWidth, this.fHeight));
            }
        }
    }

    private int getIndex(int n, int n2) {
        int n3 = -1;
        if (n >= 0 && n < this.fHeight && n2 >= 0 && n2 < this.fWidth) {
            n3 = n * this.fWidth + n2;
        }
        return n3;
    }
}

