/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.table;

import com.mathworks.mwt.MWCheckbox;
import com.mathworks.mwt.MWContainer;
import com.mathworks.mwt.MWImageResource;
import com.mathworks.mwt.MWMouseWheelTarget;
import com.mathworks.mwt.MWScrollbar;
import com.mathworks.mwt.MWTextField;
import com.mathworks.mwt.MWUtils;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.mwt.table.Cell;
import com.mathworks.mwt.table.CellBoolean;
import com.mathworks.mwt.table.CellCharacter;
import com.mathworks.mwt.table.CellColor;
import com.mathworks.mwt.table.CellEnumData;
import com.mathworks.mwt.table.CellFile;
import com.mathworks.mwt.table.CellImageResource;
import com.mathworks.mwt.table.CellMWCheckbox;
import com.mathworks.mwt.table.CellText;
import com.mathworks.mwt.table.CellTreeCellData;
import com.mathworks.mwt.table.EnumWithState;
import com.mathworks.mwt.table.KeyTracker;
import com.mathworks.mwt.table.LabeledImageResource;
import com.mathworks.mwt.table.MixedState;
import com.mathworks.mwt.table.OptionsColumn;
import com.mathworks.mwt.table.OptionsRow;
import com.mathworks.mwt.table.ScrollbarOptions;
import com.mathworks.mwt.table.Selection;
import com.mathworks.mwt.table.SelectionEvent;
import com.mathworks.mwt.table.SelectionListener;
import com.mathworks.mwt.table.SelectionOptions;
import com.mathworks.mwt.table.SimpleData;
import com.mathworks.mwt.table.Style;
import com.mathworks.mwt.table.TableData;
import com.mathworks.mwt.table.TableDataEvent;
import com.mathworks.mwt.table.TableDataListener;
import com.mathworks.mwt.table.TableDecorations;
import com.mathworks.mwt.table.TableEvent;
import com.mathworks.mwt.table.TableListener;
import com.mathworks.mwt.table.TableUtils;
import com.mathworks.mwt.table.TrackDispatcher;
import com.mathworks.mwt.table.TrackerAction;
import com.mathworks.mwt.table.TrackerCell;
import com.mathworks.mwt.table.TrackerCursor;
import com.mathworks.mwt.table.TrackerFocus;
import com.mathworks.mwt.table.TrackerResize;
import com.mathworks.mwt.table.TrackerSelection;
import com.mathworks.mwt.table.TreeCellData;
import com.mathworks.mwt.table.TreeData;
import com.mathworks.mwt.table.ValueEvent;
import com.mathworks.mwt.table.ValueListener;
import com.mathworks.util.IntBuffer;
import com.mathworks.util.IntHashtable;
import com.mathworks.util.MutableInt;
import com.mathworks.util.Offscreen;
import com.mathworks.util.PlatformInfo;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Table
extends MWContainer
implements ItemSelectable,
MWMouseWheelTarget {
    public static final int BORDER_NONE = 0;
    public static final int BORDER_SIMPLE = 1;
    public static final int BORDER_BEVEL = 2;
    public static final int HEADER_INDEX = -1;
    public static final int NO_INDEX = -2;
    public static final int TREE_INDEX = -3;
    public static final int DEFAULT_SIZE = -1;
    public static final int EXPAND_NONE = -1;
    public static final int EXPAND_LAST = -2;
    public static final int AUTO_MIN_SIZE = -1;
    protected static final int BEFORE_INDEX = -3;
    protected static final int AFTER_INDEX = -4;
    protected static final int HOME = -1;
    protected static final int END = -2;
    protected static final int UNIT_DEC = 2;
    protected static final int UNIT_INC = 1;
    protected static final int BLOCK_DEC = 3;
    protected static final int BLOCK_INC = 4;
    protected static final int NO_PART = 0;
    protected static final int CONTENT = 1;
    protected static final int COLUMN_HEADER = 2;
    protected static final int COLUMN_RESIZE = 3;
    protected static final int ROW_HEADER = 4;
    protected static final int ROW_RESIZE = 5;
    protected static final int HSCROLL = 6;
    protected static final int VSCROLL = 7;
    protected static final int NW_CORNER = 8;
    protected static final int NE_CORNER = 9;
    protected static final int SW_CORNER = 10;
    protected static final int SE_CORNER = 11;
    private static final int RESIZE_THRESHOLD = 5;
    private static final int SMOOTH_SCROLL_STEP = 10;
    private static final int SCROLLBAR_NO = 0;
    private static final int SCROLLBAR_MAYBE = 1;
    private static final int SCROLLBAR_YES = 2;
    private TableData fData;
    private TreeData fTreeData;
    private Style fStyle;
    private int fBorderStyle;
    private ScrollbarOptions fHScrollOptions;
    private ScrollbarOptions fVScrollOptions;
    private Hashtable fCells;
    private IntHashtable fColStyles;
    private IntHashtable fRowStyles;
    private IntHashtable fCellStyles;
    private Vector fStylePriority;
    private IntHashtable fColHeaderData;
    private IntHashtable fRowHeaderData;
    private OptionsColumn fColOptions;
    private OptionsRow fRowOptions;
    private int fColCount;
    private int fRowCount;
    private IntHashtable fColWidth;
    private IntHashtable fRowHeight;
    private int fHOffset;
    private int fVOffset;
    private AdjustmentHandler fAdjustmentHandler;
    private MWScrollbar fHScroll;
    private MWScrollbar fVScroll;
    private boolean fNeedsUpdate;
    private boolean fPainting;
    private int fCachedHOffset;
    private int fCachedVOffset;
    private Selection fSelection;
    private Point fTrackingCell;
    private Point fEditingCell;
    private Point fActiveCell;
    private Rectangle fActiveBorder;
    private boolean fResizeZeroWidthColumns;
    private boolean fContextTriggerAware;
    private boolean fNoSelectionFocus;
    private boolean fDblClickEdit;
    private boolean fExcelMode;
    private ExcelHandler fExcelHandler;
    private boolean fAnchorVisible;
    private int fCursorType;
    private Font fCurFont;
    private Dimension fPreferredCellSize;
    private Dimension fPreferredTableSize;
    private boolean fIncludeScroll;
    private Insets fInsets;
    private Offscreen fOffscreen;
    private Color fTableBackground;
    private ItemListener fItemListener;
    private ActionListener fActionListener;
    private Vector fValueListener;
    private Vector fTableListener;
    private String fActionCommand;
    private TreeCellData fTreeCellData;
    private boolean fShowRootlines;
    private int fAutoExpandCol;
    private int fMinAutoColWidth;
    private int fBiggestCellWidth;
    private int fWindowsFocusIndex;
    private int fWindowsFocusCol;
    private boolean fHScrollVisAWT;
    private boolean fVScrollVisAWT;
    private Rectangle fHScrollBoundsAWT;
    private Rectangle fVScrollBoundsAWT;

    public Table(TreeData treeData) {
        SimpleData simpleData = new SimpleData(1, 0);
        this.initTable(simpleData, treeData);
    }

    public Table(TableData tableData) {
        this.initTable(tableData, null);
    }

    public Table(int n, int n2) {
        SimpleData simpleData = new SimpleData(n2, n);
        this.initTable(simpleData, null);
    }

    public Table() {
        this(10, 10);
    }

    public void select(Rectangle[] rectangleArray) {
        this.getSelection().select(rectangleArray);
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public void select(Rectangle rectangle) {
        this.getSelection().select(rectangle);
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public void select(int n, int n2) {
        Rectangle rectangle = new Rectangle(n2, n, 1, 1);
        this.getSelection().select(rectangle);
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public void deselectAll() {
        this.getSelection().clearSelection(false);
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public int getFirstSelectedColumn() {
        Rectangle[] rectangleArray = this.fSelection.getSelection();
        int n = this.fData.getWidth();
        for (int i = 0; i < rectangleArray.length; ++i) {
            if (rectangleArray[i].x >= n) continue;
            n = rectangleArray[i].x;
        }
        if (n == this.fData.getWidth()) {
            n = -2;
        }
        return n;
    }

    public int getFirstSelectedRow() {
        Rectangle[] rectangleArray = this.fSelection.getSelection();
        int n = this.fData.getHeight();
        for (int i = 0; i < rectangleArray.length; ++i) {
            if (rectangleArray[i].y >= n) continue;
            n = rectangleArray[i].y;
        }
        if (n == this.fData.getHeight()) {
            n = -2;
        }
        return n;
    }

    public int getLastSelectedRow() {
        Rectangle[] rectangleArray = this.fSelection.getSelection();
        int n = -1;
        for (int i = 0; i < rectangleArray.length; ++i) {
            if (rectangleArray[i].y <= n) continue;
            n = rectangleArray[i].y;
        }
        if (n == -1) {
            n = -2;
        }
        return n;
    }

    public Object getFirstSelectedItem() {
        Rectangle[] rectangleArray = this.fSelection.getSelection();
        int n = this.fData.getWidth();
        int n2 = this.fData.getHeight();
        Object object = null;
        for (int i = 0; i < rectangleArray.length; ++i) {
            if (rectangleArray[i].y >= n2 && rectangleArray[i].x >= n) continue;
            n = rectangleArray[i].x;
            n2 = rectangleArray[i].y;
        }
        if (n < this.fData.getWidth() && n2 < this.fData.getHeight()) {
            object = this.getData().getData(n2, n);
        }
        return object;
    }

    public boolean isSelected(int n, int n2) {
        return this.fSelection.isSelected(n, n2);
    }

    public Enumeration getSelectedCells() {
        return new CellSelectionEnumerator();
    }

    public int[] getSelectedColumns() {
        int[] nArray;
        Rectangle[] rectangleArray = this.fSelection.getSelection();
        if (rectangleArray.length == 0) {
            nArray = new int[]{};
        } else if (rectangleArray.length == 1) {
            nArray = new int[rectangleArray[0].width];
            for (int i = 0; i < rectangleArray[0].width; ++i) {
                nArray[i] = rectangleArray[0].x + i;
            }
        } else {
            int n;
            IntBuffer intBuffer = new IntBuffer();
            for (n = 0; n < rectangleArray[0].width; ++n) {
                intBuffer.append(rectangleArray[0].x + n);
            }
            for (n = 1; n < rectangleArray.length; ++n) {
                for (int i = 0; i < rectangleArray[n].width; ++i) {
                    int n2;
                    int n3 = rectangleArray[n].x + i;
                    for (n2 = 0; n2 < intBuffer.length() && n3 != intBuffer.getAt(n2); ++n2) {
                    }
                    if (n2 != intBuffer.length()) continue;
                    intBuffer.append(n3);
                }
            }
            nArray = new int[intBuffer.length()];
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = intBuffer.getAt(n);
            }
        }
        return nArray;
    }

    public int[] getSelectedRows() {
        int[] nArray;
        Rectangle[] rectangleArray = this.fSelection.getSelection();
        if (rectangleArray.length == 0) {
            nArray = new int[]{};
        } else if (rectangleArray.length == 1) {
            nArray = new int[rectangleArray[0].height];
            for (int i = 0; i < rectangleArray[0].height; ++i) {
                nArray[i] = rectangleArray[0].y + i;
            }
        } else {
            int n;
            IntBuffer intBuffer = new IntBuffer();
            for (n = 0; n < rectangleArray[0].height; ++n) {
                intBuffer.append(rectangleArray[0].y + n);
            }
            for (n = 1; n < rectangleArray.length; ++n) {
                for (int i = 0; i < rectangleArray[n].height; ++i) {
                    int n2;
                    int n3 = rectangleArray[n].y + i;
                    for (n2 = 0; n2 < intBuffer.length() && n3 != intBuffer.getAt(n2); ++n2) {
                    }
                    if (n2 != intBuffer.length()) continue;
                    intBuffer.append(n3);
                }
            }
            nArray = new int[intBuffer.length()];
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = intBuffer.getAt(n);
            }
        }
        return nArray;
    }

    public boolean getShowRootlines() {
        return this.fShowRootlines;
    }

    public void setShowRootlines(boolean bl) {
        this.fShowRootlines = bl;
    }

    public TreeData getTreeData() {
        return this.fTreeData;
    }

    protected void setTreeData(TreeData treeData) {
        this.fTreeData = treeData;
        this.fTreeData.setTable(this);
    }

    public TableData getData() {
        return this.fData;
    }

    public Dimension getTableSize() {
        return new Dimension(this.fColCount, this.fRowCount);
    }

    public Style getTableStyle() {
        return this.fStyle;
    }

    public void setTableStyle(Style style) {
        this.fStyle = style;
    }

    public int getBorderStyle() {
        return this.fBorderStyle;
    }

    public void setBorderStyle(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                if (this.fBorderStyle == n) break;
                this.fInsets = null;
                this.fBorderStyle = n;
                this.layoutScrollbars();
            }
        }
    }

    public ScrollbarOptions getHScrollbarOptions() {
        return this.fHScrollOptions;
    }

    public void setHScrollbarOptions(ScrollbarOptions scrollbarOptions) {
        this.fHScrollOptions = scrollbarOptions;
    }

    public ScrollbarOptions getVScrollbarOptions() {
        return this.fVScrollOptions;
    }

    public void setVScrollbarOptions(ScrollbarOptions scrollbarOptions) {
        this.fVScrollOptions = scrollbarOptions;
    }

    public SelectionOptions getSelectionOptions() {
        return this.fSelection.getOptions();
    }

    public void setSelectionOptions(SelectionOptions selectionOptions) {
        this.fSelection.setOptions(selectionOptions);
    }

    public void setScrollOnExpand(boolean bl) {
        this.fRowOptions.setScrollOnExpand(bl);
    }

    public boolean getScrollOnExpand() {
        return this.fRowOptions.getScrollOnExpand();
    }

    public int getFirstColumn() {
        int n = this.getContentBounds().x + this.getRowOptions().getHeaderWidth();
        return this.columnAt(n);
    }

    public void setFirstColumn(int n) {
        int n2 = this.columnOffset(n);
        int n3 = this.fHScroll.getMaximum();
        int n4 = this.fHScroll.getValue();
        if (n2 > n3) {
            n2 = n3;
        }
        if (n2 != n4) {
            this.setHOffset(n2, false);
            this.fHScroll.setValue(n2);
            this.adjustScrollbars();
            this.repaint();
        }
    }

    public int getFirstRow() {
        int n = this.getContentBounds().y + this.getColumnOptions().getHeaderHeight();
        return this.rowAt(n);
    }

    public int getLastRow() {
        Rectangle rectangle = this.getContentBounds();
        int n = rectangle.y + rectangle.height - 1;
        int n2 = this.rowAt(n);
        if (n2 == -2) {
            n2 = this.fRowCount - 1;
        } else if (rectangle.height >= this.getRowHeight(n2) + this.getColumnOptions().getHeaderHeight()) {
            n2 = this.rowAt(n - this.getRowHeight(n2) + 1);
        }
        return n2;
    }

    public void setFirstRow(int n) {
        int n2 = this.rowOffset(n);
        int n3 = this.fVScroll.getMaximum();
        int n4 = this.fVScroll.getValue();
        if (n2 > n3) {
            n2 = n3;
        }
        if (n2 != n4) {
            this.setVOffset(n2, false);
            this.fVScroll.setValue(n2);
            this.adjustScrollbars();
            this.repaint();
        }
    }

    public boolean isAnchorVisible() {
        return this.fAnchorVisible;
    }

    public void setAnchorVisible(boolean bl) {
        this.fAnchorVisible = bl;
    }

    public boolean isWindowsNoSelectionFocus() {
        return this.fNoSelectionFocus;
    }

    public void setWindowsNoSelectionFocus(boolean bl) {
        this.fNoSelectionFocus = bl;
    }

    public boolean isExcelMode() {
        return this.fExcelMode;
    }

    public void setExcelMode(boolean bl) {
        if (bl != this.fExcelMode) {
            this.fExcelMode = bl;
            this.fExcelHandler = bl ? new ExcelHandler() : null;
        }
    }

    public int getCursorType() {
        return this.fCursorType;
    }

    public void setCursorType(int n) {
        if (Cursor.getPredefinedCursor(n) != null) {
            this.fCursorType = n;
        }
    }

    @Override
    public Font getFont() {
        return this.getTableStyle().getFont();
    }

    @Override
    public void setFont(Font font) {
        this.getTableStyle().setFont(font);
    }

    @Override
    public Color getForeground() {
        return this.getTableStyle().getForeground();
    }

    @Override
    public void setForeground(Color color) {
        this.getTableStyle().setForeground(color);
    }

    @Override
    public Color getBackground() {
        return this.getTableStyle().getBackground();
    }

    @Override
    public void setBackground(Color color) {
        this.getTableStyle().setBackground(color);
    }

    public Color getTableBackground() {
        return this.fTableBackground;
    }

    public void setTableBackground(Color color) {
        this.fTableBackground = color;
    }

    public Object getCellData(int n, int n2) {
        Object object = null;
        if (n2 == -1) {
            object = this.getColumnHeaderData(n2);
        } else if (n == -1) {
            object = this.getRowHeaderData(n);
        } else if (this.getTreeData() != null && n2 == -3) {
            int n3 = this.getTreeData().getItemId(n);
            if (this.fTreeCellData == null) {
                this.fTreeCellData = new TreeCellData();
            }
            this.fTreeCellData.setBranch(this.getTreeData().isBranch(n3));
            this.fTreeCellData.setExpanded(this.getTreeData().isExpanded(n3));
            this.fTreeCellData.setHasChildren(this.getTreeData().hasChildren(n3));
            this.fTreeCellData.setDepth(this.getTreeData().getDepth(n3));
            object = this.fTreeCellData;
        } else {
            object = this.fData.getData(n, n2);
        }
        return object;
    }

    public void setCellData(int n, int n2, Object object) {
        if (n2 != -1 && n != -1) {
            this.fData.setData(n, n2, object);
        }
    }

    public Style getCellStyle(int n, int n2) {
        IntHashtable intHashtable;
        Style style = this.getRowStyle(n);
        Style style2 = this.getColumnStyle(n2);
        Style style3 = null;
        Style style4 = this.getTableStyle();
        int n3 = -1;
        int n4 = -1;
        IntHashtable intHashtable2 = intHashtable = this.fCellStyles != null ? (IntHashtable)this.fCellStyles.get(n) : null;
        if (intHashtable != null) {
            style3 = (Style)intHashtable.get(n2);
        }
        if (style != null) {
            n3 = this.fStylePriority.indexOf(style);
        }
        if (style2 != null) {
            n4 = this.fStylePriority.indexOf(style2);
        }
        if (n3 < n4) {
            if (n2 > -1 && style != null) {
                style.setBaseStyle(style4);
                style4 = style;
            }
            if (n > -1 && style2 != null) {
                style2.setBaseStyle(style4);
                style4 = style2;
            }
        } else if (n4 < n3) {
            if (n > -1 && style2 != null) {
                style2.setBaseStyle(style4);
                style4 = style2;
            }
            if (n2 > -1 && style != null) {
                style.setBaseStyle(style4);
                style4 = style;
            }
        }
        if (style3 != null) {
            style3.setBaseStyle(style4);
            style4 = style3;
        }
        return style4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCellStyle(int n, int n2, Style style) {
        IntHashtable intHashtable = this.fCellStyles;
        synchronized (intHashtable) {
            IntHashtable intHashtable2 = (IntHashtable)this.fCellStyles.get(n);
            if (intHashtable2 != null) {
                intHashtable2.remove(n2);
                if (intHashtable2.size() == 0 && style == null) {
                    this.fCellStyles.remove(n);
                }
            }
            if (style != null) {
                if (intHashtable2 == null) {
                    intHashtable2 = new IntHashtable(37);
                    this.fCellStyles.put(n, (Object)intHashtable2);
                }
                intHashtable2.put(n2, (Object)style);
            }
        }
    }

    public int getAutoExpandColumn() {
        int n = this.fAutoExpandCol;
        int n2 = this.getData().getWidth();
        if (n == -2 && n2 > 0) {
            n = n2 - 1;
        }
        return n;
    }

    public void setAutoExpandColumn(int n) {
        this.fAutoExpandCol = n;
        this.refreshBiggestCellWidth();
        if (this.isShowing()) {
            this.expandColumn();
        }
    }

    public int getMinAutoExpandColumnWidth() {
        return this.fMinAutoColWidth;
    }

    public void setMinAutoExpandColumnWidth(int n) {
        this.fMinAutoColWidth = n;
        this.refreshBiggestCellWidth();
        if (this.isShowing()) {
            this.expandColumn();
        }
    }

    private void refreshBiggestCellWidth() {
        int n = this.getAutoExpandColumn();
        this.fBiggestCellWidth = -1;
        if (n != -1) {
            Dimension dimension = new Dimension();
            for (int i = 0; i < this.getData().getHeight(); ++i) {
                Cell cell = this.getCell(i, n);
                if (cell == null) continue;
                cell.getPreferredCellSize(i, n, dimension);
                if (dimension.width <= this.fBiggestCellWidth) continue;
                this.fBiggestCellWidth = dimension.width;
            }
            this.expandColumn();
        }
    }

    public void setResizeZeroWidthColumns(boolean bl) {
        this.fResizeZeroWidthColumns = bl;
    }

    boolean isResizeZeroWidthColumns() {
        return this.fResizeZeroWidthColumns;
    }

    boolean isContextTriggerAware() {
        return this.fContextTriggerAware;
    }

    public void setContextTriggerAware(boolean bl) {
        this.fContextTriggerAware = bl;
    }

    public OptionsColumn getColumnOptions() {
        return this.fColOptions;
    }

    public void setColumnOptions(OptionsColumn optionsColumn) {
        this.fColOptions = optionsColumn;
    }

    public int getColumnWidth(int n) {
        int n2 = this.getColumnOptions().getDefaultWidth();
        if (n == -1) {
            n2 = this.getRowOptions().getHeaderSize();
        } else {
            Integer n3 = (Integer)this.fColWidth.get(n);
            if (n3 != null) {
                n2 = n3;
            }
        }
        return n2;
    }

    public void setColumnWidth(int n, int n2) {
        this.setColumnWidth(n, n2, true);
        this.layoutScrollbars();
        this.repaint();
    }

    private void setColumnWidth(int n, int n2, boolean bl) {
        if (n == -1) {
            this.getRowOptions().setHeaderSize(n2);
        } else {
            this.fColWidth.remove(n);
            if (n2 != -1) {
                this.fColWidth.put(n, (Object)new Integer(n2));
            }
        }
        if (this.fExcelMode && this.fActiveBorder != null) {
            Rectangle[] rectangleArray = this.fSelection.getSelection();
            for (int i = 0; i < rectangleArray.length; ++i) {
                if (n >= rectangleArray[i].x + rectangleArray[i].width) continue;
                this.fActiveBorder = null;
                break;
            }
        }
        if (bl) {
            this.expandColumn();
        }
    }

    public Style getColumnStyle(int n) {
        Style style = null;
        if (this.fColStyles != null) {
            style = (Style)this.fColStyles.get(n);
        }
        return style;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColumnStyle(int n, Style style) {
        IntHashtable intHashtable = this.fColStyles;
        synchronized (intHashtable) {
            Style style2 = (Style)this.fColStyles.get(n);
            if (style2 != null) {
                this.fStylePriority.removeElement(style2);
                this.fColStyles.remove(n);
            }
            if (style != null) {
                this.fStylePriority.addElement(style);
                this.fColStyles.put(n, (Object)style);
            }
        }
    }

    public Object getColumnHeaderData(int n) {
        Object object = null;
        if (this.fColHeaderData.containsKey(n)) {
            object = this.fColHeaderData.get(n);
        }
        if (object == null) {
            object = TableUtils.buildAutoLabel(this.getColumnOptions().getAutoLabel(), n);
        }
        return object;
    }

    public void setColumnHeaderData(int n, Object object) {
        if (this.fColHeaderData.containsKey(n)) {
            this.fColHeaderData.remove(n);
        }
        if (object != null) {
            this.fColHeaderData.put(n, object);
        }
    }

    public OptionsRow getRowOptions() {
        return this.fRowOptions;
    }

    public void setRowOptions(OptionsRow optionsRow) {
        this.fRowOptions = optionsRow;
    }

    public int getRowHeight(int n) {
        int n2 = this.getRowOptions().getDefaultHeight();
        if (n == -1) {
            n2 = this.getColumnOptions().getHeaderSize();
        } else {
            Integer n3 = (Integer)this.fRowHeight.get(n);
            if (n3 != null) {
                n2 = n3;
            }
        }
        return n2;
    }

    public void setRowHeight(int n, int n2) {
        if (n == -1) {
            this.getColumnOptions().setHeaderSize(n2);
        } else {
            this.fRowHeight.remove(n);
            if (n2 != -1) {
                this.fRowHeight.put(n, (Object)new Integer(n2));
            }
        }
        if (this.fExcelMode && this.fActiveBorder != null) {
            Rectangle[] rectangleArray = this.fSelection.getSelection();
            for (int i = 0; i < rectangleArray.length; ++i) {
                if (n >= rectangleArray[i].y + rectangleArray[i].height) continue;
                this.fActiveBorder = null;
                break;
            }
        }
    }

    public Style getRowStyle(int n) {
        Style style = null;
        if (this.fRowStyles != null) {
            style = (Style)this.fRowStyles.get(n);
        }
        return style;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRowStyle(int n, Style style) {
        IntHashtable intHashtable = this.fRowStyles;
        synchronized (intHashtable) {
            Style style2 = (Style)this.fRowStyles.get(n);
            if (style2 != null) {
                this.fStylePriority.removeElement(style2);
                this.fRowStyles.remove(n);
            }
            if (style != null) {
                this.fStylePriority.addElement(style);
                this.fRowStyles.put(n, (Object)style);
            }
        }
    }

    public Object getRowHeaderData(int n) {
        Object object = null;
        if (this.fRowHeaderData.containsKey(n)) {
            object = this.fRowHeaderData.get(n);
        }
        if (object == null) {
            object = TableUtils.buildAutoLabel(this.getRowOptions().getAutoLabel(), n);
        }
        return object;
    }

    public void setRowHeaderData(int n, Object object) {
        if (this.fRowHeaderData.containsKey(n)) {
            this.fRowHeaderData.remove(n);
        }
        if (object != null) {
            this.fRowHeaderData.put(n, object);
        }
    }

    public void registerCellType(Class clazz, Cell cell) {
        if (this.fCells.containsKey(clazz)) {
            this.fCells.remove(clazz);
        }
        if (cell != null) {
            this.fCells.put(clazz, cell);
        }
    }

    public Point findCell(int n, int n2) {
        Point point = new Point(-2, -2);
        Rectangle rectangle = this.getContentBounds();
        int n3 = this.getRowOptions().getHeaderWidth();
        int n4 = this.getColumnOptions().getHeaderHeight();
        if (rectangle.contains(n, n2)) {
            point.x = n - rectangle.x < n3 ? -1 : this.columnAt(n);
            point.y = n2 - rectangle.y < n4 ? -1 : this.rowAt(n2);
        }
        if (this.getTreeData() != null && point.x == 0 && point.y > -1) {
            this.getCellBoundsInternal(point.y, point.x, true, rectangle);
            if (n < rectangle.x) {
                point.x = -3;
            }
        }
        return point;
    }

    public Cell getCell(int n, int n2) {
        Object object;
        if (n2 == -1) {
            object = this.getRowHeaderData(n);
        } else if (n == -1) {
            object = this.getColumnHeaderData(n2);
        } else {
            object = this.fData.getDataAsText(n, n2);
            if (object == null) {
                object = this.fData.getData(n, n2);
            }
        }
        return this.getCell(object);
    }

    public Cell getCell(Object object) {
        Cell cell = null;
        if (object == null) {
            cell = (Cell)this.fCells.get(String.class);
        } else {
            cell = (Cell)this.fCells.get(object.getClass());
            if (cell == null) {
                Class clazz = null;
                Enumeration enumeration = this.fCells.keys();
                while (enumeration.hasMoreElements()) {
                    clazz = (Class)enumeration.nextElement();
                    if (!clazz.isAssignableFrom(object.getClass())) continue;
                    cell = (Cell)this.fCells.get(clazz);
                    break;
                }
            }
        }
        return cell;
    }

    public void repaintCells(int n, int n2, int n3, int n4) {
        int n5 = n;
        int n6 = n2;
        int n7 = n4 - n2 + 1;
        int n8 = n3 - n + 1;
        Rectangle rectangle = this.getCellBounds(n5, n6);
        Rectangle rectangle2 = this.getContentBounds();
        int n9 = this.getRowOptions().getHeaderWidth();
        int n10 = this.getColumnOptions().getHeaderHeight();
        rectangle2.x += n9;
        rectangle2.width -= n9;
        rectangle2.y += n10;
        rectangle2.height -= n10;
        if (n7 > 1 || n8 > 1) {
            Rectangle rectangle3 = this.getCellBounds(n3, n4);
            rectangle = rectangle.union(rectangle3);
        }
        rectangle = rectangle.intersection(rectangle2);
        this.repaint(5L, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public Insets getInsets() {
        if (this.fInsets == null) {
            switch (this.getBorderStyle()) {
                case 0: {
                    this.fInsets = new Insets(0, 0, 0, 0);
                    break;
                }
                case 1: {
                    this.fInsets = new Insets(1, 1, 1, 1);
                    break;
                }
                case 2: {
                    if (!PlatformInfo.useWindowsXPAppearance()) {
                        this.fInsets = new Insets(2, 2, 2, 2);
                        break;
                    }
                    this.fInsets = new Insets(1, 1, 1, 1);
                    break;
                }
                default: {
                    this.fInsets = new Insets(0, 0, 0, 0);
                }
            }
        }
        return this.fInsets;
    }

    public void commitEdit() {
        Cell cell;
        if (this.fEditingCell.x > -1 && this.fEditingCell.y > -1 && (cell = this.getCell(this.fEditingCell.y, this.fEditingCell.x)) != null) {
            cell.commitEdit(this.fEditingCell.y, this.fEditingCell.x);
        }
    }

    private boolean eraseWindowsNoSelectionFocus(Graphics graphics) {
        boolean bl = false;
        if ((this.fNoSelectionFocus || this.fWindowsFocusIndex != -1) && !this.fExcelMode) {
            boolean bl2 = false;
            boolean bl3 = !this.getSelection().isSelEmpty();
            Window window = this.getTopLevelWindow();
            if (window != null && window.getFocusOwner() != this) {
                bl2 = true;
            }
            if (this.fWindowsFocusIndex != -1 && (bl3 || bl2)) {
                int n = this.fWindowsFocusIndex;
                int n2 = this.fWindowsFocusCol == -1 ? 0 : this.fWindowsFocusCol;
                Rectangle rectangle = this.getContentBounds();
                Rectangle rectangle2 = this.getCellBounds(n, n2);
                if (this.fWindowsFocusCol == -1) {
                    rectangle2.width = rectangle.width + rectangle.x - rectangle2.x;
                }
                if (rectangle2.intersects(rectangle)) {
                    Rectangle rectangle3 = graphics.getClipBounds();
                    rectangle3 = MWUtils.unionRect(rectangle3, rectangle2, rectangle3);
                    if (rectangle3.x < rectangle.x) {
                        rectangle3.x = rectangle.x;
                    }
                    if (rectangle3.y < rectangle.y) {
                        rectangle3.y = rectangle.y;
                    }
                    if (rectangle3.x + rectangle3.width > rectangle.x + rectangle.width) {
                        rectangle3.width = rectangle.x + rectangle.width - rectangle3.x;
                    }
                    if (rectangle3.y + rectangle3.height > rectangle.y + rectangle.height) {
                        rectangle3.height = rectangle.y + rectangle.height - rectangle3.y;
                    }
                    graphics.setClip(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                    bl = true;
                }
            }
        }
        return bl;
    }

    public void drawWindowsNoSelectionFocus(Graphics graphics) {
        if (this.fNoSelectionFocus && !this.fExcelMode) {
            boolean bl = !this.getSelection().isSelEmpty();
            SelectionOptions selectionOptions = this.getSelection().getOptions();
            if (selectionOptions.getMode() != 0) {
                int n = selectionOptions.getSelectBy();
                if (!(bl || n != 0 && n != 1)) {
                    Window window = this.getTopLevelWindow();
                    if (window != null && window.getFocusOwner() != this) {
                        return;
                    }
                    if (this.fWindowsFocusIndex == -1) {
                        this.fWindowsFocusIndex = this.getFirstRow();
                        if (this.fWindowsFocusIndex == -2) {
                            this.fWindowsFocusIndex = 0;
                        }
                        if (n == 0) {
                            this.fWindowsFocusCol = this.getFirstColumn();
                            if (this.fWindowsFocusCol == -2) {
                                this.fWindowsFocusCol = 0;
                            }
                        }
                    }
                    int n2 = this.fWindowsFocusIndex;
                    int n3 = this.fWindowsFocusCol == -1 ? 0 : this.fWindowsFocusCol;
                    Rectangle rectangle = this.getContentBounds();
                    Rectangle rectangle2 = this.getCellBounds(n2, n3);
                    if (n == 1) {
                        if (this.getTreeData() != null && this.fColCount == 1) {
                            Cell cell = this.getCell(n2, n3);
                            Dimension dimension = cell.getPreferredCellSize(n2, n3);
                            if (dimension.width < rectangle.width && dimension.width > 0) {
                                rectangle.width = dimension.width + rectangle2.x;
                            }
                        }
                        rectangle2.width = rectangle.width + rectangle.x - rectangle2.x;
                        this.fWindowsFocusCol = -1;
                    }
                    if (rectangle2.intersects(rectangle)) {
                        int n4 = rectangle.x + rectangle.width;
                        int n5 = rectangle.y + rectangle.height;
                        if (rectangle2.x > rectangle.x) {
                            rectangle.x = rectangle2.x;
                        }
                        if (rectangle2.y > rectangle.y) {
                            rectangle.y = rectangle2.y;
                        }
                        rectangle.width = rectangle.x + rectangle2.width < n4 ? rectangle2.width : n4 - rectangle.x;
                        rectangle.height = rectangle.y + rectangle2.height < n5 ? rectangle2.height : n5 - rectangle.y;
                        graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        Decorations.drawFocusRect(graphics, rectangle2.x, rectangle2.y, rectangle2.width - 1, rectangle2.height - 1);
                    }
                } else {
                    this.fWindowsFocusIndex = -1;
                    this.fWindowsFocusCol = -1;
                }
            } else {
                this.fWindowsFocusIndex = -1;
                this.fWindowsFocusCol = -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics graphics) {
        Graphics graphics2;
        Table table;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.fVScroll != null) {
            this.fVScroll.setVisible(this.fVScrollVisAWT);
            if (this.fVScrollBoundsAWT != null) {
                table = this;
                synchronized (table) {
                    this.fVScroll.setBounds(this.fVScrollBoundsAWT.x, this.fVScrollBoundsAWT.y, this.fVScrollBoundsAWT.width, this.fVScrollBoundsAWT.height);
                    this.fVScrollBoundsAWT = null;
                }
            }
        }
        if (this.fHScroll != null) {
            this.fHScroll.setVisible(this.fHScrollVisAWT);
            if (this.fHScrollBoundsAWT != null) {
                table = this;
                synchronized (table) {
                    this.fHScroll.setBounds(this.fHScrollBoundsAWT.x, this.fHScrollBoundsAWT.y, this.fHScrollBoundsAWT.width, this.fHScrollBoundsAWT.height);
                    this.fHScrollBoundsAWT = null;
                }
            }
        }
        this.fPainting = true;
        Rectangle rectangle = graphics.getClipBounds();
        if (this.eraseWindowsNoSelectionFocus(graphics)) {
            rectangle = rectangle.union(graphics.getClipBounds());
        }
        if ((graphics2 = this.fOffscreen.startRender(graphics)) == null) {
            this.fPainting = false;
            return;
        }
        Rectangle rectangle2 = this.getContentBounds();
        graphics2.setClip(rectangle2);
        this.renderTable(graphics2, rectangle2);
        graphics2.setClip(rectangle);
        super.paint(graphics2);
        this.renderBorder(graphics2);
        this.drawWindowsNoSelectionFocus(graphics2);
        this.fOffscreen.finishRender(graphics);
        this.fPainting = false;
        table = this;
        synchronized (table) {
            if (this.fNeedsUpdate) {
                bl2 = this.fHOffset != this.fCachedHOffset;
                bl3 = this.fVOffset != this.fCachedVOffset;
                this.fHOffset = this.fCachedHOffset;
                this.fVOffset = this.fCachedVOffset;
                this.fNeedsUpdate = false;
                bl = true;
            }
        }
        if (bl && (bl2 || bl3)) {
            if (bl2 && !bl3) {
                rectangle2.x += this.getRowOptions().getHeaderWidth();
                rectangle2.width -= this.getRowOptions().getHeaderWidth();
            } else if (bl3 && !bl2) {
                rectangle2.y += this.getColumnOptions().getHeaderHeight();
                rectangle2.height -= this.getColumnOptions().getHeaderHeight();
            }
            this.updateDataPort();
            this.repaint(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        }
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.layoutScrollbars();
        if (this.getAutoExpandColumn() != -1) {
            this.expandColumn();
            this.layoutScrollbars();
        }
        this.updateDataPort();
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public void setSize(int n, int n2) {
        Rectangle rectangle = this.getBounds();
        this.setBounds(rectangle.x, rectangle.y, n, n2);
    }

    @Override
    public void setSize(Dimension dimension) {
        Rectangle rectangle = this.getBounds();
        this.setBounds(rectangle.x, rectangle.y, dimension.width, dimension.height);
    }

    public void setIncludeScrollInPrefSize(boolean bl) {
        this.fIncludeScroll = bl;
    }

    public void setPreferredTableSize(int n, int n2) {
        this.fPreferredTableSize.width = n2;
        this.fPreferredTableSize.height = n;
    }

    @Override
    public void requestFocus() {
        boolean bl = false;
        Point point = this.getEditingCell();
        if (point.x != -2 && point.y != -2) {
            Cell cell = this.getCell(point.y, point.x);
            bl = cell.grabFocus(point.y, point.x);
        }
        if (!bl) {
            super.requestFocus();
        }
    }

    public boolean getActiveFocus() {
        boolean bl = false;
        if (MWUtils.isParentFrameActive(this)) {
            if (this.getSelectionOptions().getSelectionVisibility() == 1) {
                bl = true;
            } else {
                Window window = this.getTopLevelWindow();
                if (window != null) {
                    Component component;
                    for (component = window.getFocusOwner(); component != null && component != this; component = component.getParent()) {
                    }
                    bl = component == this;
                }
            }
        }
        return bl;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension();
        int n = this.getColumnOptions().getDefaultWidth();
        int n2 = this.getRowOptions().getDefaultHeight();
        Insets insets = this.getInsets();
        int n3 = this.fVScroll.getPreferredWidth();
        int n4 = this.fHScroll.getPreferredWidth();
        int n5 = this.getRowOptions().getHeaderWidth();
        int n6 = this.getColumnOptions().getHeaderHeight();
        dimension.width = this.fPreferredTableSize.width * n;
        dimension.height = this.fPreferredTableSize.height * n2;
        dimension.width += insets.left + insets.right + n5;
        dimension.height += insets.top + insets.bottom + n6;
        if (this.fIncludeScroll) {
            dimension.width += n3;
            dimension.height += n4;
        }
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutScrollbars() {
        Rectangle rectangle;
        Rectangle rectangle2;
        int n;
        this.adjustScrollbars();
        Rectangle rectangle3 = this.getContentBounds();
        int n2 = rectangle3.x;
        int n3 = rectangle3.y;
        int n4 = n2 + rectangle3.width;
        int n5 = n3 + rectangle3.height;
        if (this.fVScroll != null) {
            n = this.fVScroll.getPreferredWidth();
            rectangle2 = new Rectangle(n4, n3, n, rectangle3.height);
            if (TableUtils.isMac()) {
                if (this.getBorderStyle() == 0) {
                    ++rectangle2.height;
                } else {
                    --rectangle2.y;
                    rectangle2.height += 2;
                }
            }
            if (!this.getVScrollbarOptions().isOverlappingHeader()) {
                int n6 = this.getColumnOptions().getHeaderHeight();
                rectangle2.y += n6;
                rectangle2.height -= n6;
                if (rectangle2.height < 0) {
                    rectangle2.height = 0;
                }
            }
            Table table = this;
            synchronized (table) {
                if (this.fVScrollBoundsAWT == null) {
                    this.fVScrollBoundsAWT = new Rectangle(rectangle2);
                } else {
                    this.fVScrollBoundsAWT.setBounds(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
            }
            if (this.fVScroll.isVisible()) {
                rectangle = this.fVScroll.getBounds();
                if (rectangle.x != rectangle2.x || rectangle.y != rectangle2.y || rectangle.height != rectangle2.height || rectangle.width != rectangle2.width) {
                    this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            }
        }
        if (this.fHScroll != null) {
            n = this.fHScroll.getPreferredWidth();
            rectangle2 = new Rectangle(n2, n5, rectangle3.width, n);
            if (TableUtils.isMac()) {
                if (this.getBorderStyle() == 0) {
                    ++rectangle2.width;
                } else {
                    --rectangle2.x;
                    rectangle2.width += 2;
                }
            }
            if (!this.getHScrollbarOptions().isOverlappingHeader()) {
                int n7 = this.getRowOptions().getHeaderWidth();
                rectangle2.x += n7;
                rectangle2.width -= n7;
                if (rectangle2.width < 0) {
                    rectangle2.width = 0;
                }
            }
            Table table = this;
            synchronized (table) {
                if (this.fHScrollBoundsAWT == null) {
                    this.fHScrollBoundsAWT = new Rectangle(rectangle2);
                } else {
                    this.fHScrollBoundsAWT.setBounds(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
            }
            if (this.fHScroll.isVisible()) {
                rectangle = this.fHScroll.getBounds();
                if (rectangle.x != rectangle2.x || rectangle.y != rectangle2.y || rectangle.height != rectangle2.height || rectangle.width != rectangle2.width) {
                    this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            }
        }
    }

    public String getActionCommand() {
        if (this.fActionCommand == null) {
            return this.getName();
        }
        return this.fActionCommand;
    }

    public void setActionCommand(String string) {
        this.fActionCommand = string;
    }

    public void addActionListener(ActionListener actionListener) {
        this.fActionListener = AWTEventMulticaster.add(this.fActionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.fActionListener = AWTEventMulticaster.remove(this.fActionListener, actionListener);
    }

    protected void fireActionEvent() {
        if (this.fActionListener != null) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, this.getActionCommand());
            this.fActionListener.actionPerformed(actionEvent);
        }
    }

    public void addTableListener(TableListener tableListener) {
        if (tableListener != null) {
            if (this.fTableListener == null) {
                this.fTableListener = new Vector();
            }
            if (!this.fTableListener.contains(tableListener)) {
                this.fTableListener.addElement(tableListener);
            }
        }
    }

    public void removeTableListener(ValueListener valueListener) {
        if (valueListener != null && this.fTableListener != null) {
            if (this.fTableListener.contains(valueListener)) {
                this.fTableListener.removeElement(valueListener);
            }
            if (this.fTableListener.size() == 0) {
                this.fTableListener = null;
            }
        }
    }

    public void fireEditCommitedEvent(int n, int n2, Object object) {
        if (this.fTableListener != null && this.fTableListener.size() > 0) {
            Vector vector = (Vector)this.fTableListener.clone();
            TableEvent tableEvent = new TableEvent(this, 0, n, n2, object);
            for (int i = 0; i < vector.size(); ++i) {
                TableListener tableListener = (TableListener)vector.elementAt(i);
                if (tableListener == null) continue;
                tableListener.editCommitted(tableEvent);
            }
        }
    }

    public void fireEditCancelledEvent(int n, int n2) {
        if (this.fTableListener != null && this.fTableListener.size() > 0) {
            Vector vector = (Vector)this.fTableListener.clone();
            TableEvent tableEvent = new TableEvent(this, 1, n, n2, null);
            for (int i = 0; i < vector.size(); ++i) {
                TableListener tableListener = (TableListener)vector.elementAt(i);
                if (tableListener == null) continue;
                tableListener.editCancelled(tableEvent);
            }
        }
    }

    public void addValueListener(ValueListener valueListener) {
        if (valueListener != null) {
            if (this.fValueListener == null) {
                this.fValueListener = new Vector();
            }
            if (!this.fValueListener.contains(valueListener)) {
                this.fValueListener.addElement(valueListener);
            }
        }
    }

    public void removeValueListener(ValueListener valueListener) {
        if (valueListener != null && this.fValueListener != null) {
            if (this.fValueListener.contains(valueListener)) {
                this.fValueListener.removeElement(valueListener);
            }
            if (this.fValueListener.size() == 0) {
                this.fValueListener = null;
            }
        }
    }

    public void fireValueChangedEvent(int n, int n2) {
        this.fireValueChangedEvent(n, n2, null);
    }

    public void fireValueChangedEvent(int n, int n2, Object object) {
        this.fireEditCommitedEvent(n, n2, object);
        if (this.fValueListener != null && this.fValueListener.size() > 0) {
            Vector vector = (Vector)this.fValueListener.clone();
            ValueEvent valueEvent = new ValueEvent(this, n, n2, object);
            for (int i = 0; i < vector.size(); ++i) {
                ValueListener valueListener = (ValueListener)vector.elementAt(i);
                if (valueListener == null) continue;
                valueListener.valueChanged(valueEvent);
            }
        }
    }

    @Override
    public Object[] getSelectedObjects() {
        int n;
        Object[] objectArray = null;
        Rectangle[] rectangleArray = this.fSelection.getSelection();
        int n2 = 0;
        for (n = 0; n < rectangleArray.length; ++n) {
            n2 += rectangleArray[n].width + rectangleArray[n].height;
        }
        objectArray = new Object[n2];
        int n3 = 0;
        for (n = 0; n < rectangleArray.length; ++n) {
            for (int i = rectangleArray[n].x; i < rectangleArray[n].x + rectangleArray[n].width; ++i) {
                for (int j = rectangleArray[n].y; j < rectangleArray[n].y + rectangleArray[n].height; ++j) {
                    objectArray[n3++] = this.getData().getData(j, i);
                }
            }
        }
        return objectArray;
    }

    @Override
    public void addItemListener(ItemListener itemListener) {
        this.fItemListener = AWTEventMulticaster.add(this.fItemListener, itemListener);
    }

    @Override
    public void removeItemListener(ItemListener itemListener) {
        this.fItemListener = AWTEventMulticaster.remove(this.fItemListener, itemListener);
    }

    @Override
    public void mouseWheelTurned(int n, int n2) {
        if (n2 == 0) {
            int n3 = n < 0 ? 2 : 1;
            int n4 = n > 0 ? n : -n;
            for (int i = 0; i < n4; ++i) {
                this.vScroll(n3);
            }
        }
    }

    protected void vScroll(int n) {
        this.scroll(this.fVScroll, n);
    }

    protected void hScroll(int n) {
        this.scroll(this.fHScroll, n);
    }

    private void scroll(MWScrollbar mWScrollbar, int n) {
        if (mWScrollbar != null && mWScrollbar.isShowing()) {
            int n2;
            int n3 = 0;
            int n4 = n;
            switch (n) {
                case 2: {
                    n3 = -mWScrollbar.getUnitIncrement();
                    break;
                }
                case 1: {
                    n3 = mWScrollbar.getUnitIncrement();
                    break;
                }
                case 3: {
                    n3 = -mWScrollbar.getBlockIncrement();
                    break;
                }
                case 4: {
                    n3 = mWScrollbar.getBlockIncrement();
                    if (n3 <= 0 || this.fRowCount <= 0 || n3 >= (n2 = this.getRowHeight(this.getFirstRow()))) break;
                    n3 = n2;
                    break;
                }
                case -1: {
                    n4 = 5;
                    n3 = -mWScrollbar.getValue();
                    break;
                }
                case -2: {
                    n4 = 5;
                    n3 = mWScrollbar.getMaximum() - mWScrollbar.getValue();
                }
            }
            if (n3 != 0) {
                n2 = mWScrollbar.getValue();
                mWScrollbar.setValue(n2 + n3);
                if (mWScrollbar.getValue() != n2) {
                    AdjustmentEvent adjustmentEvent = new AdjustmentEvent(mWScrollbar, 601, n4, 0);
                    this.fAdjustmentHandler.adjustmentValueChanged(adjustmentEvent);
                }
            }
        }
    }

    public boolean scrollToCell(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        boolean bl = false;
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        int n8 = this.getColumnOptions().getHeaderHeight();
        int n9 = this.getRowOptions().getHeaderWidth();
        int n10 = -1;
        int n11 = -1;
        this.getVisibleCellsInternal(rectangle);
        this.getContentBoundsInternal(rectangle2);
        this.getCellBoundsInternal(n, n2, true, rectangle3);
        rectangle2.x += n9;
        rectangle2.width -= n9;
        rectangle2.y += n8;
        rectangle2.height -= n8;
        if (this.getSelectionOptions().getSelectBy() != 1) {
            if (rectangle3.x < rectangle2.x) {
                n10 = this.columnOffset(n2);
            } else {
                n7 = rectangle3.x + rectangle3.width;
                n6 = rectangle2.x + rectangle2.width;
                n5 = this.getHScrollbarOptions().getMode();
                if (n7 > n6) {
                    n10 = this.columnOffset(n2) + rectangle3.width - rectangle2.width;
                    if (n5 == 0) {
                        n4 = this.columnAtOffset(n10);
                        n3 = this.columnOffset(n4);
                        n10 = n3 < n10 && n4 != n2 ? this.columnOffset(n4 + 1) : n3;
                    }
                }
            }
        }
        if (this.getSelectionOptions().getSelectBy() != 2) {
            if (rectangle3.y < rectangle2.y) {
                n11 = this.rowOffset(n);
            } else {
                n7 = rectangle3.y + rectangle3.height;
                n6 = rectangle2.y + rectangle2.height;
                n5 = this.getVScrollbarOptions().getMode();
                if (n7 > n6) {
                    n11 = this.rowOffset(n) + rectangle3.height - rectangle2.height;
                    if (n5 == 0) {
                        n4 = this.rowAtOffset(n11);
                        n3 = this.rowOffset(n4);
                        n11 = n3 < n11 && n4 != n ? this.rowOffset(n4 + 1) : n3;
                    }
                }
            }
        }
        if (n10 != -1) {
            this.fHScroll.setValue(n10);
            this.setHOffset(n10, true);
            bl = true;
        }
        if (n11 != -1) {
            this.fVScroll.setValue(n11);
            this.setVOffset(n11, true);
            bl = true;
        }
        return bl;
    }

    void showRows(int n, int n2) {
        Rectangle rectangle = this.getVisibleCells();
        if (n >= rectangle.y && n + n2 < rectangle.y + rectangle.height || n == rectangle.y) {
            return;
        }
        int n3 = this.getFirstRow();
        if (n < n3) {
            this.setFirstRow(n);
            return;
        }
        Rectangle rectangle2 = this.getContentBounds();
        int n4 = this.getColumnOptions().getHeaderHeight();
        rectangle2.y += n4;
        rectangle2.height -= n4;
        if (this.fRowHeight.size() == 0) {
            int n5;
            int n6;
            int n7 = rectangle2.height / this.getRowOptions().getDefaultHeight();
            if (n2 > n7) {
                n2 = n7;
            }
            if ((n6 = n + n2) > (n5 = n3 + n7)) {
                this.setFirstRow(n3 + n6 - n5);
            }
        } else {
            int n8 = this.getCellBounds((int)n, (int)0).y;
            int n9 = n8 + rectangle2.height;
            for (int i = n; i < n + n2 && n8 < n9; n8 += this.getRowHeight(i), ++i) {
            }
            while (n8 > rectangle2.y + rectangle2.height && n3 < n) {
                n8 -= this.getRowHeight(n3);
                ++n3;
            }
            this.setFirstRow(n3);
        }
    }

    protected Selection getSelection() {
        return this.fSelection;
    }

    private int getResizeIndex(int n, int n2, int n3) {
        int n4 = -2;
        if (n == 5) {
            Rectangle rectangle = this.getVisibleCells();
            Rectangle rectangle2 = null;
            int n5 = 0;
            rectangle2 = this.getCellBounds(rectangle.y + n5, -1);
            while (n5 < rectangle.height && !rectangle2.contains(n2, n3)) {
                rectangle2 = this.getCellBounds(rectangle.y + ++n5, -1);
            }
            if (rectangle2.contains(n2, n3)) {
                if (n3 - rectangle2.y < 5) {
                    n4 = rectangle.y + n5 - 1;
                } else if (rectangle2.y + rectangle2.height - n3 <= 5) {
                    n4 = rectangle.y + n5;
                }
            }
        } else if (n == 3) {
            int n6;
            Rectangle rectangle = this.getVisibleCells();
            Rectangle rectangle3 = null;
            int n7 = 0;
            rectangle3 = this.getCellBounds(-1, rectangle.x + n7);
            while (n7 < rectangle.width && !rectangle3.contains(n2, n3)) {
                rectangle3 = this.getCellBounds(-1, rectangle.x + ++n7);
            }
            if (rectangle3.contains(n2, n3)) {
                if (n2 - rectangle3.x < 5) {
                    n4 = rectangle.x + n7 - 1;
                } else if (rectangle3.x + rectangle3.width - n2 <= 5) {
                    n4 = rectangle.x + n7;
                }
            }
            if ((n6 = this.getAutoExpandColumn()) != -1 && n6 <= n4) {
                ++n4;
            }
            if (n4 >= this.getData().getWidth()) {
                n4 = -2;
            }
        }
        return n4;
    }

    protected int getResizeIndex(int n, int n2) {
        return this.getResizeIndex(this.findPart(n, n2), n, n2);
    }

    protected int findPart(int n, int n2) {
        int n3 = 0;
        Rectangle rectangle = this.getContentBounds();
        Rectangle rectangle2 = this.getVisibleCells();
        int n4 = this.getRowOptions().getHeaderWidth();
        int n5 = this.getColumnOptions().getHeaderHeight();
        Rectangle rectangle3 = new Rectangle();
        if (rectangle.contains(n, n2)) {
            boolean bl;
            boolean bl2 = n - rectangle.x < n4;
            boolean bl3 = bl = n2 - rectangle.y < n5;
            if (bl2 && bl) {
                n3 = 8;
            } else if (bl2) {
                n3 = 4;
                if (this.getRowOptions().isResizable()) {
                    for (int i = 0; i < rectangle2.height && n3 == 4; ++i) {
                        this.getCellBoundsInternal(rectangle2.y + i, -1, false, rectangle3);
                        if (!rectangle3.contains(n, n2)) continue;
                        if (i == 0 && rectangle3.y + rectangle3.height - n2 <= 5) {
                            n3 = 5;
                            continue;
                        }
                        if (i == 0 || n2 - rectangle3.y >= 5 && rectangle3.y + rectangle3.height - n2 > 5) continue;
                        n3 = 5;
                    }
                }
            } else if (bl) {
                n3 = 2;
                if (this.getColumnOptions().isResizable()) {
                    block1: for (int i = 0; i < rectangle2.width && n3 == 2; ++i) {
                        int n6;
                        this.getCellBoundsInternal(-1, rectangle2.x + i, false, rectangle3);
                        if (!rectangle3.contains(n, n2)) continue;
                        if (i == 0 && rectangle3.x + rectangle3.width - n <= 5) {
                            if (this.fColCount == 1) {
                                n3 = 3;
                                continue;
                            }
                            for (n6 = rectangle2.x + 1; n6 < this.fColCount; ++n6) {
                                if (this.getColumnWidth(n6) == 0 && !this.fResizeZeroWidthColumns) continue;
                                n3 = 3;
                                continue block1;
                            }
                            continue;
                        }
                        if (i == 0 || n - rectangle3.x >= 5 && rectangle3.x + rectangle3.width - n > 5 || (n6 = this.getResizeIndex(3, n, n2)) == -2 || !this.fResizeZeroWidthColumns && this.getColumnWidth(n6) <= 0) continue;
                        n3 = 3;
                    }
                }
            } else {
                n3 = 1;
            }
        }
        return n3;
    }

    protected Point getTrackingCell() {
        return this.fTrackingCell;
    }

    protected void setTrackingCell(int n, int n2) {
        this.fTrackingCell.x = n2;
        this.fTrackingCell.y = n;
    }

    public void commitEditingCell() {
        Cell cell;
        Point point = this.getEditingCell();
        if (point.x != -2 && point.y != -2 && (cell = this.getCell(point.y, point.x)) != null) {
            cell.commitEdit(point.y, point.x);
        }
    }

    public Point getEditingCell() {
        return this.fEditingCell;
    }

    public void setEditingCell(int n, int n2) {
        Cell cell;
        if (!(this.fEditingCell.x == -2 || n2 != -2 && n != -2 || this.getActiveFocus())) {
            this.repaint();
        }
        this.fEditingCell.x = n2;
        this.fEditingCell.y = n;
        if (this.fExcelMode && n2 != -2 && n != -2 && (cell = this.getCell(n, n2)) != null && cell instanceof CellText) {
            this.fDblClickEdit = false;
            MWTextField mWTextField = ((CellText)cell).getField();
            if (mWTextField != null) {
                mWTextField.addKeyListener(this.fExcelHandler);
            }
        }
    }

    Point getActiveCell() {
        return this.fActiveCell;
    }

    void setExcelEdit(KeyEvent keyEvent) {
        if (this.fExcelMode) {
            if (keyEvent == null) {
                this.fDblClickEdit = true;
            } else {
                this.fExcelHandler.keyPressed(keyEvent);
            }
        }
    }

    private Rectangle calcActiveBorder(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle == null) {
            rectangle2 = null;
        } else {
            if (rectangle2 == null) {
                rectangle2 = new Rectangle();
            }
            this.getCellBoundsInternal(rectangle.y, rectangle.x, true, rectangle2);
            if (rectangle.width > 1 || rectangle.height > 1) {
                Rectangle rectangle3 = new Rectangle();
                for (int i = 0; i < rectangle.width; ++i) {
                    for (int j = 0; j < rectangle.height; ++j) {
                        this.getCellBoundsInternal(rectangle.y + j, rectangle.x + i, true, rectangle3);
                        MWUtils.unionRect(rectangle2, rectangle3, rectangle2);
                    }
                }
            }
            rectangle2.translate(this.fHOffset - 1, this.fVOffset - 1);
        }
        return rectangle2;
    }

    public Rectangle getCellBounds(int n, int n2) {
        Rectangle rectangle = new Rectangle();
        this.getCellBoundsInternal(n, n2, true, rectangle);
        return rectangle;
    }

    protected Dimension getPreferredCellSize() {
        if (this.fPreferredCellSize == null || this.fCurFont == null || this.fCurFont != null && !this.fCurFont.equals(this.getFont())) {
            Insets insets = this.getTableStyle().getMargins();
            this.fCurFont = this.getFont();
            if (this.fPreferredCellSize == null) {
                this.fPreferredCellSize = new Dimension(insets.left + insets.right + 1, insets.top + insets.bottom + 1);
            } else {
                this.fPreferredCellSize.width = insets.left + insets.right + 1;
                this.fPreferredCellSize.height = insets.top + insets.bottom + 1;
            }
            if (this.fCurFont != null) {
                FontMetrics fontMetrics = this.getFontMetrics(this.fCurFont);
                this.fPreferredCellSize.width += 8 * fontMetrics.charWidth('M');
                this.fPreferredCellSize.height += fontMetrics.getHeight();
            }
        }
        return this.fPreferredCellSize;
    }

    protected Rectangle getContentBounds() {
        Rectangle rectangle = new Rectangle();
        this.getContentBoundsInternal(rectangle);
        return rectangle;
    }

    private void getContentBoundsInternal(Rectangle rectangle) {
        if (rectangle != null) {
            Dimension dimension = this.getSize();
            rectangle.x = 0;
            rectangle.y = 0;
            rectangle.width = dimension.width;
            rectangle.height = dimension.height;
            Insets insets = this.getInsets();
            int n = 0;
            rectangle.x += insets.left;
            rectangle.width -= insets.left + insets.right;
            rectangle.y += insets.top;
            rectangle.height -= insets.top + insets.bottom;
            if (TableUtils.isMac() && this.getBorderStyle() != 0) {
                n = 1;
            }
            if (this.fHScroll != null && this.fHScrollVisAWT) {
                rectangle.height -= this.fHScroll.getPreferredWidth() - n;
            }
            if (this.fVScroll != null && this.fVScrollVisAWT) {
                rectangle.width -= this.fVScroll.getPreferredWidth() - n;
            }
        }
    }

    private int maxHOffset() {
        int n = 0;
        int n2 = this.getData().getWidth();
        int n3 = this.getHScrollbarOptions().getMode();
        if (n2 > 0) {
            int n4;
            int n5;
            int n6 = this.columnOffset(n2 - 1);
            int n7 = n6 + (n5 = this.getColumnWidthInternal(n2 - 1));
            n = n7 - (n4 = this.getContentBounds().width - this.getRowOptions().getHeaderWidth());
            if (n < 0) {
                n = 0;
            } else if (n3 == 0) {
                int n8 = this.columnAtOffset(n);
                int n9 = this.columnOffset(n8);
                if (n8 == n2 - 1) {
                    n = n9;
                } else if (n9 != n) {
                    n = this.columnOffset(n8 + 1);
                }
            }
        }
        return n;
    }

    private int maxVOffset() {
        int n = 0;
        int n2 = this.getData().getHeight();
        int n3 = this.getVScrollbarOptions().getMode();
        if (n2 > 0) {
            int n4;
            int n5;
            int n6 = this.rowOffset(n2 - 1);
            int n7 = n6 + (n5 = this.getRowHeight(n2 - 1));
            n = n7 - (n4 = this.getContentBounds().height - this.getColumnOptions().getHeaderHeight());
            if (n < 0) {
                n = 0;
            } else if (n3 == 0) {
                int n8 = this.rowAtOffset(n);
                int n9 = this.rowOffset(n8);
                if (n8 == n2 - 1) {
                    n = n9;
                } else if (n9 != n) {
                    n = this.rowOffset(n8 + 1);
                }
            }
        }
        return n;
    }

    private int columnOffset(int n) {
        int n2 = 0;
        if (this.fColWidth.size() == 0) {
            if (n > 0) {
                n2 = n * this.getColumnOptions().getDefaultWidth();
            }
            if (this.getTreeData() != null) {
                int n3 = (this.getTreeData().getMaxDepth() + 1) * TableUtils.getTreeIndent();
                n2 += n3;
            }
        } else if (n > 0) {
            for (int i = 0; i < n; ++i) {
                n2 += this.getColumnWidthInternal(i);
            }
        }
        return n2;
    }

    private int rowOffset(int n) {
        int n2 = 0;
        if (this.fRowHeight.size() == 0) {
            if (n > 0) {
                n2 = n * this.getRowOptions().getDefaultHeight();
            }
        } else if (n > 0) {
            for (int i = 0; i < n; ++i) {
                n2 += this.getRowHeight(i);
            }
        }
        return n2;
    }

    private int columnAtOffset(int n) {
        int n2 = -2;
        int n3 = this.getData().getWidth();
        if (n >= 0) {
            int n4 = 0;
            int n5 = this.getColumnWidthInternal(0);
            n2 = 0;
            while (n2 < n3 && n >= n4 + n5) {
                n4 += n5;
                if (++n2 >= n3) continue;
                n5 = this.getColumnWidthInternal(n2);
            }
            if (n2 == n3) {
                n2 = -2;
            }
        }
        return n2;
    }

    private int columnAt(int n) {
        Rectangle rectangle = this.getContentBounds();
        int n2 = this.getRowOptions().getHeaderWidth();
        return this.columnAtOffset(n -= rectangle.x + n2 - this.fHOffset);
    }

    private int rowAtOffset(int n) {
        int n2 = -2;
        int n3 = this.getData().getHeight();
        if (this.fRowHeight.size() == 0) {
            if (n3 > 0 && (n2 = n / this.getRowOptions().getDefaultHeight()) >= n3) {
                n2 = -2;
            }
        } else if (n >= 0) {
            int n4 = 0;
            int n5 = this.getRowHeight(0);
            n2 = 0;
            while (n2 < n3 && n >= n4 + n5) {
                n4 += n5;
                if (++n2 >= n3) continue;
                n5 = this.getRowHeight(n2);
            }
            if (n2 == n3) {
                n2 = -2;
            }
        }
        return n2;
    }

    private int rowAt(int n) {
        Rectangle rectangle = this.getContentBounds();
        int n2 = this.getColumnOptions().getHeaderHeight();
        return this.rowAtOffset(n -= rectangle.y + n2 - this.fVOffset);
    }

    protected void expandColumn() {
        int n = this.getAutoExpandColumn();
        if (n != -1) {
            int n2 = this.getData().getWidth();
            int n3 = this.getContentBounds().width - this.getRowOptions().getHeaderWidth();
            for (int i = 0; i < n2; ++i) {
                if (i == n) continue;
                n3 -= this.getColumnWidthInternal(i);
            }
            if (this.getTreeData() != null && n == 0) {
                n3 -= (this.getTreeData().getMaxDepth() + 1) * TableUtils.getTreeIndent();
            }
            if (this.fMinAutoColWidth == -1 && n3 < this.fBiggestCellWidth) {
                n3 = this.fBiggestCellWidth;
            } else if (n3 < this.fMinAutoColWidth) {
                n3 = this.fMinAutoColWidth;
            }
            this.setColumnWidth(n, n3, false);
        }
    }

    private void adjustScrollbars() {
        this.determineScrollbarVisibility();
        Rectangle rectangle = this.getContentBounds();
        int n = this.getRowOptions().getHeaderWidth();
        int n2 = this.getColumnOptions().getHeaderHeight();
        int n3 = this.fHScroll.getValue();
        this.fHScroll.setMaximum(this.maxHOffset());
        this.fHScroll.setVisibleAmount(rectangle.width - n);
        this.fHScroll.setBlockIncrement(rectangle.width - n);
        this.fHScroll.setUnitIncrement(10);
        if (this.fHScroll.getValue() != n3) {
            this.setHOffset(this.fHScroll.getValue(), false);
        }
        if (this.fHScroll.getMaximum() == this.fHScroll.getMinimum() && this.getHScrollbarOptions().getVisibility() != 2) {
            this.fHScrollVisAWT = false;
            if (this.fHScroll.isVisible() != this.fHScrollVisAWT) {
                this.fHScroll.repaint();
            }
        }
        n3 = this.fVScroll.getValue();
        this.fVScroll.setMaximum(this.maxVOffset());
        this.fVScroll.setVisibleAmount(rectangle.height - n2);
        this.fVScroll.setBlockIncrement(rectangle.height - n2);
        this.fVScroll.setUnitIncrement(10);
        if (this.fVScroll.getValue() != n3) {
            this.setVOffset(this.fVScroll.getValue(), false);
        }
        if (this.fVScroll.getMaximum() == this.fVScroll.getMinimum() && this.getVScrollbarOptions().getVisibility() != 2) {
            this.fVScrollVisAWT = false;
            if (this.fVScroll.isVisible() != this.fVScrollVisAWT) {
                this.fVScroll.repaint();
            }
        }
    }

    private void determineScrollbarVisibility() {
        int n = 2;
        int n2 = 2;
        Insets insets = this.getInsets();
        int n3 = this.getData().getWidth();
        int n4 = this.getData().getHeight();
        int n5 = this.getTreeData() != null ? (this.getTreeData().getMaxDepth() + 1) * TableUtils.getTreeIndent() : 0;
        int n6 = n3 > 0 ? this.columnOffset(n3 - 1) + this.getColumnWidth(n3 - 1) : 0;
        int n7 = n4 > 0 ? this.rowOffset(n4 - 1) + this.getRowHeight(n4 - 1) : 0;
        int n8 = this.fVScroll.getPreferredWidth();
        int n9 = this.fHScroll.getPreferredWidth();
        int n10 = this.getRowOptions().getHeaderWidth();
        int n11 = this.getColumnOptions().getHeaderHeight();
        Dimension dimension = this.getSize();
        int n12 = dimension.width - insets.left - insets.right - n10;
        int n13 = dimension.height - insets.top - insets.bottom - n11;
        n6 += n5;
        switch (this.getVScrollbarOptions().getVisibility()) {
            case 1: {
                n2 = 0;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 0: {
                n2 = n7 > n13 ? 2 : (n7 > n13 - n9 ? 1 : 0);
            }
        }
        switch (this.getHScrollbarOptions().getVisibility()) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 0: {
                if (this.getAutoExpandColumn() != -1) {
                    n10 = this.getColumnWidth(this.getAutoExpandColumn());
                    if (this.fMinAutoColWidth != -1) {
                        n10 -= this.fMinAutoColWidth;
                    }
                    if (n2 == 2) {
                        n10 -= n8;
                    }
                    if (this.getAutoExpandColumn() == 0) {
                        n10 += n5;
                    }
                } else {
                    n10 = 0;
                }
                if (n6 > n12) {
                    if (n6 - n10 > n12) {
                        n = 2;
                        break;
                    }
                    n = 0;
                    break;
                }
                if (n6 > n12 - n8) {
                    if (n2 == 2 && this.getAutoExpandColumn() != -1) {
                        n10 += n8;
                    }
                    if (n6 - n10 > n12 - n8) {
                        n = 1;
                        break;
                    }
                    n = 0;
                    break;
                }
                n = 0;
            }
        }
        if (n == 1 && n2 == 1) {
            this.fHScrollVisAWT = false;
            this.fVScrollVisAWT = false;
            if (this.fHScroll.isVisible()) {
                this.fHScroll.repaint();
            }
            if (this.fVScroll.isVisible()) {
                this.fVScroll.repaint();
            }
        } else if (n == 1) {
            this.fVScrollVisAWT = n2 == 2;
            boolean bl = this.fHScrollVisAWT = n2 == 2;
            if (this.fVScroll.isVisible() != this.fVScrollVisAWT) {
                this.fVScroll.repaint();
            }
            if (this.fHScroll.isVisible() != this.fHScrollVisAWT) {
                this.fHScroll.repaint();
            }
        } else if (n2 == 1) {
            this.fHScrollVisAWT = n == 2;
            boolean bl = this.fVScrollVisAWT = n == 2;
            if (this.fVScroll.isVisible() != this.fVScrollVisAWT) {
                this.fVScroll.repaint();
            }
            if (this.fHScroll.isVisible() != this.fHScrollVisAWT) {
                this.fHScroll.repaint();
            }
        } else {
            this.fHScrollVisAWT = n == 2;
            boolean bl = this.fVScrollVisAWT = n2 == 2;
            if (this.fVScroll.isVisible() != this.fVScrollVisAWT) {
                this.fVScroll.repaint();
            }
            if (this.fHScroll.isVisible() != this.fHScrollVisAWT) {
                this.fHScroll.repaint();
            }
        }
    }

    private int getColumnWidthInternal(int n) {
        int n2 = this.getColumnWidth(n);
        if (this.getTreeData() != null && n == 0) {
            n2 += (this.getTreeData().getMaxDepth() + 1) * TableUtils.getTreeIndent();
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getCellBoundsInternal(int n, int n2, boolean bl, Rectangle rectangle) {
        if (rectangle != null) {
            int n3;
            int n4;
            Enumeration enumeration;
            int n5;
            Rectangle rectangle2 = this.getContentBounds();
            int n6 = this.getRowOptions().getHeaderWidth();
            int n7 = this.getColumnOptions().getHeaderHeight();
            if (n2 == -1) {
                rectangle.x = rectangle2.x;
                rectangle.width = n6;
            } else {
                n5 = this.getColumnOptions().getDefaultWidth();
                rectangle.width = this.getColumnWidthInternal(n2);
                rectangle.x = rectangle2.x + n6 - this.fHOffset;
                if (n2 != -3) {
                    rectangle.x += n2 * n5;
                }
                if (n2 > 0) {
                    int n8;
                    if (this.getTreeData() != null && (n8 = this.getColumnWidthInternal(0)) != n5) {
                        rectangle.x += n8 - n5;
                    }
                    IntHashtable intHashtable = this.fColWidth;
                    synchronized (intHashtable) {
                        enumeration = this.fColWidth.keys();
                        while (enumeration.hasMoreElements()) {
                            n4 = ((MutableInt)enumeration.nextElement()).getValue();
                            if (n4 >= n2 || n4 == 0 && this.getTreeData() != null) continue;
                            n3 = (Integer)this.fColWidth.get(n4);
                            rectangle.x += n3 - n5;
                        }
                    }
                }
                if (this.getTreeData() != null && n > -1) {
                    int n9 = this.getTreeData().getItemId(n);
                    int n10 = this.getTreeData().getDepth(n9);
                    n4 = (n10 + 1) * TableUtils.getTreeIndent();
                    if (bl && n2 == 0) {
                        rectangle.x += n4;
                        rectangle.width -= n4;
                    } else if (n2 == -3) {
                        rectangle.width = n4;
                    }
                }
            }
            if (n == -1) {
                rectangle.y = rectangle2.y;
                rectangle.height = n7;
            } else {
                n5 = this.getRowOptions().getDefaultHeight();
                rectangle.height = this.getRowHeight(n);
                rectangle.y = rectangle2.y + n7 - this.fVOffset + n * n5;
                if (n > 0) {
                    IntHashtable intHashtable = this.fRowHeight;
                    synchronized (intHashtable) {
                        enumeration = this.fRowHeight.keys();
                        while (enumeration.hasMoreElements()) {
                            n4 = ((MutableInt)enumeration.nextElement()).getValue();
                            if (n4 >= n) continue;
                            n3 = (Integer)this.fRowHeight.get(n4);
                            rectangle.y += n3 - n5;
                        }
                    }
                }
            }
        }
    }

    private void updateDataPort() {
        if (this.isShowing()) {
            Rectangle rectangle = this.getVisibleCells();
            this.fData.setPort(this, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHOffset(int n, boolean bl) {
        if (!bl) {
            this.fHOffset = n;
            this.updateDataPort();
        } else {
            Rectangle rectangle = this.getContentBounds();
            rectangle.x += this.getRowOptions().getHeaderWidth();
            rectangle.width -= this.getRowOptions().getHeaderWidth();
            if (!this.fPainting) {
                this.fHOffset = n;
                this.updateDataPort();
                this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            } else {
                Table table = this;
                synchronized (table) {
                    this.fCachedHOffset = n;
                    this.fCachedVOffset = this.fVOffset;
                    this.fNeedsUpdate = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setVOffset(int n, boolean bl) {
        if (!bl) {
            this.fVOffset = n;
            this.updateDataPort();
        } else {
            Rectangle rectangle = this.getContentBounds();
            rectangle.y += this.getColumnOptions().getHeaderHeight();
            rectangle.height -= this.getColumnOptions().getHeaderHeight();
            if (!this.fPainting) {
                this.fVOffset = n;
                this.updateDataPort();
                this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            } else {
                Table table = this;
                synchronized (table) {
                    this.fCachedHOffset = this.fHOffset;
                    this.fCachedVOffset = n;
                    this.fNeedsUpdate = true;
                }
            }
        }
    }

    private void renderBorder(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        Dimension dimension = this.getSize();
        int n5 = dimension.width;
        int n6 = dimension.height;
        int n7 = 0;
        if (this.getBorderStyle() == 1) {
            n7 = 1;
        } else if (this.getBorderStyle() == 2) {
            n7 = 2;
        }
        if (this.fHScroll.isVisible() && !this.getHScrollbarOptions().isOverlappingHeader()) {
            n4 = n7;
            n3 = this.fHScroll.getBounds().y;
            n2 = this.fHScroll.getBounds().x - n4;
            n = this.fHScroll.getBounds().height;
            if (TableUtils.isMac()) {
                ++n3;
                ++n2;
                --n;
            }
            if (n2 > 0) {
                TableDecorations.renderHeaderBackground(graphics, new Rectangle(n4, n3, n2, n), 2);
            }
        }
        if (this.fVScroll.isVisible() && !this.getVScrollbarOptions().isOverlappingHeader()) {
            n4 = this.fVScroll.getBounds().x;
            n3 = n7;
            n2 = this.fVScroll.getBounds().width;
            n = this.fVScroll.getBounds().y - n3;
            if (TableUtils.isMac()) {
                ++n4;
                ++n;
                --n2;
            }
            if (n > 0) {
                TableDecorations.renderHeaderBackground(graphics, new Rectangle(n4, n3, n2, n), 2);
            }
        }
        if (this.getBorderStyle() == 1) {
            graphics.setColor(Color.black);
            graphics.drawRect(0, 0, n5 - 1, n6 - 1);
        } else if (this.getBorderStyle() == 2) {
            Decorations.drawBevelFrame(graphics, 0, 0, n5, n6);
        }
        if (this.fHScroll.isVisible() && this.fVScroll.isVisible()) {
            n4 = this.fHScroll.getBounds().x + this.fHScroll.getBounds().width;
            n3 = this.fVScroll.getBounds().y + this.fVScroll.getBounds().height;
            n2 = n5 - n4 - n7;
            n = n6 - n3 - n7;
            graphics.setColor(Decorations.getColor(6));
            graphics.fillRect(n4, n3, n2, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderTable(Graphics graphics, Rectangle rectangle) {
        TableData tableData = this.fData;
        synchronized (tableData) {
            int n;
            int n2;
            int n3;
            Style style;
            int n4;
            Rectangle rectangle2 = this.getVisibleCells();
            Rectangle rectangle3 = new Rectangle();
            Rectangle rectangle4 = graphics.getClipBounds();
            int n5 = this.getInsets().left + this.getRowOptions().getHeaderWidth();
            int n6 = this.getInsets().top + this.getColumnOptions().getHeaderHeight();
            boolean bl = this.getActiveFocus();
            if ((rectangle2.width > 0 || rectangle2.height > 0) && this.getRowOptions().isHeaderVisible() && this.getColumnOptions().isHeaderVisible()) {
                this.getCellBoundsInternal(-1, -1, false, rectangle3);
                TableDecorations.renderHeaderBackground(graphics, rectangle3, 2);
            }
            if (this.fExcelMode) {
                Rectangle[] rectangleArray;
                if (this.fSelection.isTracking()) {
                    rectangleArray = this.fSelection.getAnchor();
                    if (!rectangleArray.equals(this.fActiveCell)) {
                        this.fActiveCell.x = rectangleArray.x;
                        this.fActiveCell.y = rectangleArray.y;
                    }
                    this.fActiveBorder = this.calcActiveBorder(this.fSelection.getHiliteRect(), this.fActiveBorder);
                } else if (this.fActiveBorder == null && this.fActiveCell.x != -2 && this.fActiveCell.y != -2) {
                    rectangleArray = this.fSelection.getSelection();
                    for (n4 = 0; n4 < rectangleArray.length; ++n4) {
                        if (!rectangleArray[n4].contains(this.fActiveCell.x, this.fActiveCell.y)) continue;
                        this.fActiveBorder = this.calcActiveBorder(rectangleArray[n4], this.fActiveBorder);
                        break;
                    }
                }
            }
            graphics.setFont(this.getFont());
            for (n4 = rectangle2.x; n4 < rectangle2.x + rectangle2.width; ++n4) {
                int n7;
                int n8;
                Cell cell;
                Object object;
                if (this.getColumnOptions().isHeaderVisible()) {
                    object = this.getColumnHeaderData(n4);
                    cell = this.getCell(object);
                    style = this.getCellStyle(-1, n4);
                    this.getCellBoundsInternal(-1, n4, false, rectangle3);
                    n8 = rectangle3.x < n5 ? n5 : rectangle3.x;
                    n7 = rectangle3.width - (n8 - rectangle3.x);
                    graphics.setClip(rectangle4);
                    graphics.clipRect(n8, rectangle3.y, n7, rectangle3.height);
                    TableDecorations.renderHeaderBackground(graphics, rectangle3, 0);
                    if (cell != null) {
                        cell.render(graphics, -1, n4, rectangle3, object, style, false);
                    }
                    graphics.setClip(rectangle4);
                }
                for (int i = rectangle2.y; i < rectangle2.y + rectangle2.height; ++i) {
                    int n9;
                    int n10;
                    if (n4 == rectangle2.x && this.getRowOptions().isHeaderVisible()) {
                        object = this.getRowHeaderData(i);
                        cell = this.getCell(object);
                        style = this.getCellStyle(i, -1);
                        this.getCellBoundsInternal(i, -1, false, rectangle3);
                        n10 = rectangle3.y < n6 ? n6 : rectangle3.y;
                        n9 = rectangle3.height - (n10 - rectangle3.y);
                        graphics.setClip(rectangle4);
                        graphics.clipRect(rectangle3.x, n10, rectangle3.width, n9);
                        TableDecorations.renderHeaderBackground(graphics, rectangle3, 1);
                        if (cell != null) {
                            cell.render(graphics, i, -1, rectangle3, object, style, false);
                        }
                        graphics.setClip(rectangle4);
                    }
                    if ((object = this.fData.getDataAsText(i, n4)) == null) {
                        object = this.fData.getData(i, n4);
                    }
                    cell = this.getCell(object);
                    style = this.getCellStyle(i, n4);
                    this.getCellBoundsInternal(i, n4, false, rectangle3);
                    n8 = rectangle3.x < n5 ? n5 : rectangle3.x;
                    n7 = rectangle3.width - (n8 - rectangle3.x);
                    n10 = rectangle3.y < n6 ? n6 : rectangle3.y;
                    n9 = rectangle3.height - (n10 - rectangle3.y);
                    n3 = style.isVGridVisible() ? 1 : 0;
                    n2 = style.isHGridVisible() ? 1 : 0;
                    n = this.fSelection.isHilited(i, n4) && (bl || this.getSelectionOptions().getSelectionVisibility() != 0 && !this.fExcelMode) ? 1 : 0;
                    boolean bl2 = n != 0 && this.fSelection.isAnchor(i, n4) && this.isAnchorVisible() && !style.getCustomHilite();
                    graphics.setClip(rectangle4);
                    graphics.clipRect(n8, n10, n7, n9);
                    if (this.fExcelMode && this.fActiveCell.x == n4 && this.fActiveCell.y == i) {
                        n = 0;
                        TableDecorations.renderCellBackground(graphics, rectangle3, style, n != 0, bl2, bl, this.getBackground());
                    } else {
                        TableDecorations.renderCellBackground(graphics, rectangle3, style, n != 0, bl2, bl, this.fExcelMode, this.getBackground());
                    }
                    if (cell != null) {
                        this.getCellBoundsInternal(i, n4, true, rectangle3);
                        graphics.clipRect(n8, n10, n7 - n3, n9 - n2);
                        cell.render(graphics, i, n4, rectangle3, object, style, n != 0 && !this.fExcelMode);
                    }
                    if (this.getTreeData() != null && n4 == 0) {
                        Object object2 = this.getCellData(i, -3);
                        Cell cell2 = this.getCell(object2);
                        this.getCellBoundsInternal(i, -3, false, rectangle3);
                        if (cell2 != null) {
                            graphics.setClip(rectangle4);
                            graphics.clipRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                            cell2.render(graphics, i, -3, rectangle3, object2, style, n != 0);
                            graphics.setClip(rectangle4);
                        }
                        this.getCellBoundsInternal(i, n4, false, rectangle3);
                    }
                    graphics.setClip(rectangle4);
                }
            }
            graphics.setColor(this.getTableBackground());
            if (rectangle3.x + rectangle3.width < rectangle.x + rectangle.width) {
                int n11 = rectangle3.x + rectangle3.width;
                n3 = rectangle.x + rectangle.width - n11;
                graphics.fillRect(n11, rectangle.y, n3, rectangle.height);
            }
            if (rectangle3.y + rectangle3.height < rectangle.y + rectangle.height) {
                int n12 = rectangle3.y + rectangle3.height;
                n3 = rectangle.y + rectangle.height - n12;
                graphics.fillRect(rectangle.x, n12, rectangle.width, n3);
            }
            if (bl) {
                this.getContentBoundsInternal(rectangle3);
                n2 = n5 > 1 ? n5 - 2 : 0;
                n = n6 > 1 ? n6 - 2 : 0;
                rectangle3.x += n2;
                rectangle3.width -= n2;
                rectangle3.y += n;
                rectangle3.height -= n;
                graphics.clipRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                graphics.setColor(Color.black);
                if (this.fActiveBorder != null) {
                    int n13 = this.fActiveBorder.x - this.fHOffset;
                    n3 = this.fActiveBorder.y - this.fVOffset;
                    n2 = this.fActiveBorder.width;
                    n = this.fActiveBorder.height;
                    graphics.drawRect(n13 - 1, n3 - 1, n2 + 2, n + 2);
                    graphics.drawRect(n13, n3, n2, n);
                    graphics.drawRect(n13 + 1, n3 + 1, n2 - 2, n - 2);
                } else if (this.fEditingCell.x != -2) {
                    Rectangle rectangle5 = this.getCellBounds(this.fEditingCell.y, this.fEditingCell.x);
                    style = this.getCellStyle(this.fEditingCell.y, this.fEditingCell.x);
                    --rectangle5.x;
                    --rectangle5.y;
                    rectangle5.width = rectangle5.width + (style.isVGridVisible() ? 0 : 1);
                    rectangle5.height = rectangle5.height + (style.isHGridVisible() ? 0 : 1);
                    graphics.drawRect(rectangle5.x, rectangle5.y, rectangle5.width, rectangle5.height);
                    graphics.drawRect(rectangle5.x - 1, rectangle5.y - 1, rectangle5.width + 2, rectangle5.height + 2);
                }
                graphics.setClip(rectangle4);
            }
        }
    }

    private Rectangle getVisibleCells() {
        Rectangle rectangle = new Rectangle();
        this.getVisibleCellsInternal(rectangle);
        return rectangle;
    }

    private void getVisibleCellsInternal(Rectangle rectangle) {
        if (rectangle != null) {
            Rectangle rectangle2 = this.getContentBounds();
            int n = this.getRowOptions().getHeaderWidth();
            int n2 = this.getColumnOptions().getHeaderHeight();
            int n3 = this.columnAt(rectangle2.x + n);
            int n4 = this.columnAt(rectangle2.x + rectangle2.width - 1);
            int n5 = this.rowAt(rectangle2.y + n2);
            int n6 = this.rowAt(rectangle2.y + rectangle2.height - 1);
            int n7 = this.getData().getWidth();
            int n8 = this.getData().getHeight();
            if (n3 == -2) {
                n3 = 0;
            }
            if (n4 == -2) {
                int n9 = n4 = n7 > 0 ? n7 - 1 : 0;
            }
            if (n5 == -2) {
                n5 = 0;
            }
            if (n6 == -2) {
                n6 = n8 > 0 ? n8 - 1 : 0;
            }
            rectangle.x = n3;
            rectangle.y = n5;
            rectangle.width = n7 > 0 ? n4 - n3 + 1 : 0;
            rectangle.height = n8 > 0 ? n6 - n5 + 1 : 0;
        }
    }

    protected boolean isCellVisible(int n, int n2) {
        boolean bl = false;
        Rectangle rectangle = this.getContentBounds();
        int n3 = this.getColumnOptions().getHeaderHeight();
        int n4 = this.rowAt(rectangle.y + n3);
        int n5 = this.rowAt(rectangle.y + rectangle.height - 1);
        int n6 = this.getData().getHeight();
        if (n5 == -2 && n6 > 0) {
            n5 = n6 - 1;
        }
        if (n >= n4 && n <= n5) {
            int n7 = this.getRowOptions().getHeaderWidth();
            int n8 = this.columnAt(rectangle.x + n7);
            int n9 = this.columnAt(rectangle.x + rectangle.width - 1);
            int n10 = this.getData().getWidth();
            if (n9 == -2 && n10 > 0) {
                n9 = n10 - 1;
            }
            if (n2 >= n8 && n2 <= n9) {
                bl = true;
            }
        }
        return bl;
    }

    protected boolean isRowVisible(int n) {
        Rectangle rectangle = this.getContentBounds();
        int n2 = this.getColumnOptions().getHeaderHeight();
        int n3 = this.rowAt(rectangle.y + n2);
        return n3 != -2 && n3 == n;
    }

    private void initTable(TableData tableData, TreeData treeData) {
        this.setLayout(null);
        this.fOffscreen = new Offscreen((Component)this);
        this.fItemListener = null;
        this.fActionListener = null;
        this.fActionCommand = null;
        this.fValueListener = null;
        this.fTableListener = null;
        this.fTreeCellData = null;
        this.fAnchorVisible = false;
        this.fCursorType = 1;
        this.fCurFont = null;
        this.fPreferredCellSize = null;
        this.fPreferredTableSize = new Dimension(8, 15);
        this.fIncludeScroll = true;
        this.fStyle = new Style();
        this.fBorderStyle = 2;
        this.fHScrollOptions = new ScrollbarOptions(this);
        this.fVScrollOptions = new ScrollbarOptions(this);
        this.fTreeData = treeData;
        this.fData = tableData;
        this.fData.addDataListener(new TableDataHandler());
        this.fCells = new Hashtable(37);
        this.registerCellType(String.class, new CellText(this));
        this.registerCellType(Boolean.class, new CellBoolean(this));
        this.registerCellType(Character.class, new CellCharacter(this));
        this.registerCellType(MWImageResource.class, new CellImageResource(this));
        this.registerCellType(LabeledImageResource.class, new CellImageResource(this));
        this.registerCellType(TreeCellData.class, new CellTreeCellData(this));
        this.registerCellType(File.class, new CellFile(this));
        this.registerCellType(MWCheckbox.class, new CellMWCheckbox(this));
        this.registerCellType(MixedState.class, new CellMWCheckbox(this));
        this.registerCellType(Color.class, new CellColor(this));
        this.registerCellType(EnumWithState.class, new CellEnumData(this));
        this.fColStyles = new IntHashtable(37);
        this.fRowStyles = new IntHashtable(37);
        this.fCellStyles = new IntHashtable(37);
        this.fStylePriority = new Vector();
        Style style = new Style(256);
        style.setHAlignment(1);
        this.setRowStyle(-1, style);
        style = new Style(256);
        style.setHAlignment(2);
        this.setColumnStyle(-1, style);
        this.fColHeaderData = new IntHashtable(37);
        this.fRowHeaderData = new IntHashtable(37);
        this.fColOptions = new OptionsColumn(this);
        this.fRowOptions = new OptionsRow(this);
        this.fColCount = this.fData.getWidth();
        this.fRowCount = this.fData.getHeight();
        this.fColWidth = new IntHashtable(37);
        this.fRowHeight = new IntHashtable(37);
        this.fHScroll = new MWScrollbar(1);
        this.fVScroll = new MWScrollbar(0);
        this.fHScroll.setCursor(Cursor.getDefaultCursor());
        this.fVScroll.setCursor(Cursor.getDefaultCursor());
        this.fAdjustmentHandler = new AdjustmentHandler();
        this.add(this.fHScroll);
        this.fHScroll.addAdjustmentListener(this.fAdjustmentHandler);
        this.add(this.fVScroll);
        this.fVScroll.addAdjustmentListener(this.fAdjustmentHandler);
        this.setFirstColumn(0);
        this.setFirstRow(0);
        this.adjustScrollbars();
        this.fSelection = new Selection(this);
        this.fSelection.addSelectionListener(new SelectionHandler());
        this.fNeedsUpdate = false;
        this.fPainting = false;
        this.fAutoExpandCol = -1;
        this.fMinAutoColWidth = -1;
        this.fBiggestCellWidth = -1;
        this.fWindowsFocusIndex = -1;
        this.fWindowsFocusCol = -1;
        this.addKeyListener(new KeyTracker());
        TrackDispatcher trackDispatcher = new TrackDispatcher(this);
        trackDispatcher.addTracker(new TrackerFocus());
        trackDispatcher.addTracker(new TrackerCell());
        trackDispatcher.addTracker(new TrackerResize());
        trackDispatcher.addTracker(new TrackerSelection(this.fSelection));
        trackDispatcher.addTracker(new TrackerCursor());
        trackDispatcher.addTracker(new TrackerAction());
        this.fTrackingCell = new Point(-2, -2);
        this.fEditingCell = new Point(-2, -2);
        this.fActiveCell = new Point(-2, -2);
        this.fResizeZeroWidthColumns = true;
        this.fShowRootlines = true;
        this.addFocusListener(new FocusHandler());
        this.fTableBackground = Decorations.getColor(6);
        this.updateDataPort();
    }

    private class CellSelectionEnumerator
    implements Enumeration {
        Rectangle[] fSelRects;
        int fRect;
        int fCol;
        int fRow;

        CellSelectionEnumerator() {
            Rectangle[] rectangleArray = Table.this.fSelection.getSelection();
            this.fSelRects = new Rectangle[rectangleArray.length];
            System.arraycopy(rectangleArray, 0, this.fSelRects, 0, rectangleArray.length);
            this.fRect = 0;
            if (this.fRect < this.fSelRects.length) {
                this.fCol = this.fSelRects[this.fRect].x;
                this.fRow = this.fSelRects[this.fRect].y;
            }
        }

        @Override
        public boolean hasMoreElements() {
            return this.fRect < this.fSelRects.length;
        }

        public Object nextElement() {
            Object object = null;
            if (this.fRect < this.fSelRects.length) {
                Rectangle rectangle = this.fSelRects[this.fRect];
                int n = rectangle.x + rectangle.width;
                int n2 = rectangle.y + rectangle.height;
                if (this.fCol < n && this.fRow < n2) {
                    object = Table.this.getData().getData(this.fRow, this.fCol++);
                    if (this.fCol == n) {
                        this.fCol = this.fSelRects[this.fRect].x;
                        ++this.fRow;
                    }
                    if (this.fRow == n2) {
                        ++this.fRect;
                        if (this.fRect < this.fSelRects.length) {
                            this.fCol = this.fSelRects[this.fRect].x;
                            this.fRow = this.fSelRects[this.fRect].y;
                        }
                    }
                }
            }
            return object;
        }
    }

    private class ExcelHandler
    extends KeyAdapter {
        private ExcelHandler() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.isConsumed()) {
                return;
            }
            boolean bl = false;
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 38: {
                    bl = TableUtils.arrowKeyNav(Table.this, 38, keyEvent.getModifiers(), Table.this.fDblClickEdit);
                    break;
                }
                case 40: {
                    bl = TableUtils.arrowKeyNav(Table.this, 40, keyEvent.getModifiers(), Table.this.fDblClickEdit);
                    break;
                }
                case 37: {
                    bl = TableUtils.arrowKeyNav(Table.this, 37, keyEvent.getModifiers(), Table.this.fDblClickEdit);
                    break;
                }
                case 39: {
                    bl = TableUtils.arrowKeyNav(Table.this, 39, keyEvent.getModifiers(), Table.this.fDblClickEdit);
                    break;
                }
                case 35: {
                    Table.this.commitEditingCell();
                    bl = true;
                    break;
                }
                case 36: {
                    Table.this.commitEditingCell();
                    int n2 = ((Table)Table.this).fActiveCell.y == -2 ? 0 : ((Table)Table.this).fActiveCell.y;
                    Table.this.select(n2, 0);
                    bl = true;
                    break;
                }
                case 9: 
                case 10: {
                    if ((keyEvent.getModifiers() & 0xE) != 0) break;
                    int n3 = 0;
                    int n4 = 0;
                    n = n == 9 ? Table.this.fSelection.getOptions().getTabKeyMode() : Table.this.fSelection.getOptions().getReturnKeyMode();
                    switch (n) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            n3 = 1;
                            break;
                        }
                        case 2: {
                            n3 = -1;
                            break;
                        }
                        case 3: {
                            n4 = 1;
                            break;
                        }
                        case 4: {
                            n4 = -1;
                        }
                    }
                    if (keyEvent.getModifiers() == 1) {
                        n4 = -n4;
                        n3 = -n3;
                    }
                    bl = TableUtils.navToNextCell(Table.this, Table.this.fSelection.getSelection(), Table.this.fActiveCell, n4, n3);
                }
            }
            if (bl) {
                keyEvent.consume();
                Table.this.scrollToCell(((Table)Table.this).fActiveCell.y, ((Table)Table.this).fActiveCell.x);
            }
        }
    }

    private class SelectionHandler
    implements SelectionListener {
        private SelectionHandler() {
        }

        @Override
        public void selectionChanged(SelectionEvent selectionEvent) {
            if (Table.this.fItemListener != null || Table.this.fExcelMode) {
                int n = 1;
                if (selectionEvent.getSelectionType() == 1 && selectionEvent.getDeselectedBounds() == null) {
                    n = 2;
                }
                if (Table.this.fItemListener != null) {
                    Table.this.fItemListener.itemStateChanged(new ItemEvent(Table.this, 701, null, n));
                }
                if (Table.this.fExcelMode) {
                    Rectangle[] rectangleArray = Table.this.fSelection.getSelection();
                    if (rectangleArray.length > 0) {
                        Point point = Table.this.fSelection.getAnchor();
                        ((Table)Table.this).fActiveCell.x = point.x;
                        ((Table)Table.this).fActiveCell.y = point.y;
                        Table.this.fActiveBorder = Table.this.calcActiveBorder(rectangleArray[rectangleArray.length - 1], Table.this.fActiveBorder);
                    } else {
                        ((Table)Table.this).fActiveCell.x = -2;
                        ((Table)Table.this).fActiveCell.y = -2;
                        Table.this.fActiveBorder = null;
                    }
                }
            }
        }
    }

    private class TableDataHandler
    implements TableDataListener {
        private TableDataHandler() {
        }

        @Override
        public void dataChanged(TableDataEvent tableDataEvent) {
            Rectangle rectangle;
            Rectangle rectangle2 = tableDataEvent.getChangeBounds();
            int n = Table.this.getAutoExpandColumn();
            int n2 = Table.this.getMinAutoExpandColumnWidth();
            if (n != -1 && n2 == -1 && n >= rectangle2.x && n < rectangle2.x + rectangle2.width) {
                boolean bl = false;
                Dimension dimension = new Dimension();
                for (int i = rectangle2.y; i < rectangle2.y + rectangle2.height; ++i) {
                    Cell cell = Table.this.getCell(i, n);
                    if (cell == null) continue;
                    cell.getPreferredCellSize(i, n, dimension);
                    if (dimension.width <= Table.this.fBiggestCellWidth) continue;
                    bl = true;
                    Table.this.fBiggestCellWidth = dimension.width;
                }
                if (bl && Table.this.isShowing()) {
                    Table.this.expandColumn();
                }
            }
            if (!(rectangle2 = rectangle2.intersection(rectangle = Table.this.getVisibleCells())).isEmpty()) {
                Table.this.repaintCells(rectangle2.y, rectangle2.x, rectangle2.y + rectangle2.height - 1, rectangle2.x + rectangle2.width - 1);
            }
        }

        @Override
        public void dataBoundsChanging(TableDataEvent tableDataEvent) {
            Cell cell;
            Point point = Table.this.getEditingCell();
            if (point.x != -2 && point.y != -2 && (cell = Table.this.getCell(point.y, point.x)) != null) {
                cell.commitEdit(point.y, point.x);
            }
            if (Table.this.fExcelMode) {
                Table.this.fSelection.clearSelection(true);
            }
        }

        @Override
        public void dataBoundsChanged(TableDataEvent tableDataEvent) {
            Dimension dimension = tableDataEvent.getDataBounds();
            if (Table.this.fColCount != dimension.width || Table.this.fRowCount != dimension.height) {
                this.dataBoundsChanging(tableDataEvent);
            }
            Table.this.fColCount = dimension.width;
            Table.this.fRowCount = dimension.height;
            Table.this.layoutScrollbars();
            Table.this.expandColumn();
            Table.this.layoutScrollbars();
            Table.this.updateDataPort();
            Table.this.repaint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rowsAdded(TableDataEvent tableDataEvent) {
            Style style;
            int n;
            int n2;
            Enumeration enumeration;
            IntBuffer intBuffer;
            Rectangle[] rectangleArray;
            int n3 = tableDataEvent.getIndex();
            int n4 = tableDataEvent.getCount();
            if (Table.this.fRowStyles != null && Table.this.fRowStyles.size() > 0) {
                rectangleArray = Table.this.fRowStyles;
                synchronized (rectangleArray) {
                    intBuffer = new IntBuffer(Table.this.fRowStyles.size(), 1);
                    enumeration = Table.this.fRowStyles.keys();
                    while (enumeration.hasMoreElements()) {
                        n2 = ((MutableInt)enumeration.nextElement()).getValue();
                        if (n2 < n3) continue;
                        TableUtils.insertSorted(n2, intBuffer, false);
                    }
                    for (n2 = 0; n2 < intBuffer.length(); ++n2) {
                        n = intBuffer.getAt(n2);
                        style = (Style)Table.this.fRowStyles.get(n);
                        if (style == null) continue;
                        Table.this.fRowStyles.remove(n);
                        Table.this.fRowStyles.put(n + n4, (Object)style);
                    }
                }
            }
            if (Table.this.fCellStyles != null && Table.this.fCellStyles.size() > 0) {
                rectangleArray = Table.this.fCellStyles;
                synchronized (rectangleArray) {
                    intBuffer = new IntBuffer(Table.this.fCellStyles.size(), 1);
                    enumeration = Table.this.fCellStyles.keys();
                    while (enumeration.hasMoreElements()) {
                        n2 = ((MutableInt)enumeration.nextElement()).getValue();
                        if (n2 < n3) continue;
                        TableUtils.insertSorted(n2, intBuffer, false);
                    }
                    for (n2 = 0; n2 < intBuffer.length(); ++n2) {
                        n = intBuffer.getAt(n2);
                        style = (IntHashtable)Table.this.fCellStyles.get(n);
                        if (style == null) continue;
                        Table.this.fCellStyles.remove(n);
                        Table.this.fCellStyles.put(n + n4, (Object)style);
                    }
                }
            }
            if (Table.this.getSelectionOptions().getMode() == 1) {
                int n5 = Table.this.getFirstSelectedRow();
                int n6 = Table.this.getFirstSelectedColumn();
                if (n5 >= n3) {
                    Table.this.select(n5 + n4, n6);
                }
            } else if (Table.this.getSelectionOptions().getMode() != 0 && (rectangleArray = Table.this.fSelection.getSelection()).length > 0) {
                if (Table.this.getSelectionOptions().getMode() == 2) {
                    if (rectangleArray[0].y >= n3) {
                        rectangleArray[0].y += n4;
                        Table.this.fSelection.select(rectangleArray);
                    } else if (rectangleArray[0].y + rectangleArray[0].height > n3) {
                        rectangleArray[0].height += n4;
                        Table.this.fSelection.select(rectangleArray);
                    }
                } else if (Table.this.getSelectionOptions().getMode() == 3) {
                    boolean bl = false;
                    for (int i = 0; i < rectangleArray.length; ++i) {
                        if (rectangleArray[i].y < n3) continue;
                        rectangleArray[i].y += n4;
                        bl = true;
                    }
                    if (bl) {
                        Table.this.fSelection.select(rectangleArray);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rowsRemoved(TableDataEvent tableDataEvent) {
            Style style;
            int n;
            int n2;
            Enumeration enumeration;
            IntBuffer intBuffer;
            IntBuffer intBuffer2;
            Rectangle[] rectangleArray;
            int n3 = tableDataEvent.getIndex();
            int n4 = tableDataEvent.getCount();
            if (Table.this.fRowStyles != null && Table.this.fRowStyles.size() > 0) {
                rectangleArray = Table.this.fRowStyles;
                synchronized (rectangleArray) {
                    intBuffer2 = new IntBuffer(Table.this.fRowStyles.size(), 1);
                    intBuffer = new IntBuffer(Table.this.fRowStyles.size(), 1);
                    enumeration = Table.this.fRowStyles.keys();
                    while (enumeration.hasMoreElements()) {
                        n2 = ((MutableInt)enumeration.nextElement()).getValue();
                        if (n2 < n3) continue;
                        if (n2 >= n3 + n4) {
                            TableUtils.insertSorted(n2, intBuffer, true);
                            continue;
                        }
                        intBuffer2.append(n2);
                    }
                    for (n = 0; n < intBuffer2.length(); ++n) {
                        Table.this.fRowStyles.remove(intBuffer2.getAt(n));
                    }
                    for (n = 0; n < intBuffer.length(); ++n) {
                        n2 = intBuffer.getAt(n);
                        style = (Style)Table.this.fRowStyles.get(n2);
                        if (style == null) continue;
                        Table.this.fRowStyles.remove(n2);
                        Table.this.fRowStyles.put(n2 - n4, (Object)style);
                    }
                }
            }
            if (Table.this.fCellStyles != null && Table.this.fCellStyles.size() > 0) {
                rectangleArray = Table.this.fCellStyles;
                synchronized (rectangleArray) {
                    intBuffer2 = new IntBuffer(Table.this.fCellStyles.size(), 1);
                    intBuffer = new IntBuffer(Table.this.fCellStyles.size(), 1);
                    enumeration = Table.this.fCellStyles.keys();
                    while (enumeration.hasMoreElements()) {
                        n2 = ((MutableInt)enumeration.nextElement()).getValue();
                        if (n2 < n3) continue;
                        if (n2 >= n3 + n4) {
                            TableUtils.insertSorted(n2, intBuffer, true);
                            continue;
                        }
                        intBuffer2.append(n2);
                    }
                    for (n = 0; n < intBuffer2.length(); ++n) {
                        Table.this.fCellStyles.remove(intBuffer2.getAt(n));
                    }
                    for (n = 0; n < intBuffer.length(); ++n) {
                        n2 = intBuffer.getAt(n);
                        style = (IntHashtable)Table.this.fCellStyles.get(n2);
                        if (style == null) continue;
                        Table.this.fCellStyles.remove(n2);
                        Table.this.fCellStyles.put(n2 - n4, (Object)style);
                    }
                }
            }
            if (Table.this.getSelectionOptions().getMode() != 0 && (rectangleArray = Table.this.fSelection.getSelection()).length > 0) {
                int n5 = n3 + n4;
                int n6 = rectangleArray[0].y;
                if (Table.this.getSelectionOptions().getMode() == 1) {
                    if (rectangleArray.length > 0) {
                        int n7 = rectangleArray[0].x;
                        if (n6 >= n3) {
                            if (n6 < n5) {
                                Table.this.deselectAll();
                                Table.this.getSelection().clearSelection(true);
                            } else {
                                Table.this.select(n6 - n4, n7);
                            }
                        }
                    }
                } else if (Table.this.getSelectionOptions().getMode() == 2) {
                    int n8 = rectangleArray[0].y + rectangleArray[0].height;
                    if (n6 >= n3) {
                        if (n8 <= n5) {
                            Table.this.deselectAll();
                            Table.this.getSelection().clearSelection(true);
                        } else {
                            if (n6 < n5) {
                                rectangleArray[0].height -= n5 - n6;
                                n4 -= n6 - n3;
                            }
                            rectangleArray[0].y -= n4;
                            Table.this.fSelection.select(rectangleArray);
                        }
                    } else if (n8 > n3) {
                        rectangleArray[0].height = n8 <= n5 ? (rectangleArray[0].height -= n8 - n3) : (rectangleArray[0].height -= n4);
                        Table.this.fSelection.select(rectangleArray);
                    }
                } else if (Table.this.getSelectionOptions().getMode() == 3) {
                    for (n = 0; n < rectangleArray.length; ++n) {
                        if (rectangleArray[n].y < n3) continue;
                        if (rectangleArray[n].y < n5) {
                            rectangleArray[n] = null;
                            continue;
                        }
                        rectangleArray[n].y -= n4;
                    }
                    Table.this.fSelection.select(rectangleArray);
                }
            }
            Table.this.refreshBiggestCellWidth();
        }
    }

    private class AdjustmentHandler
    implements AdjustmentListener {
        private AdjustmentHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            Object object;
            Rectangle rectangle = Table.this.getContentBounds();
            int n = Table.this.getRowOptions().getHeaderWidth();
            int n2 = Table.this.getColumnOptions().getHeaderHeight();
            int n3 = Table.this.getHScrollbarOptions().getMode();
            int n4 = Table.this.getVScrollbarOptions().getMode();
            if (((Table)Table.this).fEditingCell.x > -1 && ((Table)Table.this).fEditingCell.y > -1 && (object = Table.this.getCell(((Table)Table.this).fEditingCell.y, ((Table)Table.this).fEditingCell.x)) != null) {
                ((Cell)object).commitEdit(((Table)Table.this).fEditingCell.y, ((Table)Table.this).fEditingCell.x);
            }
            if (adjustmentEvent.getAdjustable() == Table.this.fHScroll) {
                if (n3 == 0) {
                    switch (adjustmentEvent.getAdjustmentType()) {
                        case 2: {
                            object = this;
                            synchronized (object) {
                                int n5 = Table.this.fNeedsUpdate ? Table.this.fCachedHOffset : Table.this.fHOffset;
                                int n6 = Table.this.columnAt(rectangle.x + n);
                                int n7 = n6 > 0 ? n5 - Table.this.getColumnWidth(n6 - 1) : 0;
                                Table.this.fHScroll.setValue(n7);
                                break;
                            }
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            object = this;
                            synchronized (object) {
                                int n8 = Table.this.columnAtOffset(Table.this.fHScroll.getValue());
                                int n9 = Table.this.columnOffset(n8);
                                Table.this.fHScroll.setValue(n9);
                                break;
                            }
                        }
                        case 1: {
                            object = this;
                            synchronized (object) {
                                int n10 = Table.this.fNeedsUpdate ? Table.this.fCachedHOffset : Table.this.fHOffset;
                                int n11 = Table.this.columnAt(rectangle.x + n);
                                int n12 = n10 + Table.this.getColumnWidth(n11);
                                Table.this.fHScroll.setValue(n12);
                                break;
                            }
                        }
                    }
                }
                Table.this.setHOffset(Table.this.fHScroll.getValue(), true);
            } else if (adjustmentEvent.getAdjustable() == Table.this.fVScroll) {
                if (n4 == 0) {
                    switch (adjustmentEvent.getAdjustmentType()) {
                        case 2: {
                            object = this;
                            synchronized (object) {
                                int n13 = Table.this.fNeedsUpdate ? Table.this.fCachedVOffset : Table.this.fVOffset;
                                int n14 = Table.this.rowAt(rectangle.y + n2);
                                int n15 = n14 > 0 ? n13 - Table.this.getRowHeight(n14 - 1) : 0;
                                Table.this.fVScroll.setValue(n15);
                                break;
                            }
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            object = this;
                            synchronized (object) {
                                int n16 = Table.this.rowAtOffset(Table.this.fVScroll.getValue());
                                int n17 = Table.this.rowOffset(n16);
                                Table.this.fVScroll.setValue(n17);
                                break;
                            }
                        }
                        case 1: {
                            object = this;
                            synchronized (object) {
                                int n18 = Table.this.fNeedsUpdate ? Table.this.fCachedVOffset : Table.this.fVOffset;
                                int n19 = Table.this.rowAt(rectangle.y + n2);
                                int n20 = n18 + Table.this.getRowHeight(n19);
                                Table.this.fVScroll.setValue(n20);
                                break;
                            }
                        }
                    }
                }
                Table.this.setVOffset(Table.this.fVScroll.getValue(), true);
            }
        }
    }

    private class FocusHandler
    implements FocusListener {
        private FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.repaintIfSel();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.repaintIfSel();
        }

        private void repaintIfSel() {
            Table.this.repaint(5L);
        }
    }
}

