/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.text;

import com.mathworks.mwt.text.MWTextAdapter;
import com.mathworks.mwt.text.MWTextEvent;
import com.mathworks.mwt.text.MWTextModel;
import com.mathworks.util.IntBuffer;

class LineMgr
extends MWTextAdapter {
    private IntBuffer fLineStarts;
    private MWTextModel fText;
    private int fLineCache;

    public LineMgr(MWTextModel mWTextModel, int n, int n2) {
        this.fText = mWTextModel;
        this.fLineStarts = new IntBuffer(n, n2);
        this.fLineStarts.setGrowthMode(4);
        this.fLineStarts.append(0);
    }

    public void setGrowthFactor(int n) {
        this.fLineStarts.setGrowthFactor(n);
    }

    public int getNumLines() {
        return this.fLineStarts.length();
    }

    public int getLineStart(int n) {
        return this.fLineStarts.getAt(n);
    }

    public int lineFromPos(int n) {
        int n2;
        if (this.fLineCache < this.getNumLines() && n >= this.getLineStart(this.fLineCache) && (this.fLineCache == this.getNumLines() - 1 || n < this.getLineStart(this.fLineCache + 1))) {
            return this.fLineCache;
        }
        int n3 = n2 = this.getNumLines();
        int n4 = 0;
        int n5 = -1;
        while (n4 < n3) {
            n5 = (n4 + n3) / 2;
            int n6 = this.getLineStart(n5);
            if (n >= n6) {
                if (n5 == n2 - 1 || n < this.getLineStart(n5 + 1)) break;
                n4 = n5 + 1;
                continue;
            }
            n3 = n5;
        }
        this.fLineCache = n5;
        return n5;
    }

    public void bump(int n, int n2) {
        int n3 = this.getNumLines();
        for (int i = n; i < n3; ++i) {
            this.fLineStarts.setAt(i, this.fLineStarts.getAt(i) + n2);
        }
    }

    @Override
    public void textInserted(MWTextEvent mWTextEvent) {
        int n = mWTextEvent.getMinPos();
        int n2 = mWTextEvent.getMaxPos();
        int n3 = mWTextEvent.getMinLine();
        char[] cArray = this.fText.getRawCharBuf();
        int n4 = LineMgr.countLines(cArray, n, n2);
        this.bump(n3 + 1, mWTextEvent.getLength());
        if (n4 > 0) {
            this.fLineStarts.insertSpace(n3 + 1, n4);
            int n5 = n;
            for (int i = 1; i <= n4; ++i) {
                n5 = LineMgr.findNextLine(cArray, n5, n2);
                this.fLineStarts.setAt(n3 + i, n5);
            }
            if (n4 == 1 && n2 - n == 1 && cArray[n] == '\r') {
                this.fLineStarts.setAt(n3 + 1, n2);
            }
        }
    }

    @Override
    public void textDeleted(MWTextEvent mWTextEvent) {
        int n = mWTextEvent.getMaxLine() + 1;
        int n2 = mWTextEvent.getMaxLine() - mWTextEvent.getMinLine();
        this.bump(n, -mWTextEvent.getLength());
        this.fLineStarts.delete(n - n2, n);
    }

    private static int countLines(char[] cArray, int n, int n2) {
        int n3 = n;
        int n4 = 0;
        while (n3 < cArray.length && n3 < n2 && (n3 = LineMgr.findNextLine(cArray, n3, n2)) != -1) {
            ++n4;
        }
        return n4;
    }

    private static int findNextLine(char[] cArray, int n, int n2) {
        int n3 = -1;
        while (n < n2) {
            if (cArray[n] == '\r') {
                if (n + 1 < cArray.length && cArray[n + 1] == '\n') {
                    ++n;
                }
                n3 = n + 1;
                break;
            }
            if (cArray[n] == '\n') {
                n3 = n + 1;
                break;
            }
            ++n;
        }
        return n3;
    }

    public void check() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.getNumLines(); ++i) {
            if (n == -1) {
                throw new IllegalStateException("LineMgr.check(): reached EOF before end of line starts.");
            }
            if (this.getLineStart(i) != n) {
                throw new IllegalStateException("LineMgr.check(): mismatch between text and line starts.");
            }
            n2 = n;
            n = LineMgr.findNextLine(this.fText.getRawCharBuf(), n, this.fText.length());
        }
        if (n != -1) {
            throw new IllegalStateException("LineMgr.check(): reached end of line starts before EOF");
        }
    }
}

