/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.text;

import com.mathworks.mwt.ObjBuffer;
import com.mathworks.mwt.text.MWStyle;
import com.mathworks.mwt.text.MWTextAdapter;
import com.mathworks.mwt.text.MWTextEvent;
import com.mathworks.mwt.text.MWTextModel;
import java.util.Hashtable;

class StyleMgr
extends MWTextAdapter {
    private MWStyle fDefaultStyle = new MWStyle(true);
    private ObjBuffer fRuns;
    private MWTextModel fText;
    private Hashtable fSharedStyles = new Hashtable();
    private int fRunCache = 0;

    public StyleMgr(MWTextModel mWTextModel) {
        this.fText = mWTextModel;
        this.clear();
    }

    private ObjBuffer getRuns() {
        return this.fRuns;
    }

    private void clear() {
        this.fSharedStyles.clear();
        this.fDefaultStyle.setAutoColor(true);
        this.fDefaultStyle.setColor(null);
        this.fRuns = new ObjBuffer(2, 512);
        this.fRuns.setGrowthMode(4);
        this.fRuns.insertSpace(0, 2);
        this.fRuns.setAt(0, new RunRec(-1, this.getSharedStyle(this.fDefaultStyle)));
        this.fRuns.setAt(1, new RunRec(0, this.getSharedStyle(this.fDefaultStyle)));
    }

    public void setGrowthFactor(int n) {
        this.fRuns.setGrowthFactor(n);
    }

    public int numRuns() {
        return this.fRuns.length();
    }

    public int getRunStart(int n) {
        return this.getRunRecAt((int)n).pos;
    }

    public MWStyle getDefaultStyle() {
        return this.fDefaultStyle;
    }

    public MWStyle getStyleAt(int n) {
        return this.getRunRecAt((int)this.runIndexFromPos((int)n)).style;
    }

    public MWTextModel.StyleRun getStyleRunAt(int n, MWTextModel.StyleRun styleRun) {
        RunRec runRec = this.getRunRecAt(n);
        styleRun.setStart(runRec.pos);
        styleRun.setStyle(runRec.style);
        styleRun.setEnd(this.getRunStart(n + 1));
        return styleRun;
    }

    public int runIndexFromPos(int n) {
        int n2;
        if (this.fRunCache < this.numRuns() && n >= this.getRunStart(this.fRunCache) && (this.fRunCache == this.numRuns() - 1 || n < this.getRunStart(this.fRunCache + 1))) {
            return this.fRunCache;
        }
        int n3 = n2 = this.numRuns();
        int n4 = 0;
        int n5 = -1;
        while (n4 < n3) {
            n5 = (n4 + n3) / 2;
            int n6 = this.getRunStart(n5);
            if (n >= n6) {
                if (n5 == n2 - 1 || n < this.getRunStart(n5 + 1)) break;
                n4 = n5 + 1;
                continue;
            }
            n3 = n5;
        }
        this.fRunCache = n5;
        return n5;
    }

    void morphStyles(MWStyle[] mWStyleArray, MWStyle[] mWStyleArray2) {
        if (mWStyleArray != null && mWStyleArray2 != null) {
            int n = Math.min(mWStyleArray.length, mWStyleArray2.length);
            for (int i = 0; i < n; ++i) {
                MWStyle mWStyle = (MWStyle)this.fSharedStyles.get(mWStyleArray[i]);
                if (mWStyle == null || mWStyleArray2[i] == null || mWStyle.equals(mWStyleArray2[i])) continue;
                this.fSharedStyles.remove(mWStyle);
                mWStyle.morph(mWStyleArray2[i]);
                this.fSharedStyles.put(mWStyle, mWStyle);
            }
        }
    }

    public void setStyle(int n, int n2, MWStyle mWStyle) {
        int n3;
        if (n > n2) {
            n3 = n;
            n = n2;
            n2 = n3;
        }
        int n4 = this.runIndexFromPos(n);
        int n5 = this.runIndexFromPos(n2);
        RunRec runRec = this.getRunRecAt(n4);
        RunRec runRec2 = this.getRunRecAt(n5);
        if (n4 == n5) {
            if (n != n2 && !mWStyle.equals(runRec.style)) {
                if (n > runRec.pos) {
                    this.fRuns.insertSpace(n4 + 1, 2);
                    this.fRuns.setAt(n4 + 1, new RunRec(n, this.getSharedStyle(mWStyle)));
                    this.fRuns.setAt(n4 + 2, new RunRec(n2, runRec.style));
                } else if (mWStyle.equals(this.getRunRecAt((int)(n4 - 1)).style)) {
                    runRec.pos = n2;
                } else {
                    this.fRuns.insert(n4, new RunRec(n, this.getSharedStyle(mWStyle)));
                    runRec.pos = n2;
                }
            }
        } else {
            n3 = n4 + 1;
            int n6 = n5;
            if (n > runRec.pos) {
                if (!mWStyle.equals(runRec.style)) {
                    this.fRuns.insert(n4 + 1, new RunRec(n, this.getSharedStyle(mWStyle)));
                    ++n3;
                    ++n6;
                    ++n5;
                }
            } else if (mWStyle.equals(this.getRunRecAt((int)(n4 - 1)).style)) {
                --n3;
            } else {
                runRec.style = this.getSharedStyle(mWStyle);
            }
            if (mWStyle.equals(runRec2.style)) {
                if (n5 < this.numRuns() - 1) {
                    ++n6;
                }
            } else if (n2 > runRec2.pos) {
                runRec2.pos = n2;
            }
            if (n3 < n6) {
                this.fRuns.delete(n3, n6);
            }
        }
    }

    private MWStyle getSharedStyle(MWStyle mWStyle) {
        MWStyle mWStyle2 = (MWStyle)this.fSharedStyles.get(mWStyle);
        if (mWStyle2 == null) {
            this.fSharedStyles.put(mWStyle, mWStyle);
            mWStyle2 = mWStyle;
        }
        return mWStyle2;
    }

    @Override
    public void textInserted(MWTextEvent mWTextEvent) {
        this.bumpRuns(mWTextEvent.getMinPos(), mWTextEvent.getLength());
    }

    @Override
    public void textDeleted(MWTextEvent mWTextEvent) {
        this.deleteRuns(mWTextEvent.getMinPos(), mWTextEvent.getMaxPos());
        this.bumpRuns(mWTextEvent.getMinPos(), -mWTextEvent.getLength());
    }

    private void bumpRuns(int n, int n2) {
        if (n2 == 0) {
            return;
        }
        int n3 = this.runIndexFromPos(n);
        RunRec runRec = this.getRunRecAt(n3);
        if (runRec.pos < n) {
            ++n3;
        }
        int n4 = this.numRuns();
        for (int i = n3; i < n4; ++i) {
            runRec = this.getRunRecAt(i);
            runRec.pos = Math.max(n, runRec.pos + n2);
        }
    }

    private void deleteRuns(int n, int n2) {
        int n3;
        if (n >= n2) {
            return;
        }
        int n4 = this.runIndexFromPos(n);
        if (n4 < (n3 = this.runIndexFromPos(n2))) {
            int n5 = n4 + 1;
            int n6 = n3;
            RunRec runRec = this.getRunRecAt(n4);
            RunRec runRec2 = this.getRunRecAt(n3);
            if (n == runRec.pos) {
                --n5;
                runRec = this.getRunRecAt(n4 - 1);
            }
            if (runRec.style.equals(runRec2.style) && n3 < this.numRuns() - 1) {
                ++n6;
            }
            if (n5 < n6) {
                this.fRuns.delete(n5, n6);
            }
        }
    }

    private RunRec getRunRecAt(int n) {
        return (RunRec)this.fRuns.getAt(n);
    }

    public void check() {
        int n = this.numRuns();
        int n2 = this.fText.length();
        RunRec runRec = null;
        try {
            RunRec runRec2;
            if (n < 2) {
                throw new IllegalStateException("missing start or end run.");
            }
            runRec = this.getRunRecAt(0);
            if (runRec.pos != -1 || runRec.style != this.fDefaultStyle) {
                throw new IllegalStateException("start run is invalid.");
            }
            for (int i = 1; i < n - 1; ++i) {
                runRec2 = this.getRunRecAt(i);
                if (runRec2.pos >= n2) {
                    throw new IllegalStateException("run starts at or after EOF.  Run " + i + "(" + runRec2 + "), length=" + n2);
                }
                if (runRec2.pos <= runRec.pos) {
                    throw new IllegalStateException("run length less than one.  Run " + (i - 1) + "(" + runRec + ")  Run " + i + "(" + runRec2 + ")");
                }
                if (runRec2.style == null) {
                    throw new IllegalStateException("null style.  Run " + i + "(" + runRec2 + ")");
                }
                if (runRec2.style.equals(runRec.style)) {
                    throw new IllegalStateException("matching styles abut.  Run " + (i - 1) + "(" + runRec + ")  Run " + i + "(" + runRec2 + ")");
                }
                runRec = runRec2;
            }
            runRec2 = this.getRunRecAt(n - 1);
            if (runRec2.pos != n2 || runRec2.style != this.fDefaultStyle) {
                throw new IllegalStateException("end run is invalid.");
            }
        }
        catch (IllegalStateException illegalStateException) {
            System.out.println(illegalStateException.getMessage());
            System.out.println(this.toString());
            illegalStateException.printStackTrace();
        }
    }

    public String toString() {
        String string = "";
        int n = this.numRuns();
        for (int i = 0; i < n; ++i) {
            string = string + this.getRunRecAt(i).toString() + "\n";
        }
        return string;
    }

    private static class RunRec {
        public int pos;
        public MWStyle style;

        public RunRec() {
        }

        public RunRec(int n, MWStyle mWStyle) {
            this.pos = n;
            this.style = mWStyle;
        }

        public String toString() {
            return "<RunRec " + this.pos + "/" + this.style + ">";
        }
    }
}

