/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.text;

import com.mathworks.mwt.text.MWTextEvent;
import com.mathworks.mwt.text.MWTextModel;
import com.mathworks.mwt.undo.CannotRedoException;
import com.mathworks.mwt.undo.CannotUndoException;
import com.mathworks.mwt.undo.UndoableEdit;

class UndoableTextEdit
implements UndoableEdit {
    private static final int INSERT = 1;
    private static final int DELETE = 2;
    private int fType;
    private MWTextModel fModel;
    private boolean fHasBeenDone;
    private int fStart;
    private int fEnd;
    private String fText;

    public UndoableTextEdit(MWTextEvent mWTextEvent) {
        if (mWTextEvent.getType() != 1 && mWTextEvent.getType() != 2) {
            throw new IllegalArgumentException("Can't create an UndoableTextEdit from a text event which is neither an INSERT nor a DELETE event");
        }
        this.fModel = mWTextEvent.getModel();
        this.fHasBeenDone = true;
        this.fType = mWTextEvent.getType();
        this.fStart = mWTextEvent.getStart();
        this.fEnd = mWTextEvent.getEnd();
        if (this.fType == 2) {
            this.fText = mWTextEvent.getText();
        }
    }

    public MWTextModel getModel() {
        return this.fModel;
    }

    public int getType() {
        return this.fType;
    }

    public int getStart() {
        return this.fStart;
    }

    public int getEnd() {
        return this.fEnd;
    }

    public int getMin() {
        return Math.min(this.fStart, this.fEnd);
    }

    public int getMax() {
        return Math.max(this.fStart, this.fEnd);
    }

    public boolean canUndo() {
        return this.fHasBeenDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        this.fModel.suspendUndoNotification();
        try {
            if (this.fType == 1) {
                this.deleteAndRecord();
            } else {
                this.insertAndRecord();
            }
            this.fHasBeenDone = false;
        }
        finally {
            this.fModel.resumeUndoNotification();
        }
    }

    public boolean canRedo() {
        return !this.fHasBeenDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        this.fModel.suspendUndoNotification();
        try {
            if (this.fType == 1) {
                this.insertAndRecord();
            } else {
                this.deleteAndRecord();
            }
            this.fHasBeenDone = true;
        }
        finally {
            this.fModel.resumeUndoNotification();
        }
    }

    private void deleteAndRecord() {
        this.fText = this.fModel.getText(this.fStart, this.fEnd);
        this.fModel.delete(this.fStart, this.fEnd);
    }

    private void insertAndRecord() {
        this.fModel.insert(Math.min(this.fStart, this.fEnd), this.fText);
        this.fText = null;
    }

    public boolean merge(UndoableEdit undoableEdit) {
        if (!(undoableEdit instanceof UndoableTextEdit && this.canUndo() && ((UndoableTextEdit)undoableEdit).canUndo())) {
            return false;
        }
        UndoableTextEdit undoableTextEdit = (UndoableTextEdit)undoableEdit;
        if (this.fEnd != undoableTextEdit.getStart()) {
            return false;
        }
        if (this.fType == 1) {
            if (undoableTextEdit.getType() == 1) {
                this.fEnd = undoableTextEdit.getEnd();
                return true;
            }
            if (undoableTextEdit.getEnd() > this.fStart && undoableTextEdit.getEnd() < this.fEnd) {
                this.fEnd = undoableTextEdit.getEnd();
                return true;
            }
        }
        return false;
    }

    @Override
    public String getName() {
        return "";
    }

    public String toString() {
        String string = "[";
        if (this.fHasBeenDone) {
            string = string + "*";
        }
        string = this.fType == 1 ? string + "I" + this.fStart + "-" + this.fEnd : string + "D" + this.fStart + "-" + this.fEnd + " '" + this.fText + "'";
        string = string + "]";
        return string;
    }
}

