/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.appmanagement;

import com.mathworks.appmanagement.AppManagementMatlabWorker;
import com.mathworks.appmanagement.AppMetadata;
import com.mathworks.appmanagement.AppMetadataImpl;
import com.mathworks.appmanagement.MatlabWorkerFactory;
import com.mathworks.appmanagement.PackagingApi;
import com.mathworks.mvm.MVM;
import com.mathworks.mvm.context.MvmContext;
import com.mathworks.mvm.exec.MatlabFevalRequest;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class PackagingApiImpl
implements PackagingApi {
    private final MatlabWorkerFactory matlabWorkerFactory;
    private final Map<File, AppMetadata> appMetadataMap = new ConcurrentHashMap<File, AppMetadata>();
    private final Map<File, Long> lastModifiedMap = new ConcurrentHashMap<File, Long>();

    PackagingApiImpl(MatlabWorkerFactory matlabWorkerFactory) {
        this.matlabWorkerFactory = matlabWorkerFactory;
    }

    @Override
    public final void extract(File file, File file2) throws Exception {
        AppManagementMatlabWorker<Void> appManagementMatlabWorker = this.matlabWorkerFactory.createInstallAppMatlabWorker(file, file2);
        appManagementMatlabWorker.go();
        appManagementMatlabWorker.get();
    }

    @Override
    public final void run(String string, File file) throws Exception {
        String string2 = file.getAbsolutePath();
        MatlabFevalRequest matlabFevalRequest = new MatlabFevalRequest("appinstall.internal.runapp", Integer.valueOf(0).intValue(), new Object[]{string, string2});
        MVM mVM = MvmContext.get();
        mVM.getExecutor().submit(matlabFevalRequest);
    }

    @Override
    public void uninstall(File file, File file2) throws Exception {
        AppManagementMatlabWorker<Void> appManagementMatlabWorker = this.matlabWorkerFactory.createUninstallAppMatlabWorker(file, file2);
        appManagementMatlabWorker.go();
        appManagementMatlabWorker.get();
    }

    @Override
    public AppMetadata getAppMetadata(File file) throws Exception {
        long l = file.lastModified();
        if (!this.appMetadataMap.containsKey(file) || !this.lastModifiedMap.containsKey(file) || this.lastModifiedMap.get(file) != l) {
            AppManagementMatlabWorker<Map<String, Object>> appManagementMatlabWorker = this.matlabWorkerFactory.createGetInfoMatlabWorker(file);
            appManagementMatlabWorker.go();
            this.appMetadataMap.put(file, new AppMetadataImpl(appManagementMatlabWorker.get()));
            this.lastModifiedMap.put(file, l);
        }
        return this.appMetadataMap.get(file);
    }

    @Override
    public String getAppPathName(String string) throws Exception {
        AppManagementMatlabWorker<String> appManagementMatlabWorker = this.matlabWorkerFactory.createGetAppPathNameMatlabWorker(string);
        appManagementMatlabWorker.go();
        return appManagementMatlabWorker.get();
    }
}

