/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.appmanagement;

import com.mathworks.appmanagement.AppFileDetails;
import com.mathworks.appmanagement.AppGalleryPathConfiguration;
import com.mathworks.appmanagement.AppManagementApi;
import com.mathworks.appmanagement.AppMetadata;
import com.mathworks.appmanagement.RunAppAction;
import com.mathworks.appmanagement.resources.ResourceKey;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.toolstrip.accessories.TSContextMenuContributor;
import com.mathworks.toolstrip.accessories.ToolTipContentProvider;
import com.mathworks.toolstrip.factory.TSRegistry;
import com.mathworks.toolstrip.factory.TSToolSet;
import com.mathworks.toolstrip.factory.TSToolSetContents;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class UserAppToolSetFactory {
    private static final String APPS_TOOL_SET_NAME = "apps_toolset";
    private static final String MY_APPS_NAME = "my_apps";
    private static AppGalleryPathConfiguration appGalleryPathConfiguration = null;
    private TSToolSet toolSet;

    UserAppToolSetFactory(TSToolSet tSToolSet) {
        this.toolSet = tSToolSet;
    }

    synchronized void addApps(AppManagementApi appManagementApi, AppMetadata[] appMetadataArray) throws InvocationTargetException, InterruptedException {
        for (AppMetadata appMetadata : appMetadataArray) {
            this.addApp(appManagementApi, appMetadata);
        }
    }

    synchronized void addApp(final AppManagementApi appManagementApi, AppMetadata appMetadata) throws InvocationTargetException, InterruptedException {
        String string;
        TSToolSetContents tSToolSetContents = this.toolSet.getContents();
        if (tSToolSetContents.getTool(string = appMetadata.getGuid()) == null) {
            String string2 = appMetadata.getName();
            tSToolSetContents.addTool(new TSToolSetContents.ToolParameters(string).setLabel(string2).setIcon((Icon)appMetadata.getIcon()).setDescription(appMetadata.getDescription()), new TSToolSetContents.Dependency[]{new TSToolSetContents.Dependency(MY_APPS_NAME, APPS_TOOL_SET_NAME)});
            RunAppAction runAppAction = new RunAppAction(appManagementApi, appMetadata);
            final JPopupMenu.Separator separator = new JPopupMenu.Separator();
            runAppAction.putValue("toolstrip-context-menu-contributor", new TSContextMenuContributor(){

                public void contributeToToolsripContextMenu(JPopupMenu jPopupMenu, MouseEvent mouseEvent) {
                    jPopupMenu.add(separator);
                    jPopupMenu.add((Action)new MJAbstractAction(ResourceKey.UNINSTALL.getString(new Object[0])){

                        public void actionPerformed(ActionEvent actionEvent) {
                            appManagementApi.uninstall(string);
                        }
                    });
                }
            });
            AppFileDetails appFileDetails = new AppFileDetails(appMetadata, true);
            final JComponent jComponent = appFileDetails.getPanel();
            int n = 300;
            try {
                File file = appManagementApi.getAppInstallFolder(appMetadata.getGuid());
                String string3 = file.getAbsolutePath();
                int n2 = jComponent.getFontMetrics(jComponent.getFont()).stringWidth(string3) + 20;
                if (n2 > n) {
                    n = n2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            jComponent.setPreferredSize(new Dimension(n, 400));
            runAppAction.putValue("tool-tip-content-provider", new ToolTipContentProvider(){

                public JComponent getToolTipContent() {
                    return jComponent;
                }
            });
            this.doOnEDT(new Runnable((Action)((Object)runAppAction)){
                final /* synthetic */ Action val$appAction;
                {
                    this.val$appAction = action;
                }

                @Override
                public void run() {
                    UserAppToolSetFactory.this.toolSet.configureAndAdd(string, this.val$appAction);
                }
            });
        }
    }

    private void doOnEDT(Runnable runnable) throws InterruptedException, InvocationTargetException {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeAndWait(runnable);
        }
    }

    void removeApp(AppMetadata appMetadata) throws InvocationTargetException, InterruptedException {
        String string = appMetadata.getGuid();
        this.removeAppSpecifiedByGuid(string);
    }

    synchronized void removeAppSpecifiedByGuid(final String string) throws InterruptedException, InvocationTargetException {
        this.toolSet.getContents().removeTool(string, new TSToolSetContents.Dependency[]{new TSToolSetContents.Dependency(MY_APPS_NAME, APPS_TOOL_SET_NAME)});
        this.doOnEDT(new Runnable(){

            @Override
            public void run() {
                UserAppToolSetFactory.this.toolSet.removeAction(string);
            }
        });
    }

    static AppGalleryPathConfiguration getAppGalleryPathConfiguration() {
        return appGalleryPathConfiguration;
    }

    public static void setAppGalleryPathConfiguration(AppGalleryPathConfiguration appGalleryPathConfiguration) {
        UserAppToolSetFactory.appGalleryPathConfiguration = appGalleryPathConfiguration;
    }

    synchronized void clearMyAppsGallery() throws InvocationTargetException, InterruptedException {
        TSRegistry tSRegistry = MatlabDesktopServices.getDesktop().getToolstripRegistry();
        TSToolSetContents.Tool tool = tSRegistry.getToolSetContents(APPS_TOOL_SET_NAME).getTool(MY_APPS_NAME);
        for (TSToolSetContents.Tool tool2 : tool.getChildren()) {
            String string = tool2.getName();
            String string2 = string.substring(string.indexOf(":") + 1);
            this.removeAppSpecifiedByGuid(string2);
        }
    }
}

