/*
 * Decompiled with CFR 0.152.
 */
package ice.util;

import ice.debug.Debug;
import ice.util.Defs;
import java.lang.reflect.Field;
import java.util.Locale;

public class Emulation {
    private static final String OEAB = "4.7 [" + Locale.getDefault().toString() + "] (" + Emulation.OEAB() + "; I; ICEbrowser)";
    private static final String Z = "5.0 (" + Emulation.OEAB() + "; " + Locale.getDefault().toString() + "; rv:1.5; ICEbrowser) Gecko/20031007 Netscape/7.2";
    private static final String append = "5.0 (Java " + Defs.sysProperty("java.version", "") + "; " + Emulation.OEAB() + "; " + Locale.getDefault().toString() + ") ICEbrowser/" + Emulation.Z();

    private static String OEAB() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Defs.sysProperty("os.name", ""));
        stringBuffer.append(' ');
        stringBuffer.append(Defs.sysProperty("os.version", ""));
        stringBuffer.append(' ');
        stringBuffer.append(Defs.sysProperty("os.arch", ""));
        return stringBuffer.toString();
    }

    private static String Z() {
        String string;
        block8: {
            string = "";
            try {
                Class<?> clazz = Class.forName("ice.storm.StormBase");
                Field field = clazz.getField("VERSION");
                string = field.get(clazz).toString();
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (Debug.ex) {
                    Debug.ex(classNotFoundException);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                if (Debug.ex) {
                    Debug.ex(illegalAccessException);
                }
            }
            catch (SecurityException securityException) {
                if (Debug.ex) {
                    Debug.ex(securityException);
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if (!Debug.ex) break block8;
                Debug.ex(noSuchFieldException);
            }
        }
        return string;
    }

    public static String getEmulationMode() {
        return Defs.sysProperty("ice.browser.emulation", "");
    }

    public static String getEmulatedAppCodeName() {
        return "Mozilla";
    }

    public static String getEmulatedAppName() {
        String string = Defs.sysProperty("ice.browser.appName", null);
        if (string == null) {
            String string2 = Emulation.getEmulationMode();
            string = string2.equals("ie") ? "Microsoft Internet Explorer" : (string2.equals("ns") ? "Netscape" : (string2.equals("ns6") || string2.equals("ns7") ? "Netscape" : "ICEbrowser"));
        }
        return string;
    }

    public static String getEmulatedAppVersion() {
        String string = Defs.sysProperty("ice.browser.appVersion", null);
        if (string == null) {
            String string2 = Emulation.getEmulationMode();
            string = string2.equals("ie") ? "4.0 (compatible; MSIE 6.0; Windows NT 5.0; ICEbrowser)" : (string2.equals("ns") ? OEAB : (string2.equals("ns6") || string2.equals("ns7") ? Z : append));
        }
        return string;
    }

    public static String getEmulatedPlatform() {
        String string = Emulation.getEmulationMode();
        if (string.equals("ie")) {
            return "Win32";
        }
        return Emulation.OEAB();
    }

    public static String getEmulatedUserAgent() {
        String string = Defs.sysProperty("ice.browser.http.agent", null);
        if (string == null) {
            string = Emulation.getEmulatedAppCodeName() + '/' + Emulation.getEmulatedAppVersion();
        }
        return string;
    }
}

