/*
 * Decompiled with CFR 0.152.
 */
package ice.util.net;

import ice.debug.Debug;
import ice.util.net.Cookie;
import ice.util.net.CookieSet;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class CookieManager
extends VetoableChangeSupport
implements CookieSet {
    boolean enabled = true;
    private Vector OEAB = new Vector();
    private int addCookie = 4096;
    private int addElement = 1024;
    private int addVetoableChangeListener = -1;
    private int after = 100000;
    private static CookieManager append = null;

    public static CookieManager getInstance() {
        if (append == null) {
            append = new CookieManager();
        }
        return append;
    }

    protected CookieManager() {
        super("Dummy");
    }

    public int getMaxTotalCookieSize() {
        return this.after;
    }

    public void setMaxTotalCookieSize(int n) {
        this.after = n;
    }

    public void setMaxCookieSize(int n) {
        this.addCookie = n;
    }

    public int getMaxCookieSize() {
        return this.addCookie;
    }

    public void setMaxNumberOfCookies(int n) {
        this.addElement = n;
    }

    public int getMaxNumberOfCookies() {
        return this.addElement;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Enumeration elements() {
        return this.OEAB.elements();
    }

    public Cookie[] getAllCookies() {
        int n = this.OEAB.size();
        if (n == 0) {
            return null;
        }
        Cookie[] cookieArray = new Cookie[n];
        int n2 = 0;
        while (n2 < n) {
            cookieArray[n2] = (Cookie)this.OEAB.elementAt(n2);
            ++n2;
        }
        return cookieArray;
    }

    protected boolean extractAllCookies(URL uRL, URLConnection uRLConnection) {
        if (!this.enabled) {
            return false;
        }
        boolean bl = false;
        String string = "";
        int n = 1;
        while (string != null) {
            string = uRLConnection.getHeaderFieldKey(n);
            String string2 = uRLConnection.getHeaderField(n);
            if (string != null && string2 != null && "set-cookie".equalsIgnoreCase(string)) {
                Cookie cookie;
                if (string2.length() > this.addCookie) {
                    return false;
                }
                if (this.OEAB.size() >= this.addElement) {
                    this.OEAB.removeElementAt(0);
                }
                if ((cookie = Cookie.parseFromString(uRL, string2)) != null) {
                    this.addCookie(cookie);
                    bl = true;
                }
            }
            ++n;
        }
        return bl;
    }

    public void removeAllCookies() {
        this.OEAB.removeAllElements();
    }

    public void removeAllSessionCookies() {
        Cookie cookie = null;
        int n = 0;
        while (n < this.OEAB.size()) {
            cookie = (Cookie)this.OEAB.elementAt(n);
            if (cookie.isSessionCookie()) {
                this.OEAB.removeElementAt(n);
                --n;
            }
            ++n;
        }
    }

    public void removeAllExpiredCookies() {
        Cookie cookie = null;
        int n = 0;
        while (n < this.OEAB.size()) {
            cookie = (Cookie)this.OEAB.elementAt(n);
            if (cookie.isExpired()) {
                this.OEAB.removeElementAt(n);
                --n;
            }
            ++n;
        }
    }

    public synchronized void addCookie(Cookie cookie) {
        boolean bl;
        int n = this.OEAB.size();
        int n2 = 0;
        while (n2 < n) {
            Cookie cookie2 = (Cookie)this.OEAB.elementAt(n2);
            bl = false;
            boolean bl2 = false;
            if (cookie2.getDomain().indexOf(cookie.getDomain()) != -1 || cookie2.getDomain().equals(cookie.getDomain())) {
                bl = true;
            }
            if (cookie.path == null) {
                bl2 = true;
            }
            if (cookie.path.equals(cookie2.path) || cookie2.path.indexOf(cookie.path) != -1) {
                bl2 = true;
            }
            if (bl && bl2 && cookie.name.equals(cookie2.name)) {
                if (this.OEAB(cookie2, cookie)) {
                    this.OEAB.setElementAt(cookie, n2);
                }
                return;
            }
            ++n2;
        }
        if (this.OEAB(null, cookie)) {
            boolean bl3 = false;
            bl = false;
            if (this.OEAB.size() > this.addElement) {
                bl3 = true;
            }
            if (cookie.size() > this.addCookie) {
                bl = true;
            }
            if (this.addVetoableChangeListener + cookie.size() > this.after) {
                bl3 = true;
            }
            if (bl) {
                return;
            }
            if (bl3) {
                if (this.addVetoableChangeListener < 0) {
                    return;
                }
                Cookie cookie3 = (Cookie)this.OEAB.elementAt(0);
                this.addVetoableChangeListener -= cookie3.size();
                this.addVetoableChangeListener += cookie.size();
                this.OEAB.setElementAt(cookie, 0);
                return;
            }
            if (this.addVetoableChangeListener < 0) {
                this.addVetoableChangeListener = 0;
            }
            this.addVetoableChangeListener += cookie.size();
            this.OEAB.addElement(cookie);
        }
    }

    private boolean OEAB(Cookie cookie, Cookie cookie2) {
        try {
            this.fireVetoableChange("Cookie", cookie, cookie2);
        }
        catch (PropertyVetoException propertyVetoException) {
            return false;
        }
        return true;
    }

    public void addCookie(String string, String string2) {
        URL uRL;
        block6: {
            uRL = null;
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                if (!Debug.ex) break block6;
                Debug.ex(malformedURLException);
            }
        }
        if (uRL != null) {
            Cookie cookie = Cookie.parseFromString(uRL, string2);
            if (cookie != null) {
                this.addCookie(cookie);
            } else if (Debug.trace) {
                Debug.trace("Error: bad cookie str=" + string2);
            }
        }
    }

    public String getCookieStr(String string) {
        URL uRL;
        block3: {
            uRL = null;
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                if (!Debug.ex) break block3;
                Debug.ex(malformedURLException);
            }
        }
        if (uRL != null) {
            String string2 = this.getCookieStr(uRL);
            return string2;
        }
        return null;
    }

    protected void applyAllCookies(URL uRL, URLConnection uRLConnection) {
        String string = this.getCookieStr(uRL);
        if (string != null && string.length() != 0) {
            ((HttpURLConnection)uRLConnection).disconnect();
            uRLConnection.setRequestProperty("Cookie", string);
        }
    }

    String getCookieStr(URL uRL) {
        Serializable serializable;
        int n;
        String string;
        if (!this.enabled) {
            return null;
        }
        if ("file".equals(uRL.getProtocol())) {
            int n2;
            string = uRL.getFile();
            if (!string.endsWith("/") && (n2 = string.lastIndexOf(47)) >= 0) {
                string = string.substring(0, n2 + 1);
            }
            n2 = this.OEAB.size();
            n = 0;
            while (n < n2) {
                serializable = (Cookie)this.OEAB.elementAt(n);
                if (string.equals(((Cookie)serializable).getPath())) {
                    return ((Cookie)serializable).toString();
                }
                ++n;
            }
        }
        if ((string = uRL.getHost()) == null) {
            return null;
        }
        String string2 = uRL.getProtocol();
        if (!string2.equals("http") && !string2.equals("https")) {
            return null;
        }
        n = this.OEAB.size();
        if (n == 0) {
            return null;
        }
        serializable = new StringBuffer();
        Date date = new Date();
        boolean bl = false;
        int n3 = 0;
        while (n3 != n) {
            Cookie cookie = (Cookie)this.OEAB.elementAt(n3);
            if ((cookie.expires == null || !cookie.expires.before(date)) && this.addElement(string, cookie.domain)) {
                cookie.use();
                if (bl) {
                    ((StringBuffer)serializable).append("; ");
                } else {
                    bl = true;
                }
                ((StringBuffer)serializable).append(cookie.name);
                ((StringBuffer)serializable).append('=');
                ((StringBuffer)serializable).append(cookie.value);
            }
            ++n3;
        }
        return ((StringBuffer)serializable).toString();
    }

    private boolean addElement(String string, String string2) {
        boolean bl = false;
        int n = string2.length();
        if (n != 0) {
            int n2;
            if ('.' == string2.charAt(0)) {
                if (n >= 2 && !(bl = string.endsWith(string2)) && string.length() == n - 1) {
                    bl = string2.endsWith(string);
                }
            } else if (string.endsWith(string2) && ((n2 = string.length()) == n || '.' == string.charAt(n2 - n - 1))) {
                bl = true;
            }
        }
        return bl;
    }

    public synchronized void writeCookies(ObjectOutput objectOutput) {
        if (!this.enabled) {
            return;
        }
        try {
            Vector<Cookie> vector = new Vector<Cookie>();
            int n = 0;
            while (n < this.OEAB.size()) {
                Cookie cookie = (Cookie)this.OEAB.elementAt(n);
                if (cookie.expires == null) {
                    vector.addElement(cookie);
                }
                if (cookie.expires != null && cookie.expires.after(new Date())) {
                    vector.addElement(cookie);
                }
                ++n;
            }
            objectOutput.writeObject(vector);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void readCookies(ObjectInput objectInput) {
        if (!this.enabled) {
            return;
        }
        try {
            Vector vector = (Vector)objectInput.readObject();
            int n = 0;
            while (n < vector.size()) {
                this.addCookie((Cookie)vector.elementAt(n));
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        super.addVetoableChangeListener(vetoableChangeListener);
    }
}

