/*
 * Decompiled with CFR 0.152.
 */
package ice.net;

import ice.debug.Debug;
import ice.net.Authentication;
import ice.net.AuthenticationManager;
import ice.net.CacheCallback;
import ice.net.CacheManager;
import ice.net.CachedObject;
import ice.net.ClientSocket;
import ice.net.Connection;
import ice.net.ConnectionManager;
import ice.net.ConnectionRoute;
import ice.net.Cookie;
import ice.net.CookieManager;
import ice.net.Direct;
import ice.net.ForbiddenException;
import ice.net.HeaderMap;
import ice.net.HttpMessage;
import ice.net.HttpParser;
import ice.net.HttpRequest;
import ice.net.HttpResponse;
import ice.net.HttpSession;
import ice.net.HttpURLConnectionSettings;
import ice.net.Indirect;
import ice.net.SimpleSocket;
import ice.net.URLNotFoundException;
import ice.net.pac.ConnectionRouteNotFoundException;
import ice.net.proxy.Proxy;
import ice.net.proxy.ProxyManager;
import ice.net.proxy.ProxyResolver;
import ice.util.Defs;
import ice.util.Emulation;
import ice.util.Math;
import ice.util.ParseDate;
import ice.util.alg.HashArray;
import ice.util.memory.MemoryManager;
import ice.util.net.CookieSet;
import ice.util.security.BoxedCode;
import ice.util.security.ProxyException;
import ice.util.security.SecurityKit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

public class HttpURLConnection
extends java.net.HttpURLConnection
implements CacheCallback,
CookieSet {
    protected String host;
    protected int port;
    protected boolean wasPosted = false;
    private ByteArrayOutputStream HTTPVersion;
    private boolean J;
    private Connection OEAB;
    private Vector RFC1123Date = null;
    private boolean acknowledgeAuthentication = false;
    private boolean addCookie = false;
    CachedObject theCachedObject = null;
    private IOException addElement = null;
    private int append = 0;
    private SimpleSocket applyAllCookies;
    private static final HttpURLConnectionSettings applyAuthentication = new HttpURLConnectionSettings();
    public static final String VERSION = "v1_5_2";
    public static final String PRODUCT_NAME = "ICEhttp/v1_5_2";
    private static final DateFormat arePersistentConnectionsEnabled = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", new Locale("en", "US"));
    protected AuthenticationManager authenticationManager;
    protected CacheManager cacheManager;
    protected ConnectionManager connectionManager;
    protected CookieManager cookieManager;
    protected MemoryManager memoryManager;
    protected ProxyResolver proxyResolver;
    boolean requestCancelled = false;
    boolean responseCancelled = false;
    private Vector areRedirectsEnabled;
    private ConnectionRoute authManager;
    private HttpRequest cacheMgr;
    private HeaderMap charAt;
    private HttpResponse checkConnect;
    private String checkSetFactory;
    private boolean clearHeaders;
    private boolean clone;
    private HttpSession connect;

    public HttpURLConnection(URL uRL) {
        this(uRL, applyAuthentication, null);
    }

    public HttpURLConnection(URL uRL, HttpURLConnectionSettings httpURLConnectionSettings) {
        this(uRL, httpURLConnectionSettings, null);
    }

    public HttpURLConnection(URL uRL, HttpURLConnectionSettings httpURLConnectionSettings, SimpleSocket simpleSocket) {
        super(uRL);
        this.checkSetFactory = httpURLConnectionSettings.getHttpVersion();
        this.charAt = (HeaderMap)httpURLConnectionSettings.getRequestHeaders().clone();
        this.charAt.putHeader("User-Agent", Emulation.getEmulatedUserAgent());
        this.areRedirectsEnabled = httpURLConnectionSettings.getAcceptLanguageList();
        this.setInstanceAuthenticationManager(httpURLConnectionSettings.getAuthenticationManager());
        this.setInstanceCacheManager(httpURLConnectionSettings.getCacheManager());
        this.setInstanceConnectionManager(httpURLConnectionSettings.getConnectionManager());
        this.setInstanceCookieManager(httpURLConnectionSettings.getCookieManager());
        this.setInstanceMemoryManager(httpURLConnectionSettings.getMemoryManager());
        this.setInstanceProxyResolver(httpURLConnectionSettings.getProxyResolver());
        if (this.proxyResolver != null) {
            try {
                this.authManager = this.proxyResolver.findProxyForUrl(this.url);
            }
            catch (Exception exception) {
                Debug.ex((Throwable)exception);
            }
        }
        if (this.authManager instanceof Direct) {
            this.host = this.authManager.getRequestedUrl().getHost();
            this.port = this.authManager.getRequestedUrl().getPort() < 0 ? this.getDefaultPort() : this.authManager.getRequestedUrl().getPort();
        } else if (this.authManager instanceof Indirect) {
            this.host = ((Indirect)this.authManager).getHost();
            this.port = ((Indirect)this.authManager).getPort();
        } else {
            this.host = this.url.getHost();
            this.port = this.url.getPort() >= 0 ? this.url.getPort() : this.getDefaultPort();
        }
        this.clearHeaders = httpURLConnectionSettings.areRedirectsEnabled();
        this.clone = httpURLConnectionSettings.shouldRetryBrokenConnections();
        if (Defs.sysPropertyBoolean((String)"ice.net.debug.request", (boolean)false) || Defs.sysPropertyBoolean((String)"ice.net.debug.all", (boolean)false)) {
            Debug.trace((String)("Request for URL " + this.url));
        }
        this.HTTPVersion(this.url);
        this.applyAllCookies = simpleSocket;
    }

    public HttpURLConnection(URL uRL, SimpleSocket simpleSocket) {
        this(uRL, applyAuthentication, simpleSocket);
    }

    public HttpURLConnection(URL uRL, HttpSession httpSession) {
        super(uRL);
        this.checkSetFactory = httpSession.HTTPVersion == 10 ? "HTTP/1.0" : "HTTP/1.1";
        this.charAt = new HeaderMap();
        this.charAt.putHeader("User-Agent", Emulation.getEmulatedUserAgent());
        HashArray.Entry[] entryArray = httpSession.defaultRequestProperties.getEntries();
        int n = 0;
        while (n < entryArray.length) {
            this.charAt.putHeader((String)entryArray[n].key(), (String)entryArray[n].value);
            ++n;
        }
        HttpURLConnection.updateAcceptLanguage(this.charAt, httpSession.acceptLanguageList);
        this.areRedirectsEnabled = httpSession.acceptLanguageList;
        this.connect = httpSession;
        this.setInstanceAuthenticationManager(this.connect.authManager);
        this.setInstanceCacheManager(this.connect.cacheMgr);
        this.setInstanceConnectionManager(this.connect.connectionMgr);
        this.setInstanceCookieManager(this.connect.cookieMgr);
        this.setInstanceMemoryManager(this.connect.memoryManager);
        this.setInstanceProxyResolver(this.connect.proxyResolver);
        if (this.proxyResolver != null) {
            try {
                this.authManager = this.proxyResolver.findProxyForUrl(this.url);
            }
            catch (Exception exception) {
                Debug.trace((String)exception.toString());
                Debug.ex((Throwable)exception);
            }
        }
        if (this.authManager instanceof Direct) {
            this.host = this.authManager.getRequestedUrl().getHost();
            this.port = this.authManager.getRequestedUrl().getPort() < 0 ? this.getDefaultPort() : this.authManager.getRequestedUrl().getPort();
        } else if (this.authManager instanceof Indirect) {
            this.host = ((Indirect)this.authManager).getHost();
            this.port = ((Indirect)this.authManager).getPort();
        } else {
            this.host = this.url.getHost();
            this.port = this.url.getPort() >= 0 ? this.url.getPort() : this.getDefaultPort();
        }
        this.append = 0;
        if (Defs.sysPropertyBoolean((String)"ice.net.debug.request", (boolean)false) || Defs.sysPropertyBoolean((String)"ice.net.debug.all", (boolean)false)) {
            Debug.trace((String)("Request for URL " + this.url));
        }
        this.HTTPVersion(this.url);
    }

    public boolean areRedirectsEnabled() {
        return this.clearHeaders;
    }

    public Vector getAcceptLanguageList() {
        return this.areRedirectsEnabled;
    }

    public static AuthenticationManager getAuthenticationManager() {
        return HttpURLConnection.getGlobalAuthenticationManager();
    }

    public static CacheManager getCacheManager() {
        return HttpURLConnection.getGlobalCacheManager();
    }

    public static ConnectionManager getConnectionManager() {
        return HttpURLConnection.getGlobalConnectionManager();
    }

    public String getContentType() {
        String[] stringArray;
        if (this.checkConnect == null) {
            try {
                this.getInputStream();
            }
            catch (IOException iOException) {
                this.addElement = iOException;
                return null;
            }
        }
        return (stringArray = this.checkConnect.getFieldValues("Content-Type")).length > 0 ? stringArray[0] : null;
    }

    public static CookieManager getCookieManager() {
        return HttpURLConnection.getGlobalCookieManager();
    }

    public static String getDefaultRequestProperty(String string) {
        String[] stringArray = applyAuthentication.getRequestHeaders().getFieldValues(string);
        return stringArray.length > 0 ? stringArray[0] : null;
    }

    public static boolean getFollowRedirects() {
        return applyAuthentication.areRedirectsEnabled();
    }

    public static AuthenticationManager getGlobalAuthenticationManager() {
        return applyAuthentication.getAuthenticationManager();
    }

    public static CacheManager getGlobalCacheManager() {
        return applyAuthentication.getCacheManager();
    }

    public static ConnectionManager getGlobalConnectionManager() {
        return applyAuthentication.getConnectionManager();
    }

    public static CookieManager getGlobalCookieManager() {
        return applyAuthentication.getCookieManager();
    }

    public static MemoryManager getGlobalMemoryManager() {
        return applyAuthentication.getMemoryManager();
    }

    public static ProxyManager getGlobalProxyManager() {
        ProxyResolver proxyResolver = HttpURLConnection.getGlobalProxyResolver();
        if (proxyResolver instanceof ProxyManager) {
            return (ProxyManager)proxyResolver;
        }
        return null;
    }

    public static ProxyResolver getGlobalProxyResolver() {
        return applyAuthentication.getProxyResolver();
    }

    public int getHeaderCount() {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException iOException) {
                Debug.ex((Throwable)iOException);
            }
        }
        if (this.checkConnect != null) {
            return this.checkConnect.getHeaderCount() + 1;
        }
        return 0;
    }

    public String getHeaderField(int n) {
        if (this.checkConnect == null) {
            try {
                this.getInputStream();
            }
            catch (IOException iOException) {
                Debug.ex((Throwable)iOException);
            }
        }
        if (n == 0) {
            return this.checkConnect.getStatusLine();
        }
        return this.checkConnect.getFieldValue(n - 1);
    }

    public String getHeaderField(String string) {
        if (this.checkConnect == null) {
            try {
                this.getInputStream();
            }
            catch (IOException iOException) {
                Debug.ex((Throwable)iOException);
            }
        }
        if (this.checkConnect != null) {
            String[] stringArray = this.checkConnect.getFieldValues(string);
            return stringArray.length > 0 ? stringArray[0] : null;
        }
        return null;
    }

    public String getHeaderFieldKey(int n) {
        if (this.checkConnect == null) {
            try {
                this.getInputStream();
            }
            catch (IOException iOException) {
                Debug.ex((Throwable)iOException);
            }
        }
        if (n == 0) {
            return "statusline";
        }
        return this.checkConnect.getFieldName(n - 1);
    }

    public String getHttpVersion() {
        return this.checkSetFactory;
    }

    public AuthenticationManager getInstanceAuthenticationManager() {
        return this.authenticationManager;
    }

    public CacheManager getInstanceCacheManager() {
        return this.cacheManager;
    }

    public ConnectionManager getInstanceConnectionManager() {
        return this.connectionManager;
    }

    public CookieManager getInstanceCookieManager() {
        return this.cookieManager;
    }

    public MemoryManager getInstanceMemoryManager() {
        return this.memoryManager;
    }

    public ProxyManager getInstanceProxyManager() {
        if (this.proxyResolver instanceof ProxyManager) {
            return (ProxyManager)this.proxyResolver;
        }
        return null;
    }

    public ProxyResolver getInstanceProxyResolver() {
        return this.proxyResolver;
    }

    public static ProxyManager getProxyManager() {
        return HttpURLConnection.getGlobalProxyManager();
    }

    public HttpRequest getRequest() {
        if (this.cacheMgr != null) {
            return (HttpRequest)this.cacheMgr.clone();
        }
        return null;
    }

    public String getRequestProperty(String string) {
        String[] stringArray = this.charAt.getFieldValues(string);
        return stringArray.length > 0 ? stringArray[0] : null;
    }

    public HttpResponse getResponse() {
        return this.checkConnect;
    }

    public boolean parseHeaderLine(String string) {
        try {
            if (this.checkConnect == null) {
                this.checkConnect = new HttpResponse("HTTP/1.0", 200, "OK");
            }
            HttpParser.parseHeader(string, this.checkConnect);
            return true;
        }
        catch (ProtocolException protocolException) {
            Debug.trace((String)"Invalid header");
            return false;
        }
    }

    public static void removeCookieManager() {
        HttpURLConnection.setGlobalCookieManager(null);
    }

    public static void setAuthenticationManager(AuthenticationManager authenticationManager) {
        HttpURLConnection.setGlobalAuthenticationManager(authenticationManager);
    }

    public static void setCacheManager(CacheManager cacheManager) {
        HttpURLConnection.setGlobalCacheManager(cacheManager);
    }

    public static void setConnectionManager(ConnectionManager connectionManager) throws IllegalArgumentException {
        HttpURLConnection.setGlobalConnectionManager(connectionManager);
    }

    public static void setCookieManager(CookieManager cookieManager) {
        HttpURLConnection.setGlobalCookieManager(cookieManager);
    }

    public static void setDefaultRequestProperty(String string, String string2) {
        applyAuthentication.getRequestHeaders().putHeader(string, string2);
    }

    public static void setFollowRedirects(boolean bl) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        applyAuthentication.setRedirectsEnabled(bl);
    }

    public static void setGlobalAuthenticationManager(AuthenticationManager authenticationManager) {
        applyAuthentication.setAuthenticationManager(authenticationManager);
    }

    public static void setGlobalCacheManager(CacheManager cacheManager) {
        applyAuthentication.setCacheManager(cacheManager);
    }

    public static void setGlobalConnectionManager(ConnectionManager connectionManager) throws IllegalArgumentException {
        applyAuthentication.setConnectionManager(connectionManager);
    }

    public static void setGlobalCookieManager(CookieManager cookieManager) {
        applyAuthentication.setCookieManager(cookieManager);
    }

    public static void setGlobalMemoryManager(MemoryManager memoryManager) {
        applyAuthentication.setMemoryManager(memoryManager);
    }

    public static void setGlobalProxyManager(ProxyManager proxyManager) {
        HttpURLConnection.setGlobalProxyResolver(proxyManager);
    }

    public static void setGlobalProxyResolver(ProxyResolver proxyResolver) {
        applyAuthentication.setProxyResolver(proxyResolver);
    }

    public void setIfModifiedSince(long l) throws IllegalAccessError {
        if (this.connected) {
            throw new IllegalAccessError("already connected");
        }
        this.ifModifiedSince = l;
        this.charAt.putHeader("If-Modified-Since", this.connect == null ? arePersistentConnectionsEnabled.format(new Date(this.ifModifiedSince)) : this.connect.RFC1123Date.format(new Date(this.ifModifiedSince)));
    }

    public void setInstanceAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setInstanceCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setInstanceConnectionManager(ConnectionManager connectionManager) throws IllegalArgumentException {
        if (connectionManager == null) {
            throw new IllegalArgumentException("connectionManager is null");
        }
        this.connectionManager = connectionManager;
    }

    public void setInstanceCookieManager(CookieManager cookieManager) {
        this.cookieManager = cookieManager;
    }

    public void setInstanceFollowRedirects(boolean bl) {
        this.clearHeaders = bl;
    }

    public void setInstanceMemoryManager(MemoryManager memoryManager) {
        this.memoryManager = memoryManager;
    }

    public void setInstanceProxyManager(ProxyManager proxyManager) {
        this.setInstanceProxyResolver(proxyManager);
    }

    public void setInstanceProxyResolver(ProxyResolver proxyResolver) {
        this.proxyResolver = proxyResolver;
    }

    public static void setProxyManager(ProxyManager proxyManager) {
        HttpURLConnection.setGlobalProxyManager(proxyManager);
    }

    public void setRequestProperty(String string, Date date) throws IllegalAccessError {
        this.setRequestProperty(string, this.connect == null ? arePersistentConnectionsEnabled.format(date) : this.connect.RFC1123Date.format(date));
    }

    public void setRequestProperty(String string, String string2) throws IllegalAccessError {
        if (this.connected) {
            throw new IllegalAccessError("already connected");
        }
        this.charAt.putHeader(string, string2);
    }

    public boolean shouldRetryBrokenConnections() {
        return this.clone;
    }

    public static void unload() {
        applyAuthentication.setAuthenticationManager(null);
        applyAuthentication.setCacheManager(null);
        applyAuthentication.setConnectionManager(null);
        applyAuthentication.setCookieManager(null);
        applyAuthentication.setMemoryManager(null);
        applyAuthentication.setProxyResolver(null);
    }

    void parseStatusLine(String string) throws ProtocolException {
        this.checkConnect = HttpParser.parseStatusLine(string);
    }

    void setResponse(HttpResponse httpResponse) {
        this.checkConnect = httpResponse;
        this.responseCode = this.checkConnect.getStatusCode();
        if (this.responseCode >= 400) {
            this.J = true;
        }
        this.responseMessage = this.checkConnect.getReasonPhrase();
    }

    static void updateAcceptLanguage(HeaderMap headerMap, Vector vector) {
        int n;
        if (headerMap.containsFieldName("Accept-Language")) {
            headerMap.removeHeaders("Accept-Language");
        }
        if (vector != null && (n = vector.size()) > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            if (n == 1) {
                Locale locale = (Locale)vector.elementAt(0);
                stringBuffer.append(locale.getLanguage());
                String string = locale.getCountry();
                if (string.length() != 0) {
                    stringBuffer.append("-" + string);
                }
            } else {
                double d = 1.0;
                double d2 = d / (double)n;
                int n2 = 0;
                while (n2 < n) {
                    double d3;
                    if (n2 > 0) {
                        stringBuffer.append(",");
                    }
                    Locale locale = (Locale)vector.elementAt(n2);
                    stringBuffer.append(locale.getLanguage());
                    String string = locale.getCountry();
                    if (string.length() != 0) {
                        stringBuffer.append("-" + string);
                    }
                    if ((d3 = Math.round((double)d, (int)1)) != 1.0) {
                        stringBuffer.append(";q=" + d3);
                    }
                    d -= d2;
                    ++n2;
                }
            }
            headerMap.putHeader("Accept-Language", stringBuffer.toString());
        }
    }

    public void setRetry(boolean bl) {
        this.append = bl ? (this.connect == null ? 1 : 1) : (this.connect == null ? 2 : 2);
    }

    public boolean getRetry() {
        return this.connect == null ? (this.append == 0 ? this.clone : this.append == 1) : (this.append == 0 ? this.connect.retryBrokenConnections : this.append == 1);
    }

    public boolean usingProxy() {
        return this.authManager instanceof Proxy;
    }

    public void setProxy(Proxy proxy) {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        this.authManager = proxy;
        if (this.authManager == null) {
            this.host = this.url.getHost();
            this.port = this.url.getPort() < 0 ? this.getDefaultPort() : this.url.getPort();
        } else {
            this.host = ((Proxy)this.authManager).getHost();
            this.port = ((Proxy)this.authManager).getPort();
        }
    }

    public Proxy getProxy() {
        if (this.usingProxy()) {
            return (Proxy)this.authManager;
        }
        return null;
    }

    public boolean isConnected() {
        return this.connected;
    }

    private void HTTPVersion(URL uRL) {
        Object object;
        String string;
        String string2 = uRL.toString();
        if (string2.indexOf("/./") != -1) {
            int n = string2.indexOf("/./");
            string = string2.substring(0, n);
            object = string2.substring(n + 2);
            try {
                URL uRL2;
                this.url = uRL2 = new URL(string + (String)object);
                string2 = uRL2.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (string2.indexOf("..") != -1) {
            try {
                String string3 = uRL.getFile();
                string = HttpURLConnection.acknowledgeAuthentication(uRL.getFile());
                if (string != string3) {
                    this.url = object = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string);
                    string2 = ((URL)object).toString();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        int n = string2.lastIndexOf("http://");
        int n2 = string2.indexOf("?");
        if (n > 0 && n2 == -1) {
            URL uRL3;
            this.acknowledgeAuthentication = true;
            if (this.RFC1123Date == null) {
                this.RFC1123Date = new Vector();
            }
            this.RFC1123Date.removeAllElements();
            int n3 = 0;
            int n4 = 0;
            while (n3 != -1) {
                n3 = string2.indexOf("http://", n4 + 1);
                if (n3 == -1) continue;
                try {
                    uRL3 = null;
                    if (n4 != n3) {
                        uRL3 = new URL(string2.substring(n4, n3));
                        this.RFC1123Date.addElement(uRL3);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                n4 = n3;
            }
            try {
                uRL3 = null;
                uRL3 = new URL(string2.substring(n4, string2.length()));
                this.RFC1123Date.addElement(uRL3);
                this.RFC1123Date.addElement(new URL(string2));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.url = (URL)this.RFC1123Date.elementAt(this.RFC1123Date.size() - 1);
            this.RFC1123Date.removeElementAt(this.RFC1123Date.size() - 1);
        }
    }

    private static Object J(BoxedCode boxedCode) throws IOException {
        try {
            return SecurityKit.doPrivileged((BoxedCode)boxedCode);
        }
        catch (ProxyException proxyException) {
            throw (IOException)proxyException.getTarget();
        }
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(this.url.getHost(), this.url.getPort());
        }
        this.connected = true;
        InetAddress inetAddress = null;
        if (this.acknowledgeAuthentication) {
            boolean bl = false;
            while (!bl) {
                try {
                    inetAddress = this.getInstanceConnectionManager().getByName(this.host, this.applyAllCookies == null ? true : this.applyAllCookies.useIp());
                    bl = true;
                }
                catch (UnknownHostException unknownHostException) {
                    Debug.ex((Throwable)unknownHostException);
                    if (this.RFC1123Date != null && this.RFC1123Date.size() > 0) {
                        this.url = (URL)this.RFC1123Date.elementAt(0);
                        this.host = this.url.getHost();
                        this.RFC1123Date.removeElementAt(0);
                        continue;
                    }
                    throw unknownHostException;
                }
            }
        } else {
            inetAddress = !this.usingProxy() ? this.getInstanceConnectionManager().getByName(this.host, this.applyAllCookies == null ? true : this.applyAllCookies.useIp()) : (InetAddress)HttpURLConnection.J(new BoxedCode(this){
                private final HttpURLConnection this$0;
                {
                    this.this$0 = httpURLConnection;
                }

                public Object run() {
                    try {
                        return this.this$0.getInstanceConnectionManager().getByName(this.this$0.host, HttpURLConnection.access$000(this.this$0) == null ? true : HttpURLConnection.access$000(this.this$0).useIp());
                    }
                    catch (IOException iOException) {
                        throw new ProxyException((Exception)iOException);
                    }
                }
            });
        }
        this.OEAB = this.getInstanceConnectionManager().getConnection(this, this.url, inetAddress, this.port);
    }

    protected Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        if (!this.usingProxy()) {
            return this.getInstanceConnectionManager().createSocket(inetAddress, n);
        }
        return (Socket)HttpURLConnection.J(new BoxedCode(this, inetAddress, n){
            private final InetAddress val$inetAddress;
            private final int val$port;
            private final HttpURLConnection this$0;
            {
                this.this$0 = httpURLConnection;
                this.val$inetAddress = inetAddress;
                this.val$port = n;
            }

            public Object run() {
                try {
                    return this.this$0.getInstanceConnectionManager().createSocket(this.val$inetAddress, this.val$port);
                }
                catch (IOException iOException) {
                    throw new ProxyException((Exception)iOException);
                }
            }
        });
    }

    protected SimpleSocket createSimpleSocket(InetAddress inetAddress, int n) throws IOException {
        if (this.applyAllCookies == null) {
            return new ClientSocket(this.createSocket(inetAddress, n));
        }
        return this.applyAllCookies;
    }

    protected int getDefaultPort() {
        if (this.url.getProtocol().equals("https")) {
            return 443;
        }
        return 80;
    }

    public void disconnect() {
        block4: {
            try {
                if (this.OEAB != null) {
                    this.OEAB.disconnect();
                }
                if (this.checkConnect != null) {
                    this.checkConnect.dispose();
                }
                this.connected = false;
            }
            catch (IOException iOException) {
                if (!Debug.ex) break block4;
                Debug.ex((Throwable)iOException);
            }
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.addElement != null) {
            throw this.addElement;
        }
        if (this.checkConnect != null) {
            return this.checkConnect.getEntityBody().getInputStream();
        }
        Object object = null;
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        if (!this.doInput) {
            throw new ProtocolException("Cannot read from URLConnection if doInput=false (call setDoInput(true))");
        }
        do {
            Object object2;
            int n3;
            Object object3;
            AuthenticationManager authenticationManager;
            CookieManager cookieManager;
            if ((cookieManager = this.getInstanceCookieManager()) != null) {
                try {
                    cookieManager.applyAllCookies(this.url, this);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if ((authenticationManager = this.getInstanceAuthenticationManager()) != null) {
                if (object != null || (object = authenticationManager.applyAuthentication(this.url, this)) == null || ((Authentication)object).giveUp()) {
                    // empty if block
                }
                if (object != null) {
                    if (this.connected) {
                        this.disconnect();
                    }
                    this.charAt.putHeader("Authorization", ((Authentication)object).getAuthString(), true);
                }
            }
            Authentication authentication = null;
            if (this.usingProxy() && (authentication = ((Proxy)this.authManager).getAuthentication()) != null) {
                if (this.connected) {
                    this.disconnect();
                }
                this.charAt.putHeader("Proxy-Authorization", authentication.getAuthString(), true);
                this.addCookie = true;
            }
            if (!"POST".equalsIgnoreCase(this.method)) {
                this.OEAB();
                if (this.checkConnect != null) {
                    this.connected = true;
                    return this.checkConnect.getEntityBody().getInputStream();
                }
            }
            boolean bl2 = false;
            while (!bl2) {
                try {
                    if (this.proxyResolver != null) {
                        this.authManager = this.proxyResolver.findProxyForUrl(this.url);
                        if (this.authManager instanceof Direct) {
                            object3 = this.authManager.getRequestedUrl();
                            this.host = ((URL)object3).getHost();
                            this.port = ((URL)object3).getPort() < 0 ? this.getDefaultPort() : ((URL)object3).getPort();
                        } else if (this.authManager instanceof Indirect) {
                            this.host = ((Indirect)this.authManager).getHost();
                            this.port = ((Indirect)this.authManager).getPort();
                        }
                    } else {
                        this.host = this.url.getHost();
                        int n4 = this.port = this.url.getPort() < 0 ? this.getDefaultPort() : this.url.getPort();
                    }
                    if (Defs.sysPropertyBoolean((String)"ice.net.debug.all", (boolean)false)) {
                        Debug.trace((String)("Trying connection route: " + (this.authManager != null ? this.authManager.toString() : "Direct")));
                    }
                    this.connect();
                    if (Defs.sysPropertyBoolean((String)"ice.net.debug.all", (boolean)false)) {
                        Debug.trace((String)("Using connection route: " + (this.authManager != null ? this.authManager.toString() : "Direct")));
                    }
                    bl2 = true;
                    if (this.authManager == null) continue;
                    this.authManager.setStatus(2);
                }
                catch (ConnectionRouteNotFoundException connectionRouteNotFoundException) {
                    throw new UnknownHostException(this.url.getHost());
                }
                catch (IOException iOException) {
                    this.connected = false;
                    if (this.authManager != null) {
                        this.authManager.setStatus(3);
                        continue;
                    }
                    throw iOException;
                }
                catch (Throwable throwable) {
                    Debug.ex((Throwable)throwable);
                }
            }
            if (this.OEAB != null) {
                object3 = this.OEAB.getInputStream(this);
                if (object3 == null) {
                    throw new IOException("unable to get a response from the server");
                }
                this.checkConnect.setEntityBody(new HttpMessage.EntityBody((InputStream)object3));
                if (Defs.sysPropertyBoolean((String)"ice.net.debug.responseHeaders", (boolean)false) || Defs.sysPropertyBoolean((String)"ice.net.debug.all", (boolean)false)) {
                    Debug.trace((String)("HTTP response:\r\n" + this.checkConnect.getMessage()));
                }
                this.connectionManager.fireHttpURLConnectionEvent(this, 3, this.cacheMgr, this.checkConnect);
                if (this.responseCancelled) {
                    throw new IOException("response cancelled");
                }
            }
            if (this.checkConnect.getStatusCode() == 304) {
                this.RFC1123Date();
                if (this.checkConnect != null) {
                    return this.checkConnect.getEntityBody().getInputStream();
                }
            }
            if (this.checkConnect.getStatusCode() == 403) {
                throw new ForbiddenException("Server refuses to serve document");
            }
            if (!(this.checkConnect.getStatusCode() != 404 || this.checkConnect.containsHeader("Content-Type") && "text/html".equalsIgnoreCase(this.checkConnect.getFieldValues("Content-Type")[0]))) {
                throw new URLNotFoundException("Document not found on server");
            }
            int n5 = this.checkConnect.getStatusCode() / 100;
            if (this.acknowledgeAuthentication && this.checkConnect.getStatusCode() != 200 && n5 != 3 && this.checkConnect.getStatusCode() != 400 && this.RFC1123Date.size() > 0) {
                this.url = (URL)this.RFC1123Date.elementAt(0);
                this.RFC1123Date.removeElementAt(0);
                this.checkConnect.clearHeaders();
                if (this.proxyResolver != null) {
                    try {
                        this.authManager = this.proxyResolver.findProxyForUrl(this.url);
                    }
                    catch (Exception exception) {
                        Debug.trace((String)exception.toString());
                    }
                }
                if (this.authManager instanceof Direct) {
                    this.host = this.authManager.getRequestedUrl().getHost();
                    this.port = this.authManager.getRequestedUrl().getPort() < 0 ? this.getDefaultPort() : this.authManager.getRequestedUrl().getPort();
                } else if (this.authManager instanceof Indirect) {
                    this.host = ((Indirect)this.authManager).getHost();
                    this.port = ((Indirect)this.authManager).getPort();
                } else {
                    this.host = this.url.getHost();
                    this.port = this.url.getPort() < 0 ? this.getDefaultPort() : this.url.getPort();
                }
                this.disconnect();
            }
            if (this.checkConnect.getStatusCode() == 200 && this.addCookie) {
                this.addCookie = false;
                authentication.setConfirmed(true);
            }
            if ((cookieManager = this.getInstanceCookieManager()) != null) {
                cookieManager.extractAllCookies(this.url, this);
            }
            if ((n3 = this.checkConnect.getStatusCode()) == 400 && n2 < 5 && this.getRetry()) {
                ++n2;
                this.checkConnect.clearHeaders();
                this.disconnect();
            }
            String string = null;
            if (this.connected) {
                object2 = this.checkConnect.getFieldValues("Refresh");
                String string2 = string = ((String[])object2).length > 0 ? object2[0] : null;
            }
            if (string != null && (string.indexOf("url") != -1 || string.indexOf("URL") != -1)) {
                int n6;
                boolean bl3 = true;
                try {
                    n6 = Integer.parseInt(string);
                    if (n6 > 0) {
                        bl3 = false;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (bl3) {
                    n3 = 301;
                    n6 = string.indexOf(61) + 1;
                    String string3 = string.substring(n6);
                    this.checkConnect.putHeader("Location", string3);
                }
            }
            if (n3 >= 300 && n3 <= 305 && n3 != 304 && (this.connect == null ? this.clearHeaders : this.connect.followRedirects)) {
                String string4;
                object2 = this.checkConnect.getFieldValues("Location");
                String string5 = string4 = ((String[])object2).length > 0 ? object2[0] : null;
                if (string4 != null && n < 10) {
                    try {
                        try {
                            if (string4.indexOf(" ") != -1) {
                                string4 = HttpURLConnection.acceptLanguageList(string4);
                            }
                            this.url = new URL(this.getURL(), string4);
                        }
                        catch (MalformedURLException malformedURLException) {
                            try {
                                String string6 = this.url.toString();
                                int n7 = string6.indexOf("?");
                                string6 = string6.substring(0, n7);
                                n7 = string6.lastIndexOf("/");
                                string6 = string6.substring(0, n7 + 1);
                                String string7 = string6 + string4;
                                this.url = new URL(string7);
                            }
                            catch (Exception exception) {
                                throw malformedURLException;
                            }
                        }
                        if (this.proxyResolver != null) {
                            try {
                                this.authManager = this.proxyResolver.findProxyForUrl(this.url);
                            }
                            catch (Exception exception) {
                                Debug.trace((String)exception.toString());
                            }
                        }
                        if (this.authManager instanceof Direct) {
                            this.host = this.authManager.getRequestedUrl().getHost();
                            this.port = this.authManager.getRequestedUrl().getPort() < 0 ? this.getDefaultPort() : this.authManager.getRequestedUrl().getPort();
                        } else if (this.authManager instanceof Indirect) {
                            this.host = ((Indirect)this.authManager).getHost();
                            this.port = ((Indirect)this.authManager).getPort();
                        } else {
                            this.host = this.url.getHost();
                            this.port = this.url.getPort() < 0 ? this.getDefaultPort() : this.url.getPort();
                        }
                        this.disconnect();
                        this.checkConnect = null;
                        this.responseCode = -1;
                        this.responseMessage = null;
                        if (n3 == 301 || n3 == 302 || n3 == 303) {
                            this.HTTPVersion = null;
                            this.wasPosted = false;
                            this.method = "GET";
                            object = null;
                            this.charAt.removeHeaders("Authorization");
                            this.charAt.removeHeaders("Content-Length");
                            this.charAt.removeHeaders("Content-Type");
                            this.charAt.removeHeaders("Host");
                            this.charAt.removeHeaders("Connection");
                            this.charAt.removeHeaders("Cookie");
                        }
                        ++n;
                    }
                    catch (MalformedURLException malformedURLException) {
                        bl = true;
                    }
                } else {
                    bl = true;
                }
            } else {
                bl = true;
            }
            if (n3 == 401 || n3 == 407) {
                authenticationManager = this.getInstanceAuthenticationManager();
                if (authenticationManager != null) {
                    authenticationManager.removeBadAuthentication((Authentication)object);
                    if (n3 == 401) {
                        authenticationManager.removeBadAuthentication((Authentication)object);
                    } else if (n3 == 407 && (object2 = ((Proxy)this.authManager).getAuthentication()) != null && !((Authentication)object2).isConfirmed()) {
                        authenticationManager.removeBadAuthentication((Authentication)object2);
                        ((Proxy)this.authManager).setAuthentication(null);
                    }
                    object2 = authenticationManager.extractAuthentication(this.url, this);
                    if (!((Authentication)object2).giveUp()) {
                        if (n3 == 401) {
                            object = object2;
                        } else if (n3 == 407 && this.usingProxy()) {
                            ((Proxy)this.authManager).setAuthentication((Authentication)object2);
                            ((Authentication)object2).setConfirmed(false);
                        }
                        this.checkConnect = null;
                        if (this.connected) {
                            this.disconnect();
                        }
                        bl = false;
                    } else {
                        authenticationManager.removeAuthentication((Authentication)object2);
                        bl = true;
                    }
                }
            } else if (object != null) {
                authenticationManager.acknowledgeAuthentication((Authentication)object);
            }
            if (n3 != 200) continue;
            bl = true;
        } while (!bl);
        return this.checkConnect != null ? this.checkConnect.getEntityBody().getInputStream() : null;
    }

    private void OEAB() {
        CacheManager cacheManager = this.getInstanceCacheManager();
        if (cacheManager != null) {
            this.theCachedObject = cacheManager.getCachedObject(this.url, this);
            if (this.theCachedObject != null) {
                if (this.theCachedObject.isFresh()) {
                    this.responseCode = 200;
                    this.responseMessage = "OK";
                    this.checkConnect = new HttpResponse(this.checkSetFactory, 200, "OK");
                    int n = 0;
                    while (n < this.theCachedObject.headerKeys.length) {
                        try {
                            HttpParser.parseHeader(this.theCachedObject.headerKeys[n] + ": " + this.theCachedObject.headers[n], this.checkConnect);
                        }
                        catch (ProtocolException protocolException) {
                            Debug.ex((Throwable)protocolException);
                        }
                        ++n;
                    }
                    this.checkConnect.setEntityBody(new HttpMessage.EntityBody(new ByteArrayInputStream(this.theCachedObject.data)));
                } else {
                    String string = this.theCachedObject.findHeader("ETag");
                    if (string != null) {
                        this.charAt.putHeader("If-None-Match", string);
                    } else {
                        String string2 = this.theCachedObject.findHeader("Last-Modified");
                        if (string2 == null) {
                            string2 = "";
                        }
                        this.charAt.putHeader("If-Modified-Since", string2);
                    }
                }
            }
        }
    }

    private void RFC1123Date() {
        if (this.theCachedObject != null) {
            this.theCachedObject.setRecieved(System.currentTimeMillis());
            if (this.checkConnect.containsHeader("Last-Modified")) {
                this.theCachedObject.setLastModified(ParseDate.parseDate((String)this.getHeaderField("Last-Modified")).getTime());
            }
            this.responseCode = 200;
            this.responseMessage = "OK";
            this.checkConnect = new HttpResponse(this.checkSetFactory, 200, "OK");
            int n = 0;
            while (n < this.theCachedObject.headerKeys.length) {
                try {
                    HttpParser.parseHeader(this.theCachedObject.headerKeys[n] + ": " + this.theCachedObject.headers[n], this.checkConnect);
                }
                catch (ProtocolException protocolException) {
                    Debug.ex((Throwable)protocolException);
                }
                ++n;
            }
            this.checkConnect.setEntityBody(new HttpMessage.EntityBody(new ByteArrayInputStream(this.theCachedObject.data)));
        }
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.doOutput) {
            throw new ProtocolException("cannot write to a URLConnection if doOutput=false - call setDoOutput(true)");
        }
        this.method = "POST";
        if (this.checkConnect != null) {
            throw new ProtocolException("Cannot write output after reading input.");
        }
        if (!this.connected) {
            this.connect();
        }
        if (this.HTTPVersion == null) {
            this.HTTPVersion = new ByteArrayOutputStream();
        }
        this.wasPosted = true;
        return this.HTTPVersion;
    }

    public InputStream getErrorStream() {
        if (!this.connected || !this.J) {
            return null;
        }
        return this.checkConnect.getEntityBody().getInputStream();
    }

    public int getResponseCode() throws IOException {
        if (this.checkConnect == null) {
            this.getInputStream();
        }
        return this.checkConnect.getStatusCode();
    }

    public String getResponseMessage() throws IOException {
        if (this.checkConnect == null) {
            this.getInputStream();
        }
        return this.checkConnect.getReasonPhrase();
    }

    void prepareRequest() {
        String string;
        boolean bl = false;
        if (this.usingProxy()) {
            bl = this.url.getProtocol().equals("https") ? true : ((Proxy)this.authManager).isTunneling();
        }
        if (this.usingProxy() && !bl) {
            string = this.url.toExternalForm();
            int n = string.indexOf("://");
            if (n != -1) {
                n += 3;
                if ((n = string.indexOf("/", n)) == -1) {
                    string = string + "/";
                }
            }
            if (string.indexOf(" ") != -1) {
                string = HttpURLConnection.acceptLanguageList(string);
            }
        } else {
            string = this.url.getFile();
            if ("".equals(string)) {
                string = "/";
                try {
                    this.url = new URL(this.url, string);
                }
                catch (MalformedURLException malformedURLException) {}
            } else if (string.indexOf(" ") != -1) {
                string = HttpURLConnection.acceptLanguageList(string);
            }
            if (this.url.getProtocol().equals("https")) {
                this.checkSetFactory = "HTTP/1.0";
            }
        }
        if (this.url.getPort() == 80 || this.url.getPort() < 0) {
            this.charAt.putHeader("Host", this.url.getHost(), true);
        } else {
            this.charAt.putHeader("Host", this.url.getHost() + ":" + this.url.getPort(), true);
        }
        if (!this.checkSetFactory.equals("HTTP/1.0") && !this.connectionManager.arePersistentConnectionsEnabled()) {
            this.charAt.putHeader("Connection", "Close", true);
        }
        if (this.connectionManager.arePersistentConnectionsEnabled()) {
            if (this.usingProxy()) {
                this.charAt.putHeader("Proxy-Connection", "Keep-Alive", true);
            } else {
                this.charAt.putHeader("Connection", "Keep-Alive", true);
            }
        }
        this.cacheMgr = new HttpRequest(this.method, string, this.checkSetFactory);
        int n = this.charAt.getSize();
        int n2 = 0;
        while (n2 < n) {
            this.cacheMgr.putHeader(this.charAt.getFieldName(n2), this.charAt.getFieldValue(n2));
            ++n2;
        }
        if (this.HTTPVersion != null) {
            this.cacheMgr.setEntityBody(new HttpMessage.EntityBody(this.HTTPVersion.toByteArray()));
        }
        if (Defs.sysPropertyBoolean((String)"ice.net.debug.requestHeaders", (boolean)false) || Defs.sysPropertyBoolean((String)"ice.net.debug.all", (boolean)false)) {
            Debug.trace((String)("HTTP request:\r\n" + this.cacheMgr.getMessage()));
        }
        this.connectionManager.fireHttpURLConnectionEvent(this, 1, this.cacheMgr);
    }

    void sendRequest() throws IOException {
        if (!this.requestCancelled) {
            this.OEAB.getOutputStream().write(this.cacheMgr.getBytes(), 0, this.cacheMgr.getLength());
            this.connectionManager.fireHttpURLConnectionEvent(this, 2, this.cacheMgr);
        }
    }

    public boolean wasPosted() {
        return this.wasPosted;
    }

    public void addCookie(String string, String string2) {
        CookieManager cookieManager;
        if (Debug.trace) {
            Debug.trace((String)("url=" + string + " str=" + string2));
        }
        if ((cookieManager = this.getInstanceCookieManager()) != null) {
            URL uRL;
            block8: {
                uRL = null;
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    if (!Debug.ex) break block8;
                    Debug.ex((Throwable)malformedURLException);
                }
            }
            if (uRL != null) {
                Cookie cookie = Cookie.parseFromString(uRL, string2);
                if (cookie != null) {
                    cookieManager.addCookie(cookie);
                } else if (Debug.trace) {
                    Debug.trace((String)("Error: bad cookie str=" + string2));
                }
            }
        }
    }

    public String getCookieStr(String string) {
        CookieManager cookieManager = this.getInstanceCookieManager();
        if (cookieManager != null) {
            URL uRL;
            block4: {
                uRL = null;
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    if (!Debug.ex) break block4;
                    Debug.ex((Throwable)malformedURLException);
                }
            }
            if (uRL != null) {
                return cookieManager.getCookieStr(uRL);
            }
        }
        return null;
    }

    private static String acceptLanguageList(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == ' ') {
                stringBuffer.append("%20");
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static String acknowledgeAuthentication(String string) throws IOException {
        CharSequence charSequence;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/", true);
        Vector<CharSequence> vector = new Vector<CharSequence>();
        while (stringTokenizer.hasMoreElements()) {
            charSequence = stringTokenizer.nextToken();
            if ("..".equals(charSequence)) {
                if (vector.size() < 3) {
                    throw new IOException("Error simplifying /../ .");
                }
                vector.removeElementAt(vector.size() - 1);
                vector.removeElementAt(vector.size() - 1);
                vector.removeElementAt(vector.size() - 1);
                continue;
            }
            vector.addElement(charSequence);
        }
        charSequence = new StringBuffer();
        int n = 0;
        while (n < vector.size()) {
            ((StringBuffer)charSequence).append((String)vector.elementAt(n));
            ++n;
        }
        return ((StringBuffer)charSequence).toString();
    }

    static SimpleSocket access$000(HttpURLConnection httpURLConnection) {
        return httpURLConnection.applyAllCookies;
    }

    static {
        if (Debug.trace) {
            Debug.traceAsIs((String)"ICEhttp v1_5_2");
        } else if (Defs.sysPropertyBoolean((String)"ice.browser.verbose", (boolean)true)) {
            System.out.println("ICEhttp v1_5_2\r\n(c) ICEsoft Technologies, Inc.");
        }
        arePersistentConnectionsEnabled.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

