/*
 * Decompiled with CFR 0.152.
 */
package ice.net;

import ice.net.Cache;
import ice.net.CacheManager;
import ice.net.CachedObject;
import ice.util.ParseDate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class MemoryCache
implements Cache {
    private String J = "default memory cache";
    private long OEAB = 1000000L;
    private long before;
    private Hashtable calculateSize = new Hashtable();
    private CacheManager clear;

    public void setManager(CacheManager cacheManager) {
        this.clear = cacheManager;
    }

    public void setExpires(String string, Date date) {
        CachedObject cachedObject = (CachedObject)this.calculateSize.get(string);
        if (cachedObject != null && date != null) {
            cachedObject.expires = date.getTime();
        }
    }

    public void submit(CachedObject cachedObject) {
        if (cachedObject != null && (long)this.calculateSize(cachedObject) < this.OEAB) {
            if (this.has(cachedObject.url)) {
                if (this.isExpired(this.get(cachedObject.url))) {
                    this.OEAB(cachedObject.url);
                    this.before(cachedObject);
                } else if (this.J(cachedObject)) {
                    this.OEAB(cachedObject.url);
                    this.before(cachedObject);
                }
            } else {
                this.before(cachedObject);
            }
        }
    }

    public void delete(String string, boolean bl) {
        if (this.has(string)) {
            CachedObject cachedObject = this.get(string);
            this.OEAB(string);
            if (this.clear != null && bl) {
                this.clear.wasDeleted(cachedObject, this);
            }
        }
    }

    private boolean J(CachedObject cachedObject) {
        CachedObject cachedObject2 = (CachedObject)this.calculateSize.get(cachedObject.url);
        Date date = ParseDate.parseDate((String)cachedObject2.findHeader("Last-Modified"));
        Date date2 = ParseDate.parseDate((String)cachedObject.findHeader("Last-Modified"));
        if (date == null || date2 == null) {
            return false;
        }
        return date.before(date2);
    }

    public boolean has(String string) {
        return this.calculateSize.containsKey(string);
    }

    private void OEAB(String string) {
        CachedObject cachedObject = (CachedObject)this.calculateSize.get(string);
        if (cachedObject != null) {
            this.calculateSize.remove(string);
            this.before -= (long)this.calculateSize(cachedObject);
            cachedObject = null;
        }
    }

    private void before(CachedObject cachedObject) {
        cachedObject.lastAccessed = System.currentTimeMillis();
        this.before += (long)this.calculateSize(cachedObject);
        if (this.before > this.OEAB) {
            this.calculateSize();
        }
        this.calculateSize.put(cachedObject.url, cachedObject);
    }

    int calculateSize(CachedObject cachedObject) {
        int n = 0;
        n = cachedObject.data.length;
        int n2 = 0;
        while (n2 < cachedObject.headers.length) {
            n += cachedObject.headers[n2].length() * 2;
            ++n2;
        }
        return n;
    }

    public long getCurrentSize() {
        return this.before;
    }

    public void clear() {
        this.calculateSize.clear();
        this.before = 0L;
    }

    private void calculateSize() {
        while (this.before > this.OEAB) {
            String string = this.getOldest();
            CachedObject cachedObject = (CachedObject)this.calculateSize.get(string);
            this.OEAB(string);
            if (this.clear == null) continue;
            this.clear.wasDeleted(cachedObject, this);
        }
    }

    public void setMaxSize(long l) {
        this.OEAB = l;
        if (this.before > this.OEAB) {
            this.calculateSize();
        }
    }

    public long getMaxSize() {
        return this.OEAB;
    }

    public void clearExpired() {
        Enumeration enumeration = this.calculateSize.elements();
        while (enumeration.hasMoreElements()) {
            CachedObject cachedObject = (CachedObject)enumeration.nextElement();
            if (!this.isExpired(cachedObject)) continue;
            this.OEAB(cachedObject.url);
        }
    }

    public CachedObject get(String string) {
        CachedObject cachedObject = (CachedObject)this.calculateSize.get(string);
        if (cachedObject != null && this.isExpired(cachedObject)) {
            this.OEAB(string);
            cachedObject = null;
        }
        return cachedObject;
    }

    public String getName() {
        return this.J;
    }

    boolean isExpired(CachedObject cachedObject) {
        return this.clear.isExpired(cachedObject);
    }

    String getOldest() {
        Enumeration enumeration = this.calculateSize.elements();
        String string = null;
        long l = Long.MAX_VALUE;
        while (enumeration.hasMoreElements()) {
            CachedObject cachedObject = (CachedObject)enumeration.nextElement();
            if (cachedObject.lastAccessed >= l) continue;
            l = cachedObject.lastAccessed;
            string = cachedObject.url;
        }
        return string;
    }
}

