/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mvm.exec;

public class MatlabConversionError
extends Throwable {
    private final int fArgNum;
    private final boolean fWasExecuted;

    private MatlabConversionError(String string, int n, boolean bl, Throwable throwable) {
        super(string, throwable);
        this.fArgNum = n;
        this.fWasExecuted = n < 0 || n == 0 && bl;
    }

    public boolean wasExecuted() {
        return this.fWasExecuted;
    }

    public boolean isInputError() {
        return this.fArgNum > 0;
    }

    public boolean isOutputError() {
        return this.fArgNum < 0;
    }

    public int getArgNum() {
        return Math.abs(this.fArgNum);
    }

    @Override
    public String toString() {
        String string;
        String string2 = this.getClass().getName() + ": ";
        if (this.fArgNum != 0) {
            string2 = this.isInputError() ? string2 + "argument " : string2 + "return value ";
            string2 = string2 + Math.abs(this.fArgNum);
            string2 = string2 + ": ";
        }
        if ((string = this.getLocalizedMessage()) != null) {
            string2 = string2 + string;
        }
        return string2 + (this.wasExecuted() ? " (was" : " (was not") + " executed)";
    }
}

