/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mvm.exec;

import com.mathworks.mvm.MvmImpl;
import com.mathworks.mvm.exec.MvmExecutionException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.Nullable;

final class NativeFutureResult<V> {
    private long fNativeID;
    private Throwable fJavaCause;
    private AtomicReference<Runnable> fRunnable = new AtomicReference();
    private volatile boolean fDoneCalled;

    private NativeFutureResult(long l) {
        assert (l != 0L);
        this.fNativeID = l;
    }

    V get() throws IllegalStateException, CancellationException, MvmExecutionException {
        return this.nativeGet(this.fNativeID);
    }

    boolean cancel(boolean bl) {
        return this.nativeCancel(this.fNativeID, bl);
    }

    boolean waitForCompletion(double d) throws IllegalStateException {
        return this.nativeWaitForCompletion(this.fNativeID, d);
    }

    boolean isCancelled() {
        return this.nativeIsCancelled(this.fNativeID);
    }

    boolean isDone() {
        return this.nativeIsDone(this.fNativeID);
    }

    void runWhenDone(final @Nullable Runnable runnable) {
        Runnable runnable2;
        if (runnable == null) {
            return;
        }
        final Runnable runnable3 = this.fRunnable.getAndSet(null);
        Runnable runnable4 = runnable2 = runnable3 == null ? runnable : new Runnable(){

            @Override
            public void run() {
                runnable3.run();
                runnable.run();
            }
        };
        if (!this.fRunnable.compareAndSet(null, runnable2)) {
            this.runWhenDone(runnable2);
        } else if (this.fDoneCalled) {
            this.callRunnable();
        }
    }

    private native V nativeGet(long var1);

    private native boolean nativeCancel(long var1, boolean var3);

    private native boolean nativeWaitForCompletion(long var1, double var3);

    private native boolean nativeIsCancelled(long var1);

    private native boolean nativeIsDone(long var1);

    private native void nativeReleaseFutureResult(long var1);

    private void done() {
        assert (!this.fDoneCalled);
        this.fDoneCalled = true;
        this.callRunnable();
    }

    private void callRunnable() {
        assert (this.fDoneCalled);
        Runnable runnable = this.fRunnable.getAndSet(null);
        if (runnable != null) {
            runnable.run();
        }
    }

    private void setJavaCause(Throwable throwable) {
        this.fJavaCause = throwable;
    }

    private Throwable getJavaCause() {
        return this.fJavaCause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.fNativeID != 0L) {
                this.nativeReleaseFutureResult(this.fNativeID);
            }
            this.fNativeID = 0L;
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] serialize(Object object) throws NotSerializableException, InvalidClassException {
        ByteArrayOutputStream byteArrayOutputStream;
        block5: {
            byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                try {
                    objectOutputStream.writeObject(object);
                }
                finally {
                    objectOutputStream.close();
                }
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError();
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object deserialize(byte[] byArray) throws ClassNotFoundException, InvalidClassException, StreamCorruptedException, OptionalDataException {
        Object object;
        block5: {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            object = null;
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                try {
                    object = objectInputStream.readObject();
                }
                finally {
                    objectInputStream.close();
                }
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError();
            }
        }
        return object;
    }

    static {
        MvmImpl.loadLibrary();
    }
}

