/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil;

import com.mathworks.instutil.ExecutorServiceManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public final class ExecutorServiceManagerImpl
implements ExecutorServiceManager {
    private final ExecutorService singleThreadExecutor = Executors.newSingleThreadExecutor();
    private final ExecutorService multiThreadExecutor = Executors.newFixedThreadPool(5);
    private final Collection<Future<?>> tasks = new ArrayList();

    @Override
    public final ExecutorService getMultiThreadedExecutorService() {
        return this.multiThreadExecutor;
    }

    @Override
    public final void shutdownAndAwaitTermination() {
        this.close(Long.MAX_VALUE);
    }

    @Override
    public final synchronized Future<?> submitToSingleThreadedExecutorService(Callable<?> callable) {
        Future<?> future = this.singleThreadExecutor.submit(callable);
        this.tasks.add(future);
        return future;
    }

    @Override
    public final void shutdownAndAwaitTerminationWhenFailed() {
        this.close(90L);
    }

    private void close(long l) {
        this.close(this.singleThreadExecutor, l);
        this.close(this.multiThreadExecutor, l);
    }

    private void close(ExecutorService executorService, long l) {
        executorService.shutdown();
        this.cancelTasks();
        try {
            executorService.awaitTermination(l, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private synchronized void cancelTasks() {
        for (Future<?> future : this.tasks) {
            future.cancel(false);
        }
    }
}

