/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil;

import com.mathworks.instutil.LocalizedHelpPathFinder;
import java.io.File;
import java.text.MessageFormat;
import java.util.Locale;

final class LocalizedHelpPathFinderImpl
implements LocalizedHelpPathFinder {
    private final String resourceKey;
    private final String matlabRoot;
    private File acceptedPath = null;

    LocalizedHelpPathFinderImpl(String string, String string2) {
        this.resourceKey = string;
        this.matlabRoot = string2;
    }

    @Override
    public boolean localizedFileExists() {
        return this.helpFileExistsForLanguageAndCountry() || this.helpFileExistsForLanguage();
    }

    private boolean helpFileExistsForLanguageAndCountry() {
        String string = Locale.getDefault().toString();
        return this.getHelpFile(string);
    }

    private boolean helpFileExistsForLanguage() {
        String string = Locale.getDefault().getLanguage();
        return this.getHelpFile(string);
    }

    private boolean getHelpFile(String string) {
        MessageFormat messageFormat = new MessageFormat(this.resourceKey);
        String string2 = "_" + string;
        String string3 = messageFormat.format(new Object[]{string2});
        File file = new File(this.matlabRoot, string3);
        if (file.isFile()) {
            this.acceptedPath = file;
            return true;
        }
        return false;
    }

    @Override
    public String getAcceptedFilePath() {
        if (this.acceptedPath == null) {
            throw new RuntimeException("The localizedFileExists method should be called prior to the getAcceptedFilePath method.");
        }
        return this.acceptedPath.getAbsolutePath();
    }
}

