/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil.wizard;

import com.mathworks.instutil.wizard.ExceptionHandler;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.net.URI;
import java.util.List;
import javax.swing.text.JTextComponent;

public class TextComponentDropTarget
extends DropTargetAdapter {
    private final ExceptionHandler exceptionHandler;
    private final JTextComponent textComponent;

    public TextComponentDropTarget(ExceptionHandler exceptionHandler, JTextComponent jTextComponent) {
        this.exceptionHandler = exceptionHandler;
        this.textComponent = jTextComponent;
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            DropTargetContext dropTargetContext = dropTargetDropEvent.getDropTargetContext();
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dropTargetDropEvent.acceptDrop(1);
                Object object = transferable.getTransferData(DataFlavor.javaFileListFlavor);
                List list = (List)object;
                if (list.size() > 1) {
                    dropTargetDropEvent.rejectDrop();
                } else {
                    File file = (File)list.get(0);
                    if (file.isFile()) {
                        String string = file.getAbsolutePath();
                        this.textComponent.setText(string);
                    }
                }
                dropTargetContext.dropComplete(true);
            } else if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                dropTargetDropEvent.acceptDrop(2);
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                String string2 = new URI(string.trim()).getPath();
                File file = new File(string2);
                if (file.isFile()) {
                    this.textComponent.setText(string2);
                }
                dropTargetContext.dropComplete(true);
            } else {
                dropTargetDropEvent.rejectDrop();
            }
        }
        catch (Throwable throwable) {
            this.exceptionHandler.handleException(throwable);
            dropTargetDropEvent.rejectDrop();
        }
    }
}

