/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command;

import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.InstallOption;
import com.mathworks.install.command.Command;
import com.mathworks.instutil.FilePermissions;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.IOObserver;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

final class InstallLicenseManagerServiceCommandMac
implements Command {
    static final String LMGR_STARTUP_NAME = "MATLABLmgr";
    static final String STARTUP_PARAMETERS_PLIST_NAME = "StartupParameters.plist";
    static final String PATH_TO_MATLAB_TEMPLATE = "<PATH_TO_MATLAB>";
    static final String USER_NAME_FOR_LICENSE_MANAGER_TEMPLATE = "<USER_NAME_FOR_LICENSE_MANAGER>";
    private static final File TEMP_FOLDER = new File(System.getProperty("java.io.tmpdir"));
    private static final File STARTUP_ITEMS_FOLDER = new File(new File(File.separator + "Library"), "StartupItems");
    private static final File LMGR_STARTUP_FOLDER = new File(STARTUP_ITEMS_FOLDER, "MATLABLmgr");
    private static final File TARGET_LMGR_STARTUP_FILE = new File(LMGR_STARTUP_FOLDER, "MATLABLmgr");
    private static final File TARGET_STARTUP_PARAMETERS_PLIST_FILE = new File(LMGR_STARTUP_FOLDER, "StartupParameters.plist");
    private static final String BACKUP_FILE_DATE_PATTERN = "yyyyMMdd-HHmmss";
    private static final String BACKUP_FILE_EXTENSION_PREFIX = ".bak-";
    private final InstallOption installOption;
    private final IO myIO;
    private final FilePermissions fp;

    InstallLicenseManagerServiceCommandMac(InstallOption installOption, IO iO, FilePermissions filePermissions) {
        this.installOption = installOption;
        this.myIO = iO;
        this.fp = filePermissions;
    }

    @Override
    public void execute(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        this.createStartupItemsFolderIfNecessary();
        this.createLmgrStartupFile(file);
        this.createStartupParametersFile(file);
    }

    private void createStartupItemsFolderIfNecessary() {
        if (!LMGR_STARTUP_FOLDER.isDirectory()) {
            this.myIO.mkdirAsRoot(LMGR_STARTUP_FOLDER.getAbsolutePath());
        }
    }

    private void createLmgrStartupFile(File file) throws IOException, InterruptedException {
        this.createBackupFileIfExists(TARGET_LMGR_STARTUP_FILE);
        File file2 = InstallLicenseManagerServiceCommandMac.getFileInLicenseManagerStartupDirectory(file, LMGR_STARTUP_NAME);
        String string = InstallLicenseManagerServiceCommandMac.replacePathAndUsernameInString(file, this.installOption.getContext(), this.myIO.readFileToString(file2));
        File file3 = new File(TEMP_FOLDER, LMGR_STARTUP_NAME);
        this.myIO.writeStringToFile(string, file3, 0L, 493, new IOObserver[0]);
        this.myIO.cpFileAsRoot(file3.getAbsolutePath(), TARGET_LMGR_STARTUP_FILE.getAbsolutePath());
        file3.deleteOnExit();
    }

    private static String replacePathAndUsernameInString(File file, String string, String string2) throws IOException {
        String string3 = string2;
        string3 = string3.replaceAll(PATH_TO_MATLAB_TEMPLATE, file.getAbsolutePath().replaceAll("\\\\", "\\\\\\\\"));
        string3 = string3.replaceAll(USER_NAME_FOR_LICENSE_MANAGER_TEMPLATE, string);
        return string3;
    }

    private void createStartupParametersFile(File file) throws IOException {
        this.createBackupFileIfExists(TARGET_STARTUP_PARAMETERS_PLIST_FILE);
        File file2 = InstallLicenseManagerServiceCommandMac.getFileInLicenseManagerStartupDirectory(file, STARTUP_PARAMETERS_PLIST_NAME);
        File file3 = new File(TEMP_FOLDER, STARTUP_PARAMETERS_PLIST_NAME);
        this.myIO.copyFile(file2, file3, new IOObserver[0]);
        this.fp.setFilePermissions(file3.getAbsolutePath(), 420);
        this.myIO.cpFileAsRoot(file3.getAbsolutePath(), TARGET_STARTUP_PARAMETERS_PLIST_FILE.getAbsolutePath());
        file3.deleteOnExit();
    }

    private static File getFileInLicenseManagerStartupDirectory(File file, String string) {
        File file2 = new File(file, "etc");
        File file3 = new File(file2, LMGR_STARTUP_NAME);
        return new File(file3, string);
    }

    @Override
    public void undo(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
    }

    private void createBackupFileIfExists(File file) throws IOException {
        if (file.exists()) {
            File file2 = InstallLicenseManagerServiceCommandMac.getBackupFile(file);
            this.myIO.cpFileAsRoot(file.getAbsolutePath(), file2.getAbsolutePath());
        }
    }

    private static File getBackupFile(File file) {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(BACKUP_FILE_DATE_PATTERN);
        return new File(file.getParentFile(), file.getName().concat(BACKUP_FILE_EXTENSION_PREFIX).concat(simpleDateFormat.format(date)));
    }
}

