/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.testmeas.guiutil;

import com.mathworks.mwswing.MJFrame;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;

public class EditTextFieldTableCellEditor
extends DefaultCellEditor
implements FocusListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private AbstractTableModel model;
    private JTextField fTextField;
    private int row;
    private int column;
    private String fLastValidValue = "";
    private boolean fCheckIsVarName = false;
    private String fErrorMsg;
    private String fErrorDialogTitle;
    private MJFrame fParentFrame;

    public EditTextFieldTableCellEditor(AbstractTableModel abstractTableModel, JTextField jTextField, int n, int n2) {
        super(jTextField);
        this.model = abstractTableModel;
        this.fTextField = jTextField;
        this.row = n;
        this.column = n2;
        this.setLastValidValue((String)this.model.getValueAt(n, n2));
        this.fTextField.addFocusListener(this);
        this.fTextField.addActionListener(this);
        this.setClickCountToStart(0);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.updateValue();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.updateValue();
    }

    private void updateValue() {
        this.valdiateVariableName();
        this.setLastValidValue(this.fTextField.getText());
        this.model.setValueAt(this.getLastValidValue(), this.row, this.column);
    }

    protected void valdiateVariableName() {
        if (this.shouldValidateVarName()) {
            if (!TMStringUtil.isvarname(this.fTextField.getText())) {
                this.fTextField.setText(this.getLastValidValue());
                this.displayInvalidVariableError();
            } else {
                this.setLastValidValue(this.fTextField.getText());
            }
        }
    }

    protected void displayInvalidVariableError() {
        TMStringUtil.error(this.getParentFrame(), this.getErrorDialogTitle(), this.getErrorMsg());
    }

    public void checkForValidVariableName(MJFrame mJFrame) {
        this.checkForValidVariableName(mJFrame, "Invalid Variable Name", "The Variable Name must be a valid MATLAB variable name.");
    }

    public void checkForValidVariableName(MJFrame mJFrame, String string, String string2) {
        this.fParentFrame = mJFrame;
        this.fCheckIsVarName = true;
        this.fErrorMsg = string2;
        this.fErrorDialogTitle = string;
    }

    protected boolean shouldValidateVarName() {
        return this.fCheckIsVarName;
    }

    protected JTextField getTextField() {
        return this.fTextField;
    }

    protected String getLastValidValue() {
        return this.fLastValidValue;
    }

    protected void setLastValidValue(String string) {
        this.fLastValidValue = string;
    }

    protected String getErrorMsg() {
        return this.fErrorMsg;
    }

    protected String getErrorDialogTitle() {
        return this.fErrorDialogTitle;
    }

    protected MJFrame getParentFrame() {
        return this.fParentFrame;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }
}

