/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.testmeas.propertyeditor;

import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.toolbox.testmeas.propertyeditor.IPropertySetter;
import com.mathworks.toolbox.testmeas.propertyeditor.MLNumberUtil;
import com.mathworks.toolbox.testmeas.propertyeditor.Property;
import com.mathworks.toolbox.testmeas.propertyeditor.PropertyType;
import com.mathworks.toolbox.testmeas.propertyeditor.ReadStatus;
import com.mathworks.toolbox.testmeas.propertyeditor.UIConstants;
import com.mathworks.toolbox.testmeas.propertyeditor.Widget;
import com.mathworks.toolbox.testmeas.tmswing.TMAbstractStyleGuideJPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.EventListener;
import javax.swing.JComponent;

public class TextFieldWidget
extends Widget {
    private MJTextField fTextField = new MJTextField();
    private volatile boolean fVetoFocusLost = false;

    public TextFieldWidget(IPropertySetter iPropertySetter, Property property) {
        super(iPropertySetter, property);
        this.fTextField.setName(property.getName() + "textfield");
    }

    @Override
    public void addContent(TMAbstractStyleGuideJPanel tMAbstractStyleGuideJPanel) {
        this.fTextField.setColumns(UIConstants.TEXT_FIELD_WIDTH);
        Dimension dimension = this.fTextField.getMinimumSize();
        dimension.width = 30;
        this.fTextField.setMinimumSize(dimension);
        this.updateTextField(this.getProperty().getValue(), true);
        tMAbstractStyleGuideJPanel.addLine((JComponent[][])new JComponent[][]{{this.fTextField, null}}, 0, 1);
        if (this.getProperty().getReadStauts() == ReadStatus.READ_ONLY) {
            return;
        }
        this.fTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextFieldWidget.this.fVetoFocusLost = true;
                TextFieldWidget.this.set(TextFieldWidget.this.fTextField.getText(), (Component)TextFieldWidget.this.fTextField);
            }
        });
        this.fTextField.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (TextFieldWidget.this.fVetoFocusLost) {
                    return;
                }
                TextFieldWidget.this.set(TextFieldWidget.this.fTextField.getText(), (Component)TextFieldWidget.this.fTextField);
            }
        });
    }

    @Override
    public void displayValue(Object object) {
        this.updateTextField(object, false);
    }

    @Override
    public void enableWidget(boolean bl) {
        this.fTextField.setEnabled(bl);
    }

    @Override
    public void cleanup() {
        ActionListener[] actionListenerArray = this.fTextField.getActionListeners();
        EventListener[] eventListenerArray = actionListenerArray;
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ActionListener actionListener = eventListenerArray[i];
            this.fTextField.removeActionListener(actionListener);
        }
        for (EventListener eventListener : eventListenerArray = this.fTextField.getFocusListeners()) {
            this.fTextField.removeFocusListener((FocusListener)eventListener);
        }
    }

    protected void updateTextField(final Object object, final boolean bl) {
        if (object instanceof String) {
            this.fTextField.setText(String.valueOf(object));
            if (this.fTextField.getText().length() > 0 && bl) {
                this.fTextField.setCaretPosition(0);
            }
            this.fVetoFocusLost = false;
        } else {
            new MatlabWorker(){

                public Object runOnMatlabThread() throws Exception {
                    if (TextFieldWidget.this.getProperty().getType() == PropertyType.STRING && TextFieldWidget.this.getProperty().getValue() == null) {
                        return "";
                    }
                    return MLNumberUtil.getString(TextFieldWidget.this.getProperty().isMatrix(), object);
                }

                public void runOnAWTEventDispatchThread(Object object2) {
                    TextFieldWidget.this.fTextField.setText((String)object2);
                    if (TextFieldWidget.this.fTextField.getText().length() > 0 && bl) {
                        TextFieldWidget.this.fTextField.setCaretPosition(0);
                    }
                    TextFieldWidget.this.fVetoFocusLost = false;
                }
            }.start();
        }
    }

    protected MJTextField getTextField() {
        return this.fTextField;
    }
}

