/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.testmeas.tmswing.table;

import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.TableModelWrapper;
import com.mathworks.toolbox.testmeas.tmswing.table.ColumnInfo;
import com.mathworks.toolbox.testmeas.tmswing.table.ColumnInfoTableModel;
import com.mathworks.util.Pair;
import java.awt.Color;
import java.awt.Component;
import java.awt.SystemColor;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.CompoundBorder;
import javax.swing.table.TableCellRenderer;

public class AnnotationCellRenderer
implements TableCellRenderer {
    private TableCellRenderer fDelegateRenderer;

    public AnnotationCellRenderer(TableCellRenderer tableCellRenderer) {
        this.fDelegateRenderer = tableCellRenderer;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        int n3;
        assert (jTable instanceof SortableTable) : "Annotation only works with Sortable table";
        JComponent jComponent = (JComponent)this.fDelegateRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        ColumnInfoTableModel columnInfoTableModel = (ColumnInfoTableModel)((TableModelWrapper)jTable.getModel()).getActualModel();
        ColumnInfo columnInfo = columnInfoTableModel.getColumnInfo(n2);
        Pair<ColumnInfo.Annotation, String> pair = columnInfo.getAnnotationMessage(n3 = ((SortableTable)jTable).getActualRowAt(n));
        if (pair.getFirst() == ColumnInfo.Annotation.NORMAL) {
            return jComponent;
        }
        return this.decorateCell(jComponent, (ColumnInfo.Annotation)((Object)pair.getFirst()), (String)pair.getSecond());
    }

    private Component decorateCell(JComponent jComponent, ColumnInfo.Annotation annotation, String string) {
        Color color = Color.RED;
        switch (annotation) {
            case NORMAL: {
                assert (false) : "decoration cannot be applied for normal cells.";
                break;
            }
            case WARNING: {
                color = Color.YELLOW;
                break;
            }
            case ERROR: {
                color = Color.RED;
                break;
            }
            default: {
                assert (false) : "unknown annotation type in cell renderer.";
                break;
            }
        }
        jComponent.setToolTipText("<html>" + string.replaceAll("\\n", "<br>") + "</html>");
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(SystemColor.red, 2), BorderFactory.createEmptyBorder(1, 1, 1, 1));
        jComponent.setBorder(compoundBorder);
        return jComponent;
    }
}

