/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.testmeas.util;

import com.mathworks.services.Prefs;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class PreferenceFile {
    private static final ResourceBundle sResource = ResourceBundle.getBundle("com.mathworks.toolbox.testmeas.util.resource.RES_TMUTIL");
    private String filename = "";
    private File file = null;

    public PreferenceFile(String string) {
        this.filename = Prefs.getPropertyDirectory() + System.getProperty("file.separator") + string;
    }

    public boolean exist() {
        return new File(this.filename).exists();
    }

    public String read(String string) {
        try {
            String string2 = this.readFileData();
            int n = string2.indexOf("<" + string + ">");
            if (n != -1) {
                int n2 = string2.indexOf("</" + string + ">");
                return string2.substring(n + 2 + string.length() + 1, n2);
            }
            return "";
        }
        catch (Exception exception) {
            String string3 = MessageFormat.format(sResource.getString("TMPreferences.CorruptFileError"), this.filename);
            System.out.println(string3);
            return "";
        }
    }

    public boolean tagExists(String string) {
        String string2 = this.readFileData();
        int n = string2.indexOf("<" + string + ">");
        return n != -1;
    }

    public void update(String string, String string2) {
        String string3 = this.readFileData();
        int n = string3.indexOf("<" + string + ">");
        if (n != -1) {
            int n2 = string3.indexOf("</" + string + ">");
            String string4 = string3.substring(0, n);
            String string5 = string3.substring(n2 + 3 + string.length());
            string3 = string4 + "<" + string + ">\n" + string2 + "</" + string + ">" + string5;
        } else {
            string3 = string3 + "\n<" + string + ">\n" + string2 + "</" + string + ">";
        }
        string3 = TMStringUtil.removeTrailingCRLF(string3);
        this.writeFileData(string3);
    }

    private void writeFileData(String string) {
        block2: {
            try {
                PrintWriter printWriter = new PrintWriter(new FileOutputStream(this.file));
                printWriter.println(string);
                printWriter.close();
            }
            catch (Exception exception) {
                if (this.file.canWrite()) break block2;
                System.out.println(sResource.getString("TMPreferences.ReadOnlyError"));
                System.out.println(this.file.getAbsolutePath());
            }
        }
        this.file = null;
    }

    private String readFileData() {
        BufferedReader bufferedReader = null;
        try {
            this.file = new File(this.filename);
            bufferedReader = new BufferedReader(new FileReader(this.filename));
            char[] cArray = new char[(int)this.file.length()];
            bufferedReader.read(cArray, 0, cArray.length);
            bufferedReader.close();
            bufferedReader = null;
            return new String(cArray);
        }
        catch (Exception exception) {
            return "";
        }
    }
}

