/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.AxisCanvas;
import com.mathworks.hg.peer.FigurePeer;
import com.mathworks.hg.peer.FigureValidator;
import com.mathworks.hg.peer.UIComponentParent;
import com.mathworks.hg.peer.UnitPos;
import com.mathworks.hg.peer.event.ActiveXPositionEvent;
import com.mathworks.hg.peer.event.ActiveXPositionListener;
import com.mathworks.hg.types.HGRectangle;
import com.mathworks.hg.util.HGPeerQueueUser;
import com.mathworks.hg.util.HGPeerRunnable;
import com.mathworks.hg.util.HGUtils;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabMCR;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.EventListener;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

public class ActiveXCanvas
extends AxisCanvas
implements HGPeerQueueUser {
    private UIComponentParent fCompParent;
    private long fControlHwnd;
    private static int sPositionChangeID = 0;
    private static String[] sPositionChangeDescriptions = new String[]{"PositionChanged"};
    private EventListenerList fListenerList = new EventListenerList();
    private MatlabMCR fMatlabMCR = new MatlabMCR();
    private double fHGX = 0.0;
    private double fHGY = 0.0;
    private double fHGW = 0.0;
    private double fHGH = 0.0;

    public ActiveXCanvas(UIComponentParent uIComponentParent) {
        this.fCompParent = uIComponentParent;
        this.fControlHwnd = 0L;
        if (Matlab.isMatlabAvailable()) {
            System.loadLibrary("nativehg");
        }
    }

    void setNativeControlWindowHandle(long l) {
        this.fControlHwnd = l;
    }

    public long getNativeControlWindowHandle() {
        if (this.fControlHwnd == 0L) {
            this.fControlHwnd = this.getNativeActiveXControlWindowHandle();
        }
        return this.fControlHwnd;
    }

    native long getNativeActiveXControlWindowHandle();

    native void preRemoveNotify(long var1, long var3);

    native void postAddNotify(long var1, long var3);

    @Override
    public void addNotify() {
        super.addNotify();
        this.postAddNotify(this.getNativeControlWindowHandle(), this.getNativeWindowHandle());
        ActiveXCanvas.nativeEnableCanvasEvents(this.getNativeWindowHandle());
    }

    @Override
    public void removeNotify() {
        this.preRemoveNotify(this.getNativeControlWindowHandle(), this.getNativeWindowHandle());
        ActiveXCanvas.nativeDisableCanvasEvents(this.getNativeWindowHandle());
        super.removeNotify();
    }

    public void setPosition(final double d, final double d2, final double d3, final double d4) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setPositionAWT(d, d2, d3, d4);
        } else {
            HGUtils.invokeLater(new HGPeerRunnable(this, sPositionChangeID, 7){

                @Override
                public void run() {
                    ActiveXCanvas.this.setPositionAWT(d, d2, d3, d4);
                }
            });
        }
    }

    void setPositionAWT(double d, double d2, double d3, double d4) {
        Dimension dimension = ((FigurePeer)this.fCompParent).getWindowRect().getSize();
        this.setBounds(UnitPos.pixelPositionToBounds(new HGRectangle(d, d2, d3, d4), dimension));
        if (this.fHGX != d || this.fHGY != d2 || this.fHGW != d3 || this.fHGH != d4) {
            this.fHGX = d;
            this.fHGY = d2;
            this.fHGW = d3;
            this.fHGH = d4;
            this.fireActiveXPositionChange(new ActiveXPositionEvent(this, new double[]{d, d2, d3, d4}));
        }
    }

    private native void paintNativeChildren();

    public void paintChildren() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ActiveXCanvas.this.paintNativeChildren();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            this.fMatlabMCR.whenMatlabReady(runnable);
        } else {
            runnable.run();
        }
    }

    @Override
    public void paintCallback(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        graphics.setColor(this.getParent().getBackground());
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle == null) {
            rectangle = this.getBounds();
        }
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public int getUserLastMethodID() {
        return sPositionChangeDescriptions.length;
    }

    @Override
    public String getUserMethodDescription(int n) {
        return sPositionChangeDescriptions[n];
    }

    @Override
    public FigureValidator getParentFigureValidator() {
        return this.fCompParent;
    }

    public synchronized void removeActiveXPositionListener(ActiveXPositionListener activeXPositionListener) {
        this.fListenerList.remove(ActiveXPositionListener.class, activeXPositionListener);
    }

    public synchronized void addActiveXPositionListener(ActiveXPositionListener activeXPositionListener) {
        this.fListenerList.add(ActiveXPositionListener.class, activeXPositionListener);
    }

    private synchronized EventListener[] getListeners() {
        return this.fListenerList.getListeners(ActiveXPositionListener.class);
    }

    protected void fireActiveXPositionChange(ActiveXPositionEvent activeXPositionEvent) {
        EventListener[] eventListenerArray;
        for (EventListener eventListener : eventListenerArray = this.getListeners()) {
            ((ActiveXPositionListener)eventListener).PositionChanged(activeXPositionEvent);
        }
    }

    private static native void nativeEnableCanvasEvents(long var0);

    private static native void nativeDisableCanvasEvents(long var0);
}

