/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.ComponentPositionListener;
import com.mathworks.hg.peer.IPositionable;
import com.mathworks.hg.peer.PositionData;
import com.mathworks.hg.peer.PositionDataInDevice;
import com.mathworks.hg.peer.PositionDataInMatlab;
import com.mathworks.hg.peer.PositionEvent;
import com.mathworks.hg.peer.PositionListener;
import com.mathworks.hg.peer.UIComponentParentWithLayout;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.EventListener;
import javax.swing.event.EventListenerList;

public class PositionHandler {
    protected static boolean sRunOldStyle = true;
    private EventListenerList fListenerList = new EventListenerList();
    private final Object fLockModelListeners = new Object();
    private IPositionable fPosPeer = null;
    private ComponentPositionListener fPeerListener = null;
    private Rectangle fMLOuterBounds = new Rectangle(0, 0, 0, 0);
    private final Object fLockOuterBounds = new Object();
    private Dimension fRefFrame = null;
    private UIComponentParentWithLayout fParentWithLayout = null;

    protected static void setRunOldStyle(boolean bl) {
        sRunOldStyle = bl;
    }

    public PositionHandler(IPositionable iPositionable) {
        this.fPosPeer = iPositionable;
    }

    public void peerCreated() {
        this.fPeerListener = this.fPosPeer.createPeerPositionListener();
        this.fPosPeer.addPeerPositionListener(this.fPeerListener);
    }

    public void peerDestroyed() {
        assert (this.fPosPeer != null);
        this.fPosPeer.removePeerPositionListener(this.fPeerListener);
        this.fPeerListener = null;
    }

    public void setParentForRefFrame(UIComponentParentWithLayout uIComponentParentWithLayout) {
        this.fParentWithLayout = uIComponentParentWithLayout;
    }

    public void setPosition(int n, int n2, int n3, int n4) {
        Cloneable cloneable;
        boolean bl = this.isEqualToMLOuterRect(n, n2, n3, n4);
        if (!bl) {
            cloneable = new Rectangle(n, n2, n3, n4);
            this.setMLOuterRect((Rectangle)cloneable);
        }
        if (this.fParentWithLayout == null) {
            return;
        }
        cloneable = this.fParentWithLayout.getClientAreaSize();
        boolean bl2 = this.isEqualToRefFrame((Dimension)cloneable);
        if (!bl || !bl2) {
            this.setRefFrame((Dimension)cloneable);
            this.updatePeerBounds();
        }
    }

    public void updatePosition() {
        assert (this.fParentWithLayout != null);
        Dimension dimension = this.fParentWithLayout.getClientAreaSize();
        boolean bl = this.isEqualToRefFrame(dimension);
        if (!bl) {
            this.setRefFrame(dimension);
        }
        this.updatePeerBounds();
    }

    private void updatePeerBounds() {
        Rectangle rectangle = this.getMLOuterRect();
        Dimension dimension = this.getRefFrame();
        if (sRunOldStyle) {
            this.fPosPeer.doSetPosition(rectangle);
        } else {
            Rectangle rectangle2 = PositionData.getDeviceFromMatlab(rectangle, dimension);
            this.fPosPeer.doSetPosition(rectangle2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPositionListener(PositionListener positionListener) {
        Object object = this.fLockModelListeners;
        synchronized (object) {
            this.fListenerList.add(PositionListener.class, positionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePositionListener(PositionListener positionListener) {
        Object object = this.fLockModelListeners;
        synchronized (object) {
            this.fListenerList.remove(PositionListener.class, positionListener);
        }
    }

    public Dimension getClientAreaSize() {
        return this.getMLOuterRect().getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void positionChanged() {
        if (this.fParentWithLayout == null) {
            return;
        }
        Dimension dimension = this.fParentWithLayout.getClientAreaSize();
        PositionDataInDevice positionDataInDevice = this.fPosPeer.getPositionInDevice();
        PositionDataInMatlab positionDataInMatlab = new PositionDataInMatlab(positionDataInDevice, dimension);
        if (!sRunOldStyle) {
            this.setMLOuterRect(positionDataInMatlab.getOuterBounds());
            this.setRefFrame(dimension);
        }
        PositionEvent positionEvent = new PositionEvent((Object)this.fPosPeer, positionDataInMatlab);
        EventListener[] eventListenerArray = null;
        EventListener[] eventListenerArray2 = this.fLockModelListeners;
        synchronized (this.fLockModelListeners) {
            eventListenerArray = this.fListenerList.getListeners(PositionListener.class);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            for (EventListener eventListener : eventListenerArray) {
                ((PositionListener)eventListener).positionChanged(positionEvent);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRefFrame(Dimension dimension) {
        Object object = this.fLockOuterBounds;
        synchronized (object) {
            this.fRefFrame = new Dimension(dimension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension getRefFrame() {
        Dimension dimension = null;
        Object object = this.fLockOuterBounds;
        synchronized (object) {
            dimension = new Dimension(this.fRefFrame);
        }
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMLOuterRect(Rectangle rectangle) {
        Object object = this.fLockOuterBounds;
        synchronized (object) {
            this.fMLOuterBounds = new Rectangle(rectangle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Rectangle getMLOuterRect() {
        Rectangle rectangle = null;
        Object object = this.fLockOuterBounds;
        synchronized (object) {
            rectangle = new Rectangle(this.fMLOuterBounds);
        }
        return rectangle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEqualToMLOuterRect(int n, int n2, int n3, int n4) {
        boolean bl = false;
        Object object = this.fLockOuterBounds;
        synchronized (object) {
            if (this.fMLOuterBounds != null) {
                bl = this.fMLOuterBounds.x == n && this.fMLOuterBounds.y == n2 && this.fMLOuterBounds.width == n3 && this.fMLOuterBounds.height == n4;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEqualToRefFrame(Dimension dimension) {
        boolean bl = false;
        Object object = this.fLockOuterBounds;
        synchronized (object) {
            if (this.fRefFrame != null) {
                bl = this.fRefFrame.width == dimension.width && this.fRefFrame.height == dimension.height;
            }
        }
        return bl;
    }

    public Rectangle getPosition() {
        return this.getMLOuterRect();
    }
}

