/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.AbstractButtonPeer;
import com.mathworks.hg.peer.AbstractUicontrolPeer;
import com.mathworks.hg.peer.CheckboxPeer;
import com.mathworks.hg.peer.ComboboxPeer;
import com.mathworks.hg.peer.EditTextPeer;
import com.mathworks.hg.peer.FramePeer;
import com.mathworks.hg.peer.LabelPeer;
import com.mathworks.hg.peer.ListboxPeer;
import com.mathworks.hg.peer.PushButtonPeer;
import com.mathworks.hg.peer.RadioButtonPeer;
import com.mathworks.hg.peer.SliderPeer;
import com.mathworks.hg.peer.ToggleButtonPeer;
import java.awt.Color;

public abstract class UicontrolBuilder {
    public static final int INVALID = -1;
    public static final int PUSHBUTTON = 0;
    public static final int SLIDER = 1;
    public static final int RADIOBUTTON = 2;
    public static final int CHECKBOX = 3;
    public static final int EDIT = 4;
    public static final int TEXT = 5;
    public static final int FRAME = 6;
    public static final int POPUPMENU = 7;
    public static final int LISTBOX = 8;
    public static final int TOGGLEBUTTON = 9;
    private static String[] sStyle = new String[]{"pushbutton", "slider", "radiobutton", "checkbox", "edit", "text", "frame", "popupmenu", "listbox", "togglebutton"};

    public static AbstractUicontrolPeer createControl(String string) {
        return UicontrolBuilder.createControl(UicontrolBuilder.styleToInt(string));
    }

    public static AbstractUicontrolPeer createControl(int n) {
        switch (n) {
            case 0: {
                return new PushButtonPeer();
            }
            case 9: {
                return new ToggleButtonPeer();
            }
            case 2: {
                return new RadioButtonPeer();
            }
            case 3: {
                return new CheckboxPeer();
            }
            case 4: {
                return new EditTextPeer();
            }
            case 5: {
                return new LabelPeer();
            }
            case 1: {
                return new SliderPeer();
            }
            case 6: {
                return new FramePeer();
            }
            case 8: {
                return new ListboxPeer();
            }
            case 7: {
                return new ComboboxPeer();
            }
        }
        return new PushButtonPeer();
    }

    public static void setFactoryBackgroundColor(int n) {
        Color color = new Color((n & 0xFF000000) >> 24 & 0xFF, (n & 0xFF0000) >> 16 & 0xFF, (n & 0xFF00) >> 8 & 0xFF);
        AbstractButtonPeer.setFactoryColor(color);
    }

    private static int styleToInt(String string) {
        int n = 0;
        int n2 = -1;
        for (int i = 0; i < sStyle.length; ++i) {
            if (!sStyle[i].startsWith(string.toLowerCase())) continue;
            n2 = i;
            ++n;
        }
        if (n == 1) {
            return n2;
        }
        return -1;
    }
}

