/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.FigureChild;
import com.mathworks.hg.peer.UicontrolMouseWheelListener;
import com.mathworks.hg.peer.event.DataChangedEvent;
import com.mathworks.hg.peer.event.DataChangedListener;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.mwswing.SynchronousInvokeUtility;
import com.mathworks.widgets.spreadsheet.SpreadsheetCellEditor;
import com.mathworks.widgets.spreadsheet.SpreadsheetCellRenderer;
import com.mathworks.widgets.spreadsheet.SpreadsheetScrollPane;
import com.mathworks.widgets.spreadsheet.SpreadsheetTable;
import com.mathworks.widgets.spreadsheet.format.FormatIdentifier;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseWheelListener;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class UitablePeer
extends FigureChild {
    private PeerSpreadsheetTable fTable;
    private DefaultTableModel fTableModel;
    private SpreadsheetScrollPane fTableScrollPane;
    private int fRowCount;
    private int fColumnCount;
    private int fRowHeight;
    private int fColumnWidth;
    private float[] fGridColor = new float[3];
    private Vector fSpreadsheetCellRenderers = new Vector(5, 5);
    protected Hashtable fCustomRenderers = new Hashtable();
    protected Hashtable fCustomEditors = new Hashtable();
    private TableModelListener fTableChangeListener;
    private EventListenerList listenerList = new EventListenerList();

    public UitablePeer(DefaultTableModel defaultTableModel) {
        super(20.0, 20.0, 75.0, 75.0);
        this.fTableModel = defaultTableModel;
        this.init();
    }

    private final void init() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                assert (SwingUtilities.isEventDispatchThread());
                UitablePeer.this.fTable = new PeerSpreadsheetTable(UitablePeer.this.fTableModel);
                ((UitablePeer)UitablePeer.this).fGridColor[0] = 0.502f;
                ((UitablePeer)UitablePeer.this).fGridColor[1] = 0.502f;
                ((UitablePeer)UitablePeer.this).fGridColor[2] = 0.502f;
                UitablePeer.this.fRowCount = UitablePeer.this.fTableModel.getRowCount();
                UitablePeer.this.fColumnCount = UitablePeer.this.fTableModel.getColumnCount();
                UitablePeer.this.fRowHeight = UitablePeer.this.fTable.getRowHeight();
                UitablePeer.this.fColumnWidth = 0;
                UitablePeer.this.fTable.setAutoResizeMode(0);
                UitablePeer.this.fTable.setScheme(2);
                UitablePeer.this.fTableChangeListener = new TableChangeListener();
                UitablePeer.this.fTableModel.addTableModelListener(UitablePeer.this.fTableChangeListener);
                UitablePeer.this.fTableScrollPane = new SpreadsheetScrollPane((JTable)((Object)UitablePeer.this.fTable));
                UitablePeer.this.fTableScrollPane.addMouseWheelListener((MouseWheelListener)new UicontrolMouseWheelListener(UitablePeer.this.getUIComponentParent()));
                UitablePeer.this.setFigureComponent((Component)UitablePeer.this.fTableScrollPane);
            }
        };
        SynchronousInvokeUtility.queueSynchronousEvent((SynchronousInvokeUtility.SynchronousEvent)new SynchronousInvokeUtility.SynchronousEventAdapter(runnable), (boolean)false);
    }

    public SpreadsheetTable getTable() {
        return this.fTable;
    }

    public JScrollPane getTableScrollPane() {
        return this.fTableScrollPane;
    }

    public TableModel getTableModel() {
        return this.fTableModel;
    }

    public void setTableModel(final DefaultTableModel defaultTableModel) {
        if (null != this.fTableModel) {
            this.fTableModel.removeTableModelListener(this.fTableChangeListener);
        }
        this.fTableModel = defaultTableModel;
        this.fTableModel.addTableModelListener(this.fTableChangeListener);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UitablePeer.this.fTable.setModel(defaultTableModel);
            }
        });
    }

    public void cleanup() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UitablePeer.this.fTableModel.removeTableModelListener(UitablePeer.this.fTableChangeListener);
                UitablePeer.this.fTableChangeListener = null;
                UitablePeer.this.fCustomRenderers = null;
                UitablePeer.this.fCustomEditors = null;
                if (null != UitablePeer.this.fSpreadsheetCellRenderers) {
                    for (int i = 0; i < UitablePeer.this.fSpreadsheetCellRenderers.size(); ++i) {
                        ((SpreadsheetCellRenderer)UitablePeer.this.fSpreadsheetCellRenderers.elementAt(i)).cleanup();
                    }
                }
                UitablePeer.this.fSpreadsheetCellRenderers = null;
                if (null != UitablePeer.this.fTableScrollPane) {
                    UitablePeer.this.fTableScrollPane.cleanup();
                }
                UitablePeer.this.fTableScrollPane = null;
                if (null != UitablePeer.this.fTable) {
                    UitablePeer.this.fTable.cleanup();
                }
                UitablePeer.this.fTable = null;
            }
        });
    }

    public int getColumnWidth() {
        if (this.fColumnWidth == 0) {
            try {
                this.fColumnWidth = this.fTable.getColumnModel().getColumn(0).getWidth();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.fColumnWidth;
    }

    public void setColumnWidth(final int n) {
        this.fColumnWidth = n;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i <= UitablePeer.this.fTable.getColumnCount() - 1; ++i) {
                    UitablePeer.this.fTable.getColumnModel().getColumn(i).setPreferredWidth(n);
                }
            }
        });
    }

    public int getColumnWidth(int n) {
        return this.fTable.getColumnModel().getColumn(n).getWidth();
    }

    public void setColumnWidth(final int n, final int n2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UitablePeer.this.fTable.getColumnModel().getColumn(n).setPreferredWidth(n2);
            }
        });
    }

    public int getRowHeight() {
        return this.fRowHeight;
    }

    public void setRowHeight(final int n) {
        this.fRowHeight = n;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UitablePeer.this.fTable.setRowHeight(n);
            }
        });
    }

    public int getRowHeight(int n) {
        return this.fTable.getRowHeight(n);
    }

    public void setRowHeight(final int n, final int n2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UitablePeer.this.fTable.setRowHeight(n, n2);
            }
        });
    }

    public int getNumColumns() {
        return this.fColumnCount;
    }

    public void setNumColumns(final int n) {
        this.fColumnCount = n;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UitablePeer.this.fTableModel.setColumnCount(n);
            }
        });
    }

    public int getNumRows() {
        return this.fRowCount;
    }

    public void setNumRows(final int n) {
        this.fRowCount = n;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UitablePeer.this.fTableModel.setRowCount(n);
            }
        });
    }

    public float[] getGridColor() {
        return this.fGridColor;
    }

    public void setGridColor(String string) {
        Color color = Color.black;
        if (string.regionMatches(true, 0, "red", 0, string.length())) {
            color = Color.red;
        } else if (string.regionMatches(true, 2, "black", 2, string.length()) && string.regionMatches(true, 0, "bl", 0, 2) || string.equals("k")) {
            color = Color.black;
        } else if (string.regionMatches(true, 0, "blue", 0, string.length())) {
            color = Color.blue;
        } else if (string.regionMatches(true, 0, "green", 0, string.length())) {
            color = Color.green;
        } else if (string.regionMatches(true, 0, "cyan", 0, string.length())) {
            color = Color.cyan;
        } else if (string.regionMatches(true, 0, "magenta", 0, string.length())) {
            color = Color.magenta;
        } else if (string.regionMatches(true, 0, "yellow", 0, string.length())) {
            color = Color.yellow;
        }
        float[] fArray = null;
        float[] fArray2 = color.getRGBColorComponents(fArray);
        this.fGridColor[0] = fArray2[0];
        this.fGridColor[1] = fArray2[1];
        this.fGridColor[2] = fArray2[2];
        final Color color2 = color;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UitablePeer.this.fTable.setGridColor(color2);
            }
        });
    }

    public void setGridColor(float[] fArray) {
        if (fArray.length == 3) {
            Color color;
            this.fGridColor[0] = fArray[0];
            this.fGridColor[1] = fArray[1];
            this.fGridColor[2] = fArray[2];
            final Color color2 = color = new Color(fArray[0], fArray[1], fArray[2]);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UitablePeer.this.fTable.setGridColor(color2);
                }
            });
        } else {
            System.out.println("Invalid RGB vector.  Must be 1x3");
        }
    }

    public Object[][] getData() {
        Object[][] objectArray = new Object[this.fTableModel.getRowCount()][this.fTableModel.getColumnCount()];
        for (int i = 0; i < this.fTableModel.getRowCount(); ++i) {
            for (int j = 0; j < this.fTableModel.getColumnCount(); ++j) {
                objectArray[i][j] = this.fTableModel.getValueAt(i, j);
            }
        }
        return objectArray;
    }

    public void setData(final Object[][] objectArray) {
        if (objectArray != null) {
            if (objectArray.length == 0 || objectArray[0].length == 0) {
                System.err.println("Error: Data must be a MATLAB cell array");
                return;
            }
            if (objectArray[0].length != this.fColumnCount) {
                this.setNumColumns(objectArray[0].length);
            }
            this.setNumRows(objectArray.length);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < UitablePeer.this.getNumRows(); ++i) {
                        for (int j = 0; j < UitablePeer.this.getNumColumns(); ++j) {
                            UitablePeer.this.fTableModel.setValueAt(objectArray[i][j], i, j);
                        }
                    }
                }
            });
        }
    }

    public Object[] getColumnNames() {
        Object[] objectArray = new Object[this.fTableModel.getColumnCount()];
        for (int i = 0; i < this.fTableModel.getColumnCount(); ++i) {
            objectArray[i] = this.fTableModel.getColumnName(i);
        }
        return objectArray;
    }

    public void setColumnNames(final Object[] objectArray) {
        if (objectArray != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UitablePeer.this.fTableModel.setColumnIdentifiers(objectArray);
                    for (int i = 0; i < UitablePeer.this.fColumnCount; ++i) {
                        Object object = null;
                        if (UitablePeer.this.fCustomRenderers.containsKey(new Integer(i))) {
                            object = (TableCellRenderer)UitablePeer.this.fCustomRenderers.get(new Integer(i));
                        } else {
                            object = new SpreadsheetCellRenderer();
                            UitablePeer.this.fSpreadsheetCellRenderers.addElement(object);
                        }
                        UitablePeer.this.fTable.getColumn(UitablePeer.this.fTable.getColumnName(i)).setCellRenderer((TableCellRenderer)object);
                        if (UitablePeer.this.fCustomEditors.containsKey(new Integer(i))) {
                            UitablePeer.this.fTable.getColumn(UitablePeer.this.fTable.getColumnName(i)).setCellEditor((DefaultCellEditor)UitablePeer.this.fCustomEditors.get(new Integer(i)));
                            continue;
                        }
                        UitablePeer.this.fTable.getColumn(UitablePeer.this.fTable.getColumnName(i)).setCellEditor((TableCellEditor)new SpreadsheetCellEditor((JTextField)new MJTextField(), FormatIdentifier.getDefaultInstance()));
                    }
                }
            });
        }
    }

    public boolean isEditable() {
        return this.fTable.isEditable();
    }

    public boolean isEditable(final int n) {
        SynchronousInvokeRunnable synchronousInvokeRunnable = new SynchronousInvokeRunnable(){

            @Override
            public void run() {
                this.setResult(new Boolean(UitablePeer.this.fTable.isColumnEditable(n - 1)));
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            synchronousInvokeRunnable.run();
        } else {
            SynchronousInvokeUtility.queueSynchronousEvent((SynchronousInvokeUtility.SynchronousEvent)new SynchronousInvokeUtility.SynchronousEventAdapter((Runnable)synchronousInvokeRunnable));
        }
        return (Boolean)synchronousInvokeRunnable.getResult();
    }

    public void setEditable(final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UitablePeer.this.fTable.setEditable(bl);
            }
        });
    }

    public void setEditable(final int n, final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UitablePeer.this.fTable.setColumnEditable(n - 1, bl);
            }
        });
    }

    public boolean isEnabled(final int n) {
        SynchronousInvokeRunnable synchronousInvokeRunnable = new SynchronousInvokeRunnable(){

            @Override
            public void run() {
                TableColumn tableColumn = UitablePeer.this.fTable.getColumnModel().getColumn(n - 1);
                boolean bl = ((Component)((Object)tableColumn.getCellRenderer())).isEnabled();
                this.setResult(new Boolean(bl));
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            synchronousInvokeRunnable.run();
        } else {
            SynchronousInvokeUtility.queueSynchronousEvent((SynchronousInvokeUtility.SynchronousEvent)new SynchronousInvokeUtility.SynchronousEventAdapter((Runnable)synchronousInvokeRunnable));
        }
        return (Boolean)synchronousInvokeRunnable.getResult();
    }

    public void setEnabled(final int n, final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UitablePeer.this.fTable.setColumnEditable(n - 1, bl);
                TableColumn tableColumn = UitablePeer.this.fTable.getColumnModel().getColumn(n - 1);
                ((Component)((Object)tableColumn.getCellRenderer())).setEnabled(bl);
                UitablePeer.this.fTable.updateUI();
            }
        });
    }

    public synchronized void addTableChangeListener(DataChangedListener dataChangedListener) {
        this.listenerList.add(DataChangedListener.class, dataChangedListener);
    }

    public synchronized void removeTableChangeListener(DataChangedListener dataChangedListener) {
        this.listenerList.remove(DataChangedListener.class, dataChangedListener);
    }

    protected void fireDataChanged(DataChangedEvent dataChangedEvent) {
        EventListener[] eventListenerArray = this.listenerList.getListeners(DataChangedListener.class);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((DataChangedListener)eventListenerArray[i]).dataChanged(dataChangedEvent);
        }
    }

    public void setComboBoxEditor(final Object[] objectArray, final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                assert (SwingUtilities.isEventDispatchThread());
                int n2 = n - 1;
                Object[] objectArray2 = (String[])objectArray[0];
                MJComboBox mJComboBox = new MJComboBox(objectArray2);
                TableColumn tableColumn = UitablePeer.this.fTable.getColumnModel().getColumn(n2);
                tableColumn.setCellRenderer(new ComboBoxRenderer((String[])objectArray2));
                tableColumn.setCellEditor(new DefaultCellEditor((JComboBox<?>)mJComboBox));
                UitablePeer.this.fCustomRenderers.put(new Integer(n2), tableColumn.getCellRenderer());
                UitablePeer.this.fCustomEditors.put(new Integer(n2), tableColumn.getCellEditor());
            }
        });
    }

    public void setCheckBoxEditor(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                assert (SwingUtilities.isEventDispatchThread());
                int n2 = n - 1;
                TableColumn tableColumn = UitablePeer.this.fTable.getColumnModel().getColumn(n2);
                MJCheckBox mJCheckBox = new MJCheckBox();
                mJCheckBox.setHorizontalAlignment(0);
                tableColumn.setCellRenderer(new CheckBoxRenderer());
                tableColumn.setCellEditor(new DefaultCellEditor((JCheckBox)mJCheckBox));
                UitablePeer.this.fCustomRenderers.put(new Integer(n2), tableColumn.getCellRenderer());
                UitablePeer.this.fCustomEditors.put(new Integer(n2), tableColumn.getCellEditor());
            }
        });
    }

    class PeerSpreadsheetTable
    extends SpreadsheetTable {
        private Hashtable fNotEditableColumns;

        public PeerSpreadsheetTable() {
            this.fNotEditableColumns = new Hashtable();
        }

        public PeerSpreadsheetTable(TableModel tableModel) {
            super(tableModel);
            this.fNotEditableColumns = new Hashtable();
        }

        public void setColumnEditable(int n, boolean bl) {
            if (bl) {
                this.fNotEditableColumns.remove(new Integer(n));
            } else {
                this.fNotEditableColumns.put(new Integer(n), this);
            }
            this.reexamineEditingActions();
        }

        public void setColumnEditable(String string, boolean bl) {
            TableColumn tableColumn = UitablePeer.this.fTable.getColumn(string);
            int n = tableColumn.getModelIndex();
            this.setColumnEditable(n, bl);
        }

        public boolean isColumnEditable(int n) {
            return !this.fNotEditableColumns.containsKey(new Integer(n));
        }

        public boolean isColumnEditable(String string) {
            TableColumn tableColumn = UitablePeer.this.fTable.getColumn(string);
            int n = tableColumn.getModelIndex();
            return this.isColumnEditable(n);
        }

        public boolean isCellEditable(int n, int n2) {
            boolean bl = super.isCellEditable(n, n2);
            if (bl) {
                bl = null == this.fNotEditableColumns.get(new Integer(n2));
            }
            return bl;
        }

        public TableCellEditor getCellEditor(int n, int n2) {
            if (UitablePeer.this.fCustomEditors.containsKey(new Integer(n2))) {
                DefaultCellEditor defaultCellEditor = (DefaultCellEditor)UitablePeer.this.fCustomEditors.get(new Integer(n2));
                return defaultCellEditor;
            }
            return super.getCellEditor(n, n2);
        }

        public TableCellRenderer getCellRenderer(int n, int n2) {
            if (UitablePeer.this.fCustomRenderers.containsKey(new Integer(n2))) {
                TableCellRenderer tableCellRenderer = (TableCellRenderer)UitablePeer.this.fCustomRenderers.get(new Integer(n2));
                return tableCellRenderer;
            }
            return super.getCellRenderer(n, n2);
        }

        protected boolean useKeyBindingManager() {
            return false;
        }
    }

    private class TableChangeListener
    implements TableModelListener {
        private TableChangeListener() {
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            try {
                UitablePeer.this.fireDataChanged(new DataChangedEvent(tableModelEvent));
            }
            catch (Exception exception) {
                System.err.println("Failed to create DataChangedEvent");
            }
        }
    }

    private class CheckBoxRenderer
    extends MJCheckBox
    implements TableCellRenderer {
        public CheckBoxRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (null == object) {
                object = "false";
            }
            boolean bl3 = new Boolean(object.toString());
            this.setSelected(bl3);
            return this;
        }
    }

    private class ComboBoxRenderer
    extends MJComboBox
    implements TableCellRenderer {
        public ComboBoxRenderer(String[] stringArray) {
            super((Object[])stringArray);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setSelectedItem(object);
            return this;
        }
    }

    private static abstract class SynchronousInvokeRunnable
    implements Runnable {
        private Object fResult = null;

        private SynchronousInvokeRunnable() {
        }

        public void setResult(Object object) {
            this.fResult = object;
        }

        public Object getResult() {
            return this.fResult;
        }
    }
}

