/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer.ui;

import com.mathworks.hg.peer.HeavyweightLightweightContainerFactory;
import com.mathworks.hg.peer.UIComponentParentWithLayout;
import com.mathworks.hg.peer.ui.DefaultFigureUIChildImpl;
import java.awt.Container;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;

public class DefaultUIComponentImpl
extends DefaultFigureUIChildImpl {
    protected JComponent fFigureComponent;
    private Container fFigureContainer;
    private FocusListener fCanvasFocusListener = null;
    private boolean fCanvasFocusListenerAttached = false;
    private FocusListener fComponentFocusListener = null;

    public DefaultUIComponentImpl(JComponent jComponent) {
        super(jComponent);
        this.fFigureComponent = jComponent;
    }

    @Override
    protected void doAdd(UIComponentParentWithLayout uIComponentParentWithLayout, int n) {
        this.fCompParent = uIComponentParentWithLayout;
        this.fFigureContainer = HeavyweightLightweightContainerFactory.getUIComponentContainer(uIComponentParentWithLayout);
        this.fFigureContainer.setFocusable(false);
        this.fFigureContainer.setVisible(this.getFigureComponent().isVisible());
        this.fFigureContainer.add(this.getFigureComponent());
        uIComponentParentWithLayout.addUIcontrol(this.fFigureContainer, n);
    }

    @Override
    protected void doRemove(UIComponentParentWithLayout uIComponentParentWithLayout) {
        if (null == this.getFigureComponent() || null == this.fFigureContainer) {
            return;
        }
        this.fFigureContainer.remove(this.getFigureComponent());
        if (uIComponentParentWithLayout != null) {
            uIComponentParentWithLayout.removeUIcontrol(this.fFigureContainer);
        }
        this.fFigureContainer = null;
        this.fCompParent = null;
    }

    @Override
    protected JComponent getFigureComponent() {
        if (this.fFigureComponent == null) {
            throw new Error("Figure component handle not set.");
        }
        return this.fFigureComponent;
    }

    @Override
    public void doSetPosition(double d, double d2, double d3, double d4) {
        Container container;
        if (this.fFigureContainer != null && (container = this.fFigureContainer.getParent()) != null) {
            double d5 = container.getBounds().getHeight();
            double d6 = d;
            double d7 = d2 - d4;
            this.fFigureContainer.setBounds((int)d6, (int)d7, (int)d3, (int)d4);
        }
    }

    @Override
    public void doSetVisible(boolean bl) {
        super.doSetVisible(bl);
        if (null != this.fFigureContainer) {
            this.fFigureContainer.setVisible(bl);
        }
    }

    @Override
    public void manageFocusRequest() {
        if (null == this.fComponentFocusListener) {
            this.fComponentFocusListener = new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    DefaultUIComponentImpl.this.addLogMessage(1024, "Component gained focus. Remove axes focus listener if necessary");
                    DefaultUIComponentImpl.this.detachCanvasFocusListener();
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    DefaultUIComponentImpl.this.addLogMessage(1024, "Component lost focus.");
                }
            };
            this.getFigureComponent().addFocusListener(this.fComponentFocusListener);
        }
        if (!this.fCanvasFocusListenerAttached && null != this.getComponentParent() && !this.getFigureComponent().isFocusOwner()) {
            this.attachCanvasFocusListener();
        }
    }

    private void attachCanvasFocusListener() {
        if (null == this.fCanvasFocusListener) {
            this.fCanvasFocusListener = new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    DefaultUIComponentImpl.this.addLogMessage(1024, "Axes gained focus. Transfer to Ui.");
                    DefaultUIComponentImpl.this.getFigureComponent().requestFocus();
                    DefaultUIComponentImpl.this.detachCanvasFocusListener();
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                }
            };
        }
        this.addLogMessage(1024, "Add FocusListener to Canvas to transfer forcus to Ui.");
        this.fCanvasFocusListenerAttached = true;
        this.getComponentParent().addFocusListener(this.fCanvasFocusListener);
    }

    private void detachCanvasFocusListener() {
        if (null != this.getComponentParent()) {
            this.addLogMessage(1024, "Remove focus listener from Canvas.");
            this.getComponentParent().removeFocusListener(this.fCanvasFocusListener);
            this.fCanvasFocusListenerAttached = false;
        }
    }
}

