/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.types;

import com.mathworks.hg.types.LineSpec;
import com.mathworks.hg.types.LineStyleSpecifier;
import com.mathworks.hg.types.MarkerSpecifier;
import com.mathworks.util.DebugUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class HGLineStyles {
    public static final int SOLID_LINE = 0;
    public static final int DASHED_LINE = 1;
    public static final int DOTTED_LINE = 2;
    public static final int DASHDOT_LINE = 3;
    public static final int NO_LINE = 4;
    public static final int PLUS_MARKER = 0;
    public static final int CIRCLE_MARKER = 1;
    public static final int ASTERISK_MARKER = 2;
    public static final int POINT_MARKER = 3;
    public static final int X_MARK_MARKER = 4;
    public static final int SQUARE_MARKER = 5;
    public static final int DIAMOND_MARKER = 6;
    public static final int TRIANGLE_MARKER = 7;
    public static final int PYRAMID_MARKER = 8;
    public static final int RIGHT_MARKER = 9;
    public static final int LEFT_MARKER = 10;
    public static final int PENTOID_MARKER = 11;
    public static final int HEXOID_MARKER = 12;
    public static final int NO_MARKER = 13;
    private volatile int[] fLineStyles;
    private volatile int[] fMarkers;

    public HGLineStyles(int[] nArray, int[] nArray2) {
        this.fLineStyles = nArray;
        this.fMarkers = nArray2;
    }

    public HGLineStyles(List<LineSpec> list) {
        this.setLineSpecs(list);
    }

    public static HGLineStyles newInstance(String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray2 == null) {
            assert (DebugUtils.warning((String)"lineStyles and markerStyles argument must not be null"));
            return null;
        }
        if (stringArray.length != stringArray2.length) {
            assert (DebugUtils.warning((String)"Number of elements in lineStyles and markerStyles arrays must be equal"));
            return null;
        }
        ArrayList<LineSpec> arrayList = new ArrayList<LineSpec>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            LineStyleSpecifier lineStyleSpecifier = null;
            MarkerSpecifier markerSpecifier = null;
            try {
                lineStyleSpecifier = LineStyleSpecifier.fromString(stringArray[i]);
                markerSpecifier = MarkerSpecifier.fromString(stringArray2[i]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
            arrayList.add(new LineSpec(lineStyleSpecifier, markerSpecifier));
        }
        return new HGLineStyles(arrayList);
    }

    private String[] getConcatenatedStyles() {
        List<LineSpec> list = this.getLineSpecs();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (LineSpec lineSpec : list) {
            StringBuilder stringBuilder = new StringBuilder(lineSpec.getLineStyleSpecifier().getSpecifier());
            stringBuilder.append(" ").append(lineSpec.getMarkerSpecifier().getSpecifier());
            arrayList.add(stringBuilder.toString());
        }
        String[] stringArray = arrayList.toArray(new String[0]);
        return stringArray;
    }

    public final List<LineSpec> getLineSpecs() {
        if (this.fLineStyles == null || this.fMarkers == null) {
            return Collections.emptyList();
        }
        assert (this.fLineStyles.length == this.fMarkers.length) : this.fLineStyles.length + " " + this.fMarkers.length;
        int n = this.fMarkers.length;
        LineStyleSpecifier lineStyleSpecifier = null;
        MarkerSpecifier markerSpecifier = null;
        ArrayList<LineSpec> arrayList = new ArrayList<LineSpec>();
        for (int i = 0; i < n; ++i) {
            int n2 = this.fLineStyles[i];
            lineStyleSpecifier = LineStyleSpecifier.find(n2);
            assert (lineStyleSpecifier != null) : "Invalid line style: " + n2;
            int n3 = this.fMarkers[i];
            markerSpecifier = MarkerSpecifier.find(n3);
            assert (markerSpecifier != null) : "Invalid marker: " + n3;
            arrayList.add(new LineSpec(lineStyleSpecifier, markerSpecifier));
        }
        return arrayList;
    }

    private void setLineSpecs(List<LineSpec> list) {
        if (list == null || list.isEmpty()) {
            this.fLineStyles = new int[0];
            this.fMarkers = new int[0];
            return;
        }
        this.fLineStyles = new int[list.size()];
        this.fMarkers = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            LineSpec lineSpec = list.get(i);
            assert (lineSpec != null);
            LineStyleSpecifier lineStyleSpecifier = lineSpec.getLineStyleSpecifier();
            this.fLineStyles[i] = lineStyleSpecifier.getId();
            MarkerSpecifier markerSpecifier = lineSpec.getMarkerSpecifier();
            this.fMarkers[i] = markerSpecifier.getId();
        }
    }

    public static HGLineStyles valueOf(List<LineSpec> list) {
        if (list == null) {
            return null;
        }
        return new HGLineStyles(list);
    }

    public int[] getLineStyles() {
        return this.fLineStyles;
    }

    public void setLineStyles(int[] nArray) {
        this.fLineStyles = nArray;
    }

    public int[] getMarkers() {
        return this.fMarkers;
    }

    public void setMarkers(int[] nArray) {
        this.fMarkers = nArray;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof HGLineStyles)) {
            return false;
        }
        HGLineStyles hGLineStyles = (HGLineStyles)object;
        return Arrays.equals(this.fLineStyles, hGLineStyles.fLineStyles) && Arrays.equals(this.fMarkers, hGLineStyles.fMarkers);
    }

    public String toString() {
        return LineSpec.toString(this.getLineSpecs());
    }
}

